/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.filter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.filter.FilterInstanceWrapper;
import com.ibm.ws.webcontainer.util.ThreadContextHelper;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppServletInvocationEvent;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletWrapper;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletResponse;

public class WebAppFilterChain
implements FilterChain {
    private ArrayList _filters = new ArrayList(5);
    private int _currentFilterIndex = -1;
    private int _numberOfFilters = 0;
    private IServletWrapper requestedServlet;
    private ExtensionProcessor requestProcessor;
    private boolean _filtersDefined = false;
    private WebAppServletInvocationEvent evt;
    private static TraceComponent tc = Tr.register((Class)WebAppFilterChain.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    private boolean _entryEnabled = tc.isEntryEnabled();
    private WebApp webapp = null;

    public WebAppFilterChain() {
    }

    public WebAppFilterChain(WebApp webApp) {
        this.webapp = webApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (this._entryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"_doFilter");
        }
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader classLoader2 = this.webapp.getClassLoader();
            if (classLoader2 != classLoader) {
                ThreadContextHelper.setClassLoader(classLoader2);
            }
            this.doFilter(servletRequest, servletResponse);
        }
        finally {
            ThreadContextHelper.setClassLoader(classLoader);
        }
        if (this._entryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"_doFilter");
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (this._entryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"doFilter");
        }
        try {
            if (!this._filtersDefined) {
                if (this.requestedServlet == null) {
                    if (this.requestProcessor != null) {
                        this.requestProcessor.handleRequest(servletRequest, servletResponse);
                    }
                    return;
                }
                this.requestedServlet.service(servletRequest, servletResponse);
            } else {
                ++this._currentFilterIndex;
                if (this._currentFilterIndex < this._numberOfFilters) {
                    ((FilterInstanceWrapper)this._filters.get(this._currentFilterIndex)).doFilter(servletRequest, servletResponse, this);
                } else {
                    if (this.requestedServlet == null) {
                        if (this.requestProcessor != null) {
                            this.requestProcessor.handleRequest(servletRequest, servletResponse);
                        } else {
                            ((HttpServletResponse)servletResponse).sendError(404);
                        }
                        return;
                    }
                    this.requestedServlet.service(servletRequest, servletResponse);
                }
            }
        }
        catch (UnavailableException unavailableException) {
            throw unavailableException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ServletException servletException) {
            FFDCFilter.processException((Throwable)servletException, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterChain.doFilter", (String)"82", (Object)this);
            if (this._entryEnabled) {
                Tr.exit((TraceComponent)tc, (String)"doFilter");
            }
            throw servletException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.filter.WebAppFilterChain.doFilter", (String)"89", (Object)this);
            if (this._entryEnabled) {
                Tr.exit((TraceComponent)tc, (String)"doFilter");
            }
            throw new ServletException(throwable);
        }
        if (this._entryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"doFilter");
        }
    }

    public void addFilter(FilterInstanceWrapper filterInstanceWrapper) {
        this._filtersDefined = true;
        ++this._numberOfFilters;
        this._filters.add(filterInstanceWrapper);
    }

    public void setRequestedServlet(IServletWrapper iServletWrapper) {
        this.requestedServlet = iServletWrapper;
    }

    public void setExtensionProcessor(ExtensionProcessor extensionProcessor) {
        this.requestProcessor = extensionProcessor;
    }

    public void setInvocationEvent(WebAppServletInvocationEvent webAppServletInvocationEvent) {
        this.evt = webAppServletInvocationEvent;
    }
}

