/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainStartMode;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.PropertyVetoException;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.localhttp.channel.LocalInboundChainFactory;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.runtime.component.ContainerImpl;
import com.ibm.ws.runtime.config.ContainerConfig;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectHandler;
import com.ibm.ws.runtime.metadata.MetaDataFactory;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.ApplicationServer;
import com.ibm.ws.runtime.service.MetaDataFactoryMgr;
import com.ibm.ws.runtime.service.RuntimeCtxImpl;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.webcontainer.WebContainerService;
import com.ibm.ws.webcontainer.exception.WebAppNotLoadedException;
import com.ibm.ws.webcontainer.metadata.WebMetaDataFactory;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaDataImpl;
import com.ibm.ws.webcontainer.session.SessionRegistry;
import com.ibm.ws.webcontainer.spi.servlet.http.IHttpServletResponseListener;
import com.ibm.ws.webcontainer.spiadapter.collaborator.IInitializationCollaborator;
import com.ibm.ws.webcontainer.spiadapter.collaborator.IInvocationCollaborator;
import com.ibm.ws.webcontainer.webapp.collaborator.WebAppCollaborator;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wtp.emf.utilities.copy.EtoolsCopyUtility;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextServiceProvider;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;

public class WebContainerImpl
extends ContainerImpl
implements DeployedObjectHandler,
VetoableChangeListener,
WebContainerService {
    protected com.ibm.ws.webcontainer.WebContainer _webContainer = null;
    protected WebContainer _webContainerConfig = null;
    protected boolean startTransports = false;
    protected boolean startChannels = false;
    protected ArrayList webAppInitializationCollaboratorList;
    protected ArrayList webAppInvocationCollaboratorList;
    private WebMetaDataFactory metaDataFactory;
    private boolean isCRAJVM = false;
    private boolean isDefaultTempDir = true;
    protected static TraceComponent tc = Tr.register((Class)WebContainerService.class, (String)"Webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
    SessionRegistry _sessRegistry = null;

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        ContainerConfig containerConfig = (ContainerConfig)object;
        WebContainer webContainer = (WebContainer)containerConfig.getConfig();
        com.ibm.websphere.models.config.applicationserver.ApplicationServer applicationServer = (com.ibm.websphere.models.config.applicationserver.ApplicationServer)webContainer.getParentComponent();
        if (AdminHelper.getPlatformHelper().isZOS()) {
            if (AdminHelper.getPlatformHelper().isCRAJvm()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WebContainer is disabled in z/OS CRA.");
                }
                throw new ComponentDisabledException();
            }
            boolean bl = applicationServer.getServer().getServerInstance().isEnableMultipleServerInstances();
            int n = applicationServer.getServer().getServerInstance().getMaximumNumberOfInstances();
            Tr.debug((TraceComponent)tc, (String)("isEnabledMultipleServerInstances=" + bl + ", maximumNumberOfInstances=" + n + ", minimumNumberOfInstances" + applicationServer.getServer().getServerInstance().getMinimumNumOfInstances()));
            if (bl && n > 1) {
                this.isDefaultTempDir = false;
            }
        }
        if (webContainer.getStateManagement() != null && webContainer.getStateManagement().getInitialState().getValue() == 1) {
            throw new ComponentDisabledException();
        }
        EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
        this._webContainerConfig = (WebContainer)etoolsCopyUtility.copy((EObject)webContainer);
        ApplicationServer applicationServer2 = (ApplicationServer)this.getService(ApplicationServer.class);
        applicationServer2.addVetoableChangeListener("state", (VetoableChangeListener)this);
        this.releaseService(applicationServer2);
        this.getOuterBCS().addService(WebContainerService.class, (BeanContextServiceProvider)((Object)this));
        MetaDataFactoryMgr metaDataFactoryMgr = (MetaDataFactoryMgr)this.getService(MetaDataFactoryMgr.class);
        WebMetaDataFactory.init(metaDataFactoryMgr);
        this.metaDataFactory = new WebMetaDataFactory();
        metaDataFactoryMgr.addMetaDataFactory((MetaDataFactory)this.metaDataFactory);
        this.releaseService(metaDataFactoryMgr);
        this.isCRAJVM = PlatformHelperFactory.getPlatformHelper().isCRAJvm();
        this.components = this.loadComponents("META-INF/ws-webcontainer-startup.xml");
        this.initializeComponents((EObject)webContainer, containerConfig.getLocators());
    }

    public void destroy() {
        this.destroyComponents();
    }

    public void start() throws RuntimeError, RuntimeWarning {
        this.startComponents();
        ApplicationMgr applicationMgr = (ApplicationMgr)this.getService(ApplicationMgr.class);
        applicationMgr.addDeployedObjectHandler((DeployedObjectHandler)this);
        this.releaseService(applicationMgr);
    }

    public void stop() {
        if (this._webContainer != null) {
            this._webContainer.shutdown();
        }
        this.stopComponents();
    }

    public synchronized void install(DeployedObject deployedObject) throws RuntimeError, RuntimeWarning {
        this.init();
        boolean bl = false;
        try {
            this._webContainer.addWebApplication((DeployedModule)deployedObject, bl);
        }
        catch (WebAppNotLoadedException webAppNotLoadedException) {
            FFDCFilter.processException((Throwable)webAppNotLoadedException, (String)"com.ibm.ws.runtime.component.WebContainerImpl.install", (String)"124", (Object)this);
            throw new RuntimeWarning((Throwable)webAppNotLoadedException);
        }
    }

    public synchronized void uninstall(DeployedObject deployedObject) {
        if (this._webContainer != null) {
            try {
                this._webContainer.removeWebApplication((DeployedModule)deployedObject);
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)("Could not remove webmodule " + deployedObject.getModuleFile().getURI() + ". Check error logs for more details."));
                exception.printStackTrace(System.err);
            }
        }
    }

    public void addVirtualHostExtensionFactory(ExtensionFactory extensionFactory) {
        com.ibm.ws.webcontainer.WebContainer.addVirtualHostExtensionFactory(extensionFactory);
    }

    public void addExtensionFactory(ExtensionFactory extensionFactory) {
        com.ibm.ws.webcontainer.WebContainer.addExtensionFactory(extensionFactory);
    }

    public void addHttpServletResponseListener(IHttpServletResponseListener iHttpServletResponseListener) {
        com.ibm.ws.webcontainer.WebContainer.addHttpServletResponseListener(iHttpServletResponseListener);
    }

    public void addWebAppCollaborator(WebAppCollaborator webAppCollaborator) {
        if (this._webContainer != null) {
            throw new IllegalStateException("Web container already initialized");
        }
        if (webAppCollaborator != null) {
            if (webAppCollaborator instanceof IInvocationCollaborator) {
                if (this.webAppInvocationCollaboratorList == null) {
                    this.webAppInvocationCollaboratorList = new ArrayList();
                }
                this.webAppInvocationCollaboratorList.add(webAppCollaborator);
            }
            if (webAppCollaborator instanceof IInitializationCollaborator) {
                if (this.webAppInitializationCollaboratorList == null) {
                    this.webAppInitializationCollaboratorList = new ArrayList();
                }
                this.webAppInitializationCollaboratorList.add(webAppCollaborator);
            }
        }
    }

    protected void init() throws RuntimeError {
        if (this._webContainer != null) {
            return;
        }
        if (this._sessRegistry == null) {
            Tr.error((TraceComponent)tc, (String)"The Session registry is NULL possibly because the SessionManager did not start up correctly. Web applications WILL fail.");
        }
        this._webContainer = com.ibm.ws.webcontainer.WebContainer.getWebContainer();
        this._webContainer.setSessionRegistry(this._sessRegistry);
        com.ibm.ws.webcontainer.WebContainer.setIsDefaultTempDir(this.isDefaultTempDir);
        IInitializationCollaborator[] iInitializationCollaboratorArray = null;
        if (this.webAppInitializationCollaboratorList != null) {
            iInitializationCollaboratorArray = new IInitializationCollaborator[this.webAppInitializationCollaboratorList.size()];
            iInitializationCollaboratorArray = this.webAppInitializationCollaboratorList.toArray(iInitializationCollaboratorArray);
        } else {
            iInitializationCollaboratorArray = new IInitializationCollaborator[]{};
        }
        IInvocationCollaborator[] iInvocationCollaboratorArray = null;
        if (this.webAppInvocationCollaboratorList != null) {
            iInvocationCollaboratorArray = new IInvocationCollaborator[this.webAppInvocationCollaboratorList.size()];
            iInvocationCollaboratorArray = this.webAppInvocationCollaboratorList.toArray(iInvocationCollaboratorArray);
        } else {
            iInvocationCollaboratorArray = new IInvocationCollaborator[]{};
        }
        SecurityService securityService = (SecurityService)this.getService(SecurityService.class);
        if (securityService == null) {
            // empty if block
        }
        this._webContainer.initialize(this._webContainerConfig, new RuntimeCtxImpl(this.getBeanContextServices(), (BeanContextChild)((Object)this)), this, iInitializationCollaboratorArray, iInvocationCollaboratorArray, securityService);
        this.startTransports();
        this.registerMBean();
        this._webContainerConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTransports() throws RuntimeError {
        if (this._webContainer != null && this.startTransports) {
            VariableMap variableMap = null;
            ThreadPoolMgr threadPoolMgr = null;
            try {
                variableMap = (VariableMap)this.getService(VariableMap.class);
                threadPoolMgr = (ThreadPoolMgr)this.getService(ThreadPoolMgr.class);
                this._webContainer.startTransports(variableMap, threadPoolMgr);
                Object var4_3 = null;
                if (variableMap != null) {
                    this.releaseService(variableMap);
                }
                if (threadPoolMgr != null) {
                    this.releaseService(threadPoolMgr);
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (variableMap != null) {
                    this.releaseService(variableMap);
                }
                if (threadPoolMgr != null) {
                    this.releaseService(threadPoolMgr);
                }
                throw throwable;
            }
        }
    }

    protected void startChannels() throws RuntimeError {
        try {
            if (!this.isCRAJVM) {
                ChannelFrameworkService channelFrameworkService = (ChannelFrameworkService)this.getService(ChannelFrameworkService.class);
                String string = com.ibm.ws.webcontainer.WebContainer.getWebContainerProperties().getProperty("enableinprocessconnections");
                if (string != null && string.equalsIgnoreCase("true")) {
                    LocalInboundChainFactory localInboundChainFactory = (LocalInboundChainFactory)this.getService(LocalInboundChainFactory.class);
                    localInboundChainFactory.createLocalChains((ChannelFramework)channelFrameworkService, WebContainerImpl.class.getName());
                }
                channelFrameworkService.startChainsByAcceptorID(WebContainerImpl.class.getName(), ChainStartMode.RETRY_EACH_ON_FAIL);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.runtime.component.WebContainerImpl.startChannels", (String)"277", (Object)this);
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (propertyChangeEvent.getNewValue().equals("STARTED")) {
            this.startTransports = true;
            this.startChannels = true;
            try {
                this.startTransports();
                this.startChannels();
            }
            catch (RuntimeError runtimeError) {
                throw new PropertyVetoException(runtimeError.getMessage(), propertyChangeEvent, (Throwable)runtimeError);
            }
        }
    }

    public Object getService(Class clazz) {
        return super.getService(clazz);
    }

    public void releaseService(Object object) {
        super.releaseService(object);
    }

    public boolean start(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        DeployedObject deployedObject = deployedObjectEvent.getDeployedObject();
        if (deployedObject.getModuleFile().isWARFile()) {
            this.install(deployedObject);
            return true;
        }
        return false;
    }

    public void stop(DeployedObjectEvent deployedObjectEvent) {
        DeployedObject deployedObject = deployedObjectEvent.getDeployedObject();
        if (deployedObject.getModuleFile().isWARFile()) {
            this.uninstall(deployedObject);
        }
    }

    public synchronized void reload(DeployedObject deployedObject) throws RuntimeWarning {
        try {
            if (deployedObject.getModuleFile().isWARFile()) {
                this._webContainer.reload((DeployedModule)deployedObject);
            }
        }
        catch (WebAppNotLoadedException webAppNotLoadedException) {
            FFDCFilter.processException((Throwable)webAppNotLoadedException, (String)"com.ibm.ws.runtime.component.WebContainerImpl.reload", (String)"379", (Object)this);
            throw new RuntimeWarning((Throwable)webAppNotLoadedException);
        }
    }

    public synchronized void restart(DeployedObject deployedObject) throws RuntimeWarning {
        try {
            if (deployedObject.getModuleFile().isWARFile()) {
                this._webContainer.restartWebApplication((DeployedModule)deployedObject);
            }
        }
        catch (WebAppNotLoadedException webAppNotLoadedException) {
            FFDCFilter.processException((Throwable)webAppNotLoadedException, (String)"com.ibm.ws.runtime.component.WebContainerImpl.restart", (String)"398", (Object)this);
            throw new RuntimeWarning((Throwable)webAppNotLoadedException);
        }
    }

    protected void registerMBean() {
        try {
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator((Object)this._webContainer, "WebContainer");
            String string = mBeanFactory.getConfigId((Object)this._webContainerConfig);
            mBeanFactory.activateMBean("WebContainer", (RuntimeCollaborator)defaultRuntimeCollaborator, string, null);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.runtime.component.WebContainerImpl.registerMBean", (String)"419", (Object)this);
        }
    }

    public void setSessionRegistry(SessionRegistry sessionRegistry) {
        this._sessRegistry = sessionRegistry;
    }

    public ClassLoader getClassLoader(J2EEName j2EEName) {
        Iterator iterator = this.metaDataFactory.moduleMetaDatas();
        while (iterator.hasNext()) {
            WebModuleMetaDataImpl webModuleMetaDataImpl = (WebModuleMetaDataImpl)iterator.next();
            J2EEName j2EEName2 = webModuleMetaDataImpl.getJ2EEName();
            String string = j2EEName2.getModule();
            String string2 = j2EEName2.getApplication();
            String string3 = j2EEName.getModule();
            String string4 = j2EEName.getApplication();
            if (!(string == null ? string3 == null : string.equals(string3)) || !(string2 == null ? string4 == null : string2.equals(string4))) continue;
            return webModuleMetaDataImpl.getWebAppConfig().getWebApp().getClassLoader();
        }
        return null;
    }
}

