/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container;

import com.ibm.ws.container.Configuration;
import com.ibm.ws.container.Container;
import com.ibm.ws.webcontainer.util.EmptyIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractContainer
implements Container {
    protected String name = null;
    private boolean isAlive = false;
    protected Map subElements = null;
    protected Map attributes = null;
    protected Configuration config = null;

    public boolean isAlive() {
        return this.isAlive;
    }

    public void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public synchronized void start() {
        this.isAlive = true;
    }

    public synchronized void stop() {
        this.isAlive = false;
    }

    public synchronized void destroy() {
        if (!this.isAlive()) {
            return;
        }
        Iterator iterator = this.subContainers();
        while (iterator.hasNext()) {
            Container container = (Container)iterator.next();
            container.destroy();
        }
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Container removeSubContainer(String string) {
        if (this.subElements != null) {
            AbstractContainer abstractContainer = this;
            synchronized (abstractContainer) {
                return (Container)this.subElements.remove(string);
            }
        }
        return null;
    }

    public Container getSubContainer(String string) {
        Iterator iterator = this.subContainers();
        Container container = null;
        while (iterator.hasNext()) {
            Container container2 = (Container)iterator.next();
            if (!container2.getName().equals(string)) continue;
            container = container2;
        }
        return container;
    }

    public Iterator subContainers() {
        if (this.subElements != null) {
            Map map = (Map)((HashMap)this.subElements).clone();
            return map.values().iterator();
        }
        return EmptyIterator.getInstance();
    }

    public boolean isActive() {
        return this.isAlive;
    }

    public void initialize(Configuration configuration) {
        this.config = configuration;
        this.name = configuration.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubContainer(Container container) {
        if (container == null || container.getName() == null) {
            throw new RuntimeException("Container Name is null");
        }
        if (this.subElements == null) {
            this.subElements = new HashMap();
        }
        AbstractContainer abstractContainer = this;
        synchronized (abstractContainer) {
            this.subElements.put(container.getName(), container);
        }
    }

    protected Configuration getConfig() {
        return this.config;
    }

    protected void setConfig(Configuration configuration) {
        this.config = configuration;
    }
}

