/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.j2ee.common.SecurityRole;
import com.ibm.etools.j2ee.common.SecurityRoleRef;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.websphere.security.audit.AuditHandler;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.AuditHandlerImpl;
import com.ibm.ws.security.audit.AuditServiceImpl;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.Identity;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.authorize.WSPolicyContextHandlerImpl;
import com.ibm.ws.security.core.AccessException;
import com.ibm.ws.security.core.AccessManager;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.PermissionRoleMap;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.core.WSPrincipal;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.WCCMHelper;
import com.ibm.ws.security.web.AuthenticationResult;
import com.ibm.ws.security.web.ChallengeReply;
import com.ibm.ws.security.web.DenyReply;
import com.ibm.ws.security.web.PermitReply;
import com.ibm.ws.security.web.RedirectReply;
import com.ibm.ws.security.web.SecurityMetaData;
import com.ibm.ws.security.web.TAIChallengeReply;
import com.ibm.ws.security.web.TrustAssociationManager;
import com.ibm.ws.security.web.WebAccessContext;
import com.ibm.ws.security.web.WebAccessManager;
import com.ibm.ws.security.web.WebAccessPermission;
import com.ibm.ws.security.web.WebAppCache;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebAuthenticator;
import com.ibm.ws.security.web.WebReply;
import com.ibm.ws.security.web.WebResourceCollectionConstraints;
import com.ibm.ws.security.web.WebSecurityConfigException;
import com.ibm.ws.security.web.WebSecurityException;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.util.WSUtil;
import com.ibm.ws.webcontainer.metadata.WebComponentMetaData;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaData;
import com.ibm.ws.webcontainer.srt.IPrivateRequestAttributes;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.wsspi.security.audit.AuditOutcome;
import com.ibm.wsspi.security.audit.J2EEAuditEventFactory;
import com.ibm.wsspi.security.auth.callback.WSCallbackHandlerFactory;
import java.io.Serializable;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.eclipse.emf.common.util.EList;

public abstract class WebCollaborator {
    private static final String nullString = "";
    private static final String[] nullStringArray = new String[0];
    public static final String pnWebServer = "$webServer";
    public static final String pnVirtualHost = "$virtualHost";
    public static final String pnRemoteHost = "$remoteHost";
    public static final String pnUri = "$uri";
    public static final String pnMethod = "$method";
    public static final String pnIsSSL = "$isSSL";
    public static final String pnCertificate = "$certificate";
    public static final String pnCipher = "$cipher";
    public static final String pnAuthorization = "Authorization";
    public static final String pnCookie = "Cookie";
    protected static WebReply PERMIT_REPLY = new PermitReply();
    protected static WebReply DENY_AUTHZ_FAILED = new DenyReply("AuthorizationFailed");
    protected static WebReply DENY_AUTHN_FAILED = new DenyReply("AuthenticationFailed");
    protected static WebReply DENY_CONFIG_ERROR = new DenyReply("Configuration error");
    private static final TraceComponent tc = Tr.register((Class)WebCollaborator.class, null, (String)"com.ibm.ejs.resources.security");
    protected boolean securityEnabled;
    protected static WebAuthenticator authenticator = null;
    protected AccessManager authorizer = null;
    protected static ContextManager contextManager;
    protected static final int PUBLIC = 0;
    protected static final int ACCESSID = 1;
    protected static final int GROUPID = 2;
    protected boolean authDone = false;
    private static Object _lockObject;
    private WebAppCache webCache = null;
    private static boolean custom_auth_mech;
    private static String custom_jaas_config;
    private static TrustAssociationManager taManager;
    private static AuthCache cache;
    private static WSCallbackHandlerFactory cbkFactory;
    private ArrayList adminAppList = null;
    private WebAttributes webSecAttrs;
    private static AuditHandlerImpl auditHandler;
    private static J2EEAuditEventFactory auditFactory;
    private static final String providerName = "WebSphere";
    private static final boolean providerSuccess = true;
    private static String[] jaccHandlerKeyArray;
    private static WSPolicyContextHandlerImpl wpch;
    private static boolean initialized;

    protected abstract WebAppCache getWebCache();

    public WebCollaborator() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        this.initialize();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public void createAuthorizationManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createAuthorizationManager");
        }
        this.authorizer = new WebAccessManager();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createAuthorizationManager");
        }
    }

    public void initialize() throws Exception {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"initialize");
            }
            this.securityEnabled = false;
            try {
                this.securityEnabled = SecurityContext.isSecurityEnabled();
                if (this.securityEnabled && !initialized) {
                    AuditServiceImpl auditServiceImpl;
                    contextManager = ContextManagerFactory.getInstance();
                    String string = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
                    if (!string.equals("SWAM")) {
                        taManager = TrustAssociationManager.getInstance();
                        cache = AuthCache.getInstance();
                        custom_jaas_config = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundLoginConfig");
                        String string2 = (String)SecurityConfig.getConfig().getValue("security.enablePluggableAuthentication");
                        if (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes")) {
                            custom_auth_mech = true;
                        }
                    } else {
                        custom_jaas_config = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundLoginConfig");
                    }
                    if ((auditServiceImpl = (AuditServiceImpl)AuditServiceImpl.getAuditService()) != null) {
                        Class<?> clazz;
                        auditHandler = (AuditHandlerImpl)auditServiceImpl.newAuditHandler("WAS.security", "WAS.security");
                        if (auditHandler != null) {
                            auditFactory = (J2EEAuditEventFactory)auditHandler.getAuditEventFactory("J2EE");
                        }
                        if (auditFactory != null && !(clazz = Class.forName("com.ibm.wsspi.security.audit.J2EEAuditEventFactory")).isInstance(auditFactory)) {
                            auditFactory = null;
                        }
                    }
                    authenticator = WebAuthenticator.create(custom_jaas_config, auditHandler, auditFactory);
                    if (SecurityConfig.isJACCEnabled()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Setting the PolicyContextHandlers for JACCfor web.");
                        }
                        jaccHandlerKeyArray = new String[]{"javax.security.auth.Subject.container", "javax.servlet.http.HttpServletRequest"};
                        wpch = WSPolicyContextHandlerImpl.getInstance();
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.initialize", (String)"308", (Object)this);
                if (this.securityEnabled) {
                    Tr.error((TraceComponent)tc, (String)"security.web.initerror");
                }
                if (!tc.isDebugEnabled()) break block14;
                Tr.debug((TraceComponent)tc, (String)"initialize", (Object)new Object[]{exception});
            }
        }
        initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void addWebApp(String string, String string2, WebApp webApp) throws WebSecurityConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addWebApp", (Object)new Object[]{string, string2, webApp});
        }
        if (this.webCache == null) {
            this.webCache = this.getWebCache();
        }
        try {
            this.webCache.addWebApp(string, string2, webApp);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.web.WebCollaborator.addWebApp", (String)"344", (Object)this);
            WebSecurityConfigException webSecurityConfigException = new WebSecurityConfigException(throwable.getMessage(), null);
            webSecurityConfigException.initCause(throwable);
            if (tc.isEventEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"addWebApp excption", (Object)webSecurityConfigException);
            }
            throw webSecurityConfigException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addWebApp");
        }
    }

    private boolean isAdminApp(String string) {
        return WSAccessManager.checkIfAdminApp(string);
    }

    protected WebReply authorize(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl, String string2) throws WebSecurityException {
        String string3;
        ArrayList arrayList;
        Subject subject;
        Serializable serializable;
        SecurityRole[] securityRoleArray;
        WebAccessContext webAccessContext;
        String string4;
        String string5;
        WebReply webReply;
        block53: {
            Object object;
            WebAttributes webAttributes;
            block52: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"authorize", (Object)new Object[]{httpServletRequest, httpServletResponse, string, new Boolean(bl), string2});
                }
                if (auditHandler != null) {
                    auditHandler.setAppName(null);
                }
                webReply = null;
                string5 = WebCollaborator.getURI(httpServletRequest);
                if (string5 == null || string5.length() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"authorize: throw WebSecurityException");
                    }
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(3, 4)) {
                        auditFactory.sendAccessAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "INVALID_RESOURCE", httpServletRequest.getSession().getId(), null, string5, "WEB", httpServletRequest.getMethod(), providerName, true, "security.audit.service.bad.uri.denied.audit", null);
                    }
                    return new DenyReply("Invalid URI passed to Security Collaborator.");
                }
                string4 = httpServletRequest.getMethod();
                webReply = this.validSecAttrs(string, string5, string4, false, string2);
                if (webReply != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"authorize: ", (Object)webReply);
                    }
                    return webReply;
                }
                webAccessContext = this.webCache.getWebAccessContext(string2, string);
                if (webAccessContext.getEnterpriseAppName() != null) {
                    if (auditHandler != null) {
                        auditHandler.setAppName(webAccessContext.getEnterpriseAppName());
                    }
                } else if (auditHandler != null) {
                    auditHandler.setAppName(webAccessContext.getWebAppName());
                }
                webAttributes = webAccessContext.getWebAttributes();
                if (!httpServletRequest.isSecure() && (webReply = this.checkDataConstraints(webAccessContext, string5, string4, httpServletRequest)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"authorize: ", (Object)webReply);
                    }
                    return webReply;
                }
                webReply = this.unprotectedSpecialURI(webAttributes, string5, string4);
                if (webReply != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"authorize: ", (Object)webReply);
                    }
                    return webReply;
                }
                if (this.unsupportedAuthMech(webAttributes)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Digest Authentication Mechanism is used and is not supported : sending DenyReply response");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"authorize: ");
                    }
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(3, 4)) {
                        auditFactory.sendAccessAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "UNSUPPORTED_AUTHN_MECH", httpServletRequest.getSession().getId(), null, string5, "WEB", httpServletRequest.getMethod(), providerName, true, "security.audit.service.unsupported.auth.mechanism.audit", new Object[]{webAttributes.getChallengeType()});
                    }
                    return new DenyReply("Authentication Failed : DIGEST not supported");
                }
                securityRoleArray = this.getRequiredRoles(webAccessContext, string5, string4);
                if (securityRoleArray == PermissionRoleMap.NO_REQUIRED_ROLES) {
                    webReply = PERMIT_REPLY;
                    if (tc.isDebugEnabled()) {
                        StringBuffer stringBuffer = new StringBuffer("No required roles for ");
                        stringBuffer.append(string5).append(".").append(string4);
                        Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"authorize", (Object)webReply);
                    }
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(3, 0)) {
                        auditFactory.sendAccessAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, string5, "WEB", httpServletRequest.getMethod(), providerName, true, "security.audit.service.no.auth.constraint.audit", null);
                    }
                    return webReply;
                }
                boolean bl2 = false;
                bl2 = this.authorizer.isEveryoneGranted(webAccessContext, securityRoleArray);
                if (bl2) {
                    webReply = PERMIT_REPLY;
                    if (tc.isDebugEnabled()) {
                        StringBuffer stringBuffer = new StringBuffer("Unprotected URI is ");
                        stringBuffer.append(string5).append(".").append(string4);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"authorize", (Object)webReply);
                    }
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(3, 0)) {
                        auditFactory.sendAccessAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, string5, "WEB", httpServletRequest.getMethod(), providerName, true, "security.audit.service.everyone.audit", null);
                    }
                    return webReply;
                }
                if (tc.isDebugEnabled()) {
                    serializable = new StringBuffer("URI -  ");
                    serializable.append(string5).append(".").append(string4).append(" is protected");
                    Tr.debug((TraceComponent)tc, (String)serializable.toString());
                }
                serializable = null;
                subject = null;
                try {
                    subject = contextManager.getCallerSubject();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Saving previous subject " + subject));
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"571", (Object)this);
                    if (!tc.isDebugEnabled()) break block52;
                    Tr.debug((TraceComponent)tc, (String)"Exception occurred when trying to get initial Caller Subject ");
                }
            }
            arrayList = null;
            string3 = "???";
            if (bl) {
                object = null;
                object = authenticator.authenticate(webAttributes, httpServletRequest, httpServletResponse);
                if (object == null) {
                    Tr.error((TraceComponent)tc, (String)"authResult is null");
                    return DENY_AUTHN_FAILED;
                }
                webReply = this.checkAuthStatus((AuthenticationResult)object, webAttributes);
                if (webReply != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"authorize", (Object)webReply);
                    }
                    return webReply;
                }
                serializable = ((AuthenticationResult)object).getSubject();
                arrayList = ((AuthenticationResult)object).getCookies();
                string3 = ((AuthenticationResult)object).getUserName();
                try {
                    contextManager.setCallerSubject((Subject)serializable);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"612", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception occurred when setting credentials for 'current'. ");
                    }
                    break block53;
                }
            }
            try {
                object = contextManager.getCallerSubject();
                if (object != null) {
                    serializable = object;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"624", (Object)this);
                if (!tc.isDebugEnabled()) break block53;
                Tr.debug((TraceComponent)tc, (String)"Invalid credentials retrieved from security  'current'.");
            }
        }
        boolean bl3 = false;
        try {
            this.checkAuthorization(webAccessContext, securityRoleArray, (Subject)serializable);
            bl3 = true;
        }
        catch (AccessException accessException) {
            FFDCFilter.processException((Throwable)accessException, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"646", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkAuthorization() failed, here is the message in the exception: " + accessException.getMessage()));
            }
            Tr.audit((TraceComponent)tc, (String)"security.web.authz.failed.foruser", (Object)new Object[]{string3, string4, string + string5, accessException.getMessage()});
            try {
                contextManager.setCallerSubject(subject);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"655", (Object)this);
            }
        }
        if (bl3) {
            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(1, 0)) {
                auditFactory.sendAuthzAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, string5, "WEB", string4, providerName, true, (Subject)serializable, "security.audit.authz.success.audit", null);
            }
        } else if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(1, 4)) {
            auditFactory.sendAuthzAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "DENIED", httpServletRequest.getSession().getId(), null, string5, "WEB", string4, providerName, true, (Subject)serializable, "security.audit.authz.denied.audit", null);
        }
        webReply = this.createReply(bl3, string5, arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"authorize", (Object)webReply);
        }
        return webReply;
    }

    protected WebReply authorizeForJACC(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl, String string2, String string3) throws WebSecurityException {
        String string4;
        ArrayList arrayList;
        Subject subject;
        WebResourcePermission webResourcePermission;
        String string5;
        String string6;
        String string7;
        WebReply webReply;
        block36: {
            Object object;
            Object object2;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"authorizeForJACC");
            }
            if (this.isAdminApp(string3)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("authorizeForJACC: app is an adminApp: " + string3));
                }
                return this.authorize(httpServletRequest, httpServletResponse, string, bl, string3);
            }
            webReply = null;
            string7 = WebCollaborator.getURI(httpServletRequest);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("URI resolved is: " + string7));
            }
            string6 = httpServletRequest.getMethod();
            String[] stringArray = new String[]{string6};
            webReply = this.validSecAttrs(string, string7, string6, true, string3);
            if (webReply != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"authorizeForJACC: ", (Object)webReply);
                }
                return webReply;
            }
            StringBuffer stringBuffer = new StringBuffer(WSAccessManager.getContextID(string3));
            if (stringBuffer == null) {
                throw new WebSecurityException("Cannot get the contextID for application: " + string3, null);
            }
            stringBuffer.append("/").append(string2);
            string5 = stringBuffer.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("contextID = " + string5));
            }
            WebAccessContext webAccessContext = this.webCache.getWebAccessContext(string3, string);
            if (!httpServletRequest.isSecure()) {
                object2 = new WebUserDataPermission(string7, stringArray, null);
                if (!this.checkDataConstraints(string5, httpServletRequest, (WebUserDataPermission)object2) && (webReply = this.getRedirectURL(httpServletRequest, string7, string6)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"authorizeForJACC: ", (Object)webReply);
                    }
                    return webReply;
                }
            } else {
                object2 = new WebUserDataPermission(string7, stringArray, "CONFIDENTIAL");
                if (!this.checkDataConstraints(string5, httpServletRequest, (WebUserDataPermission)object2)) {
                    webReply = DENY_AUTHZ_FAILED;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("WebUserDataPermission: " + object2 + " is Excluded."));
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"authorizeForJACC: ", (Object)webReply);
                    }
                    return webReply;
                }
            }
            if ((webReply = this.unprotectedSpecialURI((WebAttributes)(object2 = webAccessContext.getWebAttributes()), string7, string6)) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"authorizeForJACC for special URI: ", (Object)webReply);
                }
                return webReply;
            }
            boolean bl2 = false;
            webResourcePermission = new WebResourcePermission(string7, stringArray);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("preAuthorize: WebResourcePermission = " + webResourcePermission));
            }
            if (bl2 = this.checkJaccAccess(webResourcePermission, string5, httpServletRequest, null, null, string6)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("preAuthorize is true for web: " + string7 + ". exit value true"));
                }
                if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(3, 0)) {
                    auditFactory.sendAccessAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, string7, "WEB", httpServletRequest.getMethod(), providerName, true, "security.audit.service.everyone.audit", null);
                }
                return PERMIT_REPLY;
            }
            subject = null;
            arrayList = null;
            string4 = "???";
            if (bl) {
                object = null;
                object = authenticator.authenticate((WebAttributes)object2, httpServletRequest, httpServletResponse);
                if (object == null) {
                    Tr.error((TraceComponent)tc, (String)"authResult is null");
                    return DENY_AUTHN_FAILED;
                }
                webReply = this.checkAuthStatus((AuthenticationResult)object, (WebAttributes)object2);
                if (webReply != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"authorizeForJACC", (Object)webReply);
                    }
                    return webReply;
                }
                subject = ((AuthenticationResult)object).getSubject();
                arrayList = ((AuthenticationResult)object).getCookies();
                string4 = ((AuthenticationResult)object).getUserName();
                try {
                    contextManager.setCallerSubject(subject);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"836", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception occurred when setting credentials for 'current'. ");
                    }
                    break block36;
                }
            }
            try {
                object = contextManager.getCallerSubject();
                if (object != null) {
                    subject = object;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"848", (Object)this);
                if (!tc.isDebugEnabled()) break block36;
                Tr.debug((TraceComponent)tc, (String)"Invalid credentials retrieved from security  'current'.");
            }
        }
        boolean bl3 = false;
        bl3 = this.checkJaccAccess(webResourcePermission, string5, httpServletRequest, subject, string4, string6);
        if (bl3) {
            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(1, 0)) {
                auditFactory.sendAuthzAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, string7, "WEB", string6, providerName, true, subject, "security.audit.authz.success.audit", null);
            }
        } else if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(1, 4)) {
            auditFactory.sendAuthzAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "DENIED", httpServletRequest.getSession().getId(), null, string7, "WEB", string6, providerName, true, subject, "security.audit.authz.denied.audit", null);
        }
        webReply = this.createReply(bl3, string7, arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"authorizeForJACC", (Object)webReply);
        }
        return webReply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkJaccAccess(WebResourcePermission webResourcePermission, String string, HttpServletRequest httpServletRequest, Subject subject, String string2, String string3) {
        boolean bl;
        block17: {
            block16: {
                bl = false;
                final HashMap hashMap = new HashMap();
                final Subject subject2 = subject;
                final String string4 = string;
                final WebResourcePermission webResourcePermission2 = webResourcePermission;
                final HttpServletRequest httpServletRequest2 = httpServletRequest;
                Boolean bl2 = new Boolean(false);
                bl2 = (Boolean)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws PolicyContextException {
                        Principal[] principalArray;
                        PolicyContext.setContextID((String)string4);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Registering JACC context handlers");
                        }
                        for (int i = 0; i < jaccHandlerKeyArray.length; ++i) {
                            PolicyContext.registerHandler((String)jaccHandlerKeyArray[i], (PolicyContextHandler)wpch, (boolean)true);
                        }
                        hashMap.put(jaccHandlerKeyArray[0], subject2);
                        hashMap.put(jaccHandlerKeyArray[1], httpServletRequest2);
                        ProtectionDomain protectionDomain = null;
                        if (subject2 != null && subject2.getPrincipals().size() > 0) {
                            principalArray = subject2.getPrincipals().toArray(new Principal[subject2.getPrincipals().size()]);
                            protectionDomain = new ProtectionDomain(SecurityConfig.getNullCodeSource(), null, null, principalArray);
                        } else {
                            protectionDomain = SecurityConfig.getNullProtectionDomain();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Setting JACC handler data");
                        }
                        PolicyContext.setHandlerData((Object)hashMap);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Calling JACC implies");
                        }
                        principalArray = new Boolean(Policy.getPolicy().implies(protectionDomain, (Permission)webResourcePermission2));
                        return principalArray;
                    }
                });
                bl = bl2;
                if (!tc.isDebugEnabled()) break block16;
                if (bl) {
                    if (subject2 == null) {
                        Tr.debug((TraceComponent)tc, (String)"hasAccess is true for web during preauthorize");
                    } else {
                        Tr.debug((TraceComponent)tc, (String)"hasAccess is true for web during authorize");
                    }
                    break block16;
                }
                if (subject2 == null) {
                    Tr.debug((TraceComponent)tc, (String)"hasAccess is false for web during preauthorize");
                    break block16;
                }
                Tr.debug((TraceComponent)tc, (String)"hasAccess is false for web during authorize");
            }
            Object var15_15 = null;
            try {
                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() {
                        PolicyContext.setHandlerData(null);
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception when setting setHandler data: " + exception));
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"966", (Object)this);
            }
            break block17;
            {
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"950", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("checkAuthorization() failed with the exception: " + exception));
                    }
                    Tr.audit((TraceComponent)tc, (String)"security.web.authz.failed.foruser", (Object)new Object[]{string2, string3, string, exception.getMessage()});
                    Object var15_16 = null;
                    try {
                        AccessController.doPrivileged((PrivilegedExceptionAction)new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Exception exception2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Exception when setting setHandler data: " + exception2));
                        }
                        FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"966", (Object)this);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                try {
                    AccessController.doPrivileged((PrivilegedExceptionAction)new /* invalid duplicate definition of identical inner class */);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception when setting setHandler data: " + exception));
                    }
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"966", (Object)this);
                }
                throw throwable;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean checkDataConstraints(String string, HttpServletRequest httpServletRequest, WebUserDataPermission webUserDataPermission) throws WebSecurityException {
        boolean bl;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"checkConstraints");
            }
            Object var4_4 = null;
            bl = false;
            final WebUserDataPermission webUserDataPermission2 = webUserDataPermission;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WebUserDataPermission = " + webUserDataPermission2));
            }
            final String string2 = string;
            final HashMap hashMap = new HashMap();
            final HttpServletRequest httpServletRequest2 = httpServletRequest;
            Boolean bl2 = new Boolean(false);
            bl2 = (Boolean)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws PolicyContextException {
                    PolicyContext.setContextID((String)string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Registering JACC context handlers");
                    }
                    for (int i = 0; i < jaccHandlerKeyArray.length; ++i) {
                        PolicyContext.registerHandler((String)jaccHandlerKeyArray[i], (PolicyContextHandler)wpch, (boolean)true);
                    }
                    hashMap.put(jaccHandlerKeyArray[1], httpServletRequest2);
                    ProtectionDomain protectionDomain = SecurityConfig.getNullProtectionDomain();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Setting JACC handler data");
                    }
                    PolicyContext.setHandlerData((Object)hashMap);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Calling JACC implies");
                    }
                    Boolean bl = new Boolean(Policy.getPolicy().implies(protectionDomain, (Permission)webUserDataPermission2));
                    return bl;
                }
            });
            bl = bl2;
            Object var12_12 = null;
            try {
                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() {
                        PolicyContext.setHandlerData(null);
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception when setting setHandler data: " + exception));
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"1054", (Object)this);
            }
            break block18;
            {
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.checkDataConstraints", (String)"1037", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception during checkDataConstraints call: " + exception));
                    }
                    Tr.audit((TraceComponent)tc, (String)"security.web.authz.checkdataconstraint.failed", (Object)new Object[]{string, exception});
                    bl = false;
                    Object var12_13 = null;
                    try {
                        AccessController.doPrivileged((PrivilegedExceptionAction)new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Exception exception2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Exception when setting setHandler data: " + exception2));
                        }
                        FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"1054", (Object)this);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    AccessController.doPrivileged((PrivilegedExceptionAction)new /* invalid duplicate definition of identical inner class */);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception when setting setHandler data: " + exception));
                    }
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"1054", (Object)this);
                }
                throw throwable;
            }
        }
        if (tc.isDebugEnabled()) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"hasUserDataJaccAccess is true for web");
            } else {
                Tr.debug((TraceComponent)tc, (String)"hasUserDataJaccAccess is false for web");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkConstraints", (Object)String.valueOf(bl));
        }
        return bl;
    }

    private boolean isSSLRequired(WebAccessContext webAccessContext, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isSSLRequired");
        }
        WebAccessPermission webAccessPermission = new WebAccessPermission(string, string2);
        return webAccessContext.getConstraints().isSSLRequired(webAccessContext, webAccessPermission);
    }

    protected SecurityRole[] getRequiredRoles(WebAccessContext webAccessContext, String string, String string2) {
        WebAccessPermission webAccessPermission = new WebAccessPermission(string, string2);
        return webAccessContext.getConstraints().getRequiredRoles(webAccessContext, webAccessPermission);
    }

    protected void checkAuthorization(WebAccessContext webAccessContext, String string, String string2, Subject subject) throws AccessException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkAuthorization");
        }
        if (!this.securityEnabled) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkAuthorization");
            }
            if (auditFactory != null && auditFactory.isActive(1, 0)) {
                auditFactory.sendAuthzAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", null, null, string, "WEB", string2, providerName, true, subject, "security.audit.authz.disabled.audit", null);
            }
            return;
        }
        Object var5_5 = null;
        try {
            this.authorizer.checkAccess(webAccessContext, string, string2, new WSPrincipal(subject));
            if (auditFactory != null && auditFactory.isActive(1, 0)) {
                auditFactory.sendAuthzAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", null, null, string, "WEB", string2, providerName, true, subject, "security.audit.authz.success.audit", null);
            }
        }
        catch (AccessException accessException) {
            FFDCFilter.processException((Throwable)accessException, (String)"com.ibm.ws.security.web.WebCollaborator.checkAuthorization", (String)"1177", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkAuthorization: throw AccessException");
            }
            if (auditFactory != null && auditFactory.isActive(1, 4)) {
                auditFactory.sendAuthzAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "DENIED", null, (Exception)accessException, string, "WEB", string2, providerName, true, subject, "security.audit.authz.denied.audit", null);
            }
            throw accessException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkAuthorization");
        }
    }

    protected void checkAuthorization(WebAccessContext webAccessContext, SecurityRole[] securityRoleArray, Subject subject) throws AccessException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkAuthorization");
        }
        if (!this.securityEnabled) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkAuthorization");
            }
            return;
        }
        boolean bl = this.authorizer.isGrantedAnyRole(webAccessContext, securityRoleArray, subject);
        if (!bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkAuthorization: throw AccessException");
            }
            int n = securityRoleArray.length;
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("Authorization failed, Not granted any of the required roles: ");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(securityRoleArray[i].getRoleName()).append(" ");
            }
            throw new AccessException(stringBuffer.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkAuthorization");
        }
    }

    protected String getCookieValue(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCookieValue", (Object)string2);
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getCookieValue", (Object)"no cookie");
            }
            return null;
        }
        int n = 0;
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
        while (stringTokenizer.hasMoreElements()) {
            String string5 = stringTokenizer.nextToken();
            String string6 = null;
            String string7 = null;
            int n2 = string5.indexOf("=");
            if (n2 == 0 || n2 == string5.length()) break;
            string6 = string5.substring(0, n2).trim();
            if (!string6.equals(string2) && string6.charAt(0) == '$') continue;
            string7 = string5.substring(n2 + 1);
            if (string7.startsWith("\"") && string7.endsWith("\"")) {
                string7 = string7.substring(1, string7.length() - 1);
            }
            if (string6.charAt(0) == '$') {
                if (string6.equalsIgnoreCase("$Version")) {
                    n = Integer.parseInt(string7);
                    continue;
                }
                if (string6.equalsIgnoreCase("$Domain")) {
                    string3 = string7;
                    continue;
                }
                if (!string6.equalsIgnoreCase("$Path")) continue;
                string4 = string7;
                continue;
            }
            if (!string6.equalsIgnoreCase(string2)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getCookieValue", (Object)string7);
            }
            return string7;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCookieValue: null");
        }
        return null;
    }

    private String getCookieValue(Cookie[] cookieArray, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCookieValue", (Object)string);
        }
        String string2 = null;
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                if (!string.equals(cookieArray[i].getName())) continue;
                string2 = cookieArray[i].getValue();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCookieValue", string2);
        }
        return string2;
    }

    public boolean isUserInRole(String string, String string2, String string3, HttpServletRequest httpServletRequest) {
        boolean bl;
        block16: {
            if (!SecurityConfig.isJACCEnabled()) {
                return this.isUserInRole(string, string2, string3);
            }
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"isUserInRoleForJACC");
            }
            Subject subject = null;
            Object var6_6 = null;
            bl = false;
            if (this.securityEnabled) {
                try {
                    WebComponentMetaData webComponentMetaData = (WebComponentMetaData)ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
                    Subject subject2 = contextManager.getCallerSubject();
                    if (subject2 != null) {
                        subject = subject2;
                    }
                    String string4 = string3 + ":" + string2;
                    if (webComponentMetaData == null) break block16;
                    String string5 = ((WebModuleMetaData)webComponentMetaData.getModuleMetaData()).getConfiguration().getModuleName();
                    String string6 = ((WebModuleMetaData)webComponentMetaData.getModuleMetaData()).getApplicationMetaData().getName();
                    if (this.isAdminApp(string6)) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)("isUserInRoleForJACC: The app is an adminApp: " + string6));
                        }
                        return this.isUserInRole(string, string2, string3);
                    }
                    SecurityMetaData securityMetaData = (SecurityMetaData)webComponentMetaData.getSecurityMetaData();
                    String string7 = null;
                    if (securityMetaData != null) {
                        string7 = securityMetaData.getServletName();
                    }
                    try {
                        bl = string7 != null ? this.checkJaccUserInRolePerm(string7, string, string6, string5, subject, httpServletRequest) : this.checkJaccUserInRolePerm(nullString, string, string6, string5, subject, httpServletRequest);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.isUserInRole", (String)"1417", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Exception: ", (Object)exception);
                        }
                        bl = false;
                    }
                    if (tc.isDebugEnabled()) {
                        if (bl) {
                            Tr.debug((TraceComponent)tc, (String)"hasJaccAccess is true for web role ref");
                        } else {
                            Tr.debug((TraceComponent)tc, (String)"hasJaccAccess is false for web role ref");
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.isUserInRole", (String)"1432", (Object)this);
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug((TraceComponent)tc, (String)"Exception: ", (Object)exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isUserInRoleForJACC", (Object)String.valueOf(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkJaccUserInRolePerm(String string, String string2, String string3, String string4, Subject subject, HttpServletRequest httpServletRequest) {
        boolean bl;
        block17: {
            bl = false;
            StringBuffer stringBuffer = new StringBuffer(WSAccessManager.getContextID(string3));
            if (stringBuffer == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Cannot get the contextID for application: " + string3 + ". Returning false."));
                }
                return false;
            }
            stringBuffer.append("/").append(string4);
            String string5 = stringBuffer.toString();
            final WebRoleRefPermission webRoleRefPermission = new WebRoleRefPermission(string, string2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WebRoleRefPermission = " + webRoleRefPermission));
            }
            final String string6 = string5;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("contextID: " + string6));
            }
            final HashMap hashMap = new HashMap();
            final Subject subject2 = subject;
            final HttpServletRequest httpServletRequest2 = httpServletRequest;
            Boolean bl2 = new Boolean(false);
            bl2 = (Boolean)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws PolicyContextException {
                    Principal[] principalArray;
                    PolicyContext.setContextID((String)string6);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Registering JACC context handlers");
                    }
                    for (int i = 0; i < jaccHandlerKeyArray.length; ++i) {
                        PolicyContext.registerHandler((String)jaccHandlerKeyArray[i], (PolicyContextHandler)wpch, (boolean)true);
                    }
                    hashMap.put(jaccHandlerKeyArray[0], subject2);
                    hashMap.put(jaccHandlerKeyArray[1], httpServletRequest2);
                    ProtectionDomain protectionDomain = null;
                    if (subject2 != null && subject2.getPrincipals().size() > 0) {
                        principalArray = subject2.getPrincipals().toArray(new Principal[subject2.getPrincipals().size()]);
                        protectionDomain = new ProtectionDomain(SecurityConfig.getNullCodeSource(), null, null, principalArray);
                    } else {
                        protectionDomain = SecurityConfig.getNullProtectionDomain();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Setting JACC handler data");
                    }
                    PolicyContext.setHandlerData((Object)hashMap);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Calling JACC implies");
                    }
                    principalArray = new Boolean(Policy.getPolicy().implies(protectionDomain, (Permission)webRoleRefPermission));
                    return principalArray;
                }
            });
            bl = bl2;
            Object var17_17 = null;
            try {
                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() {
                        PolicyContext.setHandlerData(null);
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception when setting setHandler data: " + exception));
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"1530", (Object)this);
            }
            break block17;
            {
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security. web.WebCollaborator.checkUserInRole", (String)"1512", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception during isUserInRolecall: " + exception));
                    }
                    Tr.audit((TraceComponent)tc, (String)"security.web.authz.isuserinrole.failed", (Object)new Object[]{string5, exception});
                    bl = false;
                    Object var17_18 = null;
                    try {
                        AccessController.doPrivileged((PrivilegedExceptionAction)new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (Exception exception2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Exception when setting setHandler data: " + exception2));
                        }
                        FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"1530", (Object)this);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                try {
                    AccessController.doPrivileged((PrivilegedExceptionAction)new /* invalid duplicate definition of identical inner class */);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception when setting setHandler data: " + exception));
                    }
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.authorize", (String)"1530", (Object)this);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isUserInRole", (Object)String.valueOf(bl));
        }
        return bl;
    }

    protected static IPrivateRequestAttributes getPrivateAttributes(HttpServletRequest httpServletRequest) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPrivateAttributes");
        }
        IPrivateRequestAttributes iPrivateRequestAttributes = null;
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        if (httpServletRequest2 instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)httpServletRequest2;
            httpServletRequest2 = (HttpServletRequest)httpServletRequestWrapper.getRequest();
            while (httpServletRequest2 != null && httpServletRequest2 instanceof HttpServletRequestWrapper) {
                httpServletRequest2 = (HttpServletRequest)((HttpServletRequestWrapper)httpServletRequest2).getRequest();
            }
        }
        if (httpServletRequest2 != null && httpServletRequest2 instanceof SRTServletRequest) {
            iPrivateRequestAttributes = (IPrivateRequestAttributes)httpServletRequest2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPrivateAttributes", (Object)new Object[]{iPrivateRequestAttributes});
        }
        return iPrivateRequestAttributes;
    }

    protected static void setPrivateAttributes(HttpServletRequest httpServletRequest, String string, Object object) {
        HttpServletRequest httpServletRequest2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setPrivateAttributes", (Object)new Object[]{string, object});
        }
        if ((httpServletRequest2 = httpServletRequest) instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)httpServletRequest2;
            httpServletRequest2 = (HttpServletRequest)httpServletRequestWrapper.getRequest();
            while (httpServletRequest2 != null && httpServletRequest2 instanceof HttpServletRequestWrapper) {
                httpServletRequest2 = (HttpServletRequest)((HttpServletRequestWrapper)httpServletRequest2).getRequest();
            }
        }
        if (httpServletRequest2 != null && httpServletRequest2 instanceof SRTServletRequest) {
            ((IPrivateRequestAttributes)httpServletRequest2).setPrivateAttribute(string, object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setPrivateAttributes");
        }
    }

    public Principal getUserPrincipal() {
        Subject subject;
        String string;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getUserPrincipal");
            }
            string = null;
            if (this.securityEnabled) {
                try {
                    subject = contextManager.getCallerSubject();
                    final WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Caller credential: ", (Object)wSCredential);
                    }
                    if (subject == null || wSCredential.isUnauthenticated()) break block15;
                    if (contextManager.getPlatformHelper().isZOS()) {
                        try {
                            string = (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    PlatformCredential platformCredential = null;
                                    String string = (String)wSCredential.get("com.ibm.wsspi.security.token.caller_principal_class");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("Requested principal class is: " + string));
                                    }
                                    if ("com.ibm.ws.security.zos.Principal".equals(string)) {
                                        platformCredential = (PlatformCredential)wSCredential.get("com.ibm.ws.security.zos.PlatformCredential");
                                    }
                                    if (platformCredential != null) {
                                        return platformCredential.getUserId();
                                    }
                                    return null;
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.WebCollaborator", (String)"1659", (Object)this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Exception getting CallerPrincipalClass: ", (Object)new Object[]{privilegedActionException.getException()});
                            }
                            string = null;
                        }
                    }
                    boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.FullyQualifiedUserName");
                    if (string == null) {
                        string = wSCredential.getSecurityName();
                    }
                    if (bl) {
                        String string2 = wSCredential.getRealmName();
                        if (string2 == null || string2.length() == 0) {
                            string2 = (String)SecurityConfig.getConfig().getValue("security.activeUserRegistry.realm");
                        }
                        string = string2 + "/" + string;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator", (String)"1688");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception", (Object)exception);
                    }
                    string = null;
                }
            }
        }
        subject = null;
        if (string != null) {
            subject = new Identity(new String(string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserPrincipal", (Object)subject);
        }
        return subject;
    }

    protected boolean SetUnauthenticatedSubjectIfNeeded(Subject subject, Subject subject2) {
        boolean bl;
        block6: {
            bl = false;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"SetUnauthenticatedSubjectIfNeeded");
            }
            if (subject == null && subject2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Invoked and received Subject are null, setting it anonymous/unauthenticated.");
                }
                try {
                    contextManager.setInvocationSubject(SubjectHelper.createUnauthenticatedSubject());
                    bl = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.SetUnauthenticatedSubjectIfNeeded", (String)"1723", (Object)this);
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)("setUnauthenticated Subject threw an unexpected exception" + exception));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SetUnauthenticatedSubjectIfNeeded:" + bl));
        }
        return bl;
    }

    private int getHTTPSPort(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getHTTPSPort: " + n));
        }
        ArrayList arrayList = null;
        String string = null;
        int n2 = -1;
        Map map = (Map)SecurityConfig.getConfig().getValue("host.virtualhosts");
        List list = (List)SecurityConfig.getConfig().getValue("webcontainer.transports");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            arrayList = (ArrayList)map.get(string);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                if (tc.isDebugEnabled() && string2 != null) {
                    Tr.debug((TraceComponent)tc, (String)("Port " + string2 + " in virtual host " + string));
                }
                n2 = -1;
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (string2 == null || n2 != n) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found HTTP port " + string2 + " in virtual host " + string));
                }
                for (int j = 0; j < list.size(); ++j) {
                    Integer n3 = (Integer)list.get(j);
                    if (n3 == null) continue;
                    int n4 = n3;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Checking if port " + n4 + " is in the same virtual host."));
                    }
                    for (int k = 0; k < arrayList.size(); ++k) {
                        String string3 = (String)arrayList.get(k);
                        n2 = -1;
                        try {
                            n2 = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (string3 != null && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Port " + n2 + " in virtual host " + string));
                        }
                        if (string3 == null || n2 != n4) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)("Found HTTPS port " + n4 + " in virtual host " + string));
                        }
                        return n4;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getHTTPSPort: SSL port not found");
        }
        return -1;
    }

    protected boolean unsupportedAuthMech(WebAttributes webAttributes) {
        String string = webAttributes.getChallengeType();
        return string.equalsIgnoreCase("DIGEST");
    }

    public boolean isUserInRole(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isUserInRole");
        }
        Subject subject = null;
        WebAccessContext webAccessContext = null;
        if (this.securityEnabled) {
            WebComponentMetaData webComponentMetaData;
            block19: {
                try {
                    webComponentMetaData = (WebComponentMetaData)ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
                    Subject subject2 = contextManager.getCallerSubject();
                    if (subject2 != null) {
                        subject = subject2;
                    }
                    String string4 = string3 + ":" + string2;
                    String string5 = null;
                    if (webComponentMetaData != null) {
                        string5 = ((WebModuleMetaData)webComponentMetaData.getModuleMetaData()).getApplicationMetaData().getName();
                    }
                    if ((webAccessContext = this.webCache.getWebAccessContext(string5, string4)) == null) {
                        return false;
                    }
                    if (webComponentMetaData != null) {
                        String string6 = ((WebModuleMetaData)webComponentMetaData.getModuleMetaData()).getConfiguration().getModuleName();
                        SecurityMetaData securityMetaData = (SecurityMetaData)webComponentMetaData.getSecurityMetaData();
                        if (securityMetaData != null) {
                            String string7 = securityMetaData.getServletName();
                            EList eList = securityMetaData.getSecurityRoleRefs();
                            Iterator iterator = eList.iterator();
                            while (iterator.hasNext()) {
                                SecurityRoleRef securityRoleRef = (SecurityRoleRef)iterator.next();
                                String string8 = securityRoleRef.getName();
                                if (!string8.equals(string)) continue;
                                String string9 = securityRoleRef.getLink();
                                SecurityRole securityRole = WCCMHelper.createSecurityRole(string9, string9);
                                return this.authorizer.isGrantedRole(webAccessContext, securityRole, new WSPrincipal(subject));
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"In isUserInRole, security metadata is null");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"In isUserInRole, WebComponentMetaData is null");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebCollaborator.isUserInRole", (String)"1938", (Object)this);
                    if (!tc.isDebugEnabled()) break block19;
                    Tr.debug((TraceComponent)tc, (String)"Exception: ", (Object)exception);
                }
            }
            webComponentMetaData = WCCMHelper.createSecurityRole(string, string);
            if (webComponentMetaData != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found security role named " + string));
                }
                if (webAccessContext != null && subject != null) {
                    return this.authorizer.isGrantedRole(webAccessContext, (SecurityRole)webComponentMetaData, new WSPrincipal(subject));
                }
                return false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Did not find security role named " + string));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isUserInRole");
        }
        return false;
    }

    protected WebReply checkDataConstraints(WebAccessContext webAccessContext, String string, String string2, HttpServletRequest httpServletRequest) throws WebSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkConstraints");
        }
        WebReply webReply = null;
        if (this.isSSLRequired(webAccessContext, string, string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Request should be over SSL to access the resource. Redirecting to HTTPS...");
            }
            webReply = this.getRedirectURL(httpServletRequest, string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkConstraints", webReply);
        }
        return webReply;
    }

    static String getURI(HttpServletRequest httpServletRequest) {
        int n;
        String string = httpServletRequest.getServletPath();
        String string2 = httpServletRequest.getPathInfo();
        if (string2 != null) {
            string = string.concat(string2);
        }
        if (string == null || string.length() == 0) {
            string = "/";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("URI requested: " + string));
        }
        if (string != null && (n = (string = WSUtil.resolveURI((String)string)).indexOf(";")) != -1) {
            string = string.substring(0, n);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("uriName returned: " + string));
        }
        return string;
    }

    private boolean checkValidURI(String string) {
        return string != null && string.length() != 0;
    }

    private WebReply validSecAttrs(String string, String string2, String string3, boolean bl, String string4) {
        DenyReply denyReply = null;
        WebAccessContext webAccessContext = this.webCache.getWebAccessContext(string4, string);
        if (webAccessContext == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No Web App config found.");
            }
            StringBuffer stringBuffer = new StringBuffer("Cannot create a web security context for this request.");
            denyReply = new DenyReply(stringBuffer.toString());
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"authorize", (Object)((Object)denyReply));
            }
            if (auditFactory != null && auditFactory.isActive(3, 4)) {
                auditFactory.sendAccessAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "CONTEXT_NONEXIST", null, null, string2, "WEB", string3, providerName, true, "security.audit.service.no.context.audit", null);
            }
            return denyReply;
        }
        if (webAccessContext.getEnterpriseAppName() != null) {
            if (auditHandler != null) {
                auditHandler.setAppName(webAccessContext.getEnterpriseAppName());
            }
        } else if (auditHandler != null) {
            auditHandler.setAppName(webAccessContext.getWebAppName());
        }
        WebAttributes webAttributes = webAccessContext.getWebAttributes();
        if (!bl) {
            if (webAttributes == null) {
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("No WebAttributes for context root = ");
                    stringBuffer.append(string);
                    Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"authorize: ", (Object)PERMIT_REPLY);
                }
                if (auditFactory != null && auditFactory.isActive(3, 0)) {
                    auditFactory.sendAccessAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", null, null, string2, "WEB", string3, providerName, true, "security.audit.service.no.webattrs.audit", null);
                }
                return PERMIT_REPLY;
            }
            WebResourceCollectionConstraints webResourceCollectionConstraints = webAccessContext.getConstraints().getConstraints(webAccessContext, string2, string3);
            if (webResourceCollectionConstraints == null) {
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("No WebConstraints for URI = ");
                    stringBuffer.append(string2);
                    stringBuffer.append(", method = ");
                    stringBuffer.append(string3);
                    Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"authorize: ", (Object)PERMIT_REPLY);
                }
                if (auditFactory != null && auditFactory.isActive(3, 0)) {
                    auditFactory.sendAccessAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", null, null, string2, "WEB", string3, providerName, true, "security.audit.service.no.security.audit", null);
                }
                return PERMIT_REPLY;
            }
        }
        return null;
    }

    private WebReply unprotectedSpecialURI(WebAttributes webAttributes, String string, String string2) {
        if (webAttributes != null) {
            String string3 = null;
            String string4 = null;
            if (webAttributes.getChallengeType().equals("FORM") && (string3 = webAttributes.getLoginURL()) != null && (string4 = webAttributes.getReloginURL()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(" We have a custom login or error page request, web app login URL:[" + string3 + "], errorPage URL:[" + string4 + "], and the requested URI:[" + string + "]"));
                }
                if (string3.equals(string) || string4.equals(string)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("authorize, login or error page[" + string + "]  requested, permit: "), (Object)PERMIT_REPLY);
                    }
                    if (auditFactory != null && auditFactory.isActive(3, 0)) {
                        auditFactory.sendAccessAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", null, null, string, "WEB", string2, providerName, true, "security.audit.service.login.audit", null);
                    }
                    return PERMIT_REPLY;
                }
                if (string != null && string.equals("/j_security_check") && string2 != null && string2.equals("POST")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("authorize, login or error page[" + string + "]  requested, permit: "), (Object)PERMIT_REPLY);
                    }
                    if (auditFactory != null && auditFactory.isActive(3, 0)) {
                        auditFactory.sendAccessAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", null, null, string, "WEB", string2, providerName, true, "security.audit.service.login.audit", null);
                    }
                    return PERMIT_REPLY;
                }
            }
        }
        return null;
    }

    private WebReply checkAuthStatus(AuthenticationResult authenticationResult, WebAttributes webAttributes) {
        WebReply webReply = null;
        switch (authenticationResult.getStatus()) {
            case 2: {
                webReply = DENY_AUTHN_FAILED;
                Tr.audit((TraceComponent)tc, (String)"security.authn.failed", (Object)new Object[]{authenticationResult.getReason()});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkAuthStatus", (Object)webReply);
                }
                return webReply;
            }
            case 3: {
                webReply = new ChallengeReply(webAttributes.getRealm());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"authentication failed - sending a 401");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkAuthStatus", (Object)webReply);
                }
                return webReply;
            }
            case 5: {
                webReply = new TAIChallengeReply(authenticationResult.getTAIChallengeCode());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("TAI authentication challenge - sending " + authenticationResult.getTAIChallengeCode()));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkAuthStatus", (Object)webReply);
                }
                return webReply;
            }
            case 4: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"redirecting to another url");
                }
                webReply = authenticationResult.getCookies() != null ? new RedirectReply(authenticationResult.getRedirectURL(), authenticationResult.getCookies()) : new RedirectReply(authenticationResult.getRedirectURL());
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkAuthStatus", (Object)webReply);
                }
                return webReply;
            }
            case 0: 
            case 6: {
                Tr.audit((TraceComponent)tc, (String)"security.authn.failed", (Object)new Object[]{new Integer(authenticationResult.getStatus())});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Authentication failed. Status: " + authenticationResult.getStatus()));
                }
                webReply = DENY_AUTHN_FAILED;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkAuthStatus", (Object)webReply);
                }
                return webReply;
            }
        }
        return webReply;
    }

    private WebReply createReply(boolean bl, String string, ArrayList arrayList) {
        WebReply webReply = null;
        if (bl) {
            webReply = new PermitReply(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Authorization check for uri: " + string + " succeeded. "));
            }
        } else {
            webReply = DENY_AUTHZ_FAILED;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Authorization check for uri: " + string + " failed. "));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createReply", (Object)webReply);
        }
        return webReply;
    }

    private WebReply getRedirectURL(HttpServletRequest httpServletRequest, String string, String string2) {
        int n;
        String string3;
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRedirectURL");
        }
        StringBuffer stringBuffer = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest);
        String string4 = stringBuffer.toString();
        int n3 = string4.indexOf(47);
        if ((n2 = (string3 = string4.substring(n3 += 2, n = string4.indexOf(47, n3))).lastIndexOf(58)) != -1) {
            String string5 = string3.substring(n2 + 1);
            int n4 = Integer.parseInt(string5);
            int n5 = this.getHTTPSPort(n4);
            String string6 = Integer.toString(n5);
            stringBuffer.replace(n3 + n2 + 1, n, string6);
        }
        stringBuffer.replace(0, 4, "https");
        if (httpServletRequest.getQueryString() != null) {
            stringBuffer.append("?");
            stringBuffer.append(httpServletRequest.getQueryString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Redirected to " + stringBuffer.toString()));
        }
        if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(3, 5)) {
            auditFactory.sendAccessAuditEvent((AuditHandler)auditHandler, AuditOutcome.REDIRECT, "DATA_REDIRECT", httpServletRequest.getSession().getId(), null, string, "WEB", string2, providerName, true, "security.audit.service.secure.redirect.audit", new Object[]{stringBuffer.toString()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRedirectURL", (Object)stringBuffer.toString());
        }
        return new RedirectReply(stringBuffer.toString());
    }

    static {
        _lockObject = new Object();
        custom_auth_mech = false;
        custom_jaas_config = null;
        taManager = null;
        cache = null;
        cbkFactory = null;
        auditHandler = null;
        auditFactory = null;
        initialized = false;
    }
}

