/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.websphere.security.WebTrustAssociationUserException;
import com.ibm.websphere.security.audit.AuditHandler;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.AuditHandlerImpl;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.ContextManagerPlatformInterface;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.registry.UserRegistryImpl;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.ws.security.web.AuthenticationResult;
import com.ibm.ws.security.web.FormLoginInfo;
import com.ibm.ws.security.web.TAIWrapper;
import com.ibm.ws.security.web.TrustAssociationManager;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.security.web.WebCollaborator;
import com.ibm.ws.webcontainer.session.IHttpSession;
import com.ibm.ws.webcontainer.srt.SRTServletRequest;
import com.ibm.wsspi.security.audit.AuditOutcome;
import com.ibm.wsspi.security.audit.J2EEAuditEventFactory;
import com.ibm.wsspi.security.tai.TAIResult;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;

public class WebAuthenticator {
    private static final TraceComponent tc = Tr.register((Class)WebAuthenticator.class, null, (String)"com.ibm.ejs.resources.security");
    private static WebAuthenticator webAuthInstance = null;
    private ContextManager contextManager = ContextManagerFactory.getInstance();
    private static final String nullString = "";
    private static final String[] nullStringArray = new String[0];
    private long cushion;
    private static AuthenticationResult AUTHN_FAILED_RESULT = new AuthenticationResult(2, "Authentication Failed");
    private static AuthenticationResult CRED_FAILED_RESULT = new AuthenticationResult(2, "credential validation failure");
    protected static TrustAssociationManager taManager = null;
    public static final String FormUserName = "__WAS_FORM_USERNAME";
    public static final String FormPassword = "__WAS_FORM_PASSWORD";
    private static String authMech = null;
    private static final String providerName = "WebSphere";
    private static final boolean providerSuccess = true;
    private static final boolean providerFailure = false;
    public static ContextManager ctxMgr = ContextManagerFactory.getInstance();
    private static AuditHandlerImpl auditHandler = null;
    private static J2EEAuditEventFactory auditFactory = null;

    public static WebAuthenticator create(String string, AuditHandlerImpl auditHandlerImpl, J2EEAuditEventFactory j2EEAuditEventFactory) {
        if (webAuthInstance == null) {
            webAuthInstance = new WebAuthenticator();
            authMech = string;
        }
        auditHandler = auditHandlerImpl;
        auditFactory = j2EEAuditEventFactory;
        return webAuthInstance;
    }

    public static WebAuthenticator getInstance() {
        return webAuthInstance;
    }

    private WebAuthenticator() {
        this.initialize();
        TrustAssociationManager.create();
        taManager = TrustAssociationManager.getInstance();
    }

    private AuthenticationResult handleTrustAssociation(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        block25: {
            Object object;
            String string;
            AuthenticationResult authenticationResult;
            Subject subject;
            String string2;
            TAIWrapper tAIWrapper;
            block24: {
                tAIWrapper = null;
                string2 = null;
                subject = null;
                authenticationResult = null;
                string = this.contextManager.getDefaultRealm();
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"handleTrustAssociation");
                }
                if ((tAIWrapper = taManager.getInterceptor(httpServletRequest)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("TAI [" + tAIWrapper.getName() + "] is available for this request."));
                    }
                    try {
                        object = tAIWrapper.negotiateAndValidateEstablishedTrust(httpServletRequest, httpServletResponse);
                        int n = object.getStatus();
                        if (n == 200) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("TAI [" + tAIWrapper.getName() + "] has been validated successfully."));
                            }
                            subject = object.getSubject();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Subject retrieved is [" + subject + "]"));
                            }
                            string2 = object.getAuthenticatedPrincipal();
                            if (tc.isEntryEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Username retrieved from TAI is [" + string2 + "]"));
                            }
                            break block24;
                        }
                        if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                            auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.REDIRECT, "TAI_CHALLENGE", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, "TAI", webAttributes.getChallengeType(), null, tAIWrapper.getName(), true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.tai.challenge.audit", new Object[]{new Integer(n)});
                        }
                        return new AuthenticationResult(5, "Challenge from TrustAssociation Interception: " + tAIWrapper.getName(), n);
                    }
                    catch (WebTrustAssociationFailedException webTrustAssociationFailedException) {
                        FFDCFilter.processException((Throwable)webTrustAssociationFailedException, (String)"com.ibm.ws.security.web.WebAuthenticator.handleTrustAssociation", (String)"272", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.web.ta.validationfailed", (Object)new Object[]{webTrustAssociationFailedException});
                        if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 4)) {
                            auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "TAI_VALIDATION_FAILED", httpServletRequest.getSession().getId(), (Exception)((Object)webTrustAssociationFailedException), WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, "TAI", webAttributes.getChallengeType(), null, tAIWrapper.getName(), true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.web.ta.validationfailed", new Object[]{webTrustAssociationFailedException});
                        }
                        return new AuthenticationResult(2, webTrustAssociationFailedException.getMessage());
                    }
                    catch (WebTrustAssociationUserException webTrustAssociationUserException) {
                        FFDCFilter.processException((Throwable)webTrustAssociationUserException, (String)"com.ibm.ws.security.web.WebAuthenticator.handleTrustAssociation", (String)"284", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.web.ta.userex");
                        if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 6)) {
                            auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.FAILURE, "PROVIDER_FAILURE", httpServletRequest.getSession().getId(), (Exception)((Object)webTrustAssociationUserException), WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, "TAI", webAttributes.getChallengeType(), null, tAIWrapper.getName(), false, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.web.ta.userex", null);
                        }
                        return new AuthenticationResult(2, webTrustAssociationUserException.getMessage());
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAuthenticator.handleTrustAssociation", (String)"305", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.web.ta.genexc", (Object)new Object[]{exception});
                        if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 6)) {
                            auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.FAILURE, "PROVIDER_FAILURE", httpServletRequest.getSession().getId(), exception, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, "TAI", webAttributes.getChallengeType(), null, tAIWrapper.getName(), false, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.web.ta.genexc", null);
                        }
                        return new AuthenticationResult(2, exception.getMessage());
                    }
                }
            }
            if (string2 != null) {
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Map credentials for " + string2 + "."));
                }
                try {
                    object = webAttributes.getWebAppName();
                    HashMap<String, TAIResult> hashMap = new HashMap<String, TAIResult>(2);
                    hashMap.put("WebAppName", (TAIResult)object);
                    hashMap.put("RedirectURL", null);
                    Subject subject2 = this.contextManager.login(string, string2, authMech, httpServletRequest, httpServletResponse, hashMap, subject);
                    authenticationResult = new AuthenticationResult(1, subject2);
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 0)) {
                        auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, "TAI", webAttributes.getChallengeType(), string2, tAIWrapper.getName(), true, subject2, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.tai.success.audit", null);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Mapped credential for TrustAssociation was validated successfully.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"handleTrustAssociation: OK");
                    }
                    return authenticationResult;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAuthenticator.handleTrustAssociation", (String)"355", (Object)this);
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Error in mapping credential for Trust Association:" + string2));
                    }
                    authenticationResult = AUTHN_FAILED_RESULT;
                    if (auditFactory == null || httpServletRequest == null || !auditFactory.isActive(0, 4)) break block25;
                    auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "TAI_MAPPING_FAILED", httpServletRequest.getSession().getId(), exception, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, "TAI", webAttributes.getChallengeType(), string2, tAIWrapper.getName(), true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.tai.mapping.audit", null);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleTrustAssociation: (null user)");
        }
        return null;
    }

    private AuthenticationResult handleSSO(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = webAttributes.getPreferredLTPACookieName();
        String string2 = webAttributes.getLTPACookieName();
        Cookie[] cookieArray = httpServletRequest.getCookies();
        AuthenticationResult authenticationResult = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleSSO");
        }
        if (cookieArray != null) {
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < cookieArray.length; ++i) {
                if (string.equals(cookieArray[i].getName())) {
                    bl = true;
                }
                if (!string2.equals(cookieArray[i].getName())) continue;
                bl2 = true;
            }
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Attempting primary cookie validation for: " + string));
                }
                authenticationResult = this.validateCookie(cookieArray, string, webAttributes, httpServletRequest, httpServletResponse);
            } else if (bl2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Attempting secondary cookie validation for: " + string2));
                }
                authenticationResult = this.validateCookie(cookieArray, string2, webAttributes, httpServletRequest, httpServletResponse);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not find LTPA cookie(s) in request.");
            }
            if (authenticationResult != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"handleSSO: found cookie");
                }
                return authenticationResult;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleSSO: (null)");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleSSO: no cookies present in the request.");
        }
        return null;
    }

    private AuthenticationResult validateCookie(Cookie[] cookieArray, String string, WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        AuthenticationResult authenticationResult = null;
        String[] stringArray = WebAuthenticator.getCookieValues(cookieArray, string);
        if (stringArray != null) {
            String string2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                if (string2.length() <= 0) continue;
                byte[] byArray = null;
                try {
                    byArray = StringUtil.getBytes((String)Base64Coder.base64Decode((String)string2));
                    authenticationResult = this.validate(this.contextManager.getDefaultRealm(), byArray, webAttributes, httpServletRequest, httpServletResponse);
                    if (authenticationResult.getStatus() != 1) continue;
                    break;
                }
                catch (Exception exception) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception validating SSO token: ", (Object)new Object[]{exception});
                    }
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAuthenticator.handleSSO", (String)"486", (Object)this);
                    authenticationResult = AUTHN_FAILED_RESULT;
                    if (auditFactory == null || httpServletRequest == null || !auditFactory.isActive(0, 4)) continue;
                    auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "SSOTOKEN_VALIDATION_FAILED", httpServletRequest.getSession().getId(), exception, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), null, null, webAttributes.getChallengeType(), null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.sso.exception.audit", new Object[]{new String(byArray)});
                }
            }
            if (authenticationResult != null && authenticationResult.getStatus() == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The LTPA token was valid.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"handleSSO", (Object)("successful ltpa token validation of " + string2));
                }
                WebCollaborator.setPrivateAttributes(httpServletRequest, "AUTH_TYPE", webAttributes.getChallengeType());
                return authenticationResult;
            }
            return null;
        }
        return null;
    }

    private AuthenticationResult handleCustomLogin(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string;
        CharSequence charSequence;
        AuthenticationResult authenticationResult = null;
        String string2 = this.contextManager.getDefaultRealm();
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleCustomLogin");
        }
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Form based login is configured for the resource");
        }
        StringBuffer stringBuffer = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest);
        String string3 = stringBuffer.toString();
        String string4 = httpServletRequest.getContextPath();
        if (string4.equals("/")) {
            string4 = nullString;
        }
        int n = string3.indexOf("//");
        n = string3.indexOf("/", n + 2);
        int n2 = string3.length();
        String string5 = webAttributes.getLoginURL();
        if (!string5.startsWith("/")) {
            string5 = "/" + string5;
        }
        string5 = string4 + string5;
        stringBuffer.replace(n, n2, string5);
        string5 = stringBuffer.toString();
        String string6 = webAttributes.getReloginURL();
        n2 = string5.length();
        if (!string6.startsWith("/")) {
            string6 = "/" + string6;
        }
        string6 = string4 + string6;
        stringBuffer.replace(n, n2, string6);
        string6 = stringBuffer.toString();
        String string7 = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
        HttpSession httpSession = null;
        FormLoginInfo formLoginInfo = null;
        if (string7.equals("SWAM")) {
            httpSession = httpServletRequest.getSession(true);
            formLoginInfo = (FormLoginInfo)((IHttpSession)httpSession).getSecurityInfo();
            if (formLoginInfo != null) {
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Form based login: Using HTTP Sessions");
                }
                charSequence = formLoginInfo.getUsername();
                string = formLoginInfo.getPassword();
                if (charSequence != null && string != null) {
                    int n3;
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Form based login: Userid/password present in the session");
                    }
                    if ((n3 = (authenticationResult = this.basicAuthenticate(string2, (String)charSequence, string, webAttributes, httpServletRequest, httpServletResponse)).getStatus()) == 2) {
                        authenticationResult = new AuthenticationResult(4, string6);
                        if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                            auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.REDIRECT, "INVALID_UIDPSWD", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string2, string7, webAttributes.getChallengeType(), (String)charSequence, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.failed.audit", new Object[]{string6});
                        }
                    } else {
                        httpSession.removeAttribute("WASReqURL");
                    }
                    WebCollaborator.setPrivateAttributes(httpServletRequest, "AUTH_TYPE", "FORM");
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"handleCustomLogin");
                    }
                    return authenticationResult;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Form based login: No HTTP Session");
            }
        } else {
            authenticationResult = this.handleSSO(webAttributes, httpServletRequest, httpServletResponse);
            if (authenticationResult != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"handleCustomLogin");
                }
                return authenticationResult;
            }
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Form based login: No or Bad ltpa cookie ");
            }
        }
        charSequence = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest);
        if (httpServletRequest.getQueryString() != null) {
            ((StringBuffer)charSequence).append("?");
            ((StringBuffer)charSequence).append(httpServletRequest.getQueryString());
        }
        string = ((StringBuffer)charSequence).toString();
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Form based login: Stored original request : " + string));
        }
        authenticationResult = new AuthenticationResult(4, string5);
        if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
            auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.REDIRECT, "SEND_LOGIN_FORM", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string2, string7, webAttributes.getChallengeType(), null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.form.login.redirect.audit", new Object[]{string5});
        }
        if (string7.equals("SWAM")) {
            if (formLoginInfo == null) {
                formLoginInfo = new FormLoginInfo();
            }
            formLoginInfo.setRefererURL(string);
            ((IHttpSession)httpSession).putSecurityInfo((Object)formLoginInfo);
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Form based login: Referer URL set  in session " + string));
            }
        } else {
            Cookie cookie = new Cookie("WASReqURL", string);
            cookie.setPath("/");
            cookie.setMaxAge(-1);
            authenticationResult.setCookie(cookie);
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Form based login: Referer URL cookie set " + string));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleCustomLogin", (Object)("Redirecting to a login form" + string5));
        }
        return authenticationResult;
    }

    private AuthenticationResult handleCertificates(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        AuthenticationResult authenticationResult;
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"handleCertificates");
            }
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Challenge type used is CERT.");
            }
            String string = "CLIENT_CERT";
            authenticationResult = null;
            String string2 = this.contextManager.getDefaultRealm();
            X509Certificate[] x509CertificateArray = null;
            String string3 = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
            Object var9_9 = null;
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                x509CertificateArray = (X509Certificate[])httpServletRequest.getAttribute("javax.net.ssl.peer_certificates");
                if (x509CertificateArray == null) {
                    if (!webAttributes.isDefaultToBasic()) {
                        if (tc.isEntryEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"No certificate provided and default to basic is false.");
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"handleCertificates");
                        }
                        return new AuthenticationResult(2, "No Client Certificate Available", null);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No certificate was provided but defaulting to BASIC.");
                    }
                    string = "BASIC";
                }
                if (string.equalsIgnoreCase("BASIC")) break block21;
                byte[] byArray = x509CertificateArray[0].getEncoded();
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Map credential for this certificate.");
                }
                try {
                    object4 = string2;
                    object3 = x509CertificateArray;
                    final String string4 = webAttributes.getWebAppName();
                    object2 = string;
                    object = new PrivilegedExceptionAction((String)object4, (X509Certificate[])object3, httpServletRequest, httpServletResponse, string3, (String)object2){
                        private final /* synthetic */ String val$realm_final;
                        private final /* synthetic */ X509Certificate[] val$certs_final;
                        private final /* synthetic */ HttpServletRequest val$req;
                        private final /* synthetic */ HttpServletResponse val$res;
                        private final /* synthetic */ String val$authMechanism;
                        private final /* synthetic */ String val$challengeType_final;
                        {
                            this.val$realm_final = string2;
                            this.val$certs_final = x509CertificateArray;
                            this.val$req = httpServletRequest;
                            this.val$res = httpServletResponse;
                            this.val$authMechanism = string3;
                            this.val$challengeType_final = string42;
                        }

                        public Object run() throws Exception {
                            AuthenticationResult authenticationResult = null;
                            try {
                                Subject subject = null;
                                UserRegistryImpl userRegistryImpl = (UserRegistryImpl)SecurityServerImpl.getRegistryImpl(WebAuthenticator.this.contextManager.getDefaultRealm());
                                if (ctxMgr.getPlatformHelper().isZOS()) {
                                    Subject subject2 = null;
                                    try {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Calling contextManager.login with certificate");
                                        }
                                        HashMap<String, String> hashMap = new HashMap<String, String>(2);
                                        hashMap.put("WebAppName", string4);
                                        hashMap.put("RedirectURL", null);
                                        subject2 = ((ContextManagerPlatformInterface)WebAuthenticator.this.contextManager).login(this.val$realm_final, this.val$certs_final, authMech, this.val$req, this.val$res, hashMap);
                                        if (subject2 != null) {
                                            authenticationResult = new AuthenticationResult(1, subject2);
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)tc, (String)"Subject authenticated successfully");
                                            }
                                        } else {
                                            authenticationResult = AUTHN_FAILED_RESULT;
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)tc, (String)"Authentication failed");
                                            }
                                        }
                                        return authenticationResult;
                                    }
                                    catch (Exception exception) {
                                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAuthenticator.handleCertificates", (String)"763", (Object)this);
                                        if (tc.isEntryEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Credential Mapping for Certificate failed.");
                                        }
                                        authenticationResult = AUTHN_FAILED_RESULT;
                                        throw exception;
                                    }
                                }
                                if (userRegistryImpl != null) {
                                    String string = userRegistryImpl.mapCertificate(this.val$certs_final);
                                    HashMap<String, String> hashMap = new HashMap<String, String>(2);
                                    hashMap.put("WebAppName", string4);
                                    hashMap.put("RedirectURL", null);
                                    subject = WebAuthenticator.this.contextManager.login(this.val$realm_final, string, authMech, this.val$req, this.val$res, hashMap);
                                    if (subject != null) {
                                        authenticationResult = new AuthenticationResult(1, subject);
                                        if (auditFactory != null && this.val$req != null && auditFactory.isActive(0, 0)) {
                                            auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", this.val$req.getSession().getId(), null, WebCollaborator.getURI(this.val$req), "WEB", this.val$req.getMethod(), this.val$realm_final, this.val$authMechanism, this.val$challengeType_final, string, WebAuthenticator.providerName, true, subject, this.val$req.getRemoteAddr(), this.val$req.getRemoteHost(), this.val$req.getRemotePort(), "security.audit.cert.success.audit", null);
                                        }
                                    } else {
                                        authenticationResult = AUTHN_FAILED_RESULT;
                                        if (auditFactory != null && this.val$req != null && auditFactory.isActive(0, 4)) {
                                            auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "DENIED", this.val$req.getSession().getId(), null, WebCollaborator.getURI(this.val$req), "WEB", this.val$req.getMethod(), this.val$realm_final, this.val$authMechanism, this.val$challengeType_final, string, WebAuthenticator.providerName, true, null, this.val$req.getRemoteAddr(), this.val$req.getRemoteHost(), this.val$req.getRemotePort(), "security.audit.cert.mapping.audit", null);
                                        }
                                    }
                                } else {
                                    authenticationResult = AUTHN_FAILED_RESULT;
                                    if (auditFactory != null && this.val$req != null && auditFactory.isActive(0, 4)) {
                                        auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "DENIED", this.val$req.getSession().getId(), null, WebCollaborator.getURI(this.val$req), "WEB", this.val$req.getMethod(), this.val$realm_final, this.val$authMechanism, this.val$challengeType_final, null, WebAuthenticator.providerName, true, null, this.val$req.getRemoteAddr(), this.val$req.getRemoteHost(), this.val$req.getRemotePort(), "security.audit.cert.registry.audit", null);
                                    }
                                }
                                return authenticationResult;
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAuthenticator.handleCertificates", (String)"815", (Object)this);
                                if (tc.isEntryEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Credential Mapping for Certificate failed.");
                                }
                                authenticationResult = AUTHN_FAILED_RESULT;
                                if (auditFactory != null && this.val$req != null && auditFactory.isActive(0, 4)) {
                                    auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "DENIED", this.val$req.getSession().getId(), exception, WebCollaborator.getURI(this.val$req), "WEB", this.val$req.getMethod(), this.val$realm_final, this.val$authMechanism, this.val$challengeType_final, null, WebAuthenticator.providerName, true, null, this.val$req.getRemoteAddr(), this.val$req.getRemoteHost(), this.val$req.getRemotePort(), "security.audit.cert.exception.audit", null);
                                }
                                throw exception;
                            }
                        }
                    };
                    authenticationResult = (AuthenticationResult)this.contextManager.runAsSystem((PrivilegedExceptionAction)object);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    authenticationResult = AUTHN_FAILED_RESULT;
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 4)) {
                        auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "DENIED", httpServletRequest.getSession().getId(), (Exception)privilegedActionException, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string2, string3, string, null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.cert.exception.audit", null);
                    }
                    throw privilegedActionException.getException();
                }
                object4 = (Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred");
                authenticationResult.clearCookieList();
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Storing certificates in the credential");
                }
                object3 = new ArrayList(x509CertificateArray.length);
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    object3.add(x509CertificateArray[i]);
                }
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                object2 = certificateFactory.generateCertPath((List<? extends Certificate>)object3);
                object = authenticationResult.getSubject();
                WSCredential wSCredential = (WSCredential)((Subject)object).getPublicCredentials(WSCredential.class).iterator().next();
                if (wSCredential != null) {
                    wSCredential.set("wssecurity.setAttributForIdentityAssertion", object2);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAuthenticator.handleCertificates", (String)"873", (Object)this);
                if (webAttributes.isDefaultToBasic()) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception occurred while processing certificate: " + exception.getMessage()));
                        Tr.debug((TraceComponent)tc, (String)"Defaulting to Basic");
                    }
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 4)) {
                        auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "DENIED", httpServletRequest.getSession().getId(), exception, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string2, string3, string, null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.cert.default.audit", null);
                    }
                    string = "BASIC";
                }
                if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 4)) {
                    auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "DENIED", httpServletRequest.getSession().getId(), exception, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string2, string3, string, null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.cert.exception.audit", null);
                }
                throw exception;
            }
        }
        WebCollaborator.setPrivateAttributes(httpServletRequest, "AUTH_TYPE", "CLIENT_CERT");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleCertificates");
        }
        return authenticationResult;
    }

    static final String getHeader(HttpServletRequest httpServletRequest, String string) {
        Object object;
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        if (httpServletRequest2 instanceof HttpServletRequestWrapper) {
            object = (HttpServletRequestWrapper)httpServletRequest2;
            httpServletRequest2 = (HttpServletRequest)object.getRequest();
            while (httpServletRequest2 != null && httpServletRequest2 instanceof HttpServletRequestWrapper) {
                httpServletRequest2 = (HttpServletRequest)((HttpServletRequestWrapper)httpServletRequest2).getRequest();
            }
        }
        if (httpServletRequest2 != null && httpServletRequest2 instanceof SRTServletRequest) {
            object = ((SRTServletRequest)httpServletRequest2).getHeaderDirect(string);
            return object;
        }
        return httpServletRequest.getHeader(string);
    }

    private AuthenticationResult handleBasicAuth(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleBasicAuth");
        }
        AuthenticationResult authenticationResult = null;
        Cookie cookie = null;
        String string2 = this.contextManager.getDefaultRealm();
        String string3 = httpServletRequest.getHeader("Authorization");
        if (string3 == null || !string3.startsWith("Basic ")) {
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"basic 401");
            }
            authenticationResult = new AuthenticationResult(3, webAttributes.getRealm(), cookie);
            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.REDIRECT, "INVALID_UIDPSWD", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string2, null, webAttributes.getChallengeType(), null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.basic.challenge.audit", null);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleBasicAuth");
            }
            return authenticationResult;
        }
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Authorization: " + string3));
        }
        String string4 = httpServletRequest.getCharacterEncoding();
        int n = (string3 = Base64Coder.base64Decode((String)string3.substring(6), (String)string4)).indexOf(58);
        if (n < 0) {
            authenticationResult = new AuthenticationResult(3, webAttributes.getRealm(), cookie);
            if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 5)) {
                auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.REDIRECT, "INVALID_UIDPSWD", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string2, null, webAttributes.getChallengeType(), null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.basic.missing.audit", null);
            }
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Failed to find username/password info -- Sending 401.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleBasicAuth");
            }
            return authenticationResult;
        }
        String string5 = string3.substring(0, n);
        authenticationResult = this.basicAuthenticate(string2, string5, string = string3.substring(n + 1), webAttributes, httpServletRequest, httpServletResponse);
        int n2 = authenticationResult.getStatus();
        if ((n2 == 3 || n2 == 2) && n2 == 2) {
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Authentication failed after calling basicAuthenticate");
            }
            authenticationResult = new AuthenticationResult(3, webAttributes.getRealm(), cookie);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleBasicAuth");
        }
        return authenticationResult;
    }

    public AuthenticationResult authenticate(WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        AuthenticationResult authenticationResult;
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"authenticate");
            }
            authenticationResult = null;
            try {
                boolean bl = false;
                Object var6_7 = null;
                String string = webAttributes.getChallengeType();
                authenticationResult = null;
                Boolean bl2 = (Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred");
                if (bl2.booleanValue() && webAttributes.isSSOEnabled()) {
                    bl = webAttributes.isSecureSSO() ? httpServletRequest.getScheme().equalsIgnoreCase("https") : true;
                    authenticationResult = this.handleSSO(webAttributes, httpServletRequest, httpServletResponse);
                    if (authenticationResult != null) {
                        return authenticationResult;
                    }
                }
                if (taManager.isTrustAssociationEnabled()) {
                    authenticationResult = this.handleTrustAssociation(webAttributes, httpServletRequest, httpServletResponse);
                }
                if (authenticationResult == null) {
                    if (string.equalsIgnoreCase("FORM")) {
                        authenticationResult = this.handleCustomLogin(webAttributes, httpServletRequest, httpServletResponse);
                        return authenticationResult;
                    }
                    if (string.equalsIgnoreCase("CLIENT_CERT") && (authenticationResult = this.handleCertificates(webAttributes, httpServletRequest, httpServletResponse)) != null) {
                        if (bl) {
                            ArrayList arrayList = WebAttributes.createCookies(httpServletRequest, authenticationResult.getSubject());
                            if (arrayList != null) {
                                authenticationResult.setCookieList(arrayList);
                            }
                        }
                        return authenticationResult;
                    }
                    authenticationResult = this.handleBasicAuth(webAttributes, httpServletRequest, httpServletResponse);
                }
                if (authenticationResult.getStatus() == 1) {
                    WebCollaborator.setPrivateAttributes(httpServletRequest, "AUTH_TYPE", "BASIC");
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Successful authentication");
                    }
                    if (bl) {
                        ArrayList arrayList = WebAttributes.createCookies(httpServletRequest, authenticationResult.getSubject());
                        if (arrayList != null) {
                            authenticationResult.setCookieList(arrayList);
                        }
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAuthenticator.authenticate", (String)"1136", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception occurred: " + exception.getMessage()));
                    Tr.debug((TraceComponent)tc, (String)"Authentication failed.");
                }
                authenticationResult = new AuthenticationResult(2, exception.getMessage());
                if (auditFactory == null || httpServletRequest == null || !auditFactory.isActive(0, 4)) break block17;
                auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "DENIED", httpServletRequest.getSession().getId(), exception, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), null, null, webAttributes.getChallengeType(), null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.exception.audit", null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"authenticate");
        }
        return authenticationResult;
    }

    public static String getCookieValue(Cookie[] cookieArray, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCookieValue", (Object)string);
        }
        String string2 = null;
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                if (!string.equals(cookieArray[i].getName())) continue;
                string2 = cookieArray[i].getValue();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCookieValue", string2);
        }
        return string2;
    }

    public static String[] getCookieValues(Cookie[] cookieArray, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCookieValues", (Object)string);
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        if (cookieArray != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                if (!string.equals(cookieArray[i].getName())) continue;
                vector.add(cookieArray[i].getValue());
                ++n;
                if (!tc.isEntryEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)cookieArray[i].getValue());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCookieValues");
        }
        if (vector.size() > 0) {
            return vector.toArray(new String[n]);
        }
        return null;
    }

    public AuthenticationResult validate(String string, byte[] byArray, WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        AuthenticationResult authenticationResult;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"validate");
            }
            authenticationResult = null;
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>(2);
                hashMap.put("WebAppName", webAttributes.getWebAppName());
                hashMap.put("RedirectURL", null);
                Subject subject = this.contextManager.login(string, byArray, authMech, httpServletRequest, httpServletResponse, hashMap);
                boolean bl = this.contextManager.getWSCredTokenMapper().checkCushionValidityOfAllTokens(subject, this.cushion);
                if (subject != null) {
                    if (!bl) {
                        subject = null;
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"validate: LTPA token validation failed");
                        }
                        if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 4)) {
                            auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "TOKEN_EXPIRED", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, authMech, webAttributes.getChallengeType(), null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.sso.expired.audit", new Object[]{new String(byArray)});
                        }
                        return AUTHN_FAILED_RESULT;
                    }
                } else {
                    if (tc.isEntryEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"validate: Subject is null.");
                    }
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 4)) {
                        auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "SSOTOKEN_VALIDATION_FAILED", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, authMech, webAttributes.getChallengeType(), null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.sso.invalid.audit", new Object[]{new String(byArray)});
                    }
                    return AUTHN_FAILED_RESULT;
                }
                authenticationResult = new AuthenticationResult(1, subject);
                if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 0)) {
                    WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
                    auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, authMech, webAttributes.getChallengeType(), wSCredential.getSecurityName(), providerName, true, subject, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.sso.validate.audit", new Object[]{new String(byArray)});
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAuthenticator.validate", (String)"1286", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"validate", (Object)exception);
                }
                authenticationResult = new AuthenticationResult(2, exception.getMessage());
                if (auditFactory == null || httpServletRequest == null || !auditFactory.isActive(0, 4)) break block13;
                auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "DENIED", httpServletRequest.getSession().getId(), exception, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, authMech, webAttributes.getChallengeType(), null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.sso.exception.audit", new Object[]{new String(byArray)});
            }
        }
        authenticationResult.realm = string;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validate");
        }
        return authenticationResult;
    }

    private void initialize() {
        this.cushion = AuthCache.getInstance().getCushion();
    }

    public AuthenticationResult basicAuthenticate(String string, String string2, String string3) {
        return this.basicAuthenticate(string, string2, string3, null, null, null);
    }

    public AuthenticationResult basicAuthenticate(String string, String string2, String string3, WebAttributes webAttributes, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        AuthenticationResult authenticationResult;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"basicAuthenticate");
            }
            authenticationResult = null;
            try {
                Subject subject = null;
                if (webAttributes != null) {
                    HashMap<String, String> hashMap = new HashMap<String, String>(2);
                    hashMap.put("WebAppName", webAttributes.getWebAppName());
                    hashMap.put("RedirectURL", null);
                    subject = this.contextManager.login(this.contextManager.getDefaultRealm(), string2, string3, authMech, httpServletRequest, httpServletResponse, hashMap);
                } else {
                    subject = this.contextManager.login(this.contextManager.getDefaultRealm(), string2, string3, authMech, null, null, null);
                }
                if (subject == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"basicAuthenticate: authentication failed");
                    }
                    if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 4)) {
                        auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "INVALID_UIDPSWD", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, authMech, webAttributes.getChallengeType(), string2, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.basic.error.audit", null);
                    }
                    return AUTHN_FAILED_RESULT;
                }
                authenticationResult = new AuthenticationResult(1, subject);
                if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(0, 0)) {
                    auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, authMech, webAttributes.getChallengeType(), string2, providerName, true, subject, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.basic.success.audit", null);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.WebAuthenticator.basicAuthenticate", (String)"1388", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"basicAuthenticate", (Object)exception);
                }
                authenticationResult = new AuthenticationResult(2, exception.getMessage());
                if (auditFactory == null || httpServletRequest == null || !auditFactory.isActive(0, 4)) break block11;
                auditFactory.sendAuthnAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "DENIED", httpServletRequest.getSession().getId(), exception, WebCollaborator.getURI(httpServletRequest), "WEB", httpServletRequest.getMethod(), string, authMech, webAttributes.getChallengeType(), string2, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.basic.exception.audit", null);
            }
        }
        authenticationResult.realm = string;
        authenticationResult.userName = string2;
        authenticationResult.passWord = string3;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"basicAuthenticate");
        }
        return authenticationResult;
    }

    protected WSCredential setSasBasicAuth(String string, String string2, String string3) throws Exception {
        throw new RuntimeException("Not Implemented");
    }

    public Subject getPreferredSubject(Subject subject, Subject subject2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPreferredSubject");
        }
        return subject != null ? subject : subject2;
    }
}

