/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.audit.AuditHandler;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.AuditHandlerImpl;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.web.SecurityMetaData;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaData;
import com.ibm.ws.webcontainer.util.WebContainerSystemProps;
import com.ibm.wsspi.security.audit.AuditOutcome;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.J2EEAuditEventFactory;
import com.ibm.wsspi.webcontainer.extension.WebExtensionProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FormLogoutExtensionProcessor
extends WebExtensionProcessor {
    private static TraceComponent tc = Tr.register((Class)FormLogoutExtensionProcessor.class, null, (String)"com.ibm.ejs.resources.security");
    protected static String DEFAULT_LOGOUT_MSG = "<!DOCTYPE HTML PUBLIC \"-//W3C/DTD HTML 4.0 Transitional//EN\"><HTML><TITLE>Default Logout Exit Page</TITLE><BODY><H2>Successful Logout</H2></BODY></HTML>";
    private WebAttributes _webAttrs = null;
    private String _authMechanism = null;
    boolean _securityEnabled = (Boolean)SecurityConfig.getConfig().getValue("security.enabled");
    private static AuditHandlerImpl auditHandler = null;
    private static J2EEAuditEventFactory auditFactory = null;
    private static final String providerName = "WebSphere";
    private static final boolean providerSuccess = true;
    private static AuditService auditService = null;
    private static final String ADMIN_APP = "adminconsole";
    private static String ABSOLUTE_URI = "com.ibm.websphere.security.web.absoluteUri";
    private boolean _adminConsole = false;
    private boolean _absoluteUri = false;

    public FormLogoutExtensionProcessor(IServletContext iServletContext) {
        super(iServletContext);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("int, securityEnabled[" + this._securityEnabled + "]"));
        }
        if (this._securityEnabled) {
            try {
                Class<?> clazz;
                String string;
                WebAppConfig webAppConfig = iServletContext.getWebAppConfig();
                WebModuleMetaData webModuleMetaData = webAppConfig.getMetaData();
                SecurityMetaData securityMetaData = (SecurityMetaData)webModuleMetaData.getSecurityMetaData();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Create WebAttributes for this webApp.");
                }
                if (securityMetaData != null) {
                    this._webAttrs = securityMetaData.getWebAttributes();
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"In FormLogoutExtensionProcessor(), security MetaData is null.");
                }
                if (this._webAttrs == null) {
                    Tr.error((TraceComponent)tc, (String)"security.web.form.createWebAttr");
                } else {
                    this._authMechanism = this._webAttrs.getAuthMechanism();
                    if (ADMIN_APP.equalsIgnoreCase(this._webAttrs.getWebAppName())) {
                        this._adminConsole = true;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("securityEnabled[" + this._securityEnabled + "] " + "authMachism[" + this._authMechanism + "]"));
                    }
                }
                String string2 = System.getProperty(ABSOLUTE_URI);
                if (string2 != null && string2.equalsIgnoreCase("true")) {
                    this._absoluteUri = true;
                }
                this._authMechanism = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
                if (auditService == null && (auditService = ContextManagerFactory.getInstance().getAuditService()) != null && (auditFactory = (J2EEAuditEventFactory)(auditHandler = (AuditHandlerImpl)auditService.newAuditHandler(string = "WAS.security", string)).getAuditEventFactory("J2EE")) != null && !(clazz = Class.forName("com.ibm.wsspi.security.audit.J2EEAuditEventFactory")).isInstance(auditFactory)) {
                    auditFactory = null;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.web.FormLogoutServlet.init", (String)"103", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"security.web.form.noWebAppInfo", (Object)new Object[]{exception});
            }
        }
    }

    public void handleRequest(ServletRequest servletRequest, ServletResponse servletResponse) throws Exception {
        if (this._securityEnabled && servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            this.formLogout(httpServletRequest, httpServletResponse);
        }
    }

    private void formLogout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"formLogout");
        }
        if (auditHandler != null && this._webAttrs != null) {
            auditHandler.setAppName(this._webAttrs.getWebAppName());
        }
        if (auditFactory != null && httpServletRequest != null && auditFactory.isActive(11, 0)) {
            auditFactory.sendLogoutAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", httpServletRequest.getSession().getId(), null, ContextManagerFactory.getInstance().getDefaultRealm(), null, providerName, true, null, httpServletRequest.getRemoteAddr(), httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "security.audit.logout.success.audit", null);
        }
        if (this._authMechanism.equals("LTPA")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"LTPA Enabled, clearing LTPA Cookies");
            }
            this._webAttrs.createLogoutCookies(httpServletRequest, httpServletResponse);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"LTPA and SSO NOT Enabled");
        }
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"invalidating existing HTTP Session");
            }
            httpSession.invalidate();
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Existing HTTP Session does not exist, nothing to invalidate");
        }
        if (tc.isDebugEnabled()) {
            object3 = httpServletRequest.getParameterNames();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                Tr.debug((TraceComponent)tc, (String)("paramName:" + (String)object2));
                object = httpServletRequest.getParameterValues((String)object2);
                if (((String[])object).length == 1) {
                    String string = object[0];
                    if (string.length() == 0) {
                        Tr.debug((TraceComponent)tc, (String)"paramValue:No Value");
                        continue;
                    }
                    Tr.debug((TraceComponent)tc, (String)("paramValue:" + string));
                    continue;
                }
                for (int i = 0; i < ((String[])object).length; ++i) {
                    Tr.debug((TraceComponent)tc, (String)("paramValue:" + (String)object[i]));
                }
            }
        }
        if ((object3 = httpServletRequest.getParameter("logoutExitPage")) != null && ((String)object3).length() != 0) {
            if (((String)object3).startsWith("//")) {
                object3 = ((String)object3).substring(1);
            }
            if (!WebContainerSystemProps.getSendRedirectCompatibilty()) {
                Tr.debug((TraceComponent)tc, (String)"Compatibility=false (default) redirect mode");
                if (this._absoluteUri && !this._adminConsole) {
                    if (((String)object3).equals("/")) {
                        object3 = "";
                    } else if (((String)object3).startsWith("/")) {
                        object3 = ((String)object3).substring(1);
                    }
                    Tr.debug((TraceComponent)tc, (String)"Logout exit page is not relative to Context Root.");
                } else if (((String)object3).startsWith("/")) {
                    object2 = new StringBuffer();
                    object = httpServletRequest.getContextPath();
                    if (object != null && ((String)object).endsWith("/")) {
                        int n = ((String)object).lastIndexOf("/");
                        object = ((String)object).substring(0, n);
                    }
                    ((StringBuffer)object2).append((String)object);
                    ((StringBuffer)object2).append((String)object3);
                    object3 = ((StringBuffer)object2).toString();
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("logoutExitPage specified, redirecting to: " + (String)object3));
            }
            httpServletResponse.sendRedirect(httpServletResponse.encodeURL((String)object3));
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No logoutExitPage specified");
            }
            object2 = httpServletResponse.getWriter();
            ((PrintWriter)object2).println(DEFAULT_LOGOUT_MSG);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"formLogout");
        }
    }
}

