/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.token.AbstractTokenImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.security.PrivilegedAction;

public class SingleSignonTokenImpl
extends AbstractTokenImpl
implements SingleSignonToken {
    private Token token = null;
    private LTPAServerObject ltpaServer = null;
    private ContextManager contextManager = null;
    private String name = "LtpaToken";
    private short version = (short)2;
    private static final TraceComponent tc = Tr.register((Class)SingleSignonTokenImpl.class, null, (String)"com.ibm.ejs.resources.security");

    public void initializeToken(byte[] byArray) throws WSLoginFailedException {
        try {
            this.ltpaServer = LTPAServerObject.getLTPAServer();
            this.contextManager = ContextManagerFactory.getInstance();
            final Token token = this.token = this.ltpaServer.validateToken(byArray);
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    SingleSignonTokenImpl.this.setToken(token);
                    return null;
                }
            });
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.token.SingleSignonTokenImpl.initializeToken", (String)"63", (Object)((Object)this));
            Tr.debug((TraceComponent)tc, (String)"Exception validating LTPA token.", (Object)new Object[]{wSLoginFailedException});
            this.contextManager.setRootException((Throwable)wSLoginFailedException);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.SingleSignonTokenImpl.initializeToken", (String)"70", (Object)((Object)this));
            Tr.debug((TraceComponent)tc, (String)"Exception validating LTPA token.", (Object)new Object[]{exception});
            this.contextManager.setRootException((Throwable)exception);
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
    }

    public void initializeToken(Token token) throws WSLoginFailedException {
        final Token token2 = this.token = token;
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                SingleSignonTokenImpl.this.setToken(token2);
                return null;
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public short getVersion() {
        return this.version;
    }

    public Object clone() {
        try {
            SingleSignonTokenImpl singleSignonTokenImpl = new SingleSignonTokenImpl();
            this.token = (Token)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return SingleSignonTokenImpl.this.getToken();
                }
            });
            singleSignonTokenImpl.initializeToken((Token)this.token.clone());
            return singleSignonTokenImpl;
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)tc, (String)"Exception creating clone of single signon token.", (Object)new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.SingleSignonToken.clone", (String)"134");
            return null;
        }
    }
}

