/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.server.lm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.ws.security.common.auth.util.Util;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.icsf.ICSFConfigException;
import com.ibm.ws.security.icsf.ICSFServerObject;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class ICSFLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private WSPrincipal principal;
    private WSCredential credential;
    private ContextManager contextManager;
    private UserRegistry registry;
    protected boolean debug = false;
    private ICSFServerObject icsfServer;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final TraceComponent tc = Tr.register((Class)ICSFLoginModule.class, null, (String)"com.ibm.ejs.resources.security");

    public ICSFLoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ICSFLoginModule()");
            Tr.exit((TraceComponent)tc, (String)"ICSFLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + map.toString() + "\", options = \"" + map2.toString() + "\")"));
            }
            this.subject = subject;
            this.callbackHandler = callbackHandler;
            this.sharedState = map;
            this.options = map2;
            try {
                this.icsfServer = ICSFServerObject.getICSFServer();
            }
            catch (ICSFConfigException iCSFConfigException) {
                FFDCFilter.processException((Throwable)iCSFConfigException, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.initialize", (String)"120", (Object)this);
                if (!this.debug && !tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"ERROR: Failed to get the ICSF server object.");
            }
        }
        this.contextManager = ContextManagerFactory.getInstance();
        if (this.contextManager != null) {
            this.registry = this.contextManager.getRegistry(this.contextManager.getDefaultRealm());
            this.contextManager.clearRootException();
        }
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WSLoginModuleImpl initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    public boolean login() throws LoginException {
        Object object;
        Object object2;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"login()");
        }
        this.succeeded = false;
        if (this.commitSucceeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The login module is in funny state, cleanup before starting a new login process.");
            }
            this.cleanup();
        }
        if (this.callbackHandler == null) {
            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
            this.contextManager.setRootException((Throwable)wSLoginFailedException);
            throw wSLoginFailedException;
        }
        Callback[] callbackArray = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSCredTokenCallbackImpl("Credential Token: ")};
        String string = null;
        String string2 = null;
        char[] cArray = null;
        byte[] byArray = null;
        try {
            this.callbackHandler.handle(callbackArray);
            string = ((NameCallback)callbackArray[0]).getName();
            object2 = ((PasswordCallback)callbackArray[1]).getPassword();
            if (object2 != null) {
                cArray = new char[((char[])object2).length];
                System.arraycopy(object2, 0, cArray, 0, ((char[])object2).length);
                ((PasswordCallback)callbackArray[1]).clearPassword();
            }
            if ((object = ((WSCredTokenCallbackImpl)callbackArray[2]).getCredToken()) != null) {
                byArray = CredentialsHelper.copyCredToken((byte[])object);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.server.lm.ICSFLoginModule.login", (String)"180", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.jaas.callBackHandlerIOException", (Object)new Object[]{this.getClass().getName(), iOException});
            this.contextManager.setRootException((Throwable)iOException);
            throw new WSLoginFailedException("IOException: " + iOException.getMessage(), (Throwable)iOException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            FFDCFilter.processException((Throwable)unsupportedCallbackException, (String)"com.ibm.ws.security.server.lm.ICSFLoginModule.login", (String)"184", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.jaas.callBackHandlerException", (Object)new Object[]{this.getClass().getName(), unsupportedCallbackException.getCallback().toString(), unsupportedCallbackException});
            this.contextManager.setRootException((Throwable)unsupportedCallbackException);
            throw new WSLoginFailedException(unsupportedCallbackException.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user" + unsupportedCallbackException.getMessage(), (Throwable)unsupportedCallbackException);
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("uid = " + string));
            Tr.debug((TraceComponent)tc, (String)("realm = " + string2));
            Tr.debug((TraceComponent)tc, (String)("password = " + (cArray == null ? "<null>" : "XXXXXXXX")));
            Tr.debug((TraceComponent)tc, (String)("cred token = " + Util.toString((byte[])byArray)));
        }
        if (string == null && cArray == null && byArray == null) {
            object2 = (Object)new WSLoginFailedException("No authentication data.");
            this.contextManager.setRootException((Throwable)object2);
            throw object2;
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Successfully gathered authentication information");
        }
        if (string != null && cArray != null) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using uid and password for authentication");
                object2 = new StringBuffer("Authenticating \"");
                object2.append(string2).append('/').append(string).append("\"");
                Tr.debug((TraceComponent)tc, (String)object2.toString());
            }
            object2 = new String(cArray);
            object = new BasicAuthData(string, (String)object2);
            try {
                this.credential = this.icsfServer.authenticate((BasicAuthData)object);
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"271", (Object)this);
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login()", (Object)new Object[]{wSLoginFailedException});
                }
                this.contextManager.setRootException((Throwable)wSLoginFailedException);
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"277", (Object)this);
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"login()", (Object)new Object[]{exception});
                }
                this.contextManager.setRootException((Throwable)exception);
                throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
            }
        } else if (string != null) {
            object2 = System.getSecurityManager();
            if (object2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                    Tr.debug((TraceComponent)tc, (String)("Expecting : " + MAP_CREDENTIAL.toString()));
                }
                object2.checkPermission((Permission)MAP_CREDENTIAL);
            }
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using uid to mapCredential");
                object = new StringBuffer("Authenticating \"");
                ((StringBuffer)object).append(string2).append('/').append(string).append("\"");
                Tr.debug((TraceComponent)tc, (String)((StringBuffer)object).toString());
            }
            try {
                if (SecurityConfig.isRegTAM() && !RegistryUtil.checkValidUserifTAM(string, this.registry)) {
                    throw new WSLoginFailedException("User is not valid in Access Manager");
                }
                object = this.registry.createCredential(string);
                this.credential = this.icsfServer.createICSFToken((WSCredential)object);
            }
            catch (TokenCreationFailedException tokenCreationFailedException) {
                FFDCFilter.processException((Throwable)tokenCreationFailedException, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"311", (Object)this);
                Tr.debug((TraceComponent)tc, (String)"Using uid to mapCredential");
                this.contextManager.setRootException((Throwable)tokenCreationFailedException);
                throw new WSLoginFailedException(tokenCreationFailedException.getMessage(), (Throwable)tokenCreationFailedException);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"317", (Object)this);
                this.contextManager.setRootException((Throwable)exception);
                throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
            }
        } else if (byArray != null) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using credential token for authentication");
            }
            try {
                this.credential = this.icsfServer.validate(byArray);
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"333", (Object)this);
                this.contextManager.setRootException((Throwable)wSLoginFailedException);
                throw wSLoginFailedException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.ltpaLoginModule.login", (String)"338", (Object)this);
                this.contextManager.setRootException((Throwable)exception);
                throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
            }
        } else {
            object2 = (Object)new WSLoginFailedException("ltpaLoginModule: No authentication data");
            this.contextManager.setRootException((Throwable)object2);
            throw object2;
        }
        if (this.credential == null) {
            object2 = new WSLoginFailedException("ltpaLoginModule: Credential returned from SAS authentication is null");
            this.contextManager.setRootException((Throwable)object2);
            throw object2;
        }
        try {
            this.principal = ContextManagerFactory.getInstance().createPrincipal(this.credential);
        }
        catch (WSSecurityException wSSecurityException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"WSSecurityException caught creating a new principal.", (Object)new Object[]{wSSecurityException});
            }
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.server.lm.ICSFLoginModule.login", (String)"260", (Object)this);
            this.contextManager.setRootException((Throwable)wSSecurityException);
            throw new WSLoginFailedException(wSSecurityException.getMessage(), (Throwable)wSSecurityException);
        }
        this.succeeded = true;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login()");
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit()");
        }
        boolean bl = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Do not commit because of authentication failed.");
            }
            bl = false;
        } else {
            if (!this.commitSucceeded) {
                if (this.principal == null) {
                    WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("ltpaLoginModule: WSPrincipal is null in commit (phase 2) stage");
                    this.contextManager.setRootException((Throwable)wSLoginFailedException);
                    throw wSLoginFailedException;
                }
                if (this.credential == null) {
                    WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("ltpaLoginModule: WSCredential is null in commit (phase 2) stage");
                    this.contextManager.setRootException((Throwable)wSLoginFailedException);
                    throw wSLoginFailedException;
                }
                try {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Start committing the changes to the Subject ...");
                    }
                    try {
                        AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                                if (!ICSFLoginModule.this.subject.getPrincipals().contains(ICSFLoginModule.this.principal)) {
                                    ICSFLoginModule.this.subject.getPrincipals().add((Principal)ICSFLoginModule.this.principal);
                                }
                                if (!ICSFLoginModule.this.subject.getPublicCredentials().contains(ICSFLoginModule.this.credential)) {
                                    ICSFLoginModule.this.subject.getPublicCredentials().add(ICSFLoginModule.this.credential);
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.auth.swamLoginModule.commit", (String)"471", (Object)this);
                        this.contextManager.setRootException((Throwable)privilegedActionException.getException());
                        throw new WSLoginFailedException(privilegedActionException.getException().getMessage(), (Throwable)privilegedActionException.getException());
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.ICSFLoginModule.commit", (String)"341", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.jaas.LoginModuleCommitError", (Object)new Object[]{this.getClass().getName(), exception});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"It has been committed prior this call, nothing is done.");
            }
            bl = this.commitSucceeded;
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commit()");
        }
        return bl;
    }

    public boolean abort() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"abort()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug((TraceComponent)tc, (String)"Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logout()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug((TraceComponent)tc, (String)"Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Start removing WSPrinciapl, WSCredential, and CORBA Credentials from the Subject.");
            Tr.debug((TraceComponent)tc, (String)"Start removing ...");
        }
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                try {
                    if (ICSFLoginModule.this.principal != null && ICSFLoginModule.this.subject.getPrincipals().contains(ICSFLoginModule.this.principal)) {
                        ICSFLoginModule.this.subject.getPrincipals().remove(ICSFLoginModule.this.principal);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.ICSFLoginModule.run", (String)"456", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.jaas.removeCredException", (Object)new Object[]{this.getClass().getName(), exception});
                }
                try {
                    if (ICSFLoginModule.this.credential != null && ICSFLoginModule.this.subject.getPublicCredentials().contains(ICSFLoginModule.this.credential)) {
                        ICSFLoginModule.this.subject.getPublicCredentials().remove(ICSFLoginModule.this.credential);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.lm.ICSFLoginModule.run", (String)"464", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.jaas.removeCredException", (Object)new Object[]{this.getClass().getName(), exception});
                }
                if (ICSFLoginModule.this.credential != null) {
                    // empty if block
                }
                return null;
            }
        });
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Removed.");
        }
        this.principal = null;
        this.credential = null;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cleanup()");
        }
    }
}

