/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.audit.AuditHandler;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.audit.AuditHandlerImpl;
import com.ibm.ws.security.audit.AuditServiceImpl;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.role.PluggableAuthorizationTableProxy;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfiguratorImpl;
import com.ibm.ws.security.role.RoleBasedModule;
import com.ibm.ws.security.role.RoleBasedSubjectMap;
import com.ibm.wsspi.security.audit.AuditOutcome;
import com.ibm.wsspi.security.audit.J2EEAuditEventFactory;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;

class RoleBasedAuthorizerImpl
implements RoleBasedAuthorizer {
    private static TraceComponent tc = Tr.register((Class)RoleBasedAuthorizerImpl.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    private RoleBasedConfiguratorImpl configurator = null;
    private String appName = null;
    private String cellName = null;
    private String serverName = null;
    private HashMap accessContext = new HashMap(3);
    private PluggableAuthorizationTableProxy pluggableAuthTable = null;
    private static boolean ignoreCase = false;
    private static final ContextManager contextManager = ContextManagerFactory.getInstance();
    private boolean staticsInitialized = false;
    private static AuditHandlerImpl auditHandler = null;
    private static J2EEAuditEventFactory auditFactory = null;
    private static String providerName = "WebSphere";
    private static final boolean providerSuccess = true;

    public RoleBasedAuthorizerImpl(String string, RoleBasedConfiguratorImpl roleBasedConfiguratorImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{string, roleBasedConfiguratorImpl});
        }
        this.appName = string;
        this.configurator = roleBasedConfiguratorImpl;
        this.pluggableAuthTable = PluggableAuthorizationTableProxy.getAuthorizationTableProxy();
        if (this.pluggableAuthTable != null) {
            this.cellName = (String)SecurityConfig.getConfig().getValue("cellname");
            this.serverName = (String)SecurityConfig.getConfig().getValue("shortservername");
            this.accessContext.put("APPLICATION_NAME", this.appName);
            this.accessContext.put("SERVER_NAME", this.serverName);
            this.accessContext.put("CELL_NAME", this.cellName);
            providerName = "AuthorizationTable";
        }
        if (!this.staticsInitialized) {
            Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.registry.IgnoreCase");
            if (bl != null && bl.booleanValue()) {
                ignoreCase = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ignoreCase is set");
                }
            }
            try {
                AuditServiceImpl auditServiceImpl = (AuditServiceImpl)AuditServiceImpl.getAuditService();
                if (auditServiceImpl != null) {
                    Class<?> clazz;
                    auditHandler = (AuditHandlerImpl)auditServiceImpl.newAuditHandler("WAS.security", "WAS.security");
                    if (auditHandler != null) {
                        auditFactory = (J2EEAuditEventFactory)auditHandler.getAuditEventFactory("J2EE");
                    }
                    if (auditFactory != null && !(clazz = Class.forName("com.ibm.wsspi.security.audit.J2EEAuditEventFactory")).isInstance(auditFactory)) {
                        auditFactory = null;
                    }
                }
                if (auditHandler != null) {
                    auditHandler.setAppName(this.appName);
                }
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.classnotfound", (Object)new Object[]{"J2EEAuditEventFactory"});
            }
            this.staticsInitialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public boolean checkAccess(String string, String string2, String string3) {
        boolean bl;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"checkAccess", (Object)new Object[]{string, string2, string3});
            }
            bl = false;
            try {
                Object object;
                HashSet hashSet;
                CredHolder credHolder = null;
                RoleBasedSubjectMap roleBasedSubjectMap = this.configurator.getRoleBasedSubjectMap(this.appName);
                RoleBasedModule roleBasedModule = this.configurator.getRoleBasedModule(this.appName, string);
                HashSet hashSet2 = hashSet = roleBasedModule != null ? roleBasedModule.getRequiredRoles(string2 + ":" + string3) : null;
                if (this.isEveryoneGranted(hashSet, roleBasedSubjectMap)) {
                    bl = true;
                } else {
                    credHolder = this.getEffectiveCredentials();
                    if (credHolder.isThreadMissingCredentials()) {
                        object = new Exception("Invocation and received credentials are both null");
                        Tr.error((TraceComponent)tc, (String)"security.rolebauthz.nocred", (Object)new Object[]{string3, string2, string, object});
                    }
                    bl = this.pluggableAuthTable != null ? this.checkAccess(hashSet, string, string2, string3, credHolder) : this.checkAccess(hashSet, string, string2, string3, credHolder, roleBasedSubjectMap);
                }
                if (!bl) {
                    String string4 = this.getAccessId(credHolder.cred);
                    object = this.getSecurityName(credHolder.cred);
                    String[] stringArray = hashSet != null ? hashSet.toArray(new String[0]) : new String[]{};
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i == 0) {
                            stringBuffer.append(stringArray[i]);
                            continue;
                        }
                        stringBuffer.append(", ").append(stringArray[i]);
                    }
                    Tr.audit((TraceComponent)tc, (String)"security.rolebauthz.authzfail", (Object)new Object[]{this.appName, string2, string3, object, string4, stringBuffer.toString()});
                }
            }
            catch (RoleBasedAppException roleBasedAppException) {
                FFDCFilter.processException((Throwable)roleBasedAppException, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.checkAccess", (String)"284", (Object)this);
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug((TraceComponent)tc, (String)"Unable to acquire role info", (Object)((Object)roleBasedAppException));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkAccess", (Object)new Boolean(bl));
        }
        return bl;
    }

    private boolean checkAccess(Set set, String string, String string2, String string3, CredHolder credHolder) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkAccess", (Object)new Object[]{set, string, string2, string3, credHolder});
        }
        boolean bl = false;
        Exception exception = null;
        try {
            String[] stringArray = set == null ? new String[]{} : set.toArray(new String[0]);
            bl = this.pluggableAuthTable.isGrantedAnyRole(this.accessContext, stringArray, credHolder.subject);
        }
        catch (Exception exception2) {
            FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.checkAccess", (String)"317", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception caught: ", (Object)exception2);
            }
            Exception exception3 = exception = exception2 instanceof Exception ? exception2 : null;
        }
        if (auditFactory != null && auditFactory.isActive(1, 0) && bl) {
            auditFactory.sendAuthzAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", "", null, string2, "WAS", string3, providerName, true, credHolder.subject, "security.audit.authz.success.audit", null);
        }
        if (auditFactory != null && auditFactory.isActive(1, 4) && !bl) {
            auditFactory.sendAuthzAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "DENIED", "", exception, string2, "WAS", string3, providerName, true, credHolder.subject, "security.audit.authz.denied.audit", null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkAccess", (Object)new Boolean(bl));
        }
        return bl;
    }

    private boolean checkAccess(Set set, String string, String string2, String string3, CredHolder credHolder, RoleBasedSubjectMap roleBasedSubjectMap) {
        Exception exception;
        boolean bl;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"checkAccess", (Object)new Object[]{set, string, string2, string3, credHolder, roleBasedSubjectMap});
            }
            bl = false;
            exception = null;
            try {
                if (roleBasedSubjectMap.isGrantedAnyRole(credHolder.cred, set)) {
                    bl = true;
                } else if (this.isGroupGrantedAnyRole(set, roleBasedSubjectMap, credHolder.cred)) {
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.checkAccess", (String)"373", (Object)this);
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception caught: ", (Object)throwable);
            }
        }
        if (auditFactory != null && auditFactory.isActive(1, 0) && bl) {
            auditFactory.sendAuthzAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", "", null, string2, "WAS", string3, providerName, true, credHolder.subject, "security.audit.authz.success.audit", null);
        }
        if (auditFactory != null && auditFactory.isActive(1, 4) && !bl) {
            auditFactory.sendAuthzAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "DENIED", "", exception, string2, "WAS", string3, providerName, true, credHolder.subject, "security.audit.authz.denied.audit", null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkAccess", (Object)new Boolean(bl));
        }
        return bl;
    }

    private boolean isEveryoneGranted(Set set, RoleBasedSubjectMap roleBasedSubjectMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isEveryoneGranted", (Object)new Object[]{set, roleBasedSubjectMap});
        }
        boolean bl = false;
        if (this.pluggableAuthTable == null || set == null) {
            bl = roleBasedSubjectMap.isEveryoneGranted(set);
        } else {
            String[] stringArray = set == null ? new String[]{} : set.toArray(new String[0]);
            bl = this.pluggableAuthTable.isEveryoneGranted(this.accessContext, stringArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isEveryoneGranted", (Object)new Boolean(bl));
        }
        return bl;
    }

    private boolean isGroupGrantedAnyRole(Set set, RoleBasedSubjectMap roleBasedSubjectMap, WSCredential wSCredential) {
        ArrayList arrayList;
        boolean bl;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"isGroupGrantedAnyRole", (Object)new Object[]{set, roleBasedSubjectMap, wSCredential});
            }
            bl = false;
            arrayList = null;
            try {
                arrayList = wSCredential.getGroupIds();
            }
            catch (GeneralSecurityException generalSecurityException) {
                FFDCFilter.processException((Throwable)generalSecurityException, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.isCallerInRole", (String)"451", (Object)this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"Exception getting group IDs", (Object)generalSecurityException);
            }
        }
        String[] stringArray = arrayList == null ? new String[]{} : arrayList.toArray(new String[arrayList.size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            if (ignoreCase) {
                stringArray[i] = stringArray[i].toLowerCase();
            }
            if (!roleBasedSubjectMap.isGroupGrantedAnyRole(stringArray[i], set)) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isGroupGrantedAnyRole", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isCallerInRole(String string) {
        Object object;
        Object object2;
        CredHolder credHolder;
        boolean bl;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"isCallerInRole", (Object)string);
            }
            bl = false;
            if (string == null) {
                Tr.error((TraceComponent)tc, (String)"security.roleref.configerror", (Object)new Object[]{string});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"isCallerInRole", (Object)new Boolean(bl));
                }
                return bl;
            }
            credHolder = this.getEffectiveCredentials();
            if (credHolder.isThreadMissingCredentials()) {
                object2 = new Exception("Invocation and received credentials are both null");
                Tr.error((TraceComponent)tc, (String)"security.rolebauthz.nocred2", (Object)new Object[]{string, object2});
            }
            try {
                if (this.pluggableAuthTable != null) {
                    bl = this.pluggableAuthTable.isGrantedRole(this.accessContext, string, credHolder.subject);
                } else {
                    object = this.configurator.getRoleBasedSubjectMap(this.appName);
                    object2 = new HashSet(1);
                    ((HashSet)object2).add(string);
                    if (((RoleBasedSubjectMap)object).isGrantedAnyRole(credHolder.cred, (Set)object2)) {
                        bl = true;
                    } else if (this.isGroupGrantedAnyRole((Set)object2, (RoleBasedSubjectMap)object, credHolder.cred)) {
                        bl = true;
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.isCallerInRole", (String)"533", (Object)this);
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception caught: ", (Object)throwable);
            }
        }
        if (!bl && tc.isDebugEnabled()) {
            object = this.getSecurityName(credHolder.cred);
            object2 = this.getAccessId(credHolder.cred);
            Tr.debug((TraceComponent)tc, (String)("SECJ0321E: Role based authorization is caller in role  failed for security name: " + (String)object + " accessID: " + (String)object2 + " and role name: " + string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isCallerInRole", (Object)new Boolean(bl));
        }
        return bl;
    }

    private CredHolder getEffectiveCredentials() {
        CredHolder credHolder;
        boolean bl;
        block18: {
            WSCredential wSCredential;
            Subject subject;
            WSCredential wSCredential2;
            WSCredential wSCredential3;
            Subject subject2;
            block17: {
                if (tc.isEntryEnabled()) {
                    Tr.entry((TraceComponent)tc, (String)"getEffectiveCredentials");
                }
                subject2 = null;
                wSCredential3 = null;
                bl = false;
                Subject subject3 = null;
                wSCredential2 = null;
                subject = null;
                wSCredential = null;
                try {
                    subject3 = contextManager.getInvocationSubject();
                    wSCredential2 = SubjectHelper.getWSCredentialFromSubject((Subject)subject3);
                    if (wSCredential2 != null && !wSCredential2.isUnauthenticated()) {
                        subject2 = subject3;
                        wSCredential3 = wSCredential2;
                    }
                    if (wSCredential3 == null && (wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)(subject = contextManager.getCallerSubject()))) != null && !wSCredential.isUnauthenticated()) {
                        subject2 = subject;
                        wSCredential3 = wSCredential;
                    }
                }
                catch (WSSecurityException wSSecurityException) {
                    FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.getEffectiveCredentials", (String)"610", (Object)this);
                    if (!tc.isDebugEnabled()) break block17;
                    Tr.debug((TraceComponent)tc, (String)"Exception getting invocation credential", (Object)((Object)wSSecurityException));
                }
            }
            if (wSCredential2 == null && wSCredential == null) {
                bl = true;
            }
            if (wSCredential2 != null && wSCredential2.isUnauthenticated() && wSCredential != null && wSCredential.isUnauthenticated()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Invocation and received creds are UNAUTHENTICATED!");
                }
                subject2 = subject;
                wSCredential3 = wSCredential;
            }
            if (wSCredential3 != null && wSCredential3.isBasicAuth()) {
                try {
                    wSCredential3 = contextManager.authenticate(wSCredential3);
                }
                catch (WSSecurityException wSSecurityException) {
                    FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl", (String)"646", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception during authentication", (Object)((Object)wSSecurityException));
                    }
                    wSCredential3 = null;
                }
            }
            credHolder = new CredHolder(subject2, wSCredential3, bl);
            if (credHolder.cred == null) {
                try {
                    credHolder.subject = contextManager.createUnauthenticatedSubject();
                    credHolder.cred = contextManager.getUnauthenticatedCredential();
                }
                catch (WSSecurityException wSSecurityException) {
                    FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl", (String)"663", (Object)this);
                    if (!tc.isDebugEnabled()) break block18;
                    Tr.debug((TraceComponent)tc, (String)"Exception getting unauthenticated cred", (Object)((Object)wSSecurityException));
                }
            }
        }
        if ((credHolder.cred.isUnauthenticated() || bl) && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Unauthenticated or missing subject/credentials.", (Object)new Exception("Unauthenticated or missing subject/credentials."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEffectiveCredentials", (Object)credHolder);
        }
        return credHolder;
    }

    public boolean isGrantedRole(String[] stringArray, Subject subject) {
        Object object;
        Exception exception;
        WSCredential wSCredential;
        boolean bl;
        block26: {
            bl = false;
            wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
            exception = null;
            if (wSCredential != null && wSCredential.isBasicAuth()) {
                try {
                    wSCredential = contextManager.authenticate(wSCredential);
                }
                catch (WSSecurityException wSSecurityException) {
                    FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl", (String)"699", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception during authentication", (Object)((Object)wSSecurityException));
                    }
                    wSCredential = null;
                }
            }
            if (wSCredential == null) {
                try {
                    subject = contextManager.createUnauthenticatedSubject();
                    wSCredential = contextManager.getUnauthenticatedCredential();
                }
                catch (WSSecurityException wSSecurityException) {
                    FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl", (String)"714", (Object)this);
                    if (!tc.isDebugEnabled()) break block26;
                    Tr.debug((TraceComponent)tc, (String)"Exception getting unauthenticated cred", (Object)((Object)wSSecurityException));
                }
            }
        }
        try {
            object = new HashSet<String>();
            if (stringArray.length > 1) {
                for (int i = 0; i < stringArray.length; ++i) {
                    ((HashSet)object).add(stringArray[i]);
                }
            } else if (stringArray[0].equals("monitor")) {
                ((HashSet)object).add(stringArray[0]);
                ((HashSet)object).add("configurator");
                ((HashSet)object).add("operator");
                ((HashSet)object).add("administrator");
            } else if (stringArray[0].equals("configurator") || stringArray[0].equals("operator")) {
                ((HashSet)object).add(stringArray[0]);
                ((HashSet)object).add("administrator");
            } else {
                ((HashSet)object).add(stringArray[0]);
            }
            if (this.pluggableAuthTable != null) {
                stringArray = ((HashSet)object).toArray(new String[0]);
                bl = this.pluggableAuthTable.isGrantedAnyRole(this.accessContext, stringArray, subject);
            } else {
                RoleBasedSubjectMap roleBasedSubjectMap = this.configurator.getRoleBasedSubjectMap(this.appName);
                if (roleBasedSubjectMap.isGrantedAnyRole(wSCredential, (Set)object)) {
                    bl = true;
                } else if (this.isGroupGrantedAnyRole((Set)object, roleBasedSubjectMap, wSCredential)) {
                    bl = true;
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.isGrantedRole", (String)"767", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception caught", (Object)throwable);
            }
            Exception exception2 = exception = throwable instanceof Exception ? (Exception)throwable : null;
        }
        if (auditFactory != null && auditFactory.isActive(1, 0) && bl) {
            auditFactory.sendAuthzAuditEvent((AuditHandler)auditHandler, AuditOutcome.SUCCESS, "SUCCESS", "", null, null, "WAS", "isGrantedRole", providerName, true, subject, "security.audit.authz.success.audit", new Object[]{stringArray[0]});
        }
        if (auditFactory != null && auditFactory.isActive(1, 4) && !bl) {
            auditFactory.sendAuthzAuditEvent((AuditHandler)auditHandler, AuditOutcome.DENIED, "DENIED", "", exception, null, "WAS", "isGrantedRole", providerName, true, subject, "security.audit.authz.denied.audit", new Object[]{stringArray[0]});
        }
        if (!bl && tc.isDebugEnabled()) {
            object = stringArray[stringArray.length - 1];
            String string = this.getSecurityName(wSCredential);
            String string2 = this.getAccessId(wSCredential);
            Tr.debug((TraceComponent)tc, (String)"security.rolebauthz.iscallerinrolefail", (Object)new Object[]{string, string2, object});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("isGrantedRole, result:" + bl));
        }
        return bl;
    }

    private String getAccessId(WSCredential wSCredential) {
        String string;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getAccessId", (Object)wSCredential);
            }
            string = null;
            try {
                if (wSCredential != null) {
                    string = wSCredential.getAccessId();
                    if (ignoreCase) {
                        string = string.toLowerCase();
                    }
                } else {
                    string = "NO_CRED_NO_ACCESS_ID";
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                FFDCFilter.processException((Throwable)generalSecurityException, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.getAccessId", (String)"819", (Object)this);
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception getting accessId", (Object)generalSecurityException);
            }
        }
        if (string == null) {
            string = "NULL_ACCESS_ID";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAccessId", (Object)string);
        }
        return string;
    }

    private String getSecurityName(WSCredential wSCredential) {
        String string;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getSecurityName", (Object)wSCredential);
            }
            string = null;
            try {
                if (wSCredential != null) {
                    string = wSCredential.getSecurityName();
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                FFDCFilter.processException((Throwable)generalSecurityException, (String)"com.ibm.ws.security.role.RoleBasedAuthorizerImpl.getAccessId", (String)"846", (Object)this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception getting securityName", (Object)generalSecurityException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSecurityName", (Object)string);
        }
        return string;
    }

    private static final class CredHolder {
        WSCredential cred = null;
        Subject subject = null;
        boolean threadMissingCredentials = false;

        CredHolder(Subject subject, WSCredential wSCredential, boolean bl) {
            this.subject = subject;
            this.cred = wSCredential;
            this.threadMissingCredentials = bl;
        }

        public boolean isThreadMissingCredentials() {
            return this.threadMissingCredentials;
        }

        public String toString() {
            return super.toString() + ";cred=" + this.cred + ";subject=" + this.subject + ";threadMissingCredentials=" + this.threadMissingCredentials;
        }
    }
}

