/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.j2ee.common.SecurityRole;
import com.ibm.websphere.security.AuthorizationTable;
import com.ibm.websphere.security.SecurityProviderException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.AccessContext;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import java.security.Principal;
import java.util.HashMap;
import javax.security.auth.Subject;

public final class PluggableAuthorizationTableProxy {
    private static final TraceComponent tc = Tr.register((Class)PluggableAuthorizationTableProxy.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    public static final String SUBJECT_KEY = "AUTHZ_SUBJECT";
    private static PluggableAuthorizationTableProxy _instance = null;
    private static boolean _isSAFAuthorization = false;
    private static boolean _attemptedLoad = false;
    private final AuthorizationTable _authTable;
    private final String _cellName;
    private final String _serverName;

    public static synchronized PluggableAuthorizationTableProxy getAuthorizationTableProxy() {
        if (_attemptedLoad) {
            return _instance;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAuthorizationTableProxy");
        }
        ContextManager contextManager = ContextManagerFactory.getInstance();
        String string = contextManager.getProperty("com.ibm.websphere.security.authorizationTable", null);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Pluggable Authz Table name: " + string));
        }
        _attemptedLoad = true;
        if (string != null && string.length() != 0) {
            try {
                Object obj = Class.forName(string).newInstance();
                _instance = new PluggableAuthorizationTableProxy((AuthorizationTable)obj);
                Tr.audit((TraceComponent)tc, (String)"security.wsaccessmanager.classloaded", (Object)new Object[]{string});
                SecurityConfig.setNativeAuthz(false);
                _isSAFAuthorization = "com.ibm.ws.security.core.SAFAuthorizationTableImpl".equals(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.security.core.WSAccessManager.WSAccessManager", (String)"125");
                Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.classnotfound", (Object)new Object[]{string});
            }
            catch (InstantiationException instantiationException) {
                FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.security.core.WSAccessManager.WSAccessManager", (String)"130");
                Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.instantiationerror", (Object)new Object[]{string});
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.WSAccessManager", (String)"135");
                Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.classloading", (Object)new Object[]{string});
            }
            if (_instance == null) {
                Tr.audit((TraceComponent)tc, (String)"security.wsaccessmanager.classloadingaudit", (Object)new Object[]{string});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAuthorizationTableProxy", (Object)_instance);
        }
        return _instance;
    }

    private PluggableAuthorizationTableProxy(AuthorizationTable authorizationTable) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)authorizationTable);
        }
        this._authTable = authorizationTable;
        this._cellName = (String)SecurityConfig.getConfig().getValue("cellname");
        this._serverName = (String)SecurityConfig.getConfig().getValue("shortservername");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public AuthorizationTable getAuthorizationTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAuthorizationTable");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAuthorizationTable", (Object)this._authTable);
        }
        return this._authTable;
    }

    public boolean isGrantedRole(AccessContext accessContext, SecurityRole securityRole, Subject subject) {
        HashMap hashMap = this.createAccessContext(accessContext, subject);
        String string = securityRole.getRoleName();
        return this.isGrantedRole(hashMap, string, subject);
    }

    public boolean isGrantedRole(HashMap hashMap, String string, Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isGrantedRole", (Object)new Object[]{hashMap, string, subject});
        }
        boolean bl = false;
        try {
            WSPrincipal wSPrincipal = SubjectHelper.getPrincipalFromSubject((Subject)subject);
            hashMap = this.getAccessContext(hashMap, subject);
            bl = this._authTable.isGrantedRole(hashMap, string, (Principal)wSPrincipal);
        }
        catch (SecurityProviderException securityProviderException) {
            FFDCFilter.processException((Throwable)securityProviderException, (String)"com.ibm.ws.security.core.WSAccessManager.isGrantedRole", (String)"215", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.VendorAuthTableError", (Object)new Object[]{securityProviderException});
            Exception exception = securityProviderException.getException();
            if (exception != null) {
                Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.VendorAuthTableSpecificError", (Object)new Object[]{exception});
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.isGrantedRole", (String)"224", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.VendorAuthTableGenericError");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isGrantedRole", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isGrantedAnyRole(AccessContext accessContext, SecurityRole[] securityRoleArray, Subject subject) {
        HashMap hashMap = this.createAccessContext(accessContext, subject);
        String[] stringArray = this.getRoleNamesFromRoles(securityRoleArray);
        return this.isGrantedAnyRole(hashMap, stringArray, subject);
    }

    public boolean isGrantedAnyRole(HashMap hashMap, String[] stringArray, Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isGrantedAnyRole", (Object)new Object[]{hashMap, stringArray, subject});
        }
        boolean bl = false;
        try {
            WSPrincipal wSPrincipal = SubjectHelper.getPrincipalFromSubject((Subject)subject);
            hashMap = this.getAccessContext(hashMap, subject);
            bl = this._authTable.isGrantedAnyRole(hashMap, stringArray, (Principal)wSPrincipal);
        }
        catch (SecurityProviderException securityProviderException) {
            FFDCFilter.processException((Throwable)securityProviderException, (String)"com.ibm.ws.security.core.WSAccessManager.isGrantedRole", (String)"271", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.VendorAuthTableError", (Object)new Object[]{securityProviderException});
            Exception exception = securityProviderException.getException();
            if (exception != null) {
                Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.VendorAuthTableSpecificError", (Object)new Object[]{exception});
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.isGrantedRole", (String)"280", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.VendorAuthTableGenericError");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isGrantedAnyRole", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isEveryoneGranted(AccessContext accessContext, SecurityRole[] securityRoleArray) {
        HashMap hashMap = this.createAccessContext(accessContext, null);
        String[] stringArray = this.getRoleNamesFromRoles(securityRoleArray);
        return this.isEveryoneGranted(hashMap, stringArray);
    }

    public boolean isEveryoneGranted(HashMap hashMap, String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isEveryoneGranted", (Object)new Object[]{hashMap, stringArray});
        }
        boolean bl = false;
        try {
            bl = this._authTable.isEveryoneGranted(hashMap, stringArray);
        }
        catch (SecurityProviderException securityProviderException) {
            FFDCFilter.processException((Throwable)securityProviderException, (String)"com.ibm.ws.security.core.WSAccessManager.isGrantedRole", (String)"323", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.VendorAuthTableError", (Object)new Object[]{securityProviderException});
            Exception exception = securityProviderException.getException();
            if (exception != null) {
                Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.VendorAuthTableSpecificError", (Object)new Object[]{exception});
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.WSAccessManager.isGrantedRole", (String)"332", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.wsaccessmanager.VendorAuthTableGenericError");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isEveryoneGranted", (Object)new Boolean(bl));
        }
        return bl;
    }

    private HashMap createAccessContext(AccessContext accessContext, Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createAccessContext", (Object)new Object[]{accessContext, subject});
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("SERVER_NAME", this._serverName);
        hashMap.put("CELL_NAME", this._cellName);
        hashMap.put("APPLICATION_NAME", accessContext.getEnterpriseAppName());
        if (_isSAFAuthorization && subject != null) {
            hashMap.put(SUBJECT_KEY, subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createAccessContext", hashMap);
        }
        return hashMap;
    }

    private HashMap getAccessContext(HashMap hashMap, Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAccessContext", (Object)new Object[]{hashMap, subject});
        }
        HashMap hashMap2 = hashMap;
        if (_isSAFAuthorization && subject != null && hashMap != null) {
            hashMap2 = (HashMap)hashMap.clone();
            hashMap2.put(SUBJECT_KEY, subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAccessContext", (Object)hashMap2);
        }
        return hashMap2;
    }

    private String[] getRoleNamesFromRoles(SecurityRole[] securityRoleArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRoleNamesFromRoles", (Object)securityRoleArray);
        }
        String[] stringArray = securityRoleArray != null ? new String[securityRoleArray.length] : new String[]{};
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = securityRoleArray[i].getRoleName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRoleNamesFromRoles", (Object)stringArray);
        }
        return stringArray;
    }
}

