/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.zOS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.zOS.SAFRegistryException;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.RegExp;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import java.rmi.RemoteException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public final class SAFRegistryImpl
implements UserRegistry {
    private static final TraceComponent tc = Tr.register((Class)SAFRegistryImpl.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    private static final String TOKEN_DELIMETER = "::";
    private String realm = null;
    private boolean ignoreCase = true;
    private boolean disableGroupLoad = false;
    private boolean useSimpleAuthentication = false;
    private PlatformCredentialManager pcManager = PlatformCredentialManager.instance();

    public SAFRegistryImpl() throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public void initialize(Properties properties) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        this.realm = ContextManagerFactory.getInstance().getDefaultRealm();
        if (this.ignoreCase) {
            this.realm.toLowerCase();
        }
        String string = (String)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.zos.disableGroupAcquisition");
        this.disableGroupLoad = "true".equalsIgnoreCase(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public String checkPassword(String string, String string2) throws PasswordCheckFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkPassword", (Object)new Object[]{string, string2 == null ? null : "****"});
        }
        String string3 = this.normalizeUserId(string);
        String string4 = this.normalizePassword(string2);
        String string5 = null;
        try {
            Object object;
            if (this.useSimpleAuthentication) {
                string5 = SAFRegistryImpl.ntv_checkPassword(string3, string4);
            } else {
                object = this.pcManager.createPasswordCredential(string3, string4);
                String string6 = this.pcManager.getKeyFromCredential((PlatformCredential)object);
                string5 = string6 + TOKEN_DELIMETER + string;
            }
            if (string5 == null) {
                object = "Authentication failed for user: " + string;
                throw new PasswordCheckFailedException((String)object);
            }
        }
        catch (PasswordCheckFailedException passwordCheckFailedException) {
            Tr.error((TraceComponent)tc, (String)"security.authn.failed.foruser", (Object)new Object[]{string});
            throw passwordCheckFailedException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.checkPassword", (String)"227", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.authn.error", (Object)new Object[]{string, throwable});
            throw new CustomRegistryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkPassword", (Object)string5);
        }
        return string5;
    }

    public String mapCertificate(X509Certificate[] x509CertificateArray) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapCertificate", (Object)x509CertificateArray);
        }
        String string = null;
        try {
            if (this.useSimpleAuthentication) {
                byte[] byArray = x509CertificateArray[0].getEncoded();
                string = SAFRegistryImpl.ntv_mapCertificate(byArray, byArray.length);
            } else {
                PlatformCredential platformCredential = this.pcManager.createCertificateCredential(x509CertificateArray);
                String string2 = this.pcManager.getKeyFromCredential(platformCredential);
                string = string2 + TOKEN_DELIMETER + platformCredential.getUserId();
            }
            if (string == null) {
                throw new CertificateMapFailedException("Certificate could not be mapped to a valid SAF user ID");
            }
        }
        catch (CertificateMapFailedException certificateMapFailedException) {
            Tr.error((TraceComponent)tc, (String)"security.registry.mapcertificate.failed");
            throw certificateMapFailedException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.mapCertificate", (String)"287", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.mapcertificate.failed");
            throw new CustomRegistryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapCertificate", (Object)string);
        }
        return string;
    }

    public String getRealm() throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRealm");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRealm", (Object)this.realm);
        }
        return this.realm;
    }

    public Result getUsers(String string, int n) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsers", (Object)new Object[]{string, new Integer(n)});
        }
        Result result = new Result();
        ArrayList arrayList = this.getUsers(string);
        if (n > 0 && arrayList.size() > n) {
            arrayList = new ArrayList(arrayList.subList(0, n - 1));
            result.setHasMore();
        }
        result.setList((List)arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsers", (Object)result);
        }
        return result;
    }

    public String getUserDisplayName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserDisplayName", (Object)string);
        }
        try {
            if (!this.isValidUser(string)) {
                throw new EntryNotFoundException("Display name not found in registry");
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            Tr.error((TraceComponent)tc, (String)"security.registry.userdisplayname.notfound", (Object)new Object[]{string});
            throw entryNotFoundException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getUserDisplayName", (String)"415", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.userdisplayname.error", (Object)new Object[]{string, throwable});
            throw new EntryNotFoundException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserDisplayName", (Object)string);
        }
        return string;
    }

    public String getUniqueUserId(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueUserId", (Object)string);
        }
        try {
            if (!this.isValidUser(string)) {
                String string2 = "User " + string + " not found";
                throw new EntryNotFoundException(string2);
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            FFDCFilter.processException((Throwable)entryNotFoundException, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getUniqueUserId", (String)"455", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.uniqueusrid.notfound", (Object)new Object[]{string});
            throw entryNotFoundException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getUniqueUserId", (String)"461", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.uniqueusrid.error", (Object)new Object[]{string, throwable});
            throw new EntryNotFoundException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueUserId", (Object)string);
        }
        return string;
    }

    public String getUserSecurityName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserSecurityName", (Object)string);
        }
        if (!this.isValidUser(string)) {
            Tr.error((TraceComponent)tc, (String)"security.registry.usersecurityname.notfound", (Object)new Object[]{string});
            String string2 = "User " + string + " not found";
            throw new EntryNotFoundException(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserSecurityName", (Object)string);
        }
        return string;
    }

    public boolean isValidUser(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isValidUser", (Object)string);
        }
        boolean bl = false;
        try {
            string = this.normalizeUserId(string);
            bl = SAFRegistryImpl.ntv_isValidUser(string);
        }
        catch (SAFRegistryException sAFRegistryException) {
            FFDCFilter.processException((Throwable)sAFRegistryException, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.isValidUser", (String)"521", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.isvaliduser.error", (Object)new Object[]{string, sAFRegistryException});
            throw new CustomRegistryException((Throwable)sAFRegistryException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isValidUser", (Object)new Boolean(bl));
        }
        return bl;
    }

    public Result getGroups(String string, int n) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroups", (Object)new Object[]{string, new Integer(n)});
        }
        Result result = new Result();
        ArrayList arrayList = this.getGroups(string);
        if (n > 0 && arrayList.size() > n) {
            arrayList = new ArrayList(arrayList.subList(0, n - 1));
            result.setHasMore();
        }
        result.setList((List)arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroups", (Object)result);
        }
        return result;
    }

    public String getGroupDisplayName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupDisplayName", (Object)string);
        }
        try {
            if (!this.isValidGroup(string)) {
                throw new EntryNotFoundException("Group entry not found");
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            FFDCFilter.processException((Throwable)entryNotFoundException, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupDisplayName", (String)"609", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.groupdisplayname.notfound", (Object)new Object[]{string});
            throw entryNotFoundException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupDisplayName", (String)"615", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.groupdisplayname.error", (Object)new Object[]{string, throwable});
            throw new CustomRegistryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupDisplayName", (Object)string);
        }
        return string;
    }

    public String getUniqueGroupId(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueGroupId", (Object)string);
        }
        try {
            if (!this.isValidGroup(string)) {
                throw new EntryNotFoundException("Group entry not found");
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            FFDCFilter.processException((Throwable)entryNotFoundException, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getUniqueGroupId", (String)"654", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.uniquegrpid.notfound", (Object)new Object[]{string});
            throw entryNotFoundException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getUniqueGroupId", (String)"660", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.uniquegrpid.error", (Object)new Object[]{string, throwable});
            throw new CustomRegistryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueGroupId", (Object)string);
        }
        return string;
    }

    public List getUniqueGroupIds(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueGroupIds", (Object)string);
        }
        List list = this.getGroupsForUser(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueGroupIds", (Object)list);
        }
        return list;
    }

    public String getGroupSecurityName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupSecurityName", (Object)string);
        }
        if (!this.isValidGroup(string)) {
            Tr.error((TraceComponent)tc, (String)"security.registry.groupsecurityname.notfound", (Object)new Object[]{string});
            String string2 = "Group " + string + " not found";
            throw new EntryNotFoundException(string2);
        }
        String string3 = string;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupSecurityName", (Object)string3);
        }
        return string3;
    }

    public boolean isValidGroup(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isValidGroup", (Object)string);
        }
        boolean bl = false;
        try {
            string = this.normalizeGroupName(string);
            bl = SAFRegistryImpl.ntv_isValidGroup(string);
        }
        catch (SAFRegistryException sAFRegistryException) {
            FFDCFilter.processException((Throwable)sAFRegistryException, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.isValidGroup", (String)"754", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.isvalidgroup.error", (Object)new Object[]{string, sAFRegistryException});
            throw new CustomRegistryException((Throwable)sAFRegistryException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isValidGroup", (Object)new Boolean(bl));
        }
        return bl;
    }

    public List getGroupsForUser(String string) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupsForUser", (Object)string);
        }
        List list = null;
        try {
            String string2 = this.normalizeUserId(string);
            list = SAFRegistryImpl.ntv_getGroupsForUser(string2, new ArrayList());
            if (list.size() == 0 && !this.isValidUser(string)) {
                String string3 = "User " + string + " not found";
                throw new EntryNotFoundException(string3);
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            FFDCFilter.processException((Throwable)entryNotFoundException, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupsForUser", (String)"801", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.getgrpsforuser.notfound", (Object)new Object[]{string});
            throw entryNotFoundException;
        }
        catch (SAFRegistryException sAFRegistryException) {
            FFDCFilter.processException((Throwable)sAFRegistryException, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupsForUser", (String)"807", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.getgrpsforuser.notfound", (Object)new Object[]{string});
            String string4 = "User " + string + " not found";
            throw new EntryNotFoundException(string4);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupsForUser", (String)"814", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.getgrpsforuser.error", (Object)new Object[]{string, throwable});
            throw new CustomRegistryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupsForUser", (Object)list);
        }
        return list;
    }

    public Result getUsersForGroup(String string, int n) throws EntryNotFoundException, CustomRegistryException {
        ArrayList arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsersForGroup", (Object)new Object[]{string, new Integer(n)});
        }
        Result result = new Result();
        try {
            String string2 = this.normalizeGroupName(string);
            arrayList = SAFRegistryImpl.ntv_getUsersForGroup(string2, new ArrayList());
            if (arrayList.size() == 0 && !this.isValidGroup(string)) {
                String string3 = "Group " + string + " not found";
                throw new EntryNotFoundException(string3);
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            FFDCFilter.processException((Throwable)entryNotFoundException, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupsForUser", (String)"883", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.uniquegrpid.notfound", (Object)new Object[]{string});
            throw entryNotFoundException;
        }
        catch (SAFRegistryException sAFRegistryException) {
            FFDCFilter.processException((Throwable)sAFRegistryException, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupsForUser", (String)"889", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.getusrsforgrp.error", (Object)new Object[]{string, sAFRegistryException});
            String string4 = "Group " + string + " not found";
            throw new EntryNotFoundException(string4);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroupsForUser", (String)"896", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.getusrsforgrp.error", (Object)new Object[]{string, throwable});
            throw new CustomRegistryException(throwable);
        }
        if (n > 0 && arrayList.size() > n) {
            arrayList = new ArrayList(arrayList.subList(0, n - 1));
            result.setHasMore();
        }
        result.setList((List)arrayList);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsersForGroup", (Object)result);
        }
        return result;
    }

    public WSCredential createCredential(String string) throws CustomRegistryException, NotImplementedException, EntryNotFoundException {
        Object object;
        Object object2;
        Object object3;
        String[] stringArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createCredential", (Object)string);
        }
        String string2 = (stringArray = string.split(TOKEN_DELIMETER, 2)).length > 1 ? stringArray[0] : null;
        String string3 = string2 == null ? string : stringArray[1];
        WSCredential wSCredential = null;
        try {
            String[] stringArray2;
            object3 = this.getRealm();
            object2 = new ArrayList<String>();
            if (!this.disableGroupLoad && (object = this.getUniqueGroupIds(string3)) != null) {
                stringArray2 = object.toArray(new String[object.size()]);
                for (int i = 0; i < stringArray2.length; ++i) {
                    ((ArrayList)object2).add(RegistryUtil.appendRealm("group", stringArray2[i], (String)object3));
                }
            }
            object = RegistryUtil.appendRealm("user", string3, (String)object3);
            stringArray2 = ((ArrayList)object2).size() > 0 ? (String)((ArrayList)object2).get(0) : RegistryUtil.nullString;
            wSCredential = (WSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((String)object3, string3, (String)stringArray2, (String)object, (ArrayList)object2){
                private final /* synthetic */ String val$realm;
                private final /* synthetic */ String val$name;
                private final /* synthetic */ String val$primaryGroupId;
                private final /* synthetic */ String val$accessId;
                private final /* synthetic */ ArrayList val$groupList;
                {
                    this.val$realm = string;
                    this.val$name = string2;
                    this.val$primaryGroupId = string3;
                    this.val$accessId = string4;
                    this.val$groupList = arrayList;
                }

                public Object run() throws Exception {
                    return new WSCredentialImpl(this.val$realm, this.val$name, this.val$name, this.val$primaryGroupId, this.val$accessId, null, this.val$groupList);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.UserRegistryImpl.createCredential", (String)"960", (Object)this);
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        catch (EntryNotFoundException entryNotFoundException) {
            throw entryNotFoundException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.UserRegistryImpl.createCredential", (String)"969", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.createcredential.error", (Object)new Object[]{string3, exception});
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        try {
            object3 = null;
            if (string2 != null) {
                object3 = this.pcManager.getCredentialFromKey(string2);
            }
            if (object3 == null && !this.useSimpleAuthentication) {
                object3 = this.pcManager.createCredential(string3);
            }
            if (object3 != null) {
                object2 = object3;
                object = wSCredential;
                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((WSCredential)object, (PlatformCredential)object2){
                    private final /* synthetic */ WSCredential val$wsCred;
                    private final /* synthetic */ PlatformCredential val$platformCred;
                    {
                        this.val$wsCred = wSCredential;
                        this.val$platformCred = platformCredential;
                    }

                    public Object run() throws Exception {
                        this.val$wsCred.set("com.ibm.ws.security.zos.PlatformCredential", (Object)this.val$platformCred);
                        return null;
                    }
                });
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.SAFRegistryImpl", (String)"1002", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception setting PlatformCredential", (Object)privilegedActionException.getException());
            }
            throw new CustomRegistryException(privilegedActionException.getException().getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.SAFRegistryImpl", (String)"1008", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception setting PlatformCredential", (Object)exception);
            }
            throw new CustomRegistryException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCredential", (Object)wSCredential);
        }
        return wSCredential;
    }

    List getGroups() throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroups");
        }
        List list = this.getGroups("*");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroups", (Object)list);
        }
        return list;
    }

    List getGroups(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroups", (Object)string);
        }
        List list = null;
        try {
            list = SAFRegistryImpl.ntv_getGroups(new ArrayList());
            list = this.filterList(list, string);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getGroups", (String)"1052", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.getgroups.error", (Object)new Object[]{"*", throwable});
            throw new CustomRegistryException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroups", (Object)list);
        }
        return list;
    }

    private List getUsers(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsers", (Object)string);
        }
        List list = null;
        try {
            list = SAFRegistryImpl.ntv_getUsers(new ArrayList());
            list = this.filterList(list, string);
        }
        catch (SAFRegistryException sAFRegistryException) {
            FFDCFilter.processException((Throwable)sAFRegistryException, (String)"com.ibm.ws.security.registry.zOS.SAFRegistryImpl.getUsers", (String)"1078", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.getusers.error", (Object)new Object[]{string, sAFRegistryException});
            throw new CustomRegistryException((Throwable)sAFRegistryException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsers", (Object)list);
        }
        return list;
    }

    private List filterList(List list, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"filterArray", (Object)new Object[]{list, string});
        }
        RegExp regExp = new RegExp(string.toUpperCase());
        Iterator iterator = list.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!regExp.match(string2)) continue;
            arrayList.add(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"filterArray", arrayList);
        }
        return arrayList;
    }

    private String normalizeUserId(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"normailzeUserId", (Object)string);
        }
        String string2 = string = this.ignoreCase ? string.toUpperCase().trim() : string.trim();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"normalizeUserId", (Object)string);
        }
        return string;
    }

    private String normalizePassword(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"normalizePassword");
        }
        string = string.toUpperCase().trim();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"normalizePassword");
        }
        return string;
    }

    private String normalizeGroupName(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"normalizeGroupName", (Object)string);
        }
        String string2 = string = this.ignoreCase ? string.toUpperCase().trim() : string.trim();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"nomralizeGroupName", (Object)string);
        }
        return string;
    }

    private static synchronized native List ntv_getUsers(List var0) throws SAFRegistryException;

    private static synchronized native List ntv_getGroups(List var0) throws SAFRegistryException;

    private static native List ntv_getGroupsForUser(String var0, List var1) throws SAFRegistryException;

    private static native List ntv_getUsersForGroup(String var0, List var1) throws SAFRegistryException;

    private static native boolean ntv_isValidGroup(String var0) throws SAFRegistryException;

    private static native boolean ntv_isValidUser(String var0) throws SAFRegistryException;

    private static native String ntv_checkPassword(String var0, String var1) throws SAFRegistryException;

    private static native String ntv_mapCertificate(byte[] var0, int var1) throws SAFRegistryException;
}

