/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.unix;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.registry.unix.UnixRegistryException;
import com.ibm.ws.security.util.RegExp;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class UnixRegistryImpl
implements UserRegistry {
    private static TraceComponent tc;
    private String realm;
    int maxUidSize = -1;
    int maxPWSize = -1;

    private native int ntv_basicAuthenticate(String var1, String var2) throws UnixRegistryException;

    private native String[] ntv_getUsers() throws UnixRegistryException;

    private native String[] ntv_getGroups() throws UnixRegistryException;

    private native String[] ntv_getGroupsForUser(String var1) throws UnixRegistryException;

    private native String ntv_getGroupRealName(String var1) throws UnixRegistryException;

    private native String ntv_getUserRealName(String var1) throws UnixRegistryException;

    private native String ntv_getGroupSecurityName(long var1) throws UnixRegistryException;

    private native String ntv_getUserSecurityName(long var1) throws UnixRegistryException;

    private native long ntv_getGID(String var1) throws UnixRegistryException;

    private native long ntv_getUID(String var1) throws UnixRegistryException;

    private native int ntv_isValidGroup(String var1) throws UnixRegistryException;

    private native int ntv_isValidUser(String var1) throws UnixRegistryException;

    public String checkPassword(String string, String string2) throws PasswordCheckFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"authenticate");
        }
        if (string.length() > this.getMaxUidSize() || string2.length() > this.getMaxPWSize()) {
            Tr.error((TraceComponent)tc, (String)"security.registry.checkpass.failed", (Object)new Object[]{string});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkPassword");
            }
            throw new PasswordCheckFailedException("checkPassword failed due to userid length (" + string.length() + ") and/or password length " + string2.length() + ") too large.");
        }
        try {
            if (this.ntv_basicAuthenticate(string, string2) == 0) {
                PasswordCheckFailedException passwordCheckFailedException = new PasswordCheckFailedException("Authentication failed for user: " + string);
                Tr.error((TraceComponent)tc, (String)"security.authn.failed.foruser", (Object)new Object[]{string});
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"authenticate", (Object)((Object)passwordCheckFailedException));
                }
                throw passwordCheckFailedException;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.unix.UnixRegistryImpl.checkPassword", (String)"125", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"authenticate", (Object)exception);
            }
            Tr.error((TraceComponent)tc, (String)"security.authn.error", (Object)new Object[]{string, exception});
            throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
        }
        return string;
    }

    public String mapCertificate(X509Certificate[] x509CertificateArray) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapCertificate");
        }
        CertificateMapNotSupportedException certificateMapNotSupportedException = new CertificateMapNotSupportedException("");
        Tr.error((TraceComponent)tc, (String)"security.registry.mapcertificate.notsupported");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapCertificate", (Object)certificateMapNotSupportedException);
        }
        throw certificateMapNotSupportedException;
    }

    public String getGroupDisplayName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupDisplayName");
        }
        String string2 = "";
        try {
            string2 = this.ntv_getGroupRealName(string);
        }
        catch (UnixRegistryException unixRegistryException) {
            FFDCFilter.processException((Throwable)unixRegistryException, (String)"com.ibm.ws.security.registry.unix.UnixRegistryImpl.getGroupDisplayName", (String)"214", (Object)this);
            this.logErrorCode(unixRegistryException);
            Tr.error((TraceComponent)tc, (String)"security.registry.groupdisplayname.error", (Object)new Object[]{string, unixRegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroupDisplayName", (Object)unixRegistryException);
            }
            this.throwException(unixRegistryException, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupDisplayName");
        }
        return string2;
    }

    public String getUniqueGroupId(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueGroupId", (Object)string);
        }
        long l = 0L;
        try {
            l = this.ntv_getGID(string);
        }
        catch (UnixRegistryException unixRegistryException) {
            FFDCFilter.processException((Throwable)unixRegistryException, (String)"com.ibm.ws.security.registry.unix.UnixRegistryImpl.getUniqueGroupId", (String)"243", (Object)this);
            this.logErrorCode(unixRegistryException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroupPrivilegeAttributeId", (Object)unixRegistryException);
            }
            Tr.error((TraceComponent)tc, (String)"security.registry.uniquegrpid.error", (Object)new Object[]{string, unixRegistryException});
            this.throwException(unixRegistryException, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueGroupId", (Object)String.valueOf(l));
        }
        return String.valueOf(l);
    }

    public Enumeration getGroups() throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroups");
        }
        String[] stringArray = null;
        try {
            stringArray = this.ntv_getGroups();
        }
        catch (UnixRegistryException unixRegistryException) {
            FFDCFilter.processException((Throwable)unixRegistryException, (String)"com.ibm.ws.security.registry.unix.UnixRegistryImpl.getGroups", (String)"268", (Object)this);
            this.logErrorCode(unixRegistryException);
            Tr.error((TraceComponent)tc, (String)"security.registry.getgroups.error", (Object)new Object[]{"*", unixRegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroups", (Object)unixRegistryException);
            }
            throw new CustomRegistryException(unixRegistryException.getMessage(), (Throwable)unixRegistryException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroups");
        }
        return this.arrayToEnumeration(stringArray);
    }

    public Result getGroups(String string, int n) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroups", (Object)(string + ":" + n));
        }
        int n2 = 0;
        Result result = new Result();
        if (n < 0) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No groups searched as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroups", (Object)(string + ":" + n));
            }
            return result;
        }
        Enumeration enumeration = this.getGroups(string);
        if (enumeration == null) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"no groups found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroups", (Object)(string + ":" + n));
            }
            return result;
        }
        ArrayList arrayList = new ArrayList();
        if (n != 0) {
            arrayList = new ArrayList(n);
        }
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
            if (n == 0 || ++n2 != n) continue;
        }
        result.setList(arrayList);
        if (enumeration.hasMoreElements()) {
            result.setHasMore();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroups", (Object)(string + ":" + n));
        }
        return result;
    }

    public Enumeration getGroups(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroups");
        }
        String[] stringArray = null;
        try {
            stringArray = this.ntv_getGroups();
            this.filterArray(stringArray, string);
        }
        catch (UnixRegistryException unixRegistryException) {
            FFDCFilter.processException((Throwable)unixRegistryException, (String)"com.ibm.ws.security.registry.unix.UnixRegistryImpl.getGroups", (String)"312", (Object)this);
            this.logErrorCode(unixRegistryException);
            Tr.error((TraceComponent)tc, (String)"security.registry.getgroups.error", (Object)new Object[]{string, unixRegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroups", (Object)unixRegistryException);
            }
            throw new CustomRegistryException(unixRegistryException.getMessage(), (Throwable)unixRegistryException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroups");
        }
        return this.arrayToEnumeration(stringArray);
    }

    public List getGroupsForUser(String string) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupsForUser", (Object)string);
        }
        String[] stringArray = null;
        try {
            stringArray = this.ntv_getGroupsForUser(string);
        }
        catch (UnixRegistryException unixRegistryException) {
            FFDCFilter.processException((Throwable)unixRegistryException, (String)"com.ibm.ws.security.registry.unix.UnixRegistryImpl.getGroupsForUser", (String)"341", (Object)this);
            this.logErrorCode(unixRegistryException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroupsForUser", (Object)unixRegistryException);
            }
            Tr.error((TraceComponent)tc, (String)"security.registry.getgrpsforuser.error", (Object)new Object[]{string, unixRegistryException});
            this.throwException(unixRegistryException, string);
        }
        if (stringArray.length == 1 && stringArray[0].trim().equals("*NONE")) {
            return new ArrayList(0);
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Number of groups returned = " + arrayList.size()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupsForUser");
        }
        return arrayList;
    }

    public List getGroupsForUser(String string, int n) throws EntryNotFoundException, CustomRegistryException {
        int n2 = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupsForUser");
        }
        String[] stringArray = null;
        try {
            stringArray = this.ntv_getGroupsForUser(string);
        }
        catch (UnixRegistryException unixRegistryException) {
            FFDCFilter.processException((Throwable)unixRegistryException, (String)"com.ibm.ws.security.registry.unix.UnixRegistryImpl.getGroupsForUser", (String)"373", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroupsForUser", (Object)unixRegistryException);
            }
            Tr.error((TraceComponent)tc, (String)"security.registry.getgrpsforuser.error", (Object)new Object[]{string, unixRegistryException});
            this.throwException(unixRegistryException, string);
        }
        if (stringArray == null || stringArray.length == 0 || stringArray.length == 1 && stringArray[0].trim().equals("*NONE")) {
            return new ArrayList(0);
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
            if (n2++ >= n) break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupsForUser");
        }
        return arrayList;
    }

    public Result getUsersForGroup(String string, int n) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsersForGroup", (Object)string);
        }
        int n2 = 0;
        Result result = new Result();
        if (n < 0) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No groups searched for users as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUsersForGroup");
            }
            return result;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n != 0 && n < Integer.MAX_VALUE) {
            arrayList = new ArrayList(n + 1);
        } else if (n == Integer.MAX_VALUE) {
            arrayList = new ArrayList(n);
        }
        Enumeration enumeration = this.getUsers();
        block0: while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            List list = this.getGroupsForUser(string2);
            if (list == null || list.size() <= 0) continue;
            for (int i = 0; i < list.size(); ++i) {
                String string3 = (String)list.get(i);
                if (!string3.equals(string)) continue;
                arrayList.add(string2);
                if (n >= Integer.MAX_VALUE || n == 0 || ++n2 != n + 1) continue;
                result.setHasMore();
                arrayList.remove(string2);
                continue block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsersForGroup");
        }
        result.setList(arrayList);
        return result;
    }

    public String getGroupSecurityName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupSecurityName", (Object)string);
        }
        String string2 = "";
        try {
            string2 = this.ntv_getGroupSecurityName(Long.valueOf(string));
        }
        catch (UnixRegistryException unixRegistryException) {
            FFDCFilter.processException((Throwable)unixRegistryException, (String)"com.ibm.ws.security.registry.unix.UnixRegistryImpl.getGroupSecurityName", (String)"484", (Object)this);
            this.logErrorCode(unixRegistryException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getGroupSecurityName", (Object)unixRegistryException);
            }
            this.throwException(unixRegistryException, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupSecurityName");
        }
        return string2;
    }

    public String getUserDisplayName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserDisplayName", (Object)string);
        }
        String string2 = "";
        try {
            string2 = this.ntv_getUserRealName(string);
        }
        catch (UnixRegistryException unixRegistryException) {
            FFDCFilter.processException((Throwable)unixRegistryException, (String)"com.ibm.ws.security.registry.unix.UnixRegistryImpl.getUserDisplayName", (String)"515", (Object)this);
            this.logErrorCode(unixRegistryException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUserDisplayName", (Object)unixRegistryException);
            }
            this.throwException(unixRegistryException, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserDisplayName");
        }
        return string2;
    }

    public String getUniqueUserId(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueUserId", (Object)string);
        }
        long l = 0L;
        try {
            l = this.ntv_getUID(string);
        }
        catch (UnixRegistryException unixRegistryException) {
            FFDCFilter.processException((Throwable)unixRegistryException, (String)"com.ibm.ws.security.registry.unix.UnixRegistryImpl.getUniqueUserId", (String)"541", (Object)this);
            this.logErrorCode(unixRegistryException);
            Tr.error((TraceComponent)tc, (String)"security.registry.uniqueusrid.error", (Object)new Object[]{string, unixRegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUniqueUserId", (Object)unixRegistryException);
            }
            this.throwException(unixRegistryException, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueUserId");
        }
        return String.valueOf(l);
    }

    public Enumeration getUsers() throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsers");
        }
        String[] stringArray = null;
        try {
            stringArray = this.ntv_getUsers();
        }
        catch (UnixRegistryException unixRegistryException) {
            FFDCFilter.processException((Throwable)unixRegistryException, (String)"com.ibm.ws.security.registry.unix.UnixRegistryImpl.getUsers", (String)"567", (Object)this);
            this.logErrorCode(unixRegistryException);
            Tr.error((TraceComponent)tc, (String)"security.registry.getusers.error", (Object)new Object[]{"*", unixRegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUsers", (Object)unixRegistryException);
            }
            throw new CustomRegistryException(unixRegistryException.getMessage(), (Throwable)unixRegistryException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsers");
        }
        return this.arrayToEnumeration(stringArray);
    }

    public Result getUsers(String string, int n) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsers", (Object)(string + ":" + n));
        }
        int n2 = 0;
        Result result = new Result();
        if (n < 0) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No users searched as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUsers", (Object)(string + ":" + n));
            }
            return result;
        }
        Enumeration enumeration = this.getUsers(string);
        if (enumeration == null) {
            ArrayList arrayList = new ArrayList(0);
            result.setList(arrayList);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No users found.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUsers", (Object)(string + ":" + n));
            }
            return result;
        }
        ArrayList arrayList = new ArrayList();
        if (n != 0) {
            arrayList = new ArrayList(n);
        }
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
            if (n == 0 || ++n2 != n) continue;
        }
        result.setList(arrayList);
        if (enumeration.hasMoreElements()) {
            result.setHasMore();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsers", (Object)(string + ":" + n));
        }
        return result;
    }

    public Enumeration getUsers(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsers");
        }
        String[] stringArray = null;
        try {
            stringArray = this.ntv_getUsers();
            this.filterArray(stringArray, string);
        }
        catch (UnixRegistryException unixRegistryException) {
            FFDCFilter.processException((Throwable)unixRegistryException, (String)"com.ibm.ws.security.registry.unix.UnixRegistryImpl.getUsers", (String)"610", (Object)this);
            this.logErrorCode(unixRegistryException);
            Tr.error((TraceComponent)tc, (String)"security.registry.getusers.error", (Object)new Object[]{string, unixRegistryException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUsers", (Object)unixRegistryException);
            }
            throw new CustomRegistryException(unixRegistryException.getMessage(), (Throwable)unixRegistryException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsers");
        }
        return this.arrayToEnumeration(stringArray);
    }

    public String getUserSecurityName(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserSecurityName", (Object)string);
        }
        String string2 = "";
        try {
            string2 = this.ntv_getUserSecurityName(Long.valueOf(string));
        }
        catch (UnixRegistryException unixRegistryException) {
            FFDCFilter.processException((Throwable)unixRegistryException, (String)"com.ibm.ws.security.registry.unix.UnixRegistryImpl.getUserSecurityName", (String)"640", (Object)this);
            this.logErrorCode(unixRegistryException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUserSecurityName", (Object)unixRegistryException);
            }
            Tr.error((TraceComponent)tc, (String)"security.registry.usersecurityname.error", (Object)new Object[]{string, unixRegistryException});
            this.throwException(unixRegistryException, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserSecurityName");
        }
        return string2;
    }

    public void initialize(Properties properties) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        try {
            this.realm = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.security.registry.unix.UnixRegistryImpl.initialize", (String)"673", (Object)this);
            this.realm = "";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public boolean isValidGroup(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isValidGroup");
        }
        int n = 0;
        try {
            n = this.ntv_isValidGroup(string);
        }
        catch (UnixRegistryException unixRegistryException) {
            FFDCFilter.processException((Throwable)unixRegistryException, (String)"com.ibm.ws.security.registry.unix.UnixRegistryImpl.isValidGroup", (String)"696", (Object)this);
            this.logErrorCode(unixRegistryException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isValidGroup", (Object)unixRegistryException);
            }
            Tr.error((TraceComponent)tc, (String)"security.registry.isvalidgroup.error", (Object)new Object[]{string, unixRegistryException});
            throw new CustomRegistryException(unixRegistryException.getMessage(), (Throwable)unixRegistryException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isValidGroup");
        }
        return n == 1;
    }

    public boolean isValidUser(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isValidUser");
        }
        int n = 0;
        try {
            n = this.ntv_isValidUser(string);
        }
        catch (UnixRegistryException unixRegistryException) {
            FFDCFilter.processException((Throwable)unixRegistryException, (String)"com.ibm.ws.security.registry.unix.UnixRegistryImpl.isValidUser", (String)"722", (Object)this);
            this.logErrorCode(unixRegistryException);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isValidUser", (Object)unixRegistryException);
            }
            Tr.error((TraceComponent)tc, (String)"security.registry.isvaliduser.error", (Object)new Object[]{string, unixRegistryException});
            throw new CustomRegistryException(unixRegistryException.getMessage(), (Throwable)unixRegistryException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isValidUser");
        }
        return n == 1;
    }

    public WSCredential createCredential(String string) throws CustomRegistryException, NotImplementedException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createCredential", (Object)string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCredential", (Object)string);
        }
        return null;
    }

    public String getRealm() throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRealm");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRealm", (Object)this.realm);
        }
        return this.realm;
    }

    public List getUniqueGroupIds(String string) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueGroupIds", (Object)string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.getUserSecurityName(string);
        List list = this.getGroupsForUser(string2);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(this.getUniqueGroupId((String)list.get(i)));
            }
        } else {
            arrayList = new ArrayList(0);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueGroupIds", (Object)String.valueOf(arrayList.size()));
        }
        return arrayList;
    }

    private Enumeration arrayToEnumeration(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            vector.addElement(stringArray[i]);
        }
        return vector.elements();
    }

    private void filterArray(String[] stringArray, String string) {
        RegExp regExp;
        try {
            regExp = new RegExp(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.security.registry.unix.UnixRegistryImpl.filterArray", (String)"840", (Object)this);
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = null;
            }
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (regExp.match(stringArray[i])) continue;
            stringArray[i] = null;
        }
    }

    private void throwException(UnixRegistryException unixRegistryException, String string) throws CustomRegistryException, EntryNotFoundException {
        if (unixRegistryException.getErrorCode() == 0) {
            throw new CustomRegistryException(unixRegistryException.getMessage());
        }
        throw new EntryNotFoundException(string);
    }

    private int getMaxUidSize() {
        if (this.maxUidSize == -1) {
            String string = (String)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.registry.maxUseridSize");
            this.maxUidSize = string != null ? Integer.parseInt(string) : Integer.parseInt("256");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getMaxUidSize: " + this.maxUidSize));
            }
        }
        return this.maxUidSize;
    }

    private int getMaxPWSize() {
        if (this.maxPWSize == -1) {
            String string = (String)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.registry.maxPasswordSize");
            this.maxPWSize = string != null ? Integer.parseInt(string) : Integer.parseInt("256");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getMaxPWSize: " + this.maxPWSize));
            }
        }
        return this.maxPWSize;
    }

    private void logErrorCode(UnixRegistryException unixRegistryException) {
        StringBuffer stringBuffer = new StringBuffer("Native error code = ");
        stringBuffer.append(unixRegistryException.getErrorCode());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
        }
    }

    static {
        System.loadLibrary("UnixRegistryImpl");
        tc = Tr.register((Class)UnixRegistryImpl.class, null, (String)"com.ibm.ejs.resources.security");
    }
}

