/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.nt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.registry.RegistryErrorException;
import com.ibm.ws.security.registry.nt.NTRegistryImpl;
import com.ibm.ws.security.util.RegExp;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public abstract class ArrayEnumeration
implements Enumeration {
    private static TraceComponent tc = Tr.register((Class)ArrayEnumeration.class, null, (String)"com.ibm.ejs.resources.security");
    protected NTRegistryImpl ntRegistry;
    protected RegExp filter;
    protected String[] array;
    protected int arrayLen = 0;
    protected int index = 0;
    protected int resumeHandle = 0;
    protected boolean done = false;

    public ArrayEnumeration(NTRegistryImpl nTRegistryImpl) throws RegistryErrorException {
        this(nTRegistryImpl, 0, null, false);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ArrayEnumeration");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ArrayEnumeration");
        }
    }

    public ArrayEnumeration(NTRegistryImpl nTRegistryImpl, int n, String string) throws RegistryErrorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ArrayEnumeration");
        }
        this.ntRegistry = nTRegistryImpl;
        if (n > 0) {
            this.array = new String[n];
        }
        if (string != null) {
            this.filter = new RegExp(string);
        }
        this.getMoreData();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ArrayEnumeration");
        }
    }

    public ArrayEnumeration(NTRegistryImpl nTRegistryImpl, int n, String string, boolean bl) throws RegistryErrorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ArrayEnumeration");
        }
        this.ntRegistry = nTRegistryImpl;
        if (n > 0) {
            this.array = new String[n];
        }
        if (string != null) {
            this.filter = new RegExp(string, bl);
        }
        this.getMoreData();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ArrayEnumeration");
        }
    }

    public boolean hasMoreElements() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"hasMoreElements");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"hasMoreElements");
        }
        return this.index < this.arrayLen;
    }

    public Object nextElement() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"nextElement");
        }
        if (this.index > this.arrayLen) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"index > arrayLen");
            }
            throw new NoSuchElementException();
        }
        String string = this.array[this.index++];
        while (this.index != this.arrayLen && this.array[this.index] == null) {
            ++this.index;
        }
        if (!this.done && this.index == this.arrayLen) {
            try {
                this.getMoreData();
            }
            catch (RegistryErrorException registryErrorException) {
                FFDCFilter.processException((Throwable)((Object)registryErrorException), (String)"com.ibm.ws.security.registry.nt.ArrayEnumeration.nextElement", (String)"80", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"nextElement", (Object)((Object)registryErrorException));
                }
                this.arrayLen = 0;
                this.index = 0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"nextElement");
        }
        return string;
    }

    protected void getMoreData() throws RegistryErrorException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMoreData");
        }
        boolean bl = false;
        do {
            this.obtainData();
            n = this.arrayLen;
            if (this.filter == null) continue;
            this.index = this.arrayLen;
            for (int i = 0; i < this.arrayLen; ++i) {
                if (!this.filter.match(this.array[i])) {
                    this.array[i] = null;
                    --n;
                    continue;
                }
                if (bl) continue;
                this.index = i;
                bl = true;
            }
        } while (!this.done && n == 0);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMoreData");
        }
    }

    protected abstract void obtainData() throws RegistryErrorException;
}

