/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.auth.AuthenticationNotSupportedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.registry.RegistryErrorException;
import com.ibm.ws.security.registry.ldap.LdapRegistryImpl;
import com.tivoli.mts.PDPrincipal;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Properties;

public class TAMLdapRegistryImpl
extends LdapRegistryImpl {
    private static URL propURL = null;
    private static TraceComponent tc = Tr.register((Class)TAMLdapRegistryImpl.class, null, (String)"com.ibm.ejs.resources.security");

    public void initialize(Properties properties) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        super.initialize(properties);
        String string = null;
        if (properties != null) {
            string = (String)properties.get("com.ibm.websphere.security.registry.TAMPropURL");
        }
        try {
            if (string != null && string.length() > 0) {
                if (string.startsWith("$")) {
                    string = SecurityConfig.expandString(string);
                }
                propURL = new File(string).toURL();
                if (tc.isDebugEnabled() && propURL != null) {
                    Tr.debug((TraceComponent)tc, (String)("URL is: " + propURL));
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.security.registry.ldap.LdapRegistryImpl.authenticate", (String)"55", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.ldap.initerror", (Object)new Object[]{malformedURLException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initialize");
            }
            throw new CustomRegistryException(malformedURLException.toString(), (Throwable)malformedURLException);
        }
        Tr.audit((TraceComponent)tc, (String)"security.registry.TAM.initialize");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    protected String authenticate(String string, String string2) throws AuthenticationFailedException, AuthenticationNotSupportedException, RegistryErrorException, CustomRegistryException {
        long l = 0L;
        String string3 = LdapRegistryImpl.escapeChar(string, '*');
        try {
            l = System.currentTimeMillis();
            PDPrincipal pDPrincipal = new PDPrincipal(string, string2.toCharArray(), propURL);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Authenticated the user: " + string + " using AM"));
                StringBuffer stringBuffer = new StringBuffer("Time elapsed to open/close DirContext: ");
                stringBuffer = stringBuffer.append(System.currentTimeMillis() - l);
                Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
            }
            return string;
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl.authenticate", (String)"111", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.authn.error", (Object)new Object[]{string, nullPointerException});
            throw new AuthenticationFailedException(nullPointerException.getMessage(), (Throwable)nullPointerException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl.authenticate", (String)"117", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.authn.error", (Object)new Object[]{string, illegalArgumentException});
            throw new AuthenticationFailedException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl.authenticate", (String)"122", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.authn.error", (Object)new Object[]{string, illegalStateException});
            throw new AuthenticationFailedException(illegalStateException.getMessage(), (Throwable)illegalStateException);
        }
    }

    public boolean isValidUser(String string) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isValidUser", (Object)string);
        }
        try {
            PDPrincipal pDPrincipal = new PDPrincipal(string, propURL);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Verified the user: " + string + " using AM"));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isValidUser", (Object)string);
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl.isValidUser", (String)"141", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.isvaliduser.error", (Object)new Object[]{string, nullPointerException});
            throw new CustomRegistryException(nullPointerException.getMessage(), (Throwable)nullPointerException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl.isValidUser", (String)"146", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.isvaliduser.error", (Object)new Object[]{string, illegalArgumentException});
            throw new CustomRegistryException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl.isValidUser", (String)"151", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.isvaliduser.error", (Object)new Object[]{string, illegalStateException});
            throw new CustomRegistryException(illegalStateException.getMessage(), (Throwable)illegalStateException);
        }
    }
}

