/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.ldap;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.registry.ldap.CertificateMapperException;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.StringUtil;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class CertificateMapper {
    public static final String exactDnMapMode = "exactDNMode";
    public static final String uniqueKeyMapMode = "uniqueKeyMode";
    public static final String filterDescriptorMapMode = "filterDescriptorMode";
    private String mapMode;
    private int searchScope;
    private String mapDesc = null;
    private String[] mapDescEles = null;

    public CertificateMapper() {
        try {
            this.setLdapMapMode(exactDnMapMode);
        }
        catch (CertificateMapperException certificateMapperException) {
            FFDCFilter.processException((Throwable)certificateMapperException, (String)"com.ibm.ws.security.registry.ldap.CertificateMapper.CertificateMapper", (String)"61", (Object)this);
        }
    }

    public String getLdapMapMode() {
        return this.mapMode;
    }

    public void setLdapMapMode(String string) throws CertificateMapperException {
        this.mapMode = string;
        if (string.equals(exactDnMapMode)) {
            this.searchScope = 0;
        } else if (string.equals(uniqueKeyMapMode)) {
            this.searchScope = 2;
        } else if (string.equals(filterDescriptorMapMode)) {
            this.searchScope = 2;
        } else {
            throw new CertificateMapperException("invalid map mode: " + string);
        }
    }

    public String getLdapFilterDescriptor() {
        return this.mapDesc;
    }

    public void setLdapFilterDescriptor(String string) throws CertificateMapperException {
        if (string != null) {
            this.mapDescEles = this.parseFilterDescriptor(string);
        }
        this.mapDesc = string;
    }

    public String getLdapSearchFilter(X509Certificate x509Certificate) throws CertificateMapperException {
        if (this.mapMode.equals(exactDnMapMode)) {
            return x509Certificate.getSubjectDN().getName();
        }
        if (this.mapMode.equals(uniqueKeyMapMode)) {
            return "userCertificate=" + CertificateMapper.getUniqueKey(x509Certificate);
        }
        if (this.mapMode.equals(filterDescriptorMapMode)) {
            return this.getFilterByDescriptor(x509Certificate);
        }
        throw new CertificateMapperException("unknown map mode: " + this.mapMode);
    }

    public int getLdapSearchScope() {
        return this.searchScope;
    }

    public static String getUniqueKey(X509Certificate x509Certificate) {
        StringBuffer stringBuffer = new StringBuffer("subjectDN:");
        stringBuffer.append(x509Certificate.getSubjectDN().getName()).append("issuerDN:").append(x509Certificate.getIssuerDN().getName());
        return Base64Coder.base64Encode((String)CertificateMapper.getDigest(stringBuffer.toString()));
    }

    private String getFilterByDescriptor(X509Certificate x509Certificate) throws CertificateMapperException {
        if (this.mapDescEles == null) {
            throw new CertificateMapperException("map descriptor is not set");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.mapDescEles.length; ++i) {
            String string = this.mapDescEles[i];
            if (string.charAt(0) != '$') {
                stringBuffer.append(string);
                continue;
            }
            if (string.equals("${UniqueKey}")) {
                stringBuffer.append(CertificateMapper.getUniqueKey(x509Certificate));
                continue;
            }
            if (string.equals("${PublicKey}")) {
                stringBuffer.append(x509Certificate.getPublicKey().getEncoded());
                continue;
            }
            if (string.equals("${BasicConstraints}")) continue;
            if (string.startsWith("${Issuer")) {
                stringBuffer.append(CertificateMapper.getDnSubField(string.substring(8, string.length() - 1), x509Certificate.getIssuerDN().getName()));
                continue;
            }
            if (string.equals("${IssuerUniqueID}") || string.equals("${KeyUsage}")) continue;
            if (string.equals("${NotAfter}")) {
                stringBuffer.append(x509Certificate.getNotAfter().toString());
                continue;
            }
            if (string.equals("${NotBefore}")) {
                stringBuffer.append(x509Certificate.getNotBefore().toString());
                continue;
            }
            if (string.equals("${SerialNumber}")) {
                stringBuffer.append(x509Certificate.getSerialNumber());
                continue;
            }
            if (string.equals("${SigAlgName}")) {
                stringBuffer.append(x509Certificate.getSigAlgName());
                continue;
            }
            if (string.equals("${SigAlgOID}")) {
                stringBuffer.append(x509Certificate.getSigAlgOID());
                continue;
            }
            if (string.equals("${SigAlgParams}")) {
                stringBuffer.append(x509Certificate.getSigAlgParams());
                continue;
            }
            if (string.equals("${Signature}")) continue;
            if (string.startsWith("${Subject")) {
                stringBuffer.append(CertificateMapper.getDnSubField(string.substring(9, string.length() - 1), x509Certificate.getSubjectDN().getName()));
                continue;
            }
            if (string.equals("${SubjectUniqueID}")) continue;
            if (string.equals("${TBSCertificate}")) {
                throw new CertificateMapperException("getTBSCertificate() is unsupported");
            }
            if (string.equals("${Version}")) {
                stringBuffer.append(x509Certificate.getVersion());
                continue;
            }
            throw new CertificateMapperException("unknown variable: " + string);
        }
        return stringBuffer.toString();
    }

    private String[] parseFilterDescriptor(String string) throws CertificateMapperException {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n < n3) {
            n = string.indexOf("${", n2);
            if (n == -1) {
                if (n2 >= n3) break;
                vector.addElement(string.substring(n2));
                break;
            }
            if (n2 < n) {
                vector.addElement(string.substring(n2, n));
            }
            if ((n = string.indexOf("}", n2 = n)) == -1) {
                throw new CertificateMapperException("missing '}'");
            }
            vector.addElement(string.substring(n2, ++n));
            n2 = n;
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    private static String getDnSubField(String string, String string2) throws CertificateMapperException {
        block4: {
            String string3;
            String string4;
            if (string.equals("DN")) {
                return string2;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            do {
                try {
                    string4 = stringTokenizer.nextToken(",= ");
                    string3 = stringTokenizer.nextToken(",");
                    if (string3 == null) continue;
                    string3 = string3.substring(1);
                }
                catch (NoSuchElementException noSuchElementException) {
                    FFDCFilter.processException((Throwable)noSuchElementException, (String)"com.ibm.ws.security.registry.ldap.CertificateMapper.getDnSubField", (String)"264");
                    break block4;
                }
            } while (!string4.equals(string));
            return string3;
        }
        throw new CertificateMapperException("unknown field of DN: " + string);
    }

    private static String getDigest(String string) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.ldap.CertificateMapper.getDigest", (String)"282");
            return null;
        }
        messageDigest.update(StringUtil.getBytes((String)string));
        return StringUtil.toString((byte[])messageDigest.digest());
    }

    private static String removeSpace(String string) {
        if (string != null && string.trim().length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == ' ' && (string.charAt(i - 1) == ',' || string.charAt(i - 1) == ' ')) continue;
                stringBuffer.append(string.charAt(i));
            }
            return stringBuffer.toString();
        }
        return string;
    }
}

