/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistry;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.ldap.LdapRegistryImpl;
import com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl;
import com.ibm.ws.security.registry.zOS.SAFRegistryImpl;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.util.AccessController;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;

public class UserRegistryImpl
extends PortableRemoteObject
implements UserRegistry {
    private static TraceComponent tc = Tr.register((Class)UserRegistryImpl.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    public static ContextManager ctxMgr = ContextManagerFactory.getInstance();
    private static String CUSTOM_PREFIX = "Custom_";
    private static String CUSTOM_REALM = "customRealm";
    private UserRegistry custImpl;
    private static CustomRegistry oldCustImpl;
    private String realm = null;
    public static final String NONE = "";
    public static final String USERTYPE = "user";
    public static final String GROUPTYPE = "group";
    public static final String ROLETYPE = "role";
    protected static final String nullString;
    protected static final String[] nullStringArray;
    protected static final byte[] nullByteArray;
    protected static final String realmSeparator = "/";
    public static final String typeSeparator = ":";
    private static RoleBasedAuthorizer authorizer;
    private boolean isLDAP = false;
    private boolean isSAF = false;
    private boolean isWindows = false;
    private boolean isLocalOrDomain = false;
    private String useDisplayName = null;
    private Properties supportedRegistries = new Properties();

    public UserRegistryImpl() throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public void initialize(Properties properties) throws CustomRegistryException, RemoteException {
        Object object;
        Object object2;
        String string;
        block25: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"initialize");
            }
            string = null;
            if (properties != null) {
                this.useDisplayName = properties.getProperty("WAS_UseDisplayName");
                string = (String)properties.get("CustUserRegImplClass");
                if ("com.ibm.ws.security.registry.ldap.LdapRegistryImpl".equals(string) && "true".equalsIgnoreCase((String)(object2 = (String)properties.get("com.ibm.websphere.security.registry.UseTAM")))) {
                    string = "com.ibm.ws.security.registry.ldap.TAMLdapRegistryImpl";
                }
            }
            if (string == null) {
                try {
                    this.supportedRegistries.load(((Object)((Object)this)).getClass().getResourceAsStream("wsregistries.properties"));
                }
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Cannot load wsregistries.properties", (Object)throwable);
                    }
                    Tr.error((TraceComponent)tc, (String)"security.registry.loadproperr", (Object)new Object[]{throwable});
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.registry.UserRegistryImpl.initialize", (String)"171", (Object)((Object)this));
                    throw new CustomRegistryException(throwable.getMessage(), throwable);
                }
                object2 = System.getProperty("os.name");
                if (((String)object2).startsWith("Windows")) {
                    object2 = "Windows";
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Registry type", (Object)object2);
                }
                string = this.supportedRegistries.getProperty((String)object2);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Registry implementation", (Object)string);
                }
            }
            if (string == null) {
                Tr.error((TraceComponent)tc, (String)"security.registry.noclassname");
                throw new CustomRegistryException("CustomUserRegistryImplementation Class name is null");
            }
            try {
                object2 = Thread.currentThread().getContextClassLoader();
                object = Class.forName(string, true, (ClassLoader)object2);
                Object obj = ((Class)object).newInstance();
                if (obj instanceof UserRegistry) {
                    String string2;
                    this.custImpl = (UserRegistry)obj;
                    this.isLDAP = obj instanceof LdapRegistryImpl;
                    this.isWindows = obj instanceof NTLocalDomainRegistryImpl;
                    this.isSAF = obj instanceof SAFRegistryImpl;
                    if (this.isWindows && properties != null && ("Domain".equalsIgnoreCase(string2 = properties.getProperty("com.ibm.websphere.registry.UseRegistry")) || "Local".equalsIgnoreCase(string2))) {
                        this.isLocalOrDomain = true;
                    }
                    break block25;
                }
                if (obj instanceof CustomRegistry) {
                    this.custImpl = new CustomRegistryProxy((CustomRegistry)obj);
                    break block25;
                }
                Tr.error((TraceComponent)tc, (String)"security.registry.unsupportedclass", (Object)new Object[]{string});
                throw new CustomRegistryException("The implementation file for the custom registry: " + string + " is not supported");
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.registry.UserRegistryImpl.initialize", (String)"231", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"security.registry.loadclass", (Object)new Object[]{string, throwable});
                throw new CustomRegistryException(throwable.getMessage(), throwable);
            }
        }
        try {
            this.custImpl.initialize(properties);
            this.realm = this.custImpl.getRealm();
            if (this.realm == null || this.realm.length() == 0) {
                this.realm = CUSTOM_REALM;
            }
        }
        catch (CustomRegistryException customRegistryException) {
            Tr.error((TraceComponent)tc, (String)"security.registry.initerr", (Object)new Object[]{string, customRegistryException});
            FFDCFilter.processException((Throwable)customRegistryException, (String)"com.ibm.ws.security.registry.UserRegistryImpl.initialize", (String)"249", (Object)((Object)this));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initialize", (Object)((Object)customRegistryException));
            }
            throw customRegistryException;
        }
        if (ctxMgr.getPlatformHelper().isControlJvm()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"initialize: in control region, register with JNDI");
            }
            try {
                object2 = (Stub)PortableRemoteObject.toStub((Remote)((Object)this));
                object = new InitialContext();
                ((InitialContext)object).rebind("UserRegistry", (Object)this);
            }
            catch (Exception exception) {
                throw new CustomRegistryException(exception.getMessage(), (Throwable)exception);
            }
        }
        Tr.audit((TraceComponent)tc, (String)"security.custom.registry.initialized", (Object)new Object[]{string});
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize", (Object)((Object)this));
        }
    }

    public String checkPassword(String string, String string2) throws PasswordCheckFailedException, CustomRegistryException, RemoteException {
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkPassword", (Object)new Object[]{string, string2 == null ? null : "****"});
        }
        if ((string3 = this.custImpl.checkPassword(string, string2)) == null || string3.trim().length() <= 0) {
            Tr.error((TraceComponent)tc, (String)"security.registry.checkpass.failed", (Object)new Object[]{string});
            throw new PasswordCheckFailedException("checkPassword for: " + string + " failed to return a user: " + string3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"checkPassword", (Object)string3);
        }
        return string3;
    }

    public String mapCertificate(X509Certificate[] x509CertificateArray) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapCertificate", (Object)x509CertificateArray);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "mapCertificate")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAccess failed", (Object)new Exception("Authorization failed"));
            }
            return null;
        }
        String string = this.custImpl.mapCertificate(x509CertificateArray);
        if (string == null) {
            Tr.error((TraceComponent)tc, (String)"security.registry.mapcertfail");
            throw new CertificateMapFailedException("could not map the certificate to a user");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapCertificate", (Object)string);
        }
        return string;
    }

    public Result getUsers(String string, int n) throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsers", (Object)new Object[]{string, new Integer(n)});
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUsers")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAccess failed", (Object)new Exception("Authorization failed"));
            }
            return null;
        }
        Result result = this.custImpl.getUsers(string, n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsers", (Object)result);
        }
        return result;
    }

    public String getUserDisplayName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserDisplayName", (Object)string);
        }
        if ((string2 = this.custImpl.getUserDisplayName(string)) == null) {
            string2 = NONE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserDisplayName", (Object)string2);
        }
        return string2;
    }

    public String getUniqueUserId(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueUserId", (Object)string);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUniqueUserId")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAccess failed", (Object)new Exception("Authorization failed"));
            }
            return null;
        }
        String string2 = RegistryUtil.appendRealm(USERTYPE, this.custImpl.getUniqueUserId(string), this.realm);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueUserId", (Object)string2);
        }
        return string2;
    }

    public String getUserSecurityName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserSecurityName", (Object)string);
        }
        String string2 = this.custImpl.getUserSecurityName(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserSecurityName", (Object)string2);
        }
        return string2;
    }

    public boolean isValidUser(String string) throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isValidUser", (Object)string);
        }
        boolean bl = this.custImpl.isValidUser(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isValidUser", (Object)new Boolean(bl));
        }
        return bl;
    }

    public Result getGroups(String string, int n) throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroups", (Object)new Object[]{string, new Integer(n)});
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getGroups")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAccess failed", (Object)new Exception("Authorization failed"));
            }
            return null;
        }
        Result result = this.custImpl.getGroups(string, n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroups", (Object)result);
        }
        return result;
    }

    public String getGroupDisplayName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupDisplayName", (Object)string);
        }
        if ((string2 = this.custImpl.getGroupDisplayName(string)) == null) {
            string2 = NONE;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupDisplayName", (Object)string2);
        }
        return string2;
    }

    public String getUniqueGroupId(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueGroupId", (Object)string);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUniqueGroupId")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAccess failed", (Object)new Exception("Authorization failed"));
            }
            return null;
        }
        String string2 = RegistryUtil.appendRealm(GROUPTYPE, this.custImpl.getUniqueGroupId(string), this.realm);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueGroupId", (Object)string2);
        }
        return string2;
    }

    public String getGroupSecurityName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupSecurityName", (Object)string);
        }
        String string2 = this.custImpl.getGroupSecurityName(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupSecurityName", (Object)string2);
        }
        return string2;
    }

    public boolean isValidGroup(String string) throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isValidGroup", (Object)string);
        }
        boolean bl = this.custImpl.isValidGroup(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isValidGroup", (Object)new Boolean(bl));
        }
        return bl;
    }

    public List getGroupsForUser(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroupsForUser", (Object)string);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getGroupsForGroup")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAccess failed", (Object)new Exception("Authorization failed"));
            }
            return null;
        }
        List list = this.custImpl.getGroupsForUser(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroupsForUser", (Object)String.valueOf(list.size()));
        }
        return list;
    }

    public WSCredential createCredential(String object) throws CustomRegistryException, EntryNotFoundException, NotImplementedException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createCredential", (Object)object);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "createCredential")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAccess failed", (Object)new Exception("Authorization failed"));
            }
            return null;
        }
        if (object == null || object.length() == 0) {
            throw new EntryNotFoundException("SecurityName is null");
        }
        WSCredential wSCredential = null;
        if (this.isLDAP || this.isSAF) {
            wSCredential = this.custImpl.createCredential((String)object);
        } else {
            String string = null;
            if ("true".equalsIgnoreCase(this.useDisplayName)) {
                try {
                    string = this.getUserDisplayName((String)object);
                    if (NONE.equals(string)) {
                        string = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                int n;
                String[] stringArray;
                String string2 = this.custImpl.getUniqueUserId((String)object);
                final String string3 = this.getRealm();
                String string4 = RegistryUtil.appendRealm(USERTYPE, string2, string3);
                ArrayList<String> arrayList = new ArrayList<String>();
                List list = this.custImpl.getUniqueGroupIds(string2);
                String string5 = null;
                if (list != null && list.size() > 0) {
                    stringArray = list.toArray(new String[list.size()]);
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i == 0) {
                            string5 = RegistryUtil.appendRealm(GROUPTYPE, stringArray[i], string3);
                        }
                        arrayList.add(RegistryUtil.appendRealm(GROUPTYPE, stringArray[i], string3));
                    }
                }
                Object object2 = object = string != null ? string : object;
                if (this.isWindows && !this.isLocalOrDomain && (n = object.indexOf("\\")) != -1) {
                    object = object.substring(n + 1);
                }
                stringArray = object;
                String string6 = string5 != null ? string5 : NONE;
                try {
                    wSCredential = (WSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((String)stringArray, string2, string6, string4, arrayList){
                        private final /* synthetic */ String val$securityName;
                        private final /* synthetic */ String val$uniqueUserId;
                        private final /* synthetic */ String val$primaryGroupId;
                        private final /* synthetic */ String val$accessId;
                        private final /* synthetic */ ArrayList val$groupList;
                        {
                            this.val$securityName = string2;
                            this.val$uniqueUserId = string32;
                            this.val$primaryGroupId = string4;
                            this.val$accessId = string5;
                            this.val$groupList = arrayList;
                        }

                        public Object run() throws Exception {
                            return new WSCredentialImpl(string3, this.val$securityName, this.val$uniqueUserId, this.val$primaryGroupId, this.val$accessId, null, this.val$groupList);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception creating credential.", (Object)new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.UserRegistryImpl.createCredential", (String)"777", (Object)((Object)this));
                throw new RemoteException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createCredential", (Object)wSCredential);
        }
        return wSCredential;
    }

    public String getRealm() throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRealm");
        }
        if (this.realm == null) {
            String string = this.custImpl.getRealm();
            if (string == null || string.length() == 0) {
                string = CUSTOM_REALM;
            }
            this.realm = string;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRealm", (Object)this.realm);
        }
        return this.realm;
    }

    public List getUniqueGroupIds(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUniqueGroupIds", (Object)string);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUniqueGroupId")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAccess failed", (Object)new Exception("Authorization failed"));
            }
            return null;
        }
        List list = this.custImpl.getUniqueGroupIds(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUniqueGroupIds", (Object)list);
        }
        return list;
    }

    public Result getUsersForGroup(String string, int n) throws NotImplementedException, EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsersForGroup", (Object)string);
        }
        if (authorizer != null && !authorizer.checkAccess("/com/ibm/ws/security/server/xml/SecurityServer.xml", "UserRegistry", "getUsersForGroup")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAccess failed", (Object)new Exception("Authorization failed"));
            }
            return null;
        }
        Result result = this.custImpl.getUsersForGroup(string, n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsersForGroup", (Object)result);
        }
        return result;
    }

    public void setConfigurator(RoleBasedConfigurator roleBasedConfigurator) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setConfigurator", (Object)roleBasedConfigurator);
        }
        if (authorizer == null && roleBasedConfigurator != null) {
            try {
                authorizer = roleBasedConfigurator.getRoleBasedAuthorizer("admin-authz", "domain");
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception caught retrieving RoleBasedAuthorizer", (Object)exception);
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.UserRegistryImpl.setConfigurator", (String)"902", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"security.init.roleauthz.geterr", (Object)new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setConfigurator");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(";").append("impl=").append(this.custImpl.toString());
        stringBuffer.append(";").append("realm=").append(this.realm);
        return stringBuffer.toString();
    }

    static {
        nullString = RegistryUtil.nullString;
        nullStringArray = RegistryUtil.nullStringArray;
        nullByteArray = RegistryUtil.nullByteArray;
        authorizer = null;
    }

    private static final class CustomRegistryProxy
    implements UserRegistry {
        private CustomRegistry target = null;

        CustomRegistryProxy(CustomRegistry customRegistry) {
            this.target = customRegistry;
        }

        public void initialize(Properties properties) throws CustomRegistryException, RemoteException {
            this.target.initialize(properties);
        }

        public String checkPassword(String string, String string2) throws PasswordCheckFailedException, CustomRegistryException, RemoteException {
            return this.target.checkPassword(string, string2);
        }

        public String mapCertificate(X509Certificate[] x509CertificateArray) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException, RemoteException {
            return this.target.mapCertificate(x509CertificateArray[0]);
        }

        public String getRealm() throws CustomRegistryException, RemoteException {
            return this.target.getRealm();
        }

        public Result getUsers(String string, int n) throws CustomRegistryException, RemoteException {
            Result result = new Result();
            List list = this.target.getUsers(string);
            result.setList(list);
            return result;
        }

        public String getUserDisplayName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
            return this.target.getUserDisplayName(string);
        }

        public String getUniqueUserId(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
            return this.target.getUniqueUserId(string);
        }

        public String getUserSecurityName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
            return this.target.getUserSecurityName(string);
        }

        public boolean isValidUser(String string) throws CustomRegistryException, RemoteException {
            return this.target.isValidUser(string);
        }

        public Result getGroups(String string, int n) throws CustomRegistryException, RemoteException {
            Result result = new Result();
            List list = this.target.getGroups(string);
            result.setList(list);
            return result;
        }

        public String getGroupDisplayName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
            return this.target.getGroupDisplayName(string);
        }

        public String getUniqueGroupId(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
            return this.target.getUniqueGroupId(string);
        }

        public List getUniqueGroupIds(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
            return this.target.getUniqueGroupIds(string);
        }

        public String getGroupSecurityName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
            return this.target.getGroupSecurityName(string);
        }

        public boolean isValidGroup(String string) throws CustomRegistryException, RemoteException {
            return this.target.isValidGroup(string);
        }

        public List getGroupsForUser(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
            return this.target.getGroupsForUser(string);
        }

        public Result getUsersForGroup(String string, int n) throws NotImplementedException, EntryNotFoundException, CustomRegistryException, RemoteException {
            Result result = new Result();
            List list = this.target.getUsersForGroup(string);
            result.setList(list);
            return result;
        }

        public WSCredential createCredential(String string) throws CustomRegistryException, EntryNotFoundException, NotImplementedException, RemoteException {
            throw new NotImplementedException();
        }

        public String toString() {
            return this.target.toString();
        }
    }
}

