/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.provider.AllPolicyConfigs;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;

public class WSPolicyConfigurationImpl
implements PolicyConfiguration {
    private static TraceComponent tc = Tr.register((Class)WSPolicyConfigurationImpl.class, null, (String)"com.ibm.ejs.resources.security");
    String contextID = null;
    ArrayList excludedList = null;
    ArrayList uncheckedList = null;
    HashMap roleToPermMap = new HashMap();
    int state = 0;

    public WSPolicyConfigurationImpl(String string) throws PolicyContextException {
        this.contextID = string;
    }

    public String getContextID() throws PolicyContextException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getContextID");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getContextID", (Object)this.contextID);
        }
        return this.contextID;
    }

    public void addToRole(String string, PermissionCollection permissionCollection) throws PolicyContextException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addToRole ", (Object)new Object[]{string, permissionCollection});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("addToRole called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (permissionCollection != null) {
            ArrayList arrayList = (ArrayList)this.roleToPermMap.get(string);
            if (arrayList == null) {
                ArrayList<Permission> arrayList2 = new ArrayList<Permission>();
                Enumeration<Permission> enumeration = permissionCollection.elements();
                while (enumeration.hasMoreElements()) {
                    arrayList2.add(enumeration.nextElement());
                }
                this.roleToPermMap.put(string, arrayList2);
            } else {
                Enumeration<Permission> enumeration = permissionCollection.elements();
                while (enumeration.hasMoreElements()) {
                    arrayList.add(enumeration.nextElement());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addToRole ");
        }
    }

    public void addToRole(String string, Permission permission) throws PolicyContextException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addToRole.", (Object)new Object[]{string, permission});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("addToRole called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (permission != null) {
            ArrayList arrayList = (ArrayList)this.roleToPermMap.get(string);
            if (arrayList == null) {
                ArrayList<Permission> arrayList2 = new ArrayList<Permission>();
                arrayList2.add(permission);
                this.roleToPermMap.put(string, arrayList2);
            } else {
                arrayList.add(permission);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addToRole.", (Object)permission);
        }
    }

    public void addToUncheckedPolicy(PermissionCollection permissionCollection) throws PolicyContextException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addToUncheckedPolicy", (Object)new Object[]{permissionCollection});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("addToUncheckedPolicy called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (this.uncheckedList == null && permissionCollection != null) {
            this.uncheckedList = new ArrayList();
        }
        if (permissionCollection != null) {
            Enumeration<Permission> enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                this.uncheckedList.add(enumeration.nextElement());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addToUncheckedPolicy");
        }
    }

    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addToUncheckedPolicy.", (Object)new Object[]{permission});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("addToUncheckedPolicy called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (this.uncheckedList == null && permission != null) {
            this.uncheckedList = new ArrayList();
        }
        if (permission != null) {
            this.uncheckedList.add(permission);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addToUncheckedPolicy.");
        }
    }

    public void addToExcludedPolicy(PermissionCollection permissionCollection) throws PolicyContextException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addToExcludedPolicy", (Object)new Object[]{permissionCollection});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("addToExcludedPolicy called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (this.excludedList == null && permissionCollection != null) {
            this.excludedList = new ArrayList();
        }
        if (permissionCollection != null) {
            Enumeration<Permission> enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                this.excludedList.add(enumeration.nextElement());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addToExcludedPolicy");
        }
    }

    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addToExcludedPolicy.", (Object)new Object[]{permission});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("addToExcludedPolicy called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (this.excludedList == null && permission != null) {
            this.excludedList = new ArrayList();
        }
        if (permission != null) {
            this.excludedList.add(permission);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addToExcludedPolicy.");
        }
    }

    public void removeRole(String string) throws PolicyContextException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeRole ", (Object)string);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("removeRole called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeRole");
        }
    }

    public void removeUncheckedPolicy() throws PolicyContextException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeUncheckedPolicy");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("removeUncheckedPolicy called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeUncheckedPolicy");
        }
    }

    public void removeExcludedPolicy() throws PolicyContextException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeExcludedPolicy");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("removeExcludedPolicy called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeExcludedPolicy");
        }
    }

    public void linkConfiguration(PolicyConfiguration policyConfiguration) throws PolicyContextException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"linkConfiguration", (Object)policyConfiguration);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state != 0) {
            throw new UnsupportedOperationException("linkConfiguration called when the PolicyConfiguration is not in the open state. The current state is = " + String.valueOf(this.state));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"linkConfiguration");
        }
    }

    public void delete() throws PolicyContextException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"delete");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        this.state = 2;
        AllPolicyConfigs.getInstance().remove(this.contextID);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"delete", (Object)String.valueOf(this.state));
        }
    }

    public void commit() throws PolicyContextException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (this.state == 2) {
            throw new UnsupportedOperationException("commit called when the PolicyConfiguration is in the delete state");
        }
        this.state = 1;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commit", (Object)String.valueOf(this.state));
        }
    }

    public boolean inService() throws PolicyContextException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"inService");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"inService", (Object)String.valueOf(this.state));
        }
        return this.state == 1;
    }

    public void setState(int n) throws PolicyContextException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setState", (Object)String.valueOf(n));
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (n != 0) {
            throw new PolicyContextException("The PolicyConfiguration state can only be set to open(0)");
        }
        this.state = n;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setState");
        }
    }

    public ArrayList getExcludedList() {
        return this.excludedList;
    }

    public ArrayList getUncheckedList() {
        return this.uncheckedList;
    }

    public HashMap getRoleToPermMap() {
        return this.roleToPermMap;
    }
}

