/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.ws.security.ltpa.LTPAPrivateKey;
import com.ibm.ws.security.ltpa.LTPAPublicKey;
import com.ibm.ws.security.ltpa.LTPAToken;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.ltpa.TokenFactory;
import java.util.Map;

public class LTPATokenFactory
implements TokenFactory {
    private Long _expirationLimit = null;
    private byte[] _sharedKey = null;
    private LTPAPublicKey _publicKey = null;
    private LTPAPrivateKey _privateKey = null;

    public void initialize(Map map) {
        this._expirationLimit = (Long)map.get("com.ibm.wsspi.security.ltpa.expiration");
        this._sharedKey = (byte[])map.get("com.ibm.wsspi.security.ltpa.ltpa_shared_key");
        this._publicKey = (LTPAPublicKey)map.get("com.ibm.wsspi.security.ltpa.ltpa_public_key");
        this._privateKey = (LTPAPrivateKey)map.get("com.ibm.wsspi.security.ltpa.ltpa_private_key");
    }

    public Token validateTokenBytes(byte[] byArray) throws InvalidTokenException, TokenExpiredException {
        return new LTPAToken(byArray, this._sharedKey, this._privateKey, this._publicKey);
    }

    public Token createToken(Map map) throws TokenCreationFailedException {
        String string = (String)map.get("com.ibm.wsspi.security.cred.uniqueId");
        if (string == null || string.length() == 0) {
            throw new TokenCreationFailedException("UniqueID is null.");
        }
        return new LTPAToken(string, this._expirationLimit, this._sharedKey, this._privateKey, this._publicKey);
    }
}

