/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.ltpa.LTPACrypto;
import com.ibm.ws.security.ltpa.LTPAPrivateKey;
import com.ibm.ws.security.ltpa.LTPAPublicKey;
import com.ibm.ws.security.ltpa.LTPAToken2;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.ltpa.TokenFactory;
import java.util.Map;
import javax.crypto.spec.IvParameterSpec;

public class LTPAToken2Factory
implements TokenFactory {
    private Long _expirationLimit = null;
    private byte[] _sharedKey = null;
    private LTPAPublicKey _publicKey = null;
    private LTPAPrivateKey _privateKey = null;

    public void initialize(Map map) {
        int n;
        byte[] byArray;
        this._expirationLimit = (Long)map.get("com.ibm.wsspi.security.ltpa.expiration");
        this._sharedKey = (byte[])map.get("com.ibm.wsspi.security.ltpa.ltpa_shared_key");
        this._publicKey = (LTPAPublicKey)map.get("com.ibm.wsspi.security.ltpa.ltpa_public_key");
        this._privateKey = (LTPAPrivateKey)map.get("com.ibm.wsspi.security.ltpa.ltpa_private_key");
        try {
            byArray = new byte[8];
            for (n = 0; n < 8; ++n) {
                byArray[n] = this._sharedKey[n];
            }
            LTPACrypto.ivs8 = new IvParameterSpec(byArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.LTPAToken2Factory.initialize", (String)"56");
        }
        try {
            byArray = new byte[16];
            for (n = 0; n < 16; ++n) {
                byArray[n] = this._sharedKey[n];
            }
            LTPACrypto.ivs16 = new IvParameterSpec(byArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.LTPAToken2Factory.initialize", (String)"69");
        }
    }

    public Token validateTokenBytes(byte[] byArray) throws InvalidTokenException, TokenExpiredException {
        return new LTPAToken2(byArray, this._sharedKey, this._privateKey, this._publicKey);
    }

    public Token createToken(Map map) throws TokenCreationFailedException {
        String string = (String)map.get("com.ibm.wsspi.security.cred.uniqueId");
        if (string == null || string.length() == 0) {
            throw new TokenCreationFailedException("UniqueID is null.");
        }
        return new LTPAToken2(string, this._expirationLimit, this._sharedKey, this._privateKey, this._publicKey);
    }
}

