/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.ltpa.LTPACrypto;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.util.ByteArray;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.spec.DESedeKeySpec;

class KeyEncryptor {
    private static final TraceComponent tc = Tr.register((Class)KeyEncryptor.class, null, (String)"com.ibm.ejs.resources.security");
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA";
    private static final String ENCRYPT_ALGORITHM = "DESede";
    byte[] password;
    byte[] desKey;
    LTPACrypto des;

    KeyEncryptor(byte[] byArray) {
        this.password = byArray;
        MessageDigest messageDigest = null;
        if (LTPAServerObject.useFIPS()) {
            try {
                messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, LTPAServerObject.defaultJCEProvider());
                this.desKey = new byte[24];
                byte[] byArray2 = messageDigest.digest(this.password);
                ByteArray.copy((byte[])byArray2, (int)0, (int)byArray2.length, (byte[])this.desKey, (int)0);
                DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(this.desKey);
                this.desKey = dESedeKeySpec.getKey();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object)new Object[]{noSuchAlgorithmException});
                FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.ltpa.KeyEncryptor.KeyEncryptor", (String)"41", (Object)this);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                Tr.debug((TraceComponent)tc, (String)("Error: Provider " + LTPAServerObject.defaultJCEProvider() + " not found"));
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object)new Object[]{noSuchProviderException});
                FFDCFilter.processException((Throwable)noSuchProviderException, (String)"com.ibm.ws.security.ltpa.KeyEncryptor.KeyEncryptor", (String)"43", (Object)this);
            }
            catch (InvalidKeyException invalidKeyException) {
                Tr.error((TraceComponent)tc, (String)"security.ltpa.noalgorithm", (Object)new Object[]{invalidKeyException});
                FFDCFilter.processException((Throwable)invalidKeyException, (String)"com.ibm.ws.security.ltpa.KeyEncryptor.KeyEncryptor", (String)"46", (Object)this);
            }
        } else {
            try {
                messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM);
                this.desKey = new byte[24];
                byte[] byArray3 = messageDigest.digest(this.password);
                ByteArray.copy((byte[])byArray3, (int)0, (int)byArray3.length, (byte[])this.desKey, (int)0);
                this.desKey[20] = 0;
                this.desKey[21] = 0;
                this.desKey[22] = 0;
                this.desKey[23] = 0;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.ltpa.KeyEncryptor.KeyEncryptor", (String)"21", (Object)this);
            }
        }
        this.des = new LTPACrypto();
    }

    byte[] decrypt(byte[] byArray) {
        return LTPACrypto.decrypt(byArray, this.desKey);
    }

    byte[] encrypt(byte[] byArray) {
        return LTPACrypto.encrypt(byArray, this.desKey);
    }
}

