/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.ltpa.LTPAPrivateKey;
import com.ibm.ws.security.ltpa.LTPAPublicKey;
import com.ibm.ws.security.ltpa.LTPATokenizer;
import com.ibm.ws.security.ltpa.UserData;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.wsspi.security.ltpa.Token;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class AuthzPropToken
implements Token,
Serializable {
    private static final TraceComponent tc = Tr.register((Class)AuthzPropToken.class, null, (String)"com.ibm.ejs.resources.security");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yy.MM.dd kk:mm:ss:SSS z");
    private UserData userData;
    private long expiration;
    private static final char DELIM = '|';
    private int defaultExpirationMins = 10;
    private byte[] tokenData = null;
    private byte[] sharedKey = null;
    private LTPAPrivateKey privateKey = null;
    private LTPAPublicKey publicKey = null;
    private short version = 1;

    public AuthzPropToken(byte[] byArray, byte[] byArray2, LTPAPrivateKey lTPAPrivateKey, LTPAPublicKey lTPAPublicKey) throws InvalidTokenException, TokenExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"AuthzPropToken from byte[]");
        }
        this.expiration = 0L;
        this.tokenData = byArray;
        this.decode();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)this.getLogInfo().toString());
        }
        if (!this.isValid() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Expired AuthzPropToken constructed", (Object)new Exception());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"AuthzPropToken from byte[]");
        }
    }

    public AuthzPropToken(String string, long l, byte[] byArray, LTPAPrivateKey lTPAPrivateKey, LTPAPublicKey lTPAPublicKey) throws TokenCreationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"AuthzPropToken from accessID");
        }
        this.expiration = System.currentTimeMillis() + l * 60L * 1000L;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Expiration set to: " + new Date(this.expiration)));
        }
        this.userData = new UserData(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"AuthzPropToken from accessID");
        }
    }

    protected AuthzPropToken(long l, byte[] byArray, LTPAPrivateKey lTPAPrivateKey, LTPAPublicKey lTPAPublicKey, UserData userData) throws TokenCreationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"AuthzPropToken from userData");
        }
        long l2 = System.currentTimeMillis();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Refreshing expiration of token.");
        }
        Long l3 = (Long)SecurityConfig.getConfig().getValue("security.ltpa.expirydate");
        this.expiration = l2 + l3 * 60L * 1000L;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Expiration set to: " + new Date(this.expiration)));
        }
        this.userData = userData;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"AuthzPropToken from userData");
        }
    }

    protected void encode() {
        String string = this.userData.toString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.expiration).append('|').append(string);
        String string2 = stringBuffer.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("tokenString before encode: " + string2));
        }
        this.tokenData = StringUtil.getBytes((String)string2);
    }

    protected void decode() throws InvalidTokenException {
        block8: {
            String string = AuthzPropToken.toStrings(this.tokenData);
            int n = string.length();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Before parsing, length: " + n), (Object)(", string: " + string));
            }
            int n2 = -1;
            int n3 = 0;
            try {
                for (int i = 0; i < n - 1; ++i) {
                    char c = string.charAt(i);
                    if (i > 0 && string.charAt(i - 1) == '\\' || c != '|' || n2 != -1) continue;
                    n2 = i + 1;
                    break;
                }
                if (n2 != -1) {
                    String string2 = string.substring(n3, n2 - 1);
                    this.expiration = Long.parseLong(string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Expiration set to: " + new Date(this.expiration)));
                    }
                    Hashtable hashtable = LTPATokenizer.parseUserData(string.substring(n2, n));
                    this.userData = new UserData(hashtable);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("userData after decode: " + this.userData.toString()));
                    }
                    break block8;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"UserData delimiter not found.");
                }
                throw new InvalidTokenException("UserData delimiter not found.");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.AuthzPropToken.decode", (String)"171");
                throw new InvalidTokenException(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public boolean isValid() throws InvalidTokenException, TokenExpiredException {
        Date date = new Date();
        Date date2 = new Date(this.expiration);
        boolean bl = date.before(date2);
        if (!bl) {
            StringBuffer stringBuffer = this.getLogInfo();
            stringBuffer.insert(0, "token expired ");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
            }
            throw new TokenExpiredException("Token expiration Date: " + date2 + ", current Date: " + date);
        }
        return bl;
    }

    private static String toStrings(byte[] byArray) {
        String string = null;
        try {
            string = new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Tr.debug((TraceComponent)tc, (String)("to UTF8 Strings =" + unsupportedEncodingException.toString()));
        }
        return string;
    }

    private static byte[] toBytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Tr.debug((TraceComponent)tc, (String)("to UTF8 bytes =" + unsupportedEncodingException.toString()));
        }
        return byArray;
    }

    public byte[] getBytes() throws InvalidTokenException, TokenExpiredException {
        this.encode();
        if (!this.isValid() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Expired or invalid LTPA token constructed");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)this.getLogInfo().toString());
        }
        return this.tokenData;
    }

    public long getExpiration() {
        return this.expiration;
    }

    UserData getUserData() {
        return this.userData;
    }

    public String[] addAttribute(String string, String string2) {
        return this.userData.addAttribute(string, string2);
    }

    public String[] getAttributes(String string) {
        return this.userData.getAttributes(string);
    }

    public Enumeration getAttributeNames() {
        return this.userData.getAttributeNames();
    }

    public String toString() {
        return StringUtil.toString((byte[])this.tokenData);
    }

    public short getVersion() {
        return this.version;
    }

    private StringBuffer getLogInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = this.getAttributes(string);
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append(stringArray);
            stringBuffer.append(", ");
        }
        stringBuffer.append("Expiration time: ");
        stringBuffer.append(dateFormat.format(new Date(this.expiration)));
        return stringBuffer;
    }

    public Object clone() {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Expiration passed into cloned token: " + this.expiration));
            }
            UserData userData = (UserData)this.userData.clone();
            return new AuthzPropToken(this.expiration, this.sharedKey, this.privateKey, this.publicKey, userData);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.ltpa.AuthzPropToken.clone", (String)"320");
            return null;
        }
    }
}

