/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.icsf;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.icsf.ICSFConfigException;
import com.ibm.ws.security.icsf.ICSFToken;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.UnsupportedEntryTypeException;
import com.ibm.ws.security.registry.UserRegistryImpl;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.security.util.AccessController;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.Date;
import java.util.Properties;
import javax.security.auth.login.CredentialExpiredException;

public class ICSFServerObject {
    private static final TraceComponent tc = Tr.register((Class)ICSFServerObject.class, null, (String)"com.ibm.ejs.resources.security");
    private static final String NONE = "";
    private static final String USERTYPE = "user";
    private static final String GROUPTYPE = "group";
    private static final String ROLETYPE = "role";
    private static final String[] supportedTypes = new String[]{"group", "user"};
    private static final int GROUP = 0;
    private static final int USER = 1;
    private static final String realmSeparator = "/";
    private static final String typeSeparator = ":";
    private String realm = null;
    private static UserRegistryImpl userRegistry;
    private static long expirationLimit;
    private byte[] adminPassword = null;
    private byte[] new_adminPassword = null;
    private byte[] icsfKeyLabel;
    private static String CURRENT_ICSF_VERSION;
    public static final String ICSF_VERSION_PROPERTY = "com.ibm.websphere.icsf.version";
    public static final String ICSF_LABEL = "was.security.ISCF.cryptoKey";
    protected static ICSFServerObject icsfServer;
    static boolean _useFIPS;
    static String _defaultJCEProvider;
    private static final WebSphereRuntimePermission ACCESS_ICSF_SERVER_OBJECT;

    public static ICSFServerObject getICSFServer() throws ICSFConfigException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getICSFServer");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + ACCESS_ICSF_SERVER_OBJECT.toString()));
            }
            securityManager.checkPermission((Permission)ACCESS_ICSF_SERVER_OBJECT);
        }
        if (icsfServer == null) {
            ICSFServerObject.initICSFServer();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getICSFServer");
        }
        return icsfServer;
    }

    /*
     * Unable to fully structure code
     */
    private static void initICSFServer() throws ICSFConfigException {
        if (ICSFServerObject.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)ICSFServerObject.tc, (String)"initICSFServer");
        }
        var0 = null;
        var1_1 = null;
        var2_2 = null;
        var3_3 = 0L;
        var5_4 = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
        if (var5_4.equals("ICSF")) {
            if (ICSFServerObject.icsfServer == null) {
                try {
                    var2_2 = (Long)SecurityConfig.getConfig().getValue("was.security.ISCF.timeout");
                    if (ICSFServerObject.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)ICSFServerObject.tc, (String)("ICSF_EXPIRATION_TIME set to " + SecurityConfig.getConfig().getValue("was.security.ISCF.timeout")));
                    }
                    var0 = (String)SecurityConfig.getConfig().getValue("was.security.ISCF.cryptoKey");
                    if (ICSFServerObject.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)ICSFServerObject.tc, (String)("ICSF_LABEL set to " + SecurityConfig.getConfig().getValue("was.security.ISCF.cryptoKey")));
                    }
                    if (var2_2 == null || var0 == null) {
                        if (ICSFServerObject.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)ICSFServerObject.tc, (String)"One or more of the required ICSF configuration items are either null or unavailable, can't init ICSFServerObject");
                        }
                        Tr.error((TraceComponent)ICSFServerObject.tc, (String)"security.TokenMechanismFactory.badicsfconfig", (Object)new Object[]{var2_2, var0});
                        throw new ICSFConfigException("ICSF Configuration error, One or more of the required ICSF configuration items are either null or unavailable, can't init ICSF ServerObject");
                    }
                    var3_3 = var2_2;
                    var6_5 = null;
                    ICSFServerObject.icsfServer = new ICSFServerObject(null, var3_3, (byte[])var6_5, var0);
                    var6_5 = (String)SecurityConfig.getConfig().getValue("com.ibm.security.useFIPS");
                    if (var6_5.equalsIgnoreCase("true")) {
                        ICSFServerObject._useFIPS = true;
                        ICSFServerObject._defaultJCEProvider = Security.getProperty("DEFAULT_JCE_PROVIDER");
                    }
                    if (!ICSFServerObject.tc.isDebugEnabled()) ** GOTO lbl44
                    Tr.debug((TraceComponent)ICSFServerObject.tc, (String)("useFIPS = " + ICSFServerObject._useFIPS));
                    if (!ICSFServerObject._useFIPS) ** GOTO lbl44
                    Tr.debug((TraceComponent)ICSFServerObject.tc, (String)("defaultJCEProvider = " + ICSFServerObject._defaultJCEProvider));
                }
                catch (ICSFConfigException var6_6) {
                    Tr.error((TraceComponent)ICSFServerObject.tc, (String)("com.ibm.ws.security.core.TokenMechanismFactory.initICSFServer" + var6_6.toString()));
                    throw var6_6;
                }
                catch (Exception var6_7) {
                    Tr.error((TraceComponent)ICSFServerObject.tc, (String)"security.TokenMechanismFactory.icsfconfigerr", (Object)new Object[]{var6_7});
                    throw new ICSFConfigException(var6_7.getMessage());
                }
            }
        } else {
            if (ICSFServerObject.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)ICSFServerObject.tc, (String)"Not Using ICSF");
            }
            ICSFServerObject.icsfServer = null;
        }
lbl44:
        // 5 sources

        if (ICSFServerObject.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)ICSFServerObject.tc, (String)"initICSFServer");
        }
    }

    public ICSFServerObject() {
    }

    private ICSFServerObject(UserRegistry userRegistry, long l, byte[] byArray, String string) throws ICSFConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ICSFServerObject");
        }
        ICSFServerObject.userRegistry = (UserRegistryImpl)SecurityServerImpl.getRegistryImpl(ContextManagerFactory.getInstance().getDefaultRealm());
        expirationLimit = l;
        this.adminPassword = byArray;
        try {
            this.icsfKeyLabel = string.getBytes("Cp1047");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.icsf.ICSFServerObject.ICSFServerObject", (String)"105", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.ltpa.init.error", (Object)new Object[]{unsupportedEncodingException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ICSFServerObject", (Object)unsupportedEncodingException);
            }
            throw new ICSFConfigException(unsupportedEncodingException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.icsf.ICSFServerObject.ICSFServerObject", (String)"87", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.ltpa.init.error", (Object)new Object[]{exception});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ICSFServerObject", (Object)exception);
            }
            throw new ICSFConfigException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ICSFServerObject");
        }
    }

    private byte[] getICSFKeyLabel() {
        return this.icsfKeyLabel;
    }

    public WSCredential createICSFToken(final WSCredential wSCredential) throws TokenCreationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createICSFToken");
        }
        String string = null;
        try {
            string = wSCredential.getAccessId();
        }
        catch (CredentialDestroyedException credentialDestroyedException) {
            FFDCFilter.processException((Throwable)credentialDestroyedException, (String)"com.ibm.ws.security.icsf.ICSFServerObject.createICSFToken", (String)"158", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.secsrv.basic.destroy", (Object)new Object[]{credentialDestroyedException});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Credential has been destroyed.");
            }
            throw new TokenCreationFailedException(credentialDestroyedException.getMessage());
        }
        catch (CredentialExpiredException credentialExpiredException) {
            FFDCFilter.processException((Throwable)credentialExpiredException, (String)"com.ibm.ws.security.icsf.ICSFServerObject.createICSFToken", (String)"164", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.secsrv.basic.expired", (Object)new Object[]{credentialExpiredException});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Credential has expired.");
            }
            throw new TokenCreationFailedException(credentialExpiredException.getMessage());
        }
        if (string == null) {
            Tr.error((TraceComponent)tc, (String)"security.ltpa.credmap.failed.nullaccessid");
            throw new TokenCreationFailedException("Cannot create token since accessID is null");
        }
        ICSFToken iCSFToken = new ICSFToken(string, new Date().getTime() + expirationLimit * 60L * 1000L);
        iCSFToken.encrypt((byte[])this.icsfKeyLabel.clone());
        WSCredential wSCredential2 = null;
        final ICSFToken iCSFToken2 = iCSFToken;
        SecurityConfig securityConfig = SecurityConfig.getConfig();
        final String string2 = (String)securityConfig.getValue("security.activeAuthMechanism.OID");
        try {
            wSCredential2 = (WSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new WSCredentialImpl(wSCredential, string2, iCSFToken2.getBytes(), true, iCSFToken2.getExpiration());
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred creating new WS cred.", (Object)new Object[]{privilegedActionException.getException()});
            }
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.icsf.ICSFServerObject.createICSFToken", (String)"245", (Object)this);
            Exception exception = privilegedActionException.getException();
            String string3 = exception != null ? exception.getMessage() : "Exception occurred creating new WS cred.";
            throw new TokenCreationFailedException(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createICSFToken");
        }
        return wSCredential2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WSCredential authenticate(BasicAuthData basicAuthData) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"authenticate");
        }
        try {
            WSCredential wSCredential;
            Object object;
            block19: {
                if (userRegistry == null) {
                    try {
                        try {
                            object = new SecurityServerImpl();
                            userRegistry = (UserRegistryImpl)object.getRegistry(null);
                        }
                        catch (RemoteException remoteException) {
                            Tr.event((TraceComponent)tc, (String)"JNDI Exception between Controller and Servant", (Object)remoteException.getMessage());
                            Object var4_8 = null;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Obtaining userRegistry object: " + (Object)((Object)userRegistry)));
                            }
                            if (userRegistry == null) {
                                return ContextManagerFactory.getInstance().getUnauthenticatedCredential();
                            }
                            break block19;
                        }
                        Object var4_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_9 = null;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Obtaining userRegistry object: " + (Object)((Object)userRegistry)));
                        }
                        if (userRegistry == null) {
                            return ContextManagerFactory.getInstance().getUnauthenticatedCredential();
                        }
                        throw throwable;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Obtaining userRegistry object: " + (Object)((Object)userRegistry)));
                    }
                    if (userRegistry == null) {
                        return ContextManagerFactory.getInstance().getUnauthenticatedCredential();
                    }
                }
            }
            if ((wSCredential = userRegistry.createCredential((String)(object = userRegistry.checkPassword(basicAuthData.getUserid(), basicAuthData.getPassword())))) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"authenticate");
                }
                return this.createICSFToken(wSCredential);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"authenticate");
            }
            throw new WSLoginFailedException("Credential returned by createCredential is null");
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            throw wSLoginFailedException;
        }
        catch (TokenCreationFailedException tokenCreationFailedException) {
            FFDCFilter.processException((Throwable)tokenCreationFailedException, (String)"com.ibm.ws.security.icsf.ICSFServerObject.authenticate", (String)"264", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.ltpa.authenticate", (Object)new Object[]{tokenCreationFailedException});
            throw new WSLoginFailedException(tokenCreationFailedException.getMessage(), (Throwable)tokenCreationFailedException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.icsf.ICSFServerObject.authenticate", (String)"270", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.ltpa.authenticate", (Object)new Object[]{exception});
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
    }

    public WSCredential authenticateLoginToken(byte[] byArray) throws WSLoginFailedException, RemoteException {
        throw new WSLoginFailedException("ICSFServerObject: authenticateLoginToken not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WSCredential validate(byte[] byArray) throws WSLoginFailedException {
        WSCredential wSCredential;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ICSFServerObject.validate");
        }
        if (byArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validate: ICSF validate failed");
            }
            Tr.error((TraceComponent)tc, (String)"security.ltpa.validate.nulltoken");
            throw new WSLoginFailedException("ICSFServerObject: token passed in is null.");
        }
        ICSFToken iCSFToken = null;
        try {
            block36: {
                if (userRegistry == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"userRegistry NULL, getting one ");
                    }
                    try {
                        try {
                            object = new SecurityServerImpl();
                            userRegistry = (UserRegistryImpl)object.getRegistry(null);
                        }
                        catch (RemoteException remoteException) {
                            Tr.event((TraceComponent)tc, (String)"JNDI Exception beetwen Controller and Servant", (Object)remoteException.getMessage());
                            wSCredential = null;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Obtaining userRegistry object: " + (Object)((Object)userRegistry)));
                            }
                            if (userRegistry == null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"userRegistry is still Null, returning Unauthenticated creds ");
                                }
                                return ContextManagerFactory.getInstance().getUnauthenticatedCredential();
                            }
                            break block36;
                        }
                        wSCredential = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Obtaining userRegistry object: " + (Object)((Object)userRegistry)));
                        }
                        if (userRegistry != null) {
                            throw throwable;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"userRegistry is still Null, returning Unauthenticated creds ");
                        }
                        return ContextManagerFactory.getInstance().getUnauthenticatedCredential();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Obtaining userRegistry object: " + (Object)((Object)userRegistry)));
                    }
                    if (userRegistry == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"userRegistry is still Null, returning Unauthenticated creds ");
                        }
                        return ContextManagerFactory.getInstance().getUnauthenticatedCredential();
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Obtained userRegistry object: " + (Object)((Object)userRegistry) + "\n" + "Getting the token now\n"));
            }
            iCSFToken = ICSFToken.getInstance(byArray, this.icsfKeyLabel);
        }
        catch (InvalidTokenException invalidTokenException) {
            FFDCFilter.processException((Throwable)invalidTokenException, (String)"com.ibm.ws.security.icsf.ICSF.validate", (String)"454", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ICSFServerObject: InvalidTokenException");
            }
            throw new WSLoginFailedException(invalidTokenException.getMessage(), (Throwable)invalidTokenException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.icsf.ICSFServerObject.validate", (String)"460", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ICSFServerObject: ICSFToken.getInstance internal error.");
            }
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
        if (!iCSFToken.isValid()) {
            Tr.error((TraceComponent)tc, (String)"security.ltpa.validate.tokenexpired");
            throw new WSLoginFailedException("ICSFServerObject: Token expired");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"validation successful - to create credential");
        }
        object = null;
        try {
            object = this.getSecurityName(iCSFToken.getAccessID());
            if (SecurityConfig.isRegTAM() && !RegistryUtil.checkValidUserifTAM((String)object, userRegistry)) {
                throw new WSLoginFailedException("User is not valid in Access Manager");
            }
            final WSCredential wSCredential2 = userRegistry.createCredential((String)object);
            wSCredential = null;
            final ICSFToken iCSFToken2 = iCSFToken;
            SecurityConfig securityConfig = SecurityConfig.getConfig();
            final String string = (String)securityConfig.getValue("security.activeAuthMechanism.OID");
            try {
                wSCredential = (WSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new WSCredentialImpl(wSCredential2, string, iCSFToken2.getBytes(), true, iCSFToken2.getExpiration());
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception occurred creating new WS cred.", (Object)new Object[]{privilegedActionException.getException()});
                }
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.icsf.ICSFServerObject.createICSFToken", (String)"561", (Object)this);
                exception = privilegedActionException.getException();
                String string2 = exception != null ? exception.getMessage() : "Exception occurred creating new WS cred.";
                throw new WSLoginFailedException(string2, (Throwable)exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ICSFServerObject.validate");
            }
            return wSCredential;
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, (String)"com.ibm.ws.security.icsf.ICSFServerObject.validate", (String)"573", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validate: ICSF validation failed", (Object)((Object)wSLoginFailedException));
            }
            Tr.error((TraceComponent)tc, (String)"security.ltpa.validate.createcredential.failed", (Object)new Object[]{object, wSLoginFailedException});
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.icsf.ICSFServerObject.validate", (String)"580", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validate: ICSF validation failed", (Object)exception);
            }
            Tr.error((TraceComponent)tc, (String)"security.ltpa.validate.createcredential.failed", (Object)new Object[]{object, exception});
            throw new WSLoginFailedException(exception.getMessage(), (Throwable)exception);
        }
    }

    private String getSecurityName(String string) throws CustomRegistryException, EntryNotFoundException, UnsupportedEntryTypeException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSecurityName", (Object)string);
        }
        String string2 = null;
        String string3 = null;
        string3 = this.getRelativeName(string);
        if (string.startsWith(supportedTypes[1])) {
            string2 = userRegistry.getUserSecurityName(string3);
        } else if (string.startsWith(supportedTypes[0])) {
            string2 = userRegistry.getGroupSecurityName(string3);
        } else {
            UnsupportedEntryTypeException unsupportedEntryTypeException = new UnsupportedEntryTypeException("not USER or GROUP");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSecurityName", (Object)((Object)unsupportedEntryTypeException));
            }
            Tr.error((TraceComponent)tc, (String)"security.ltpa.badtype", (Object)new Object[]{unsupportedEntryTypeException});
            throw unsupportedEntryTypeException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSecurityName", (Object)string2);
        }
        return string2;
    }

    private String getRelativeName(String string) throws CustomRegistryException, RemoteException {
        int n = string.indexOf(realmSeparator);
        String string2 = string;
        this.realm = userRegistry.getRealm();
        if (n >= 0) {
            int n2 = string.indexOf(typeSeparator);
            if (n - n2 - 1 == this.realm.length() && string.startsWith(this.realm, n2 + 1)) {
                string2 = string.substring(n + 1);
            } else {
                Tr.error((TraceComponent)tc, (String)"security.ltpa.realm_mismatch");
                throw new CustomRegistryException("The realm in the token: " + string.substring(n2 + 1, n) + " does not match the current realm: " + this.realm);
            }
        }
        return string2;
    }

    public synchronized void importSSOProperties(Properties properties, byte[] byArray) throws Exception {
    }

    public Properties exportSSOProperties() throws Exception {
        Properties properties = new Properties();
        return properties;
    }

    public byte[] issueLoginToken(BasicAuthData basicAuthData) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"issueLoginToken");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"issueLoginToken");
        }
        throw new RemoteException("issueLoginToken not implemented");
    }

    private static byte[] toBytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Tr.debug((TraceComponent)tc, (String)("to UTF8 bytes =" + unsupportedEncodingException.toString()));
        }
        return byArray;
    }

    static boolean useFIPS() {
        return _useFIPS;
    }

    static String defaultJCEProvider() {
        return _defaultJCEProvider;
    }

    static {
        CURRENT_ICSF_VERSION = "1.0";
        icsfServer = null;
        _useFIPS = false;
        _defaultJCEProvider = "IBMJCE";
        ACCESS_ICSF_SERVER_OBJECT = new WebSphereRuntimePermission("accessICSFServerObject");
    }
}

