/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.icsf;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.ws.security.icsf.LoginToken;
import com.ibm.ws.security.icsf.LoginTokenHeader;
import com.ibm.ws.security.util.Base64Coder;
import java.io.UnsupportedEncodingException;

public class ICSFLoginToken {
    private static TraceComponent tc = Tr.register((String)ICSFLoginToken.class.getName(), (String)"Servlet_Engine");
    protected String userid;
    protected long expires;
    private String expiresTime;
    protected boolean valid;
    protected byte[] encodedEncryptedTokenBytes;
    protected byte[] encryptedTokenBytes;
    protected LoginTokenHeader loginTokenHeader;
    protected String reasonCode;
    protected String clearTextToken;
    private String clearTextTokenHeader;
    private String clearTextTokenData;
    protected byte[] clearTextTokenBytes;
    protected String encryptionKeyLabel;
    private String encodedEncryptionKeyLabel;
    protected byte[] encryptionKeyLabelBytes;
    protected byte[] encodedEncryptionKeyLabelBytes;
    protected byte[] smooshedTokenBytes;

    ICSFLoginToken(String string, long l) {
        this.resetObject();
        this.expires = l;
        this.userid = string;
    }

    private ICSFLoginToken(byte[] byArray) throws InvalidTokenException {
        this.resetObject();
        this.valid = this.initToken(byArray);
        if (!this.valid) {
            throw new InvalidTokenException();
        }
    }

    public static ICSFLoginToken getInstance(byte[] byArray, byte[] byArray2) throws InvalidTokenException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInstance( token )");
        }
        ICSFLoginToken iCSFLoginToken = null;
        if (byArray == null) {
            return iCSFLoginToken;
        }
        try {
            iCSFLoginToken = new ICSFLoginToken(byArray);
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)("getInstance(): caught exception " + throwable));
            throwable.printStackTrace();
            iCSFLoginToken = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInstance( token )");
        }
        return iCSFLoginToken;
    }

    protected boolean createLoginTokenHeader() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createLoginTokenHeader");
        }
        boolean bl = false;
        try {
            this.loginTokenHeader = new LoginTokenHeader();
            bl = true;
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)("createLoginTokenHeader(): caught exception " + throwable));
            throwable.printStackTrace();
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createLoginTokenHeader -- rc = " + bl));
        }
        return bl;
    }

    private boolean decryptLoginToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"decryptLoginToken");
        }
        boolean bl = false;
        this.clearTextTokenBytes = new byte[this.encryptedTokenBytes.length];
        int n = 0;
        try {
            n = LoginToken.icsfDecrypt(this.encryptionKeyLabelBytes, this.encryptionKeyLabelBytes.length, this.encryptedTokenBytes, this.encryptedTokenBytes.length, this.clearTextTokenBytes, this.clearTextTokenBytes.length);
            if (n == 0) {
                if (this.clearTextTokenBytes != null) {
                    bl = true;
                }
            } else {
                String string = Integer.toHexString(n).toUpperCase();
                int n2 = string.length();
                if (n2 > 4) {
                    String string2 = string.substring(0, n2 - 4);
                    String string3 = string.substring(n2 - 4);
                    Tr.error((TraceComponent)tc, (String)("decryptLoginToken: ICSF return code = " + string2 + " and reason code = " + string3));
                    if (string2.equalsIgnoreCase("C") && string3.equals("0000")) {
                        Tr.error((TraceComponent)tc, (String)"decryptLoginToken: ICSF is not available");
                    } else if (string2.equals("8") && string3.equalsIgnoreCase("271C")) {
                        Tr.error((TraceComponent)tc, (String)"decryptLoginToken: Webcontainer property WebAuth.EncryptionKeyLabel could not be found");
                    }
                } else {
                    Tr.error((TraceComponent)tc, (String)("decryptLoginToken: ICSF decryptRC = " + string));
                }
            }
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)("decryptLoginToken: caught exception " + throwable));
            throwable.printStackTrace();
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("decryptLoginToken -- rc = " + bl));
        }
        return bl;
    }

    private boolean encryptLoginToken() {
        boolean bl;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"encryptLoginToken");
            }
            bl = false;
            this.encryptedTokenBytes = new byte[this.clearTextTokenBytes.length];
            this.encodedEncryptedTokenBytes = null;
            int n = 0;
            try {
                n = LoginToken.icsfEncrypt(this.encryptionKeyLabelBytes, this.encryptionKeyLabelBytes.length, this.clearTextTokenBytes, this.clearTextTokenBytes.length, this.encryptedTokenBytes, this.encryptedTokenBytes.length);
                if (n == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("encryptLoginToken: encryptedTokenBytes length = " + this.encryptedTokenBytes.length));
                    }
                    if (this.encryptedTokenBytes == null) break block14;
                    this.encodedEncryptedTokenBytes = Base64Coder.base64Encode((byte[])this.encryptedTokenBytes);
                    if (tc.isDebugEnabled()) {
                        int n2 = this.encodedEncryptedTokenBytes.length;
                        Tr.debug((TraceComponent)tc, (String)("encryptLoginToken: encodedEncryptedTokenBytes.length=" + n2));
                        try {
                            String string = new String(this.encodedEncryptedTokenBytes, "ISO8859-1");
                            Tr.debug((TraceComponent)tc, (String)("encryptLoginToken: encodedEncryptedTokenBytes: " + string));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                    }
                    bl = true;
                    break block14;
                }
                String string = Integer.toHexString(n).toUpperCase();
                int n3 = string.length();
                if (n3 > 4) {
                    String string2 = string.substring(0, n3 - 4);
                    String string3 = string.substring(n3 - 4);
                    Tr.error((TraceComponent)tc, (String)("encryptLoginToken: ICSF return code = " + string2 + " and reason code = " + string3));
                    if (string2.equalsIgnoreCase("C") && string3.equals("0000")) {
                        Tr.error((TraceComponent)tc, (String)"encryptLoginToken: ICSF is not available");
                    } else if (string2.equals("8") && string3.equalsIgnoreCase("271C")) {
                        Tr.error((TraceComponent)tc, (String)"encryptLoginToken: Webcontainer property WebAuth.EncryptionKeyLabel could not be found");
                    }
                } else {
                    Tr.error((TraceComponent)tc, (String)("encryptLoginToken: ICSF encryptRC = " + string));
                }
            }
            catch (Throwable throwable) {
                Tr.error((TraceComponent)tc, (String)("encryptLoginToken: caught exception " + throwable));
                throwable.printStackTrace();
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("encryptLoginToken -- rc = " + bl));
        }
        return bl;
    }

    protected void setEncryption(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setEncryption");
        }
        this.encryptionKeyLabelBytes = byArray;
        this.encodedEncryptionKeyLabelBytes = Base64Coder.base64Encode((byte[])this.encryptionKeyLabelBytes);
        if (tc.isDebugEnabled()) {
            int n = this.encodedEncryptionKeyLabelBytes.length;
            Tr.debug((TraceComponent)tc, (String)("setEncryption: encodedEncryptionKeyLabelBytes.length=" + n));
            try {
                String string = new String(this.encodedEncryptionKeyLabelBytes, "ISO8859-1");
                Tr.debug((TraceComponent)tc, (String)("setEncryption: encodedEncryptionKeyLabelBytes: " + string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setEncryption -- true");
        }
    }

    private boolean restoreExpiresTime() {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"restoreExpiresTime");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("restoreExpiresTime: expiresTime.length() = " + this.expiresTime.length()));
            Tr.debug((TraceComponent)tc, (String)("restoreExpiresTime: expiresTime = " + this.expiresTime));
        }
        try {
            this.expires = Long.parseLong(this.expiresTime);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("restoreExpiresTime: expires = " + this.expires));
            }
            bl = true;
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)("restoreExpiresTime: caught exception " + throwable));
            throwable.printStackTrace();
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("restoreExpiresTime -- rc = " + bl));
        }
        return bl;
    }

    private boolean restoreUserId() {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"restoreUserId");
        }
        if (this.clearTextTokenData != null) {
            this.userid = this.clearTextTokenData;
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("restoreUserId -- rc = " + bl));
        }
        return bl;
    }

    protected boolean smooshToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"smooshToken");
        }
        boolean bl = true;
        try {
            int n = this.encodedEncryptionKeyLabelBytes.length;
            int n2 = n / 1000;
            int n3 = (n - n2 * 1000) / 100;
            int n4 = (n - n2 * 1000 - n3 * 100) / 10;
            int n5 = n - n2 * 1000 - n3 * 100 - n4 * 10;
            long l = System.currentTimeMillis();
            int n6 = (int)(l & 0xFFL & 0xFFL);
            int n7 = (int)((l & 0xFF00L) >> 8 & 0xFFL);
            int n8 = n7 ^ n6;
            byte[] byArray = new byte[]{(byte)((n5 & 0x3F) << 2 & 0xFF), (byte)(n8 & 0xFF), (byte)(n2 & 0x3F & 0xFF), (byte)((n4 & 0x3F) << 2 & 0xFF), (byte)(n6 & 0xFF), (byte)(n3 & 0x3F & 0xFF)};
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("smooshToken: encodedEncryptionKeyLabelBytes.length=" + n));
                Tr.debug((TraceComponent)tc, (String)("smooshToken: Length position digits are: tmpm=" + n2 + " tmph=" + n3 + " tmpt=" + n4 + " tmpo=" + n5));
                Tr.debug((TraceComponent)tc, (String)("smooshToken: Filler bytes are: lowByte1=" + n6 + " lowByte2=" + n7 + " lowByte3=" + n8));
                Tr.debug((TraceComponent)tc, (String)("smooshToken: Funny length tmp2[6] is: " + byArray[0] + " " + byArray[1] + " " + byArray[2] + " " + byArray[3] + " " + byArray[4] + " " + byArray[5]));
            }
            byte[] byArray2 = Base64Coder.base64Encode((byte[])byArray);
            if (tc.isDebugEnabled()) {
                int n9 = byArray2.length;
                Tr.debug((TraceComponent)tc, (String)("smooshToken: Encoded_Funny_Length has a length of " + n9));
                try {
                    String string = new String(byArray2, "ISO8859-1");
                    Tr.debug((TraceComponent)tc, (String)("smooshToken: Encoded_Funny_Length: " + string));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            this.smooshedTokenBytes = new byte[byArray2.length + this.encodedEncryptedTokenBytes.length + this.encodedEncryptionKeyLabelBytes.length];
            System.arraycopy(byArray2, 0, this.smooshedTokenBytes, 0, byArray2.length);
            System.arraycopy(this.encodedEncryptedTokenBytes, 0, this.smooshedTokenBytes, byArray2.length, this.encodedEncryptedTokenBytes.length);
            System.arraycopy(this.encodedEncryptionKeyLabelBytes, 0, this.smooshedTokenBytes, byArray2.length + this.encodedEncryptedTokenBytes.length, this.encodedEncryptionKeyLabelBytes.length);
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)("smooshToken(): caught exception " + throwable));
            throwable.printStackTrace();
            bl = false;
        }
        if (bl && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("smooshToken: encodedEncryptedTokenBytes.length= " + this.encodedEncryptedTokenBytes.length));
            Tr.debug((TraceComponent)tc, (String)("smooshToken: encodedEncryptionKeyLabelBytes.length= " + this.encodedEncryptionKeyLabelBytes.length));
            Tr.debug((TraceComponent)tc, (String)("smooshToken: smooshedTokenBytes.length=" + this.smooshedTokenBytes.length));
            try {
                String string = new String(this.smooshedTokenBytes, "ISO8859-1");
                Tr.debug((TraceComponent)tc, (String)("smooshToken: smooshedTokenBytes: " + string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("smooshToken -- rc = " + bl));
        }
        return bl;
    }

    private boolean unSmooshToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unSmooshToken");
        }
        boolean bl = true;
        try {
            int n;
            int n2;
            Object object;
            int n3 = this.smooshedTokenBytes.length;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unSmooshToken: smooshedTokenBytes.length=" + n3));
                try {
                    object = new String(this.smooshedTokenBytes, "ISO8859-1");
                    Tr.debug((TraceComponent)tc, (String)("unSmooshToken: smooshedTokenBytes: " + (String)object));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            object = new byte[8];
            System.arraycopy(this.smooshedTokenBytes, 0, object, 0, 8);
            byte[] byArray = Base64Coder.base64Decode((byte[])object);
            if (tc.isDebugEnabled()) {
                n2 = byArray.length;
                Tr.debug((TraceComponent)tc, (String)("unSmooshToken: Funny_Length has a length of " + n2));
                for (n = 0; n < n2; ++n) {
                    Tr.debug((TraceComponent)tc, (String)("unSmooshToken: Funny_Length tmp2[" + n + "]=" + byArray[n]));
                }
            }
            n2 = (byArray[2] & 0x3F) * 1000 + (byArray[5] & 0x3F) * 100 + (byArray[3] >> 2 & 0x3F) * 10 + (byArray[0] >> 2 & 0x3F);
            this.encodedEncryptionKeyLabelBytes = new byte[n2];
            n = n3 - n2 - 8;
            this.encodedEncryptedTokenBytes = new byte[n];
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unSmooshToken: encodedEncryptedTokenBytes length = " + n));
                Tr.debug((TraceComponent)tc, (String)("unSmooshToken: encodedEncryptionKeyLabelBytes length = " + n2));
            }
            System.arraycopy(this.smooshedTokenBytes, 8, this.encodedEncryptedTokenBytes, 0, n);
            System.arraycopy(this.smooshedTokenBytes, 8 + n, this.encodedEncryptionKeyLabelBytes, 0, n2);
            this.encryptionKeyLabelBytes = Base64Coder.base64Decode((byte[])this.encodedEncryptionKeyLabelBytes);
            this.encryptedTokenBytes = Base64Coder.base64Decode((byte[])this.encodedEncryptedTokenBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unSmooshToken: encryptionKeyLabelBytes length = " + this.encryptionKeyLabelBytes.length));
                Tr.debug((TraceComponent)tc, (String)("unSmooshToken: encryptedTokenBytes length = " + this.encryptedTokenBytes.length));
            }
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)("unSmooshToken(): caught exception " + throwable));
            throwable.printStackTrace();
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("unSmooshToken -- rc=" + bl));
        }
        return bl;
    }

    protected void encrypt(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initUserid");
        }
        this.setEncryption(byArray);
        if (this.createLoginTokenHeader()) {
            if (this.createLoginToken(this.userid)) {
                if (this.encryptLoginToken()) {
                    if (this.smooshToken()) {
                        this.valid = true;
                    } else {
                        Tr.error((TraceComponent)tc, (String)"initUserid: unable to smoosh token");
                    }
                } else {
                    Tr.error((TraceComponent)tc, (String)"initUserid: could not encrypt token");
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"initUserid: could not create token data");
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"initUserid: could not create token header");
        }
    }

    private boolean setToken(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setToken");
        }
        if (byArray == null) {
            Tr.error((TraceComponent)tc, (String)"setToken: token is null");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setToken( token ) -- false");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setToken: _token.length = " + byArray.length));
        }
        if (byArray.length < 10) {
            Tr.error((TraceComponent)tc, (String)"setToken : token is empty");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setToken( token ) -- false");
            }
            return false;
        }
        try {
            this.smooshedTokenBytes = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.smooshedTokenBytes, 0, byArray.length);
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)("setToken(): caught exception " + throwable));
            throwable.printStackTrace();
            Tr.exit((TraceComponent)tc, (String)"setToken( token ) -- false");
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setToken( token ) -- true");
        }
        return true;
    }

    private boolean initToken(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initToken( encoded token )");
        }
        boolean bl = false;
        if (this.setToken(byArray) && this.unSmooshToken() && this.decryptLoginToken() && this.parseLoginToken() && this.restoreExpiresTime() && this.restoreUserId()) {
            this.valid = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("initToken( encoded token ) valid = " + this.valid));
        }
        return this.valid;
    }

    protected void resetObject() {
        this.userid = null;
        this.expires = -1L;
        this.expiresTime = null;
        this.valid = false;
        this.encodedEncryptedTokenBytes = null;
        this.encryptedTokenBytes = null;
        this.loginTokenHeader = null;
        this.reasonCode = null;
        this.clearTextToken = null;
        this.clearTextTokenHeader = null;
        this.clearTextTokenData = null;
        this.clearTextTokenBytes = null;
        this.encryptionKeyLabel = null;
        this.encodedEncryptionKeyLabel = null;
        this.encryptionKeyLabelBytes = null;
        this.encodedEncryptionKeyLabelBytes = null;
        this.smooshedTokenBytes = null;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public String getUserid() {
        return this.userid;
    }

    public long getExpiresTimestamp() {
        return this.expires;
    }

    public byte[] getEncoded() {
        if (!this.valid) {
            throw new IllegalStateException("This LoginToken Instance is no longer valid.");
        }
        return this.smooshedTokenBytes;
    }

    protected String createTokenData(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createTokenData");
        }
        String string2 = this.loginTokenHeader.getHeader() + "wastag_ui" + "=" + string + "%%%%%" + new Long(this.expires).toString() + "%%%%%";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createTokenData: tokenData=" + string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createTokenData");
        }
        return string2;
    }

    protected boolean createLoginToken(String string) {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createLoginToken");
        }
        this.clearTextToken = this.createTokenData(string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createLoginToken: clearTextToken length = " + this.clearTextToken.length()));
            Tr.debug((TraceComponent)tc, (String)("createLoginToken: clearTextToken: " + this.clearTextToken));
        }
        try {
            this.clearTextTokenBytes = this.clearTextToken.getBytes("UTF8");
            bl = true;
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)"createLoginToken: Error getting token bytes");
            throwable.printStackTrace();
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createLoginToken --  rc = " + bl));
        }
        return bl;
    }

    private boolean restoreLoginTokenHeader() {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"restoreLoginTokenHeader");
        }
        try {
            this.loginTokenHeader = new LoginTokenHeader(this.clearTextTokenHeader);
            bl = this.loginTokenHeader.isValid();
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)("restoreLoginTokenHeader: caught exception " + throwable));
            throwable.printStackTrace();
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("restoreLoginTokenHeader -- rc = " + bl));
        }
        return bl;
    }

    private boolean parseLoginToken() {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseLoginToken");
        }
        try {
            this.clearTextToken = new String(this.clearTextTokenBytes, "ISO8859-1");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("parseLoginToken: clearTextToken = " + this.clearTextToken));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"parseLoginToken -- false, fail to construct clearTextToken with ISO8859-1");
            }
            return bl;
        }
        if (!this.clearTextToken.startsWith("%%%%%")) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"parseLoginToken -- false, not start with %%%%%");
            }
            return bl;
        }
        if (!this.clearTextToken.endsWith("%%%%%")) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"parseLoginToken -- false, not end with %%%%%");
            }
            return bl;
        }
        String string = new String(this.clearTextToken);
        int n = "%%%%%".length();
        int n2 = (string = string.substring(n)).indexOf("%%%%%");
        if (n2 < 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"parseLoginToken -- false, no <header> found");
            }
            return bl;
        }
        this.clearTextTokenHeader = string.substring(0, n2);
        if ((n2 = (string = string.substring(n2 + n)).indexOf("%%%%%")) < 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"parseLoginToken -- false, no <token data> found");
            }
            return bl;
        }
        this.clearTextTokenData = string.substring(0, n2);
        if (!this.clearTextTokenData.startsWith("wastag_ui")) {
            return bl;
        }
        this.clearTextTokenData = this.clearTextTokenData.substring("wastag_ui".length() + 1);
        if (this.clearTextTokenData.length() < 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"parseLoginToken -- false, no userid found in token data");
            }
            return bl;
        }
        if ((n2 = (string = string.substring(n2 + n)).indexOf("%%%%%")) < 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"parseLoginToken -- false, no <expires> found");
            }
            return bl;
        }
        this.expiresTime = string.substring(0, n2);
        bl = true;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parseLoginToken: <header> = " + this.clearTextTokenHeader));
            Tr.debug((TraceComponent)tc, (String)("parseLoginToken: <token data> = " + this.clearTextTokenData));
            Tr.debug((TraceComponent)tc, (String)("parseLoginToken: <expires> = " + this.expiresTime));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("parseLoginToken -- rc = " + bl));
        }
        return bl;
    }

    public void destroy() {
        this.resetObject();
    }
}

