/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ISecurityUtilityImpl.WSSecurityContextFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.models.config.ipc.ssl.CryptoHardwareToken;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.jaaslogin.JAASConfiguration;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.AuthorizationConfig;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.ORB;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.audit.AuditServiceImpl;
import com.ibm.ws.security.auth.Cache;
import com.ibm.ws.security.auth.distContextManagerImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.JaasWCCMHelper;
import com.ibm.ws.security.core.SASConfig;
import com.ibm.ws.security.core.SecurityAdmin;
import com.ibm.ws.security.core.SecurityCollaborator;
import com.ibm.ws.security.core.SecurityComponentImpl;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.core.SecurityConfigException;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.core.SecurityDM;
import com.ibm.ws.security.core.SecurityManager;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.security.policy.DynamicPolicyFactory;
import com.ibm.ws.security.policy.NullDynamicPolicy;
import com.ibm.ws.security.policy.WSDynamicPolicy;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.role.RoleBasedConfiguratorFactory;
import com.ibm.ws.security.server.SecurityServer;
import com.ibm.ws.security.server.SecurityServerFactory;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import com.ibm.ws.security.util.Constants;
import com.ibm.ws.security.util.JaccUtil;
import com.ibm.ws.security.util.SecurityMerge;
import com.ibm.ws.security.web.TrustAssociationManager;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.auth.callback.WSCallbackHandlerFactory;
import com.ibm.wsspi.security.authorization.InitializeJACCProvider;
import com.ibm.wtp.emf.utilities.copy.EtoolsCopyUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.security.Policy;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class distSecurityComponentImpl
extends ComponentImpl
implements SecurityService,
ConfigChangeListener {
    private static final TraceComponent tc = Tr.register((Class)distSecurityComponentImpl.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    private static final String LOGIN_CONFIG_CLASS = "com.ibm.ws.security.auth.login.Configuration";
    private Repository repository = null;
    private EndPointMgr endPointMgr = null;
    private boolean globalSecurityEnabled = true;
    private boolean serverSecurityEnabled = true;
    private String processType = null;
    private SecurityServer secServer = null;
    private ArrayList listeners = new ArrayList(32);
    private static RoleBasedConfigurator configurator = null;
    private InitializeJACCProvider initializeJACCProvider = null;
    private static AuditService _auditService = null;
    private Properties secProps = null;
    private boolean expandedVariables = false;
    private HashMap sslRepertoire = new HashMap();
    SecurityComponentImpl Proxy = null;
    private static final String START_EVENT = "start";
    private static final String STOP_EVENT = "stop";

    distSecurityComponentImpl(SecurityComponentImpl securityComponentImpl) {
        this.Proxy = securityComponentImpl;
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)object);
        }
        com.ibm.websphere.models.config.security.Security security = null;
        try {
            security = this.initializeWCCMConfig();
            this.initializeAudit();
            this.initializeJava2Sec(security);
            this.initializeDefaultSSLSettings(security);
            this.initializeJAAS(security);
            this.initializeSecurityConfig(security);
            this.initializeSSOTAI();
            Tr.info((TraceComponent)tc, (String)"security.init.startcomplete");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.distSecurityComponentImpl.initialize", (String)"216", (Object)((Object)this));
            Tr.audit((TraceComponent)tc, (String)"security.init.svcstartfail");
            if (exception instanceof ConfigurationError) {
                throw (ConfigurationError)exception;
            }
            if (exception instanceof ConfigurationWarning) {
                throw (ConfigurationWarning)exception;
            }
            throw new ConfigurationError((Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)START_EVENT);
        }
        try {
            if (this.globalSecurityEnabled) {
                this.registerListenerWithAdminService();
            }
            if (this.processType.equals("NodeAgent")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Security server is being started");
                }
                this.initialize();
                this.fireStartedEvent();
                Tr.info((TraceComponent)tc, (String)"security.init.svcstartcomplete");
                Tr.info((TraceComponent)tc, (String)"security.init.secstatus", (Object)new Object[]{new Boolean(this.serverSecurityEnabled)});
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.start", (String)"271", (Object)((Object)this));
            Tr.error((TraceComponent)tc, (String)"security.init.error", (Object)new Object[]{exception});
            Tr.audit((TraceComponent)tc, (String)"security.init.svcstartfail");
            throw new RuntimeError((Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)START_EVENT);
        }
    }

    public void startSecurity() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startSecurity");
        }
        this.initialize();
        this.fireStartedEvent();
        Tr.info((TraceComponent)tc, (String)"security.init.svcstartcomplete");
        Tr.info((TraceComponent)tc, (String)"security.init.secstatus", (Object)new Object[]{new Boolean(this.serverSecurityEnabled)});
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startSecurity");
        }
    }

    public void initialize() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        try {
            SecurityContext.setIsServerProcess();
            ConfigRoot configRoot = this.repository.getConfigRoot();
            if (this.globalSecurityEnabled) {
                try {
                    this.secServer = SecurityServerFactory.create();
                    this.initializeCache();
                    this.initializeServerSubject();
                    String string = (String)SecurityConfig.getConfig().getValue("security.unexpandedServerId");
                    if (string != null) {
                        this.getCellHostNames(configRoot);
                    }
                    SecurityContext.enable((AuditService)_auditService);
                    SecurityContext.initialize();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initialize", (String)"348", (Object)((Object)this));
                    Tr.error((TraceComponent)tc, (String)"security.init.secidautherror", (Object)new Object[]{exception});
                    throw exception;
                }
            }
            configurator = RoleBasedConfiguratorFactory.getConfigurator((boolean)this.globalSecurityEnabled);
            if (this.globalSecurityEnabled) {
                this.configureRoleBasedAuthz(configRoot, "admin-authz");
                this.configureRoleBasedAuthz(configRoot, "naming-authz");
                SecurityCollaborator.initialize();
            }
            this.initializeSecurityMBeans();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initialize", (String)"372", (Object)((Object)this));
            if (this.globalSecurityEnabled) {
                Tr.error((TraceComponent)tc, (String)"security.init.error", (Object)new Object[]{exception});
                throw exception;
            }
            Tr.warning((TraceComponent)tc, (String)"security.init.error", (Object)new Object[]{exception});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListenerWithAdminService() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerListenerWithAdminService");
        }
        Admin admin = null;
        try {
            block10: {
                try {
                    admin = (Admin)this.Proxy.GetService(Admin.class);
                    if (admin == null) break block10;
                    admin.addConfigChangeListener((ConfigChangeListener)this);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.ServerSecurityComponentImpl.registerListenerWithAdminService", (String)"406", (Object)((Object)this));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"attempt to register ConfigChangeListener failed", (Object)exception);
                    }
                    Object var4_3 = null;
                    if (admin != null) {
                        this.Proxy.ReleaseService(admin);
                    }
                }
            }
            Object var4_2 = null;
            if (admin != null) {
                this.Proxy.ReleaseService(admin);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (admin != null) {
                this.Proxy.ReleaseService(admin);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerListenerWithAdminService");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)STOP_EVENT);
        }
        if (this.initializeJACCProvider != null) {
            this.initializeJACCProvider.cleanup();
        }
        this.fireStoppedEvent();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)STOP_EVENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private com.ibm.websphere.models.config.security.Security initializeWCCMConfig() throws Exception {
        com.ibm.websphere.models.config.security.Security security;
        block28: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"initializeSecurityWCCMConfig");
            }
            security = null;
            try {
                this.Proxy.AddService(SecurityService.class);
                this.repository = (Repository)this.Proxy.GetService(Repository.class);
                ConfigRoot configRoot = this.repository.getConfigRoot();
                SecurityDM securityDM = new SecurityDM();
                securityDM.registerWithFFDCService();
                Resource resource = null;
                String string = "security.xml";
                try {
                    resource = configRoot.getResource(0, string);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initialize", (String)"460", (Object)((Object)this));
                    Tr.error((TraceComponent)tc, (String)"security.loadresource.error", (Object)new Object[]{string, exception});
                    throw exception;
                }
                com.ibm.websphere.models.config.security.Security security2 = (com.ibm.websphere.models.config.security.Security)resource.getContents().get(0);
                EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
                security = (com.ibm.websphere.models.config.security.Security)etoolsCopyUtility.copy((EObject)security2);
                if (security == null) {
                    Tr.error((TraceComponent)tc, (String)"security.init.nullsecobject");
                    throw new SecurityConfigException("Cannot get the Security object. security.xml might be corrupt or missing");
                }
                SecurityConfig.getConfig().setValue("cell.security.enabled", new Boolean(security.isEnabled()));
                this.secProps = SecurityConfig.getProperties((List)security.getProperties());
                this.globalSecurityEnabled = security.isEnabled();
                AdminService adminService = AdminServiceFactory.getAdminService();
                this.processType = adminService.getProcessType();
                if (this.processType == null || this.processType.length() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Cannot determine process type");
                    }
                    Tr.error((TraceComponent)tc, (String)"security.init.nullprocesstype");
                    throw new SecurityConfigException("Cannot determine the process type.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Process type: " + this.processType));
                }
                SecurityConfig.getConfig().setValue("security.processType", this.processType);
                if (this.globalSecurityEnabled) {
                    WSAccessManager.adminapps = AppDeploymentUtil.listSystemApps((Repository)this.repository);
                    if (this.processType.equals("NodeAgent")) {
                        String string2 = this.secProps.getProperty("WAS_UseRemoteRegistry");
                        Properties properties = SecurityConfig.getProperties((List)security.getActiveUserRegistry().getProperties());
                        String string3 = properties.getProperty("com.ibm.websphere.registry.UseDataSource");
                        if ("cell".equalsIgnoreCase(string2) || "true".equalsIgnoreCase(string3)) {
                            SecurityConfig.getConfig().setValue("WAS_UseRemoteRegistry", "cell");
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Setting remote registry to: cell");
                            }
                        }
                    } else if (this.processType.equals("ManagedProcess")) {
                        String string4;
                        Resource resource2;
                        block27: {
                            resource2 = null;
                            try {
                                resource2 = configRoot.getResource(4, string);
                            }
                            catch (Exception exception) {
                                if (!tc.isDebugEnabled()) break block27;
                                Tr.debug((TraceComponent)tc, (String)"Security.xml for server is missing. Will use cell's security.xml", (Object)exception);
                            }
                        }
                        if (resource2 != null) {
                            string4 = (com.ibm.websphere.models.config.security.Security)resource2.getContents().get(0);
                            com.ibm.websphere.models.config.security.Security security3 = (com.ibm.websphere.models.config.security.Security)etoolsCopyUtility.copy((EObject)string4);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Managed process: Start merging the server's and cell's configuration");
                            }
                            if ((security = SecurityMerge.merge(security, security3)) == null) {
                                Tr.error((TraceComponent)tc, (String)"security.init.nullsecobject");
                                throw new SecurityConfigException("Cannot get the Security object after security merge. security.xml might be corrupt or missing");
                            }
                            this.secProps = SecurityConfig.getProperties((List)security.getProperties());
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Managed process: End of merging the server's and cell's configuration");
                            }
                        }
                        if ((string4 = this.secProps.getProperty("WAS_UseRemoteRegistry")) != null && (string4.equalsIgnoreCase("node") || string4.equalsIgnoreCase("cell"))) {
                            SecurityConfig.getConfig().setValue("WAS_UseRemoteRegistry", string4);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Setting remote registry to: " + string4));
                            }
                        }
                    }
                }
                this.serverSecurityEnabled = security.isEnabled();
                SecurityConfig.getConfig().setValue("server.security.enabled", new Boolean(this.serverSecurityEnabled));
                Object var13_17 = null;
                if (this.repository == null) break block28;
                this.Proxy.ReleaseService(this.repository);
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                if (this.repository != null) {
                    this.Proxy.ReleaseService(this.repository);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Security config: " + SecurityConfig.getConfig()));
                }
                throw throwable;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Security config: " + SecurityConfig.getConfig()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeSecurityWCCMConfig");
        }
        return security;
    }

    private void initializeAudit() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeAudit");
        }
        try {
            AuditServiceImpl.initAuditService(this.secProps);
            _auditService = AuditServiceImpl.getAuditService();
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.init.error", (Object)new Object[]{exception});
            throw new ConfigurationError("Failed to initialize AuditService", (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeAudit");
        }
    }

    private void initializeSSOTAI() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeSSOTAI");
        }
        if (this.globalSecurityEnabled) {
            Object object;
            TrustAssociationManager.create();
            SecurityConfig securityConfig = SecurityConfig.getConfig();
            String string = (String)securityConfig.getValue("security.activeAuthMechanism");
            if (!(!string.equalsIgnoreCase("LTPA") && !string.equalsIgnoreCase("ICSF") || (object = (Boolean)securityConfig.getValue("security.ltpa.sso.enabled")) != null && ((Boolean)object).booleanValue())) {
                Tr.warning((TraceComponent)tc, (String)"security.init.ltpawithoutsso");
            }
            if (((String)(object = (String)securityConfig.getValue("security.enablePluggableAuthentication"))).equalsIgnoreCase("true") || ((String)object).equalsIgnoreCase("yes")) {
                String string2 = "Failed to initialize WSCallbackHandlerFactory";
                try {
                    TrustAssociationManager.create();
                    String string3 = (String)securityConfig.getValue("security.callbackHandlerFactoryClass");
                    Class<?> clazz = Class.forName(string3);
                    Method method2 = clazz.getMethod("getInstance", String.class);
                    WSCallbackHandlerFactory wSCallbackHandlerFactory = (WSCallbackHandlerFactory)method2.invoke(null, string3);
                }
                catch (Exception exception) {
                    Tr.error((TraceComponent)tc, (String)"security.init.error", (Object)new Object[]{exception});
                    throw new ConfigurationError(string2, (Throwable)exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeSSOTAI");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSecurityConfig(com.ibm.websphere.models.config.security.Security security) throws Exception {
        String string;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeSecurityConfig");
        }
        Properties properties = new Properties();
        ORB oRB = (ORB)this.Proxy.GetService(ORB.class);
        try {
            if (oRB != null) {
                properties = oRB.getOrbProps();
            }
            string2 = null;
            if (oRB != null) {
                this.Proxy.ReleaseService(oRB);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (oRB != null) {
                this.Proxy.ReleaseService(oRB);
            }
            throw throwable;
        }
        this.insertVariables(properties);
        SecurityConfig.getConfig().setValues(security, this.secProps, this.sslRepertoire);
        Server server = (Server)this.Proxy.GetService(Server.class);
        try {
            string2 = server.getCellName() + ":" + server.getNodeName() + ":" + server.getName();
            SecurityConfig.getConfig().setValue("process.serverName", string2);
            SecurityConfig.getConfig().setValue("shortservername", server.getName());
            SecurityConfig.getConfig().setValue("server.short.name", server.getShortName());
            SecurityConfig.getConfig().setValue("nodename", server.getNodeName());
            SecurityConfig.getConfig().setValue("node.short.name", server.getShortNodeName());
            SecurityConfig.getConfig().setValue("cellname", server.getCellName());
            SecurityConfig.getConfig().setValue("cell.short.name", server.getShortCellName());
            string = null;
            if (server != null) {
                this.Proxy.ReleaseService(server);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (server != null) {
                this.Proxy.ReleaseService(server);
            }
            throw throwable;
        }
        if (this.globalSecurityEnabled && properties != null) {
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            String string10;
            String string11;
            String string12;
            string2 = (String)this.secProps.get("com.ibm.CORBA.keyFileName");
            if (string2 != null) {
                properties.put("com.ibm.CORBA.keyFileName", string2);
            }
            if ((string12 = (String)this.secProps.get("com.ibm.ssl.keyStoreClientAlias")) != null) {
                properties.put("com.ibm.ssl.keyStoreClientAlias", string12);
            }
            if ((string = (String)this.secProps.get("com.ibm.ssl.keyStoreServerAlias")) != null) {
                properties.put("com.ibm.ssl.keyStoreServerAlias", string);
            }
            if ((string11 = (String)this.secProps.get("com.ibm.ssl.sas.outbound.keyStoreClientAlias")) != null) {
                properties.put("com.ibm.ssl.sas.outbound.keyStoreClientAlias", string11);
            }
            if ((string10 = (String)this.secProps.get("com.ibm.ssl.sas.outbound.keyStoreServerAlias")) != null) {
                properties.put("com.ibm.ssl.sas.outbound.keyStoreServerAlias", string10);
            }
            if ((string9 = (String)this.secProps.get("com.ibm.ssl.sas.inbound.keyStoreClientAlias")) != null) {
                properties.put("com.ibm.ssl.sas.inbound.keyStoreClientAlias", string9);
            }
            if ((string8 = (String)this.secProps.get("com.ibm.ssl.sas.inbound.keyStoreServerAlias")) != null) {
                properties.put("com.ibm.ssl.sas.inbound.keyStoreServerAlias", string8);
            }
            if ((string7 = (String)this.secProps.get("com.ibm.ssl.csi.outbound.keyStoreClientAlias")) != null) {
                properties.put("com.ibm.ssl.csi.outbound.keyStoreClientAlias", string7);
            }
            if ((string6 = (String)this.secProps.get("com.ibm.ssl.csi.outbound.keyStoreServerAlias")) != null) {
                properties.put("com.ibm.ssl.csi.outbound.keyStoreServerAlias", string6);
            }
            if ((string5 = (String)this.secProps.get("com.ibm.ssl.csi.inbound.keyStoreClientAlias")) != null) {
                properties.put("com.ibm.ssl.csi.inbound.keyStoreClientAlias", string5);
            }
            if ((string4 = (String)this.secProps.get("com.ibm.ssl.csi.inbound.keyStoreServerAlias")) != null) {
                properties.put("com.ibm.ssl.csi.inbound.keyStoreServerAlias", string4);
            }
            if ((string3 = (String)this.secProps.get("com.ibm.ssl.tokenSlot")) != null) {
                properties.put("com.ibm.ssl.tokenSlot", string3);
            }
            String string13 = (String)this.secProps.get("com.ibm.security.useFIPS");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("use_fips_flag = " + string13));
            }
            if (string13 != null) {
                properties.put("com.ibm.security.useFIPS", string13);
            } else {
                properties.put("com.ibm.security.useFIPS", "false");
            }
            String string14 = (String)this.secProps.get("security.enablePluggableAuthentication");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("enable_pluggable_auth_falg = " + string14));
            }
            if (string14 != null) {
                properties.put("security.enablePluggableAuthentication", string14);
            } else {
                properties.put("security.enablePluggableAuthentication", "false");
            }
            String string15 = (String)this.secProps.get("com.ibm.websphere.security.suppressExceptionStack");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("suppress_exception_stack = " + string15));
            }
            if (string15 != null) {
                properties.put("com.ibm.websphere.security.suppressExceptionStack", string15);
            } else {
                properties.put("com.ibm.websphere.security.suppressExceptionStack", "false");
            }
        }
        this.endPointMgr = (EndPointMgr)this.Proxy.GetService(EndPointMgr.class);
        try {
            SASConfig.updateORBConfig(security, properties, this.endPointMgr);
            Object var21_24 = null;
            if (this.endPointMgr != null) {
                this.Proxy.ReleaseService(this.endPointMgr);
            }
        }
        catch (Throwable throwable) {
            Object var21_25 = null;
            if (this.endPointMgr != null) {
                this.Proxy.ReleaseService(this.endPointMgr);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeSecurityConfig");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initializeJAAS(com.ibm.websphere.models.config.security.Security var1_1) throws Exception {
        if (distSecurityComponentImpl.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)distSecurityComponentImpl.tc, (String)"initializeJAAS");
        }
        try {
            Configuration.setConfiguration((Configuration)new com.ibm.ws.security.auth.login.Configuration());
        }
        catch (Exception var2_2) {
            FFDCFilter.processException((Throwable)var2_2, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initialize", (String)"803", (Object)this);
            Tr.error((TraceComponent)distSecurityComponentImpl.tc, (String)"security.init.wccmjaas.setcfgerror", (Object)new Object[]{"com.ibm.ws.security.auth.login.Configuration", var2_2});
            throw new ConfigurationError("Unable to set com.ibm.ws.security.auth.login.Configuration as the JAAS Login Configuration class.", (Throwable)var2_2);
        }
        var2_3 = com.ibm.ws.security.auth.login.Configuration.getConfiguration();
        var3_4 = var2_3.getClass().getName();
        if (distSecurityComponentImpl.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)distSecurityComponentImpl.tc, (String)("The Login Configuration class is: " + var3_4));
        }
        if (var2_3 instanceof com.ibm.ws.security.auth.login.Configuration) {
            try {
                var4_5 = (com.ibm.ws.security.auth.login.Configuration)var2_3;
                var5_7 = var1_1.getSystemLoginConfig();
                var6_8 = JaasWCCMHelper.convertToConfiguration((JAASConfiguration)var5_7, (boolean)true);
                var5_7 = var1_1.getApplicationLoginConfig();
                var7_9 = JaasWCCMHelper.convertToConfiguration((JAASConfiguration)var5_7, (boolean)false);
                var6_8.putAll(var7_9);
                var4_5.updateWCCMConfig(var6_8);
                Tr.info((TraceComponent)distSecurityComponentImpl.tc, (String)"security.init.wccmjaas.init");
                if (!distSecurityComponentImpl.tc.isDebugEnabled()) ** GOTO lbl36
                var8_10 = var4_5.toString();
                Tr.debug((TraceComponent)distSecurityComponentImpl.tc, (String)("The dynamic JAAS login configuration is:\n\t" + var8_10));
            }
            catch (Exception var4_6) {
                FFDCFilter.processException((Throwable)var4_6, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initialize", (String)"838", (Object)this);
                Tr.error((TraceComponent)distSecurityComponentImpl.tc, (String)"security.init.wccmjaas.error", (Object)new Object[]{var4_6});
                throw var4_6;
            }
        } else {
            if (this.globalSecurityEnabled) {
                Tr.error((TraceComponent)distSecurityComponentImpl.tc, (String)"security.init.wccmjaas.wrongclasserror", (Object)new Object[]{var3_4, "com.ibm.ws.security.auth.login.Configuration"});
                throw new RuntimeException("JAAS Login provider class com.ibm.ws.security.auth.login.Configuration is not configured as login provider class");
            }
            Tr.warning((TraceComponent)distSecurityComponentImpl.tc, (String)"security.init.wccmjaas.wrongclasswarning", (Object)new Object[]{var3_4, "com.ibm.ws.security.auth.login.Configuration"});
        }
lbl36:
        // 3 sources

        if (distSecurityComponentImpl.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)distSecurityComponentImpl.tc, (String)"initializeJAAS");
        }
    }

    void initializeDefaultSSLSettings(com.ibm.websphere.models.config.security.Security security) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeDefaultSSLSettings");
        }
        String string = this.secProps.getProperty("com.ibm.security.useFIPS");
        this.initializeFips(security, string);
        String string2 = null;
        for (int i = 0; i < security.getRepertoire().size(); ++i) {
            SSLConfig sSLConfig = (SSLConfig)security.getRepertoire().get(i);
            if (sSLConfig == null) continue;
            Properties properties = this.getSSLConfigProperties(sSLConfig, string);
            string2 = (String)properties.get("com.ibm.ssl.contextProvider");
            if (string2 != null && string2.length() > 0) {
                JSSEProvider jSSEProvider = JSSEProviderFactory.getInstance((String)string2);
            }
            this.sslRepertoire.put(sSLConfig.getAlias(), properties);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeDefaultSSLSettings");
        }
    }

    Properties getSSLConfigProperties(SSLConfig sSLConfig, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLConfigProperties", (Object)new Object[]{sSLConfig, string});
        }
        SecureSocketLayer secureSocketLayer = sSLConfig.getSetting();
        Properties properties = new Properties();
        String string2 = null;
        if (null != sSLConfig.getType()) {
            string2 = sSLConfig.getType().getName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Adding SSL type: " + string2));
            }
            properties.put("com.ibm.ssl.sslType", string2);
        }
        if (secureSocketLayer.getKeyFileName() != null) {
            secureSocketLayer.setKeyFileName(this.Proxy.ExpandVariable(secureSocketLayer.getKeyFileName()));
        }
        if (secureSocketLayer.getTrustFileName() != null) {
            secureSocketLayer.setTrustFileName(this.Proxy.ExpandVariable(secureSocketLayer.getTrustFileName()));
        }
        properties.put("com.ibm.ssl.keyManager", JSSEProviderFactory.getKeyManagerFactoryAlgorithm());
        properties.put("com.ibm.ssl.trustManager", JSSEProviderFactory.getTrustManagerFactoryAlgorithm());
        if (secureSocketLayer.getKeyFileName() != null) {
            properties.put("com.ibm.ssl.keyStore", secureSocketLayer.getKeyFileName());
        } else if (!secureSocketLayer.isEnableCryptoHardwareSupport()) {
            throw new IllegalArgumentException("KeyFileName not set in the SSL configuration");
        }
        if (secureSocketLayer.getTrustFileName() != null) {
            properties.put("com.ibm.ssl.trustStore", secureSocketLayer.getTrustFileName());
        } else if (string2 != null && string2.equals("JSSE") && !secureSocketLayer.isEnableCryptoHardwareSupport()) {
            throw new IllegalArgumentException("TrustFileName not set in the SSL configuration");
        }
        if (secureSocketLayer.getTrustFilePassword() != null) {
            properties.put("com.ibm.ssl.trustStorePassword", secureSocketLayer.getTrustFilePassword());
        } else if (string2 != null && string2.equals("JSSE") && !secureSocketLayer.isEnableCryptoHardwareSupport()) {
            throw new IllegalArgumentException("TrustFilePassword not set in the SSL configuration");
        }
        if (secureSocketLayer.getKeyFilePassword() != null) {
            properties.put("com.ibm.ssl.keyStorePassword", secureSocketLayer.getKeyFilePassword());
        } else if (string2 != null && string2.equals("JSSE") && !secureSocketLayer.isEnableCryptoHardwareSupport()) {
            throw new IllegalArgumentException("KeyFilePassword not set in the SSL configuration");
        }
        if (secureSocketLayer.getKeyFileFormat() != null) {
            properties.put("com.ibm.ssl.keyStoreType", SASConfig.getKeyStoreType(secureSocketLayer.getKeyFileFormat()));
        } else if (string2 != null && string2.equals("JSSE") && !secureSocketLayer.isEnableCryptoHardwareSupport()) {
            throw new IllegalArgumentException("KeyFileFormat not set in the SSL configuration");
        }
        if (secureSocketLayer.getTrustFileFormat() != null) {
            properties.put("com.ibm.ssl.trustStoreType", SASConfig.getKeyStoreType(secureSocketLayer.getTrustFileFormat()));
        } else if (string2 != null && string2.equals("JSSE") && !secureSocketLayer.isEnableCryptoHardwareSupport()) {
            throw new IllegalArgumentException("TrustFileFormat not set in the SSL configuration");
        }
        properties.put("com.ibm.ssl.clientAuthentication", Boolean.toString(secureSocketLayer.isClientAuthentication()));
        properties.put("com.ibm.ssl.securityLevel", SASConfig.getSecurityLevel(secureSocketLayer.getSecurityLevel()));
        for (int i = 0; i < secureSocketLayer.getProperties().size(); ++i) {
            Property property = (Property)secureSocketLayer.getProperties().get(i);
            if (property == null) continue;
            properties.put(property.getName(), property.getValue());
        }
        if (string != null && string.equalsIgnoreCase("true")) {
            properties.put("com.ibm.ssl.protocol", "TLS");
        }
        if (secureSocketLayer.isEnableCryptoHardwareSupport()) {
            CryptoHardwareToken cryptoHardwareToken = secureSocketLayer.getCryptoHardware();
            properties.put("com.ibm.ssl.tokenType", cryptoHardwareToken.getTokenType());
            properties.put("com.ibm.ssl.tokenLibraryFile", cryptoHardwareToken.getLibraryFile());
            properties.put("com.ibm.ssl.tokenPassword", cryptoHardwareToken.getPassword());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSSLConfigProperties");
        }
        return properties;
    }

    void initializeFips(com.ibm.websphere.models.config.security.Security security, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeFips");
        }
        if (string != null && string.equalsIgnoreCase("true")) {
            Security.setProperty("USEFIPS_ENABLED", "true");
            SecurityConfig.getConfig().setValue("IBMJCE", "IBMJCEFIPS");
            Security.setProperty("DEFAULT_JCE_PROVIDER", "IBMJCEFIPS");
            Security.setProperty("com.ibm.websphere.security.fips.enabled", "true");
            Tr.info((TraceComponent)tc, (String)"security.fips.enabled");
            this.checkProviderList();
            JSSEProviderFactory.initializeFips();
        } else {
            Security.setProperty("DEFAULT_JCE_PROVIDER", (String)SecurityConfig.getConfig().getValue("IBMJCE"));
            Security.setProperty("USEFIPS_ENABLED", "false");
            Security.setProperty("com.ibm.websphere.security.fips.enabled", "false");
        }
        Security.setProperty("com.ibm.websphere.security.fips.jsseProviders", "IBMJSSE2");
        Security.setProperty("com.ibm.websphere.security.fips.jceProviders", "IBMJCEFIPS");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeFips");
        }
    }

    private void initializeJaccProxy(DynamicPolicy dynamicPolicy, com.ibm.websphere.models.config.security.Security security) throws Exception {
        DynamicPolicyFactory.setInstance((DynamicPolicy)dynamicPolicy);
        String string = System.getProperty("javax.security.jacc.policy.provider");
        boolean bl = false;
        AuthorizationConfig authorizationConfig = null;
        if (security != null) {
            try {
                authorizationConfig = security.getAuthConfig();
                if (authorizationConfig != null) {
                    bl = authorizationConfig.isUseJACCProvider();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initializeJaccProxy", (String)"1054", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"security.jacc.config.error", (Object)new Object[]{exception});
                throw new ConfigurationError("Failed to get useJACCProvider information", (Throwable)exception);
            }
        }
        if (string == null && !bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using default authorization");
            }
            return;
        }
        this.expandVariables();
        if (authorizationConfig != null) {
            SecurityConfig.setAuthorizationValues(authorizationConfig);
        }
        if (string == null && authorizationConfig != null && (string = SecurityConfig.getPolicyClassName()) != null) {
            System.setProperty("javax.security.jacc.policy.provider", string);
        }
        if (string == null) {
            throw new ConfigurationError("The JACC provider's policy class name is null");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The JACC provider's policy implementation class name is: " + string));
        }
        SecurityConfig.setJACCEnabled();
        if (SecurityConfig.supportsDynamicModuleUpdates()) {
            JaccUtil.setAppDynamicUpdates();
        }
        if (string.equals("com.ibm.ws.security.policy.JaccPolicyProxy")) {
            SecurityConfig.setDefaultJaccProvider();
        }
        String string2 = SecurityConfig.getInitializeJACCProviderClassName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"jaccInit Class Name: ", (Object)string2);
        }
        if (string2 != null && string2.length() != 0) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                this.initializeJACCProvider = (InitializeJACCProvider)Class.forName(string2, true, classLoader).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                Tr.error((TraceComponent)tc, (String)"security.jacc.initialize.error", (Object)new Object[]{string2, classNotFoundException});
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initializeJaccProvider", (String)"1119", (Object)((Object)this));
                throw new ConfigurationError(classNotFoundException.getMessage(), (Throwable)classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Tr.error((TraceComponent)tc, (String)"security.jacc.initialize.error", (Object)new Object[]{string2, illegalAccessException});
                FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initializeJaccProvider", (String)"1126", (Object)((Object)this));
                throw new ConfigurationError(illegalAccessException.getMessage(), (Throwable)illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                Tr.error((TraceComponent)tc, (String)"security.jacc.initialize.error", (Object)new Object[]{string2, instantiationException});
                FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initializeJaccProvider", (String)"1133", (Object)((Object)this));
                throw new ConfigurationError(instantiationException.getMessage(), (Throwable)instantiationException);
            }
            int n = -1;
            try {
                n = this.initializeJACCProvider.initialize(SecurityConfig.getJACCProviderCustomProperties());
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)"security.jacc.initialize.error", (Object)new Object[]{string2, exception});
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initializeJaccProvider", (String)"1145", (Object)((Object)this));
                throw new ConfigurationError(exception.getMessage(), (Throwable)exception);
            }
            if (n != 0) {
                String string3 = "The initialize method of " + string2 + " did not return success code 0.  The error code returned was: " + n;
                String string4 = Constants.nls.getFormattedMessage("security.jacc.initialize.error", new Object[]{string2, new Integer(n)}, string3);
                throw new ConfigurationError(string4);
            }
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Policy.setPolicy((Policy)Class.forName(string, true, classLoader).newInstance());
            Policy policy = Policy.getPolicy();
            policy.refresh();
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)"security.jacc.init.error", (Object)new Object[]{string, throwable});
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initializeJaccProvider", (String)"1169", (Object)((Object)this));
            throw new ConfigurationError(throwable.getMessage(), throwable);
        }
        Tr.audit((TraceComponent)tc, (String)"security.jacc.initialized", (Object)new Object[]{string, SecurityConfig.getPolicyConfigurationFactoryClassName(), SecurityConfig.getRoleConfigurationFactoryClassName(), string2});
        SecurityConfig.setNullProtectionDomain();
        SecurityConfig.setNullCodeSource();
    }

    private void initializeJava2Sec(com.ibm.websphere.models.config.security.Security security) throws SecurityConfigException, ConfigurationError {
        if (security != null) {
            Boolean bl = null;
            try {
                bl = new Boolean(security.isEnforceJava2Security());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initializeJava2Sec", (String)"1200", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"security.j2sec.init.error", (Object)new Object[]{exception});
                throw new ConfigurationError("Failed to get EnforceJava2Security.", (Throwable)exception);
            }
            try {
                boolean bl2 = bl;
                if (!bl2) {
                    NullDynamicPolicy nullDynamicPolicy = new NullDynamicPolicy(Policy.getPolicy());
                    Policy.setPolicy(nullDynamicPolicy);
                    this.initializeJaccProxy(nullDynamicPolicy, security);
                    System.setSecurityManager(null);
                    Tr.info((TraceComponent)tc, (String)"security.manager.disabled");
                } else {
                    WSDynamicPolicy wSDynamicPolicy = new WSDynamicPolicy(Policy.getPolicy(), this.repository);
                    Policy.setPolicy(wSDynamicPolicy);
                    this.initializeJaccProxy(wSDynamicPolicy, security);
                    String string = (String)this.secProps.get("java.security.debug");
                    Server server = (Server)this.Proxy.GetService(Server.class);
                    ExtClassLoader extClassLoader = (ExtClassLoader)server.getRuntimeClassLoader();
                    this.Proxy.ReleaseService(server);
                    boolean bl3 = new Boolean(security.isEnableJava2SecRuntimeFiltering());
                    SecurityManager securityManager = new SecurityManager(string, extClassLoader, wSDynamicPolicy.getRuntimeFilteredPermission(), bl3);
                    System.setSecurityManager(securityManager);
                    Tr.info((TraceComponent)tc, (String)"security.jsecman.installed");
                    Boolean bl4 = Boolean.TRUE;
                    bl4 = new Boolean(security.isIssuePermissionWarning());
                    wSDynamicPolicy.initApplicationTemplate(bl4);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.initializeJava2Sec", (String)"1248", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"security.j2sec.init.error", (Object)new Object[]{exception});
                throw new ConfigurationError("Error during Java 2 Security and Dynamic Policy initialization", (Throwable)exception);
            }
        }
    }

    void configureRoleBasedAuthz(ConfigRoot configRoot, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"configureRoleBasedAuthz", (Object)new Object[]{configRoot, string});
        }
        String string2 = string + ".xml";
        try {
            Resource resource = configRoot.getResource(0, string2);
            this.getConfigurator().loadApplication(string, resource);
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.loadresource.error", (Object)new Object[]{string2, exception});
            throw exception;
        }
        if (string.equals("admin-authz")) {
            try {
                this.getConfigurator().loadSecurityPolicy(string, "/com/ibm/ws/security/server/xml/SecurityServer.xml", "domain");
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)"security.load.secConfig", (Object)new Object[]{exception});
                throw exception;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"configureRoleBasedAuthz");
        }
    }

    void initializeSecurityMBeans() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeSecurityMBeans");
        }
        try {
            SecurityAdmin securityAdmin = new SecurityAdmin();
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator((Object)securityAdmin, "SecurityAdmin");
            mBeanFactory.activateMBean("SecurityAdmin", (RuntimeCollaborator)defaultRuntimeCollaborator, mBeanFactory.getConfigId((Object)"SecurityAdmin"), "com/ibm/ws/management/descriptor/xml/SecurityAdmin.xml");
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.init.mbeanerror", (Object)new Object[]{"SecurityAdmin", exception});
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeSecurityMBeans");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SecurityServiceListener securityServiceListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addListener", (Object)securityServiceListener);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(securityServiceListener)) {
                this.listeners.add(securityServiceListener);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SecurityServiceListener securityServiceListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeListener", (Object)securityServiceListener);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(securityServiceListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"configChanged", (Object)configRepositoryEvent);
        }
        try {
            try {
                TreeSet treeSet = (TreeSet)SecurityConfig.getConfig().getValue("security.serverNameList");
                String string = (String)SecurityConfig.getConfig().getValue("security.unexpandedServerId");
                if (treeSet != null && string != null) {
                    ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
                    for (int i = 0; i < configChangeNotifierArray.length; ++i) {
                        if (configChangeNotifierArray[i].getChangeType() != 0 && configChangeNotifierArray[i].getChangeType() != 1 || !configChangeNotifierArray[i].getUri().endsWith("serverindex.xml")) continue;
                        String string2 = configChangeNotifierArray[i].getUri();
                        int n = string2.lastIndexOf(47);
                        int n2 = -1;
                        if (n > 0) {
                            n2 = string2.lastIndexOf(47, n - 1);
                        }
                        if (n <= 0 || n2 <= 0) continue;
                        String string3 = string2.substring(n2 + 1, n);
                        if (tc.isDebugEnabled()) {
                            if (configChangeNotifierArray[i].getChangeType() == 0) {
                                Tr.debug((TraceComponent)tc, (String)("Node added: " + string3));
                            } else {
                                Tr.debug((TraceComponent)tc, (String)("Node removed: " + string3));
                            }
                        }
                        if (this.repository == null) {
                            this.repository = (Repository)this.Proxy.GetService(class$com$ibm$ws$runtime$service$Repository == null ? distSecurityComponentImpl.class$("com.ibm.ws.runtime.service.Repository") : class$com$ibm$ws$runtime$service$Repository);
                        }
                        ConfigRoot configRoot = this.repository.getConfigRoot();
                        String[] stringArray = configRoot.list(3, null);
                        String string4 = configRoot.getValue(3);
                        for (int j = 0; j < stringArray.length; ++j) {
                            boolean bl;
                            configRoot.setValue(3, stringArray[j]);
                            if (!stringArray[j].equals(string3)) continue;
                            Resource resource = configRoot.getResource(3, "serverindex.xml");
                            EList eList = resource.getContents();
                            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                            String string5 = serverIndex.getHostName().toLowerCase();
                            String string6 = SecurityConfig.expandHost(string, string5);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Expanded serverID: " + string6));
                            }
                            if (string6 == null) continue;
                            if (configChangeNotifierArray[i].getChangeType() == 0) {
                                bl = treeSet.add(string6);
                                if (!tc.isDebugEnabled()) continue;
                                if (bl) {
                                    Tr.debug((TraceComponent)tc, (String)("Server ID " + string6 + " was added to the multi-serverID list."));
                                    continue;
                                }
                                Tr.debug((TraceComponent)tc, (String)("Server ID " + string6 + " was already in the multi-serverID list."));
                                continue;
                            }
                            if (configChangeNotifierArray[i].getChangeType() != 1) continue;
                            bl = treeSet.remove(string6);
                            if (!tc.isDebugEnabled()) continue;
                            if (bl) {
                                Tr.debug((TraceComponent)tc, (String)("Server ID " + string6 + " was removed to the multi-serverID list."));
                                continue;
                            }
                            Tr.debug((TraceComponent)tc, (String)("Server ID " + string6 + " was not present in the multi-serverID list."));
                        }
                        configRoot.setValue(3, string4);
                    }
                }
                Object var21_21 = null;
                if (this.repository != null) {
                    this.Proxy.ReleaseService(this.repository);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.configChanged", (String)"1467", (Object)((Object)this));
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception caught: " + exception.getMessage()));
                }
                Object var21_22 = null;
                if (this.repository != null) {
                    this.Proxy.ReleaseService(this.repository);
                }
            }
        }
        catch (Throwable throwable) {
            Object var21_23 = null;
            if (this.repository != null) {
                this.Proxy.ReleaseService(this.repository);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"configChanged");
        }
    }

    private void getCellHostNames(ConfigRoot configRoot) throws Exception {
        TreeSet<String> treeSet;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getCellHostNames");
            }
            treeSet = new TreeSet<String>();
            try {
                Object object;
                StringBuffer stringBuffer;
                int n;
                String string;
                String[] stringArray;
                WSCredential wSCredential = ContextManagerFactory.getInstance().getServerCredential();
                if (wSCredential != null) {
                    stringArray = wSCredential.getAccessId().toLowerCase();
                    string = (String)SecurityConfig.getConfig().getValue("process.hostName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Server accessID: " + (String)stringArray + ", hostname: " + string));
                    }
                    if (string != null) {
                        n = string.length();
                        int n2 = stringArray.indexOf(string);
                        if (n2 != -1) {
                            stringBuffer = new StringBuffer((String)stringArray);
                            stringBuffer.replace(n2, n2 + n, "${HOST}");
                            object = stringBuffer.toString();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Unexpanded accessID is: " + (String)object));
                            }
                            SecurityConfig.getConfig().setValue("security.unexpandedServerId", object);
                        }
                    }
                }
                stringArray = configRoot.list(3, null);
                string = configRoot.getValue(3);
                for (n = 0; n < stringArray.length; ++n) {
                    boolean bl;
                    String string2;
                    configRoot.setValue(3, stringArray[n]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Node name: " + stringArray[n]));
                    }
                    Resource resource = configRoot.getResource(3, "serverindex.xml");
                    stringBuffer = resource.getContents();
                    object = (ServerIndex)resource.getContents().get(0);
                    String string3 = object.getHostName().toLowerCase();
                    String string4 = (String)SecurityConfig.getConfig().getValue("security.unexpandedServerId");
                    if (string4 == null || (string2 = SecurityConfig.expandHost(string4, string3)) == null || !(bl = treeSet.add(string2))) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Server ID " + string2 + " was added to the multi-serverID list."));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Server ID " + string2 + " was already in the multi-serverID list."));
                }
                configRoot.setValue(3, string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.distSecurityComponentImpl.getCellHostNames", (String)"1547", (Object)((Object)this));
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug((TraceComponent)tc, (String)"Exception occurred getting Cell hostnames.", (Object)new Object[]{exception});
            }
        }
        SecurityConfig.getConfig().setValue("security.serverNameList", treeSet);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCellHostNames");
        }
    }

    private void fireStartedEvent() {
        this.fireEvent(START_EVENT);
    }

    private void fireStoppedEvent() {
        this.fireEvent(STOP_EVENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("fireEvent,  event is :" + string));
        }
        List list = null;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            list = (List)this.listeners.clone();
        }
        if (list != null) {
            int n = list.size();
            SecurityServiceEvent securityServiceEvent = string.equals(START_EVENT) ? new SecurityServiceEvent(1) : new SecurityServiceEvent(2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("list size = " + n), (Object)("event = " + string));
            }
            for (int i = 0; i < n; ++i) {
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("Invoking stateChanged(), Listener.hashCode() = ");
                    stringBuffer.append(list.get(i).hashCode());
                    stringBuffer.append("Listener.toString()");
                    stringBuffer.append(list.get(i).toString());
                    Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
                }
                try {
                    ((SecurityServiceListener)list.get(i)).stateChanged(securityServiceEvent);
                    continue;
                }
                catch (Exception exception) {
                    Tr.error((TraceComponent)tc, (String)"security.init.error", (Object)new Object[]{exception});
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.fireEvent", (String)"1595", (Object)((Object)this));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("fireEvent, : event is " + string));
        }
    }

    public RoleBasedConfigurator getConfigurator() throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConfigurator");
        }
        if (configurator == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"RoleBasedConfigurator not initialized");
            }
            throw new RoleBasedAppException("RoleBasedConfigurator not initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConfigurator");
        }
        return configurator;
    }

    public Properties getSecureSocketLayer(String string) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSecureSocketLayer", (Object)string);
        }
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Alias is null or empty string.");
        }
        Properties properties = (Properties)this.sslRepertoire.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSecureSocketLayer");
        }
        return properties;
    }

    public boolean isSecurityEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isSecurityEnabled");
        }
        try {
            return this.globalSecurityEnabled;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.core.SecurityComponentImpl.isSecurityEnabled", (String)"1646", (Object)((Object)this));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception caught", (Object)throwable);
            }
            return true;
        }
    }

    public boolean isServerSecurityEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isServerSecurityEnabled");
        }
        try {
            return this.serverSecurityEnabled;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.core.SecurityComponentImpl.isServerSecurityEnabled", (String)"1666", (Object)((Object)this));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception caught", (Object)throwable);
            }
            return true;
        }
    }

    public String getRealm() {
        return (String)SecurityConfig.getConfig().getValue("security.activeUserRegistry.realm");
    }

    public WSSecurityContext getWSSecurityContext() {
        WSSecurityContext wSSecurityContext;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getWSSecurityContext");
            }
            wSSecurityContext = null;
            if (this.globalSecurityEnabled) {
                try {
                    String string = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism.OID");
                    WSSecurityContextFactory wSSecurityContextFactory = WSSecurityContextFactory.getInstance();
                    wSSecurityContext = wSSecurityContextFactory.createContext(string);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityComponentImpl.getWSSecurityContext", (String)"1711", (Object)((Object)this));
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)"Exception getting WSSecurityContext", (Object)exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWSSecurityContext", wSSecurityContext);
        }
        return wSSecurityContext;
    }

    private void expandVariables() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"expandVariables");
        }
        VariableMap variableMap = (VariableMap)this.Proxy.GetService(VariableMap.class);
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        try {
            string = variableMap.expand("${WAS_INSTALL_ROOT}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot expand ${WAS_INSTALL_ROOT}");
            }
            string = System.getProperty("was.install.root");
        }
        try {
            string2 = variableMap.expand("${USER_INSTALL_ROOT}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot expand ${USER_INSTALL_ROOT}");
            }
            string2 = System.getProperty("user.install.root", System.getProperty("was.install.root"));
        }
        try {
            string3 = variableMap.expand("${WAS_TEMP_DIR}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot expand ${WAS_TEMP_DIR}");
            }
            string3 = string + File.separator + "tmp";
        }
        try {
            string5 = variableMap.expand("${WAS_PROPS_DIR}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot expand ${WAS_PROPS_DIR}");
            }
            string5 = string + File.separator + "properties";
        }
        try {
            string6 = variableMap.expand("${APP_INSTALL_ROOT}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot expand ${APP_INSTALL_ROOT}");
            }
            string6 = string + File.separator + "installedApps";
        }
        try {
            string4 = variableMap.expand("${WAS_ETC_DIR}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot expand ${WAS_ETC_DIR}");
            }
            string4 = string + File.separator + "etc";
        }
        SecurityConfig.getConfig().setValue("${WAS_INSTALL_ROOT}", string);
        SecurityConfig.getConfig().setValue("${USER_INSTALL_ROOT}", string2);
        SecurityConfig.getConfig().setValue("${WAS_TEMP_DIR}", string3);
        SecurityConfig.getConfig().setValue("${WAS_PROPS_DIR}", string5);
        SecurityConfig.getConfig().setValue("${WAS_ETC_DIR}", string4);
        SecurityConfig.getConfig().setValue("${APP_INSTALL_ROOT}", string6);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("${WAS_INSTALL_ROOT}  = " + string));
            Tr.debug((TraceComponent)tc, (String)("${USER_INSTALL_ROOT} = " + string2));
            Tr.debug((TraceComponent)tc, (String)("${WAS_TEMP_DIR}      = " + string3));
            Tr.debug((TraceComponent)tc, (String)("${WAS_PROPS_DIR}     = " + string5));
            Tr.debug((TraceComponent)tc, (String)("${WAS_ETC_DIR}       = " + string4));
            Tr.debug((TraceComponent)tc, (String)("${APP_INSTALL_ROOT}  = " + string6));
        }
        this.expandedVariables = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"expandVariables");
        }
    }

    private void insertVariables(Properties properties) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"inserting variables into orbProps");
        }
        if (!this.expandedVariables) {
            this.expandVariables();
        }
        if (properties != null) {
            properties.put("${WAS_INSTALL_ROOT}", SecurityConfig.getConfig().getValue("${WAS_INSTALL_ROOT}"));
            properties.put("${USER_INSTALL_ROOT}", SecurityConfig.getConfig().getValue("${USER_INSTALL_ROOT}"));
            properties.put("${WAS_TEMP_DIR}", SecurityConfig.getConfig().getValue("${WAS_TEMP_DIR}"));
            properties.put("${WAS_PROPS_DIR}", SecurityConfig.getConfig().getValue("${WAS_PROPS_DIR}"));
            properties.put("${WAS_ETC_DIR}", SecurityConfig.getConfig().getValue("${WAS_ETC_DIR}"));
            properties.put("${APP_INSTALL_ROOT}", SecurityConfig.getConfig().getValue("${APP_INSTALL_ROOT}"));
        }
    }

    private void initializeCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeCache");
        }
        Long l = (Long)SecurityConfig.getConfig().getValue("security.CacheTimeout");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"security cache timeout", (Object)l);
        }
        Cache.setDefaultTimeout(l * 1000L);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeCache");
        }
    }

    Subject initializeServerSubject() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeServerSubject");
        }
        ContextManager contextManager = ContextManagerFactory.getInstance();
        Subject subject = ((distContextManagerImpl)contextManager).getServerSubjectInternal();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeServerSubject", (Object)subject);
        }
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkProviderList() {
        block21: {
            var1_1 = null;
            var2_2 = null;
            var3_3 = null;
            var4_4 = false;
            if (distSecurityComponentImpl.tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)distSecurityComponentImpl.tc, (String)"checkProviderList");
            }
            var5_5 = System.getProperty("java.home");
            var3_3 = var5_5 + File.separator + "lib" + File.separator + "security" + File.separator + "java.security";
            try {
                var1_1 = new BufferedReader(new FileReader(var3_3));
                while ((var2_2 = var1_1.readLine()) != null) {
                    if (var2_2.trim().startsWith("#") || var2_2.trim().length() <= 0 || !var2_2.trim().startsWith("security.provider")) continue;
                    if (var2_2.indexOf("com.ibm.crypto.fips.provider.IBMJCEFIPS") != -1) {
                        var4_4 = true;
                    }
                    if (var2_2.indexOf("com.ibm.crypto.provider.IBMJCE") == -1) continue;
                    if (var4_4) break;
                    Tr.warning((TraceComponent)distSecurityComponentImpl.tc, (String)"security.checkProviderList.warning");
                    if (!distSecurityComponentImpl.tc.isEntryEnabled()) break;
                    Tr.debug((TraceComponent)distSecurityComponentImpl.tc, (String)"In FIPS mode, IBMJCEFIPS provider is not found before the IBMJCE provider in the java.security file.");
                    break;
                }
            }
            catch (FileNotFoundException var6_14) {
                if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)distSecurityComponentImpl.tc, (String)("FileNotFoundException caught for " + var3_3));
                }
                var8_7 = null;
                try {
                    if (var1_1 != null) {
                        var1_1.close();
                    }
                }
                catch (Exception var9_11) {
                    if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)distSecurityComponentImpl.tc, (String)("Exception caught: " + var9_11.getMessage()));
                    }
                    break block21;
                }
            }
            catch (Exception var6_15) {
                if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)distSecurityComponentImpl.tc, (String)("Exception caught: " + var6_15.getMessage()));
                }
                var8_8 = null;
                try {}
                catch (Exception var9_12) {
                    if (distSecurityComponentImpl.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)distSecurityComponentImpl.tc, (String)("Exception caught: " + var9_12.getMessage()));
                    }
                    break block21;
                }
                if (var1_1 != null) {
                    var1_1.close();
                }
                break block21;
            }
            var8_6 = null;
            {
                catch (Throwable var7_16) {
                    var8_9 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 317->328)] { 
lbl58:
                    // 1 sources

                    if (var1_1 == null) throw var7_16;
                    var1_1.close();
                    throw var7_16;
lbl61:
                    // 1 sources

                    catch (Exception var9_13) {
                        if (distSecurityComponentImpl.tc.isDebugEnabled() == false) throw var7_16;
                        Tr.debug((TraceComponent)distSecurityComponentImpl.tc, (String)("Exception caught: " + var9_13.getMessage()));
                    }
                    throw var7_16;
                }
                ** try [egrp 2[TRYBLOCK] [6 : 317->328)] { 
lbl66:
                // 1 sources

                if (var1_1 != null) {
                    var1_1.close();
                }
lbl70:
                // 1 sources

                catch (Exception var9_10) {}
                if (!distSecurityComponentImpl.tc.isDebugEnabled()) break block21;
                Tr.debug((TraceComponent)distSecurityComponentImpl.tc, (String)("Exception caught: " + var9_10.getMessage()));
            }
        }
        if (distSecurityComponentImpl.tc.isEntryEnabled() == false) return;
        Tr.exit((TraceComponent)distSecurityComponentImpl.tc, (String)"checkProviderList");
    }
}

