/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.icsf.ICSFServerObject;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.server.SecurityServer;
import com.ibm.ws.security.server.SecurityServerFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Properties;

public class WSCredentialsHelper {
    private static final TraceComponent tc;
    static String securitySAFUnauthenticated;
    static String securityLocalIdentity;
    static String securityRemoteIdentity;
    private static ContextManager ctxMgr;
    private static boolean inInitialization;
    private static Object synchVariable;
    private static SecurityServer secServer;
    private static UserRegistry currentUserReg;

    public static Object runAs(PrivilegedExceptionAction privilegedExceptionAction, String string) throws PrivilegedActionException {
        String string2 = "";
        String string3 = "WSCredentialsHelper.runAs";
        WSCredential wSCredential = null;
        WSCredential wSCredential2 = null;
        Object var6_6 = null;
        if (ctxMgr.isServerSecurityEnabled()) {
            try {
                WSCredential wSCredential3 = null;
                if (string.equals("System")) {
                    wSCredential3 = WSCredentialsHelper.getServerCredential();
                    if (wSCredential3 != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Setting CallerCredential to Server");
                        }
                        wSCredential2 = WSCredentialsHelper.pushCallerCredential(wSCredential3);
                    }
                } else if (string.equals("Client")) {
                    wSCredential3 = WSCredentialsHelper.retrieveCredential();
                } else if (string.equals("ReceivedClient")) {
                    wSCredential3 = WSCredentialsHelper.getCallerCredential();
                }
                if (wSCredential3 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Setting Invocation credential to " + wSCredential3.getSecurityName()));
                    }
                    wSCredential = WSCredentialsHelper.pushInvocationCredential(wSCredential3);
                }
            }
            catch (Exception exception) {
                block30: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception occurred during RunAs processing");
                    }
                    try {
                        if (wSCredential != null) {
                            WSCredentialsHelper.popInvocationCredential(wSCredential);
                            wSCredential = null;
                        }
                        if (wSCredential2 != null) {
                            WSCredentialsHelper.popCallerCredential(wSCredential2);
                            wSCredential2 = null;
                        }
                    }
                    catch (Exception exception2) {
                        if (wSCredential2 == null) break block30;
                        WSCredentialsHelper.popCallerCredential(wSCredential2);
                        wSCredential2 = null;
                    }
                }
                throw new PrivilegedActionException(exception);
            }
        }
        try {
            var6_6 = privilegedExceptionAction.run();
        }
        catch (Exception exception) {
            block31: {
                if (ctxMgr.isServerSecurityEnabled()) {
                    try {
                        if (wSCredential != null) {
                            WSCredentialsHelper.popInvocationCredential(wSCredential);
                            wSCredential = null;
                        }
                        if (wSCredential2 != null) {
                            WSCredentialsHelper.popCallerCredential(wSCredential2);
                            wSCredential2 = null;
                        }
                    }
                    catch (Exception exception3) {
                        if (wSCredential2 == null) break block31;
                        WSCredentialsHelper.popCallerCredential(wSCredential2);
                        wSCredential2 = null;
                    }
                }
            }
            throw new PrivilegedActionException(exception);
        }
        if (ctxMgr.isServerSecurityEnabled()) {
            try {
                WSCredentialsHelper.popInvocationCredential(wSCredential);
                if (wSCredential2 != null) {
                    WSCredentialsHelper.popCallerCredential(wSCredential2);
                    wSCredential2 = null;
                }
            }
            catch (Exception exception) {
                if (wSCredential != null) {
                    WSCredentialsHelper.popInvocationCredential(wSCredential);
                    wSCredential = null;
                }
                if (wSCredential2 != null) {
                    WSCredentialsHelper.popCallerCredential(wSCredential2);
                    wSCredential2 = null;
                }
                throw new PrivilegedActionException(exception);
            }
        }
        return var6_6;
    }

    private static WSCredential retrieveCredential() {
        WSCredential wSCredential = WSCredentialsHelper.getCallerCredential();
        if (wSCredential == null) {
            wSCredential = WSCredentialsHelper.getInvocationCredential();
        }
        return wSCredential;
    }

    private static WSCredential getServerCredential() {
        boolean bl;
        WSCredential wSCredential;
        block6: {
            wSCredential = null;
            bl = false;
            if (ctxMgr != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"WSCredentialsHelper.getServerCredential");
                }
                try {
                    wSCredential = ctxMgr.getServerCredential();
                    if (wSCredential != null) {
                        bl = wSCredential.isCurrent();
                    }
                }
                catch (WSSecurityException wSSecurityException) {
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)("WSCredentialsHelper.getServerCredential threw exception" + wSSecurityException.toString()));
                }
            }
        }
        if (bl && wSCredential != null) {
            return wSCredential;
        }
        return null;
    }

    private static WSCredential getInvocationCredential() {
        String string = "";
        String string2 = "WSCredentialsHelper.getInvocationCredential";
        WSCredential wSCredential = null;
        boolean bl = false;
        if (ctxMgr != null) {
            try {
                wSCredential = ctxMgr.getInvocationCredential();
                if (wSCredential != null) {
                    bl = wSCredential.isCurrent();
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Caught Exception in " + string2));
                }
                Tr.error((TraceComponent)tc, (String)string2, (Object)exception.toString());
                bl = false;
            }
            if (bl && wSCredential != null) {
                return wSCredential;
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ContextManagerImpl null");
        }
        return null;
    }

    private static WSCredential pushInvocationCredential(WSCredential wSCredential) {
        WSCredential wSCredential2;
        block2: {
            String string = "WSCredentialsHelper.pushInvocationCredential";
            wSCredential2 = null;
            try {
                wSCredential2 = ctxMgr.pushInvocationCredential(wSCredential);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Caught Exception in " + string));
                Tr.error((TraceComponent)tc, (String)string, (Object)exception.toString());
            }
        }
        return wSCredential2;
    }

    private static void popInvocationCredential(WSCredential wSCredential) {
        block2: {
            String string = "WSCredentialsHelper.popInvocationCredential";
            try {
                ctxMgr.popInvocationCredential(wSCredential);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Caught Exception in " + string));
                Tr.error((TraceComponent)tc, (String)string, (Object)exception.toString());
            }
        }
    }

    private static WSCredential pushCallerCredential(WSCredential wSCredential) {
        WSCredential wSCredential2;
        block2: {
            String string = "WSCredentialsHelper.pushCallerCredential";
            wSCredential2 = null;
            try {
                wSCredential2 = WSCredentialsHelper.getCallerCredential();
                WSCredential[] wSCredentialArray = new WSCredential[]{wSCredential};
                ctxMgr.setCallerCredentials(wSCredentialArray);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Caught Exception in " + string));
                Tr.error((TraceComponent)tc, (String)string, (Object)exception.toString());
            }
        }
        return wSCredential2;
    }

    private static void popCallerCredential(WSCredential wSCredential) {
        String string = "WSCredentialsHelper.popCallerCredential";
        try {
            WSCredential[] wSCredentialArray = new WSCredential[]{wSCredential};
            ctxMgr.setCallerCredentials(wSCredentialArray);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught Exception in " + string));
            }
            Tr.error((TraceComponent)tc, (String)string, (Object)exception.toString());
        }
    }

    private static WSCredential getCallerCredential() {
        String string = "CredentialsHelper.getCallerCredential";
        WSCredential[] wSCredentialArray = new WSCredential[1];
        boolean bl = false;
        if (ctxMgr != null) {
            try {
                wSCredentialArray = ctxMgr.getCallerCredentials();
                if (wSCredentialArray != null && wSCredentialArray[0] != null) {
                    bl = wSCredentialArray[0].isCurrent();
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Caught Exception in " + string));
                    Tr.error((TraceComponent)tc, (String)string, (Object)exception.toString());
                }
                bl = false;
            }
        }
        if (bl && wSCredentialArray != null && wSCredentialArray[0] != null) {
            return wSCredentialArray[0];
        }
        return null;
    }

    public static WSCredential createRegistryCred(String string, String string2) {
        return WSCredentialsHelper.createRegistryCred(string, string2, new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSCredential createRegistryCred(String string, String string2, ArrayList arrayList) {
        WSCredentialImpl wSCredentialImpl;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"createRegistryCred");
            }
            wSCredentialImpl = null;
            SecurityConfig securityConfig = SecurityConfig.getConfig();
            if (null != securityConfig.getValue("security.use.localos.authorization") && "true" == securityConfig.getValue("security.use.localos.authorization")) {
                String string3 = "";
                String string4 = RegistryUtil.appendRealm("user", string2, string);
                wSCredentialImpl = new WSCredentialImpl(string, string2, string3, string3, string4, new ArrayList(), arrayList);
                if (WSCredentialsHelper.isAZOSDefault(string2)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Userid is a default zOS user.");
                    }
                    wSCredentialImpl.markAsUnauthenticated();
                }
            } else {
                try {
                    if (WSCredentialsHelper.isAZOSDefault(string2)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Created Credential for the Unauthenticated id.");
                        }
                        wSCredentialImpl = (WSCredentialImpl)ctxMgr.getUnauthenticatedCredential();
                        break block18;
                    }
                    Object object = synchVariable;
                    synchronized (object) {
                        if (inInitialization) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"inInitialization == true");
                            }
                            String string5 = "";
                            String string6 = RegistryUtil.appendRealm("user", string2, string);
                            wSCredentialImpl = new WSCredentialImpl((String)SecurityConfig.getConfig().getValue("security.activeUserRegistry.realm"), (String)SecurityConfig.getConfig().getValue("security.serverId"), string5, string5, string6, new ArrayList(), arrayList);
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"inInitialization == false");
                            }
                            inInitialization = true;
                            if (secServer == null) {
                                secServer = SecurityServerFactory.create();
                                currentUserReg = secServer.getRegistry(null);
                            }
                            wSCredentialImpl = currentUserReg.createCredential(string2);
                            inInitialization = false;
                        }
                    }
                }
                catch (Exception exception) {
                    Tr.error((TraceComponent)tc, (String)("UserRegistry failed to create Credential with userName " + string2 + ".  Exception is " + exception.getMessage()));
                    inInitialization = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createRegistryCred");
        }
        return wSCredentialImpl;
    }

    public static WSCredential createTokenCred(WSCredential wSCredential) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createTokenCred");
        }
        WSCredential wSCredential2 = null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getting TokenServer...");
        }
        SecurityConfig securityConfig = SecurityConfig.getConfig();
        String string = (String)securityConfig.getValue("security.activeAuthMechanism");
        if (string == "LTPA") {
            try {
                LTPAServerObject lTPAServerObject = LTPAServerObject.getLTPAServer();
                wSCredential2 = lTPAServerObject.createLTPAToken(wSCredential);
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)("Failed to create a credential token: " + exception.getMessage()));
            }
        } else if (string == "ICSF") {
            try {
                ICSFServerObject iCSFServerObject = ICSFServerObject.getICSFServer();
                wSCredential2 = iCSFServerObject.createICSFToken(wSCredential);
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)("Failed to create a credential token: " + exception.getMessage()));
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"creating wsCred with NULL credToken...");
            }
            wSCredential2 = new WSCredentialImpl(wSCredential, null, (byte[])null, false, -1L);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createTokenCred");
        }
        return wSCredential2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WSCredential createTokenCred(WSCredential wSCredential, String string, byte[] byArray, long l) {
        WSCredentialImpl wSCredentialImpl;
        block12: {
            block13: {
                String string2;
                block11: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)"createTokenCred");
                    }
                    wSCredentialImpl = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"getting TokenServer...");
                    }
                    SecurityConfig securityConfig = SecurityConfig.getConfig();
                    string2 = (String)securityConfig.getValue("security.activeAuthMechanism");
                    if (string2 == "LTPA") break block11;
                    if (string2 == "ICSF") break block11;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"creating wsCred with NULL credToken...");
                    }
                    wSCredentialImpl = new WSCredentialImpl(wSCredential, null, (byte[])null, false, -1L);
                    break block12;
                }
                if (string != null) break block13;
                if (string2 == "LTPA") {
                    try {
                        LTPAServerObject lTPAServerObject = LTPAServerObject.getLTPAServer();
                        wSCredentialImpl = lTPAServerObject.createLTPAToken(wSCredential);
                    }
                    catch (Exception exception) {
                        Tr.error((TraceComponent)tc, (String)("Failed to create a credential token: " + exception.getMessage()));
                    }
                    break block12;
                } else if (string2 == "ICSF") {
                    try {
                        ICSFServerObject iCSFServerObject = ICSFServerObject.getICSFServer();
                        wSCredentialImpl = iCSFServerObject.createICSFToken(wSCredential);
                    }
                    catch (Exception exception) {
                        Tr.error((TraceComponent)tc, (String)("Failed to create a credential token: " + exception.getMessage()));
                    }
                }
                break block12;
            }
            wSCredentialImpl = new WSCredentialImpl(wSCredential, string, byArray, true, l);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createTokenCred");
        }
        return wSCredentialImpl;
    }

    private static boolean isAZOSDefault(String string) {
        block16: {
            block15: {
                block14: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((TraceComponent)tc, (String)("SecurityORBImpl isAZOSDefault for user: " + string));
                    }
                    try {
                        if (securityLocalIdentity != null && securityLocalIdentity.length() != 0 && string.toUpperCase().equals(securityLocalIdentity.toUpperCase())) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Input Userid is equal to security_local_identity " + securityLocalIdentity));
                            }
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug((TraceComponent)tc, (String)"Exception securityLocalIdentity compare failed.");
                        exception.printStackTrace();
                    }
                }
                try {
                    if (securityRemoteIdentity != null && securityRemoteIdentity.length() != 0 && string.toUpperCase().equals(securityRemoteIdentity.toUpperCase())) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Input Userid is equal to security_remote_identity. " + securityRemoteIdentity));
                        }
                        return true;
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block15;
                    Tr.debug((TraceComponent)tc, (String)"Exception securityRemoteIdentity compare failed.");
                    exception.printStackTrace();
                }
            }
            try {
                if (securitySAFUnauthenticated != null && securitySAFUnauthenticated.length() != 0 && string.toUpperCase().equals(securitySAFUnauthenticated.toUpperCase())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Input Userid is equal to com_ibm_security_SAF_unauthenticated. " + securitySAFUnauthenticated));
                    }
                    return true;
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block16;
                Tr.debug((TraceComponent)tc, (String)"Exception securitySAFUnauthenticate compare failed.");
                exception.printStackTrace();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SecurityORBImpl isAZOSDefault retuning false.");
        }
        return false;
    }

    static {
        Properties properties;
        tc = Tr.register((Class)WSCredentialsHelper.class, null, (String)"com.ibm.ejs.resources.security");
        securitySAFUnauthenticated = null;
        securityLocalIdentity = null;
        securityRemoteIdentity = null;
        SecurityConfig securityConfig = SecurityConfig.getConfig();
        securitySAFUnauthenticated = (String)securityConfig.getValue("com.ibm.security.SAF.unauthenticated");
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SecurityORBImpl isAZOSDefault ibm.security.SAF.unauthenticated: " + securitySAFUnauthenticated));
        }
        if (null != (properties = (Properties)SecurityConfig.getConfig().getValue("security.toplevel.properties"))) {
            securityLocalIdentity = (String)properties.get("was.security.local.identity");
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("SecurityORBImpl isAZOSDefault security.local.identity : " + securityLocalIdentity));
            }
            securityRemoteIdentity = (String)properties.get("was.security.remote.identity");
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("SecurityORBImpl isAZOSDefault security.remote.identity : " + securityRemoteIdentity));
            }
        } else {
            Tr.entry((TraceComponent)tc, (String)"SecurityORBImpl: No z/OS default ids found, no toplevel_props found. ");
        }
        ctxMgr = null;
        inInitialization = false;
        synchVariable = new Object();
        secServer = null;
        currentUserReg = null;
        ctxMgr = ContextManagerFactory.getInstance();
    }
}

