/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.UserMapping;
import com.ibm.websphere.security.UserMappingException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import java.security.cert.X509Certificate;
import java.util.Properties;

public class UserMappingImpl
implements UserMapping {
    private static final TraceComponent tc = Tr.register((Class)UserMappingImpl.class, null, (String)"com.ibm.ejs.resources.security");
    private static UserRegistry registry;
    private UserMapping customMapping;
    public static final String MAPPING_USERS_PROPERTY = "WAS_customUserMappingImpl";

    public String mapCertificateToName(X509Certificate[] x509CertificateArray) throws UserMappingException, NotImplementedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapCertificateToName");
        }
        String string = null;
        boolean bl = this.checkCustomMapping();
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using customMapping for certificates");
            }
            try {
                string = this.customMapping.mapCertificateToName(x509CertificateArray);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"mapCertificateToName", (Object)string);
                }
                return string;
            }
            catch (NotImplementedException notImplementedException) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Using defaultMapping for certificate mapping");
        }
        if (registry == null) {
            registry = this.getUserRegistry();
        }
        try {
            string = registry.mapCertificate(x509CertificateArray);
        }
        catch (CertificateMapNotSupportedException certificateMapNotSupportedException) {
            int n;
            String string2;
            int n2;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The user registry does not support mapCertificate. Mapping using first name in the certificate");
            }
            string = (n2 = (string2 = x509CertificateArray[0].getSubjectDN().getName()).indexOf("=")) == -1 ? string2 : ((n = string2.indexOf(",")) == -1 ? string2.substring(n2 + 1) : string2.substring(n2 + 1, n));
        }
        catch (CertificateMapFailedException certificateMapFailedException) {
            FFDCFilter.processException((Throwable)certificateMapFailedException, (String)"com.ibm.UserMappingImpl.mapCertificateToName", (String)"87", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The following exception occurred in UserMappingImpl when calling mapCertificate: ", (Object)new Object[]{certificateMapFailedException});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"mapCertificateToName");
            }
            throw new UserMappingException(certificateMapFailedException.getMessage());
        }
        catch (CustomRegistryException customRegistryException) {
            FFDCFilter.processException((Throwable)customRegistryException, (String)"com.ibm.UserMappingImpl.mapCertificateToName", (String)"92", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The following exception occurred in UserMappingImpl when calling mapCertificate: ", (Object)new Object[]{customRegistryException});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"mapCertificateToName");
            }
            throw new UserMappingException(customRegistryException.getMessage());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.UserMappingImpl.mapCertificateToName", (String)"97", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The following exception occurred in UserMappingImpl when calling mapCertificate: ", (Object)new Object[]{exception});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"mapCertificateToName");
            }
            throw new UserMappingException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapCertificateToName", (Object)string);
        }
        return string;
    }

    public String mapDNToName(String string) throws UserMappingException, NotImplementedException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapDNToName");
        }
        String string2 = null;
        boolean bl = this.checkCustomMapping();
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using customMapping for DN mapping");
            }
            try {
                string2 = this.customMapping.mapDNToName(string);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"mapDNToName", (Object)string2);
                }
                return string2;
            }
            catch (NotImplementedException notImplementedException) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Using defaultMapping for DN mapping");
        }
        if (((String)SecurityConfig.getConfig().getValue("security.activeUserRegistryType")).equals("LDAP")) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"mapDNToName", (Object)string);
            }
            return string;
        }
        int n2 = string.indexOf("=");
        string2 = n2 == -1 ? string : ((n = string.indexOf(",")) == -1 ? string.substring(n2 + 1) : string.substring(n2 + 1, n));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapDNToName", (Object)string2);
        }
        return string2;
    }

    public String mapPrincipalToName(String string) throws UserMappingException, NotImplementedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapPrincipalToName");
        }
        String string2 = null;
        boolean bl = this.checkCustomMapping();
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Using customMapping for Principal mapping");
            }
            try {
                string2 = this.customMapping.mapPrincipalToName(string);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"mapPrincipalToName", (Object)string2);
                }
                return string2;
            }
            catch (NotImplementedException notImplementedException) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Using defaultMapping for Principal mapping");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapPrincipalToName", (Object)string);
        }
        return string;
    }

    private boolean checkCustomMapping() throws UserMappingException {
        Properties properties;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkCustomMapping");
        }
        if ((string = (String)(properties = (Properties)SecurityConfig.getConfig().getValue("security.toplevel.properties")).get(MAPPING_USERS_PROPERTY)) != null && string.trim().length() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Using custom mapping for certificates: " + string));
            }
            try {
                Class<?> clazz = Class.forName(string);
                Object obj = clazz.newInstance();
                this.customMapping = (UserMapping)obj;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Custom user mapping: " + string + " successfully loaded"));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkCustomMapping", (Object)"true");
                }
                return true;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.security.core.UserMappingImpl.mapCertificateToName", (String)"126", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The following exception occurred in UserMappingImpl when loading the custom implementation: ", (Object)new Object[]{throwable});
                }
                throw new UserMappingException(throwable.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkCustomMapping", (Object)"false");
        }
        return false;
    }

    private UserRegistry getUserRegistry() throws UserMappingException {
        ContextManager contextManager;
        Object var2_1 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"UserMapping:getUserRegistry");
        }
        if ((contextManager = ContextManagerFactory.getInstance()) != null) {
            try {
                registry = contextManager.getRegistry(contextManager.getDefaultRealm());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.UserMappingImpl.getUserRegistry", (String)"142");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to get registry from ContextManager");
                }
                Tr.error((TraceComponent)tc, (String)"security.sambean.urerr", (Object)new Object[]{exception});
                throw new UserMappingException(exception.getMessage());
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Failed to get ContextManager");
            }
            Tr.error((TraceComponent)tc, (String)"security.sambean.nullsecserver");
            throw new UserMappingException("Unable to get ContextManager");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"UserMapping:getUserRegistry");
        }
        return registry;
    }
}

