/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.SecurityMessages;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.List;

public class SecurityManager
extends java.lang.SecurityManager {
    public static ContextManager ctxMgr = ContextManagerFactory.getInstance();
    private static final String lineSep = System.getProperty("line.separator");
    private static final TraceComponent _tc = Tr.register((Class)SecurityManager.class, null, (String)"com.ibm.ejs.resources.security");
    private boolean grantAll = false;
    private ExtClassLoader runtimeClassLoader;
    private PermissionCollection filteredPermissions;
    private boolean enableRuntimeFiltering = false;
    private boolean filteredPermissionsEmpty = true;
    private boolean initialized = false;
    private Thread _mainthread;
    private boolean _norethrow = false;
    private boolean _nolog = false;
    private boolean _notracktrace = false;
    private static final String GETCLASSLOADER = "getClassLoader";
    private PrivilegedAction isRuntimeThreadAction = new PrivilegedAction(){

        public Object run() {
            Boolean bl = Boolean.FALSE;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                bl = new Boolean(classLoader.equals(SecurityManager.this.runtimeClassLoader));
            }
            return bl;
        }
    };
    private static final RuntimePermission MODIFYTHREAD_PERM = new RuntimePermission("modifyThread");
    private static final RuntimePermission MODIFYTHREADGROUP_PERM = new RuntimePermission("modifyThreadGroup");

    public SecurityManager() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"SecurityManager()");
        }
        this.init(null);
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"SecurityManager()");
        }
    }

    SecurityManager(String string, ExtClassLoader extClassLoader, List list, boolean bl) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("SecurityManager(" + string + ", " + extClassLoader + ", " + list + ", " + bl + ")"));
        }
        this.init(string);
        this.enableRuntimeFiltering = bl;
        if (this.enableRuntimeFiltering) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"enableRuntimeFiltering = TRUE");
            }
            this.runtimeClassLoader = extClassLoader;
            this.filteredPermissions = new Permissions();
            this.filteredPermissionsEmpty = list.isEmpty();
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("filteredPermissionsEmpty = " + this.filteredPermissionsEmpty));
            }
            if (!this.filteredPermissionsEmpty) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    this.filteredPermissions.add((Permission)list.get(i));
                }
            }
            this.filteredPermissions.setReadOnly();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"SecurityManager()");
        }
    }

    private boolean isRuntimeThread(Permission permission) {
        boolean bl = false;
        if (this._mainthread != Thread.currentThread()) {
            if (!permission.getName().equals(GETCLASSLOADER)) {
                bl = (Boolean)AccessController.doPrivileged((PrivilegedAction)this.isRuntimeThreadAction);
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public void checkPermission(Permission permission) {
        block14: {
            if (this.enableRuntimeFiltering && !this.filteredPermissionsEmpty && !this.isRuntimeThread(permission) && this.filteredPermissions.implies(permission)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("access denied due to runtime permission filtering on " + permission));
                }
                if (!this._norethrow) {
                    throw new AccessControlException("access denied due to runtime permission filtering on " + permission, permission);
                }
            }
            if (!this.grantAll) {
                try {
                    super.checkPermission(permission);
                }
                catch (SecurityException securityException) {
                    Object object;
                    String string = null;
                    String[] stringArray = null;
                    if (this._notracktrace) {
                        string = "Stack trace disabled";
                        stringArray = new String[]{"", ""};
                    } else {
                        object = new StringWriter();
                        securityException.printStackTrace(new PrintWriter((Writer)object));
                        string = ((StringWriter)object).toString();
                        try {
                            stringArray = this.getCodeBaseLoc(permission);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.ws.security.core.SecurityManager", (String)"92", (Object)this);
                            StringWriter stringWriter = new StringWriter();
                            exception.printStackTrace(new PrintWriter(stringWriter));
                            String string2 = stringWriter.toString();
                            Tr.error((TraceComponent)_tc, (String)"security.jsecman.exception.codebase", (Object)new Object[]{exception.toString() + "(" + exception.getMessage() + ")" + lineSep + lineSep + string2});
                        }
                    }
                    object = SecurityMessages.getMsg((String)"security.jsecman.permdeniedmsg", (Object[])new Object[]{lineSep + lineSep, lineSep + lineSep + "      " + permission.getName() + " : " + securityException.getMessage() + lineSep + lineSep + lineSep, stringArray[0], lineSep + lineSep, lineSep + lineSep + string + lineSep + lineSep, lineSep + lineSep + stringArray[1]});
                    String string3 = "\n CAUGHT Java Security EXCEPTION in zOS..... \n perm.getName<>: " + permission.getName() + "\n e.getMessage<>: " + securityException.getMessage() + "\nBegin SecurityException\n" + string + "\n" + "Code base location information:\n" + stringArray + "\n class ==> : " + stringArray[0] + "\nEnd SecurityException\n";
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)string3);
                    }
                    FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.ws.security.core.SecurityManager", (String)"180", (Object)this, (Object[])new Object[]{object});
                    if (!this._nolog) {
                        if (!ctxMgr.getPlatformHelper().isZOS()) {
                            Tr.warning((TraceComponent)_tc, (String)"security.jsecman.permdeniedmsg", (Object)new Object[]{lineSep + lineSep, lineSep + lineSep + "      " + permission.getName() + " : " + securityException.getMessage() + lineSep + lineSep + lineSep, stringArray[0], lineSep + lineSep, lineSep + lineSep + string + lineSep + lineSep, lineSep + lineSep + stringArray[1]});
                        } else {
                            Tr.warning((TraceComponent)_tc, (String)"security.zOS.SecurityManager.PermissionFailure1.warning", (Object)new Object[]{lineSep + lineSep, lineSep + lineSep + "      " + permission.getName() + " : " + securityException.getMessage() + lineSep + lineSep + lineSep, stringArray[0], lineSep + lineSep + stringArray[1]});
                            Tr.warning((TraceComponent)_tc, (String)"security.zOS.SecurityManager.PermissionFailure2.warning", (Object)new Object[]{"\nBegin SecurityException\n" + string + "\nEnd SecurityException\n"});
                        }
                    }
                    if (this._norethrow) break block14;
                    throw securityException;
                }
            }
        }
    }

    public void checkAccess(Thread thread) {
        if (thread == null) {
            throw new NullPointerException("thread can't be null!");
        }
        this.checkPermission(MODIFYTHREAD_PERM);
    }

    public void checkAccess(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            throw new NullPointerException("thread group can't be null!");
        }
        this.checkPermission(MODIFYTHREADGROUP_PERM);
    }

    public boolean checkTopLevelWindow(Object object) {
        return false;
    }

    private void init(String string) {
        if (!this.initialized) {
            this._mainthread = Thread.currentThread();
            PermissionCollection permissionCollection = Policy.getPolicy().getPermissions(new CodeSource(null, null));
            this.grantAll = permissionCollection.implies(new AllPermission());
            this._norethrow = Boolean.getBoolean("com.ibm.websphere.java2secman.norethrow");
            this._nolog = Boolean.getBoolean("com.ibm.websphere.java2secman.nolog");
            if (_tc.isDebugEnabled()) {
                if (this.grantAll) {
                    Tr.debug((TraceComponent)_tc, (String)"grantAll is TRUE");
                } else {
                    Tr.debug((TraceComponent)_tc, (String)"grantAll is FALSE");
                }
                if (this._norethrow) {
                    Tr.debug((TraceComponent)_tc, (String)"Running with NoRethrow debug");
                } else {
                    Tr.debug((TraceComponent)_tc, (String)"Running without NoRethrow debug");
                }
            }
            this._notracktrace = Boolean.getBoolean("com.ibm.websphere.java2secman.nostacktrace");
            if (this._norethrow) {
                Tr.warning((TraceComponent)_tc, (String)"security.jsecman.debugnorethrow");
            }
        }
    }

    private String[] getCodeBaseLoc(Permission permission) {
        final Permission permission2 = permission;
        return (String[])AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                Class[] classArray = SecurityManager.this.getClassContext();
                StringBuffer stringBuffer = new StringBuffer(classArray.length * 100);
                stringBuffer.append(lineSep);
                String[] stringArray = new String[2];
                for (int i = 0; i < classArray.length; ++i) {
                    Object object;
                    Class clazz = classArray[i];
                    ProtectionDomain protectionDomain = clazz.getProtectionDomain();
                    if (classArray[i].getName().indexOf("com.ibm.ws.security.core.SecurityManager") != -1) {
                        for (int j = i + 1; j < classArray.length; ++j) {
                            object = classArray[j].getProtectionDomain();
                            if (classArray[j].getName().startsWith("java") || classArray[j].getName().indexOf("com.ibm.ws.security.core.SecurityManager") != -1 || classArray[j].getName().indexOf("ClassLoader") != -1 || j != classArray.length - 1 && classArray[j + 1].getName().indexOf("ClassLoader") != -1 || !SecurityManager.this.lackedReqPerm(((ProtectionDomain)object).getPermissions(), permission2)) continue;
                            if (object != null) {
                                stringArray[0] = new String(lineSep + lineSep + "     " + classArray[j].getName() + "  in  " + "{" + SecurityManager.this.getCodeSource((ProtectionDomain)object) + "}" + lineSep + lineSep);
                                break;
                            }
                            stringArray[0] = new String(lineSep + lineSep + "      " + classArray[j].getName() + " at {unknown location}" + lineSep + lineSep);
                            break;
                        }
                    }
                    if (protectionDomain != null) {
                        CodeSource codeSource = protectionDomain.getCodeSource();
                        object = SecurityManager.this.getCodeSource(protectionDomain);
                        stringBuffer.append(classArray[i].getName()).append(" : ").append((String)object + lineSep);
                        stringBuffer.append("  ").append(SecurityManager.this.permissionToString(codeSource, clazz.getClassLoader(), protectionDomain.getPermissions())).append(lineSep);
                        continue;
                    }
                    stringBuffer.append(classArray[i].getName()).append(" : ").append("Unknown location" + lineSep);
                }
                stringArray[1] = new String(stringBuffer.toString());
                return stringArray;
            }
        });
    }

    private String getCodeSource(ProtectionDomain protectionDomain) {
        URL uRL;
        CodeSource codeSource = protectionDomain.getCodeSource();
        String string = null;
        string = codeSource == null ? "null code source" : ((uRL = codeSource.getLocation()) == null ? "null code URL" : uRL.toString());
        return string;
    }

    private String permissionToString(CodeSource codeSource, ClassLoader classLoader, PermissionCollection permissionCollection) {
        StringBuffer stringBuffer = new StringBuffer("ClassLoader: ");
        if (classLoader == null) {
            stringBuffer.append("Primordial Classloader");
        } else {
            stringBuffer.append(classLoader.getClass().getName());
        }
        stringBuffer.append(lineSep);
        stringBuffer.append("  Permissions granted to CodeSource ").append(codeSource).append(lineSep);
        if (permissionCollection != null) {
            Enumeration<Permission> enumeration = permissionCollection.elements();
            stringBuffer.append("  {").append(lineSep);
            while (enumeration.hasMoreElements()) {
                Permission permission = enumeration.nextElement();
                stringBuffer.append("    ").append(permission.toString()).append(";").append(lineSep);
            }
            stringBuffer.append("  }");
        } else {
            stringBuffer.append("  {").append(lineSep).append("  }");
        }
        return stringBuffer.toString();
    }

    private boolean lackedReqPerm(PermissionCollection permissionCollection, Permission permission) {
        boolean bl = true;
        if (permissionCollection != null) {
            bl = !permissionCollection.implies(permission);
        }
        return bl;
    }
}

