/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.SSLConfiguration;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.j2ee.commonarchivecore.helpers.ArchiveOptions;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.dynamicproxy.InvocationHandler;
import com.ibm.websphere.management.dynamicproxy.StateObject;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.ipc.ssl.CryptoHardwareToken;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.jaaslogin.JAASAuthData;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.DistributedMapFactory;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.authorize.AppInstallNotify;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SASConfig;
import com.ibm.ws.security.core.SSLConfigValidation;
import com.ibm.ws.security.core.SecurityAdminHelper;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.registry.UserRegistryImpl;
import com.ibm.ws.security.registry.ldap.LdapRegistryImpl;
import com.ibm.ws.security.server.LTPAConfigException;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.security.util.AuthData;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.ssl.JSSEProvider;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class SecurityAdmin
implements InvocationHandler {
    private static final String LOGIN_CONFIG_CLASS = "com.ibm.ws.security.auth.login.Configuration";
    private static List cachedDefaultCiphers = null;
    private static final WebSphereRuntimePermission GET_SSO_TOKEN_PERM = new WebSphereRuntimePermission("getSingleSignonToken");
    private static final String[] CIPHER_SUITES_LIST = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_FIPS_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_RC4_128_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"};
    private static final String[] FIPS_CIPHER_SUITES_LIST = new String[]{"SSL_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA"};
    private static final TraceComponent tc = Tr.register((Class)SecurityAdmin.class, null, (String)"com.ibm.ejs.resources.security");
    private LTPAServerObject _ltpaServer = null;
    private UserRegistry _registry = null;
    private boolean initialized = false;
    static /* synthetic */ Class class$com$ibm$wsspi$security$token$SingleSignonToken;

    public SecurityAdmin() throws Exception {
        this.initialize();
    }

    public synchronized void initialize() throws Exception {
        Boolean bl;
        if (this.initialized) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize ");
        }
        if ((bl = (Boolean)SecurityConfig.getConfig().getValue("security.enabled")).booleanValue()) {
            ContextManager contextManager;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Security is enabled, therefore initializing references to user registry and ltpa server.");
            }
            if ((contextManager = ContextManagerFactory.getInstance()) != null) {
                try {
                    this._registry = contextManager.getRegistry(contextManager.getDefaultRealm());
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.initialize", (String)"70", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"security.sambean.urerr", (Object)new Object[]{exception});
                    throw exception;
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"security.sambean.nullsecserver");
                throw new Exception("Unable to get ContextManager");
            }
            try {
                this._ltpaServer = LTPAServerObject.getLTPAServer();
            }
            catch (LTPAConfigException lTPAConfigException) {
                FFDCFilter.processException((Throwable)lTPAConfigException, (String)"com.ibm.ws.security.core.SecurityAdmin.initialize", (String)"89", (Object)this);
                Tr.debug((TraceComponent)tc, (String)"Error initializing LTPA server object.");
            }
            if (tc.isDebugEnabled()) {
                if (this._ltpaServer == null) {
                    Tr.debug((TraceComponent)tc, (String)"ltpa server not initialized.");
                } else {
                    Tr.debug((TraceComponent)tc, (String)"ltpa server initialized.");
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Security is not enabled, therefore not initializing references to user registry and ltpa server.");
        }
        this.initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void purgeUserFromAuthCache(String string, String string2) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"purgeUserFromAuthCache");
            }
            AuthCache authCache = AuthCache.getInstance();
            try {
                authCache.removeEntry(string, string2);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.purgeUserFromCache", (String)"124", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Exception purging user" + string2 + " from cache."));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"purgeUserFromAuthCache");
        }
    }

    public void clearAuthCache() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"clearAuthCache");
            }
            AuthCache authCache = AuthCache.getInstance();
            try {
                authCache.removeAllEntries();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.purgeUserFromCache", (String)"146", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Exception clearing auth cache.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clearAuthCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLdapBindInfo(String object, String string) {
        block68: {
            block67: {
                Object object2;
                ConfigServiceProxy configServiceProxy;
                block66: {
                    if (!WSSecurityHelper.isGlobalSecurityEnabled()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Global security is not enabled.");
                        }
                        return;
                    }
                    configServiceProxy = null;
                    try {
                        object2 = AdminServiceFactory.getAdminService().getDeploymentManagerAdminClient();
                        configServiceProxy = new ConfigServiceProxy((AdminClient)object2);
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block66;
                        Tr.debug((TraceComponent)tc, (String)"Unable to get ConfigService from deployment manager");
                    }
                }
                if (configServiceProxy == null) {
                    configServiceProxy = ConfigServiceFactory.getConfigService();
                }
                if (configServiceProxy == null) {
                    try {
                        object2 = new Properties();
                        ((Properties)object2).setProperty("location", "local");
                        configServiceProxy = ConfigServiceFactory.createConfigService((boolean)true, (Properties)object2);
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Unable to create ConfigService. ", (Object)exception);
                        }
                        return;
                    }
                }
                if (configServiceProxy == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"There is no configservice available.");
                    }
                    Tr.audit((TraceComponent)tc, (String)"security.registry.ldap.update.audit");
                    return;
                }
                object2 = null;
                try {
                    Object object3;
                    Integer n;
                    Object object4;
                    String string2;
                    object2 = new Session();
                    ObjectName objectName = ConfigServiceHelper.createObjectName(null, (String)"Security");
                    ObjectName objectName2 = null;
                    ObjectName objectName3 = configServiceProxy.resolve((Session)object2, "Cell=")[0];
                    if (objectName3 != null) {
                        objectName2 = configServiceProxy.queryConfigObjects((Session)object2, objectName3, objectName, null)[0];
                    }
                    if (objectName2 == null) {
                        objectName2 = configServiceProxy.queryConfigObjects((Session)object2, null, objectName, null)[0];
                    }
                    ObjectName objectName4 = (ObjectName)configServiceProxy.getAttribute((Session)object2, objectName2, "activeUserRegistry");
                    boolean bl = false;
                    try {
                        string2 = ConfigServiceHelper.getConfigDataType((ObjectName)objectName4);
                        if (string2 != null && string2.equalsIgnoreCase("LDAPUserRegistry")) {
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    string2 = null;
                    try {
                        string2 = (String)configServiceProxy.getAttribute((Session)object2, objectName4, "serverId");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!bl) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"The active registry is not LDAP, no update is performed.");
                        }
                        return;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"This is LDAP user registry.");
                    }
                    ArrayList arrayList = (ArrayList)configServiceProxy.getAttribute((Session)object2, objectName4, "hosts");
                    String string3 = "";
                    String string4 = "ldap://";
                    if (arrayList != null) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            object4 = (AttributeList)arrayList.get(i);
                            String string5 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)object4, (String)"host");
                            n = (Integer)ConfigServiceHelper.getAttributeValue((AttributeList)object4, (String)"port");
                            object3 = new StringBuffer();
                            if (string5.startsWith(string4)) {
                                string5 = string5.substring(string4.length());
                            }
                            if (SecurityConfig.isIPv6Addr(string5)) {
                                string5 = SecurityConfig.formatIPv6Addr(string5);
                            }
                            ((StringBuffer)object3).append(string4).append(string5);
                            if (n != null && n > 0) {
                                ((StringBuffer)object3).append(":" + n);
                            }
                            if (object3 == null || ((StringBuffer)object3).length() <= 0) continue;
                            if (string3 == "") {
                                string3 = ((StringBuffer)object3).toString();
                                continue;
                            }
                            if (string3.indexOf(((StringBuffer)object3).toString()) != -1) continue;
                            string3 = string3 + " " + ((StringBuffer)object3).toString();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("LDAP hosts are " + string3));
                        }
                    }
                    String string6 = (String)configServiceProxy.getAttribute((Session)object2, objectName4, "bindPassword");
                    object4 = (String)configServiceProxy.getAttribute((Session)object2, objectName4, "bindDN");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("New bind DN is " + (String)object4));
                    }
                    boolean bl2 = true;
                    if (string == null || object == null || string.length() == 0 || ((String)object).length() == 0) {
                        object = object4;
                        string = string6;
                        bl2 = false;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Bind info input  is incompleted, use bind info from security.xml.");
                        }
                    }
                    n = SecurityServerImpl.getRegistryImpl(ContextManagerFactory.getInstance().getDefaultRealm());
                    if (string != null && object != null && string.length() != 0 && ((String)object).length() != 0) {
                        try {
                            object = object3 = n.checkPassword((String)object, string);
                        }
                        catch (Exception exception) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Bind info is incorrect with Bind DN of " + (String)object));
                            }
                            Tr.audit((TraceComponent)tc, (String)"security.registry.ldap.update.audit");
                            try {
                                configServiceProxy.discard((Session)object2);
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            return;
                        }
                    }
                    object = null;
                    string = null;
                    LdapRegistryImpl.refreshRegistry((String)object, string, string3);
                    try {
                        if (string2 == null || string2 == "") {
                            string2 = "123";
                        }
                        n.getUsers(string2, 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if ((string6 == null && string == null || string6.equals(string)) && (object4 == null && object == null || ((String)object4).equals(object))) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Bind info is not changed in security.xml since last update.");
                        }
                        bl2 = false;
                    }
                    if (bl2) {
                        object3 = new AttributeList();
                        ((AttributeList)object3).add(new Attribute("bindDN", object));
                        ((AttributeList)object3).add(new Attribute("bindPassword", string));
                        configServiceProxy.setAttributes((Session)object2, objectName4, (AttributeList)object3);
                        configServiceProxy.save((Session)object2, false);
                        try {
                            configServiceProxy.discard((Session)object2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        String string7 = AdminServiceFactory.getAdminService().getProcessType();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Process Type is " + string7));
                        }
                        if (string7.equals("DeploymentManager")) {
                            // empty if block
                        }
                        ObjectName objectName5 = new ObjectName("WebSphere:type=NodeSync,*");
                        Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName5, null).iterator();
                        while (iterator.hasNext()) {
                            ObjectName objectName6 = (ObjectName)iterator.next();
                            AdminServiceFactory.getAdminService().invoke(objectName6, "sync", new Object[0], new String[0]);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"security.xml Sync completed.");
                        }
                        break block67;
                    }
                    try {
                        configServiceProxy.discard((Session)object2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                catch (Exception exception) {
                    break block68;
                }
                finally {
                    try {
                        configServiceProxy.discard((Session)object2);
                    }
                    catch (Exception exception) {}
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void updateAuthDataCfg(HashMap var1_1) {
        block21: {
            if (SecurityAdmin.tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)SecurityAdmin.tc, (String)"updateAuthDataCfg ", (Object)new Object[]{var1_1});
            }
            if (var1_1 != null) {
                WSDefaultPrincipalMapping.refreshAuthData((HashMap)var1_1);
            } else {
                var2_2 = null;
                try {
                    block20: {
                        var3_3 = "" + System.currentTimeMillis();
                        var2_2 = WorkSpaceManagerFactory.getManager().getWorkSpace(var3_3);
                        var4_5 = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("cells");
                        var5_6 = URI.createURI((String)"security.xml");
                        var6_7 = var2_2.findContext(var4_5);
                        var7_8 = null;
                        var8_9 = var6_7.iterator();
                        if (var8_9.hasNext()) {
                            var9_10 = (RepositoryContext)var8_9.next();
                            var10_11 = var9_10.getResourceSet().createResource(var5_6);
                            var11_12 = new HashMap();
                            var10_11.load(var11_12);
                            var7_8 = (Security)var10_11.getContents().get(0);
                        }
                        if (var7_8 == null) break block20;
                        var9_10 = new HashMap<K, V>();
                        var10_11 = var7_8.getAuthDataEntries().iterator();
                        while (var10_11.hasNext()) {
                            var11_12 = (JAASAuthData)var10_11.next();
                            if (var11_12 == null) continue;
                            var9_10.put(var11_12.getAlias(), new AuthData(var11_12.getUserId(), var11_12.getPassword()));
                            if (!SecurityAdmin.tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)SecurityAdmin.tc, (String)("AuthData - add " + var11_12.getAlias()));
                        }
                        WSDefaultPrincipalMapping.refreshAuthData((HashMap)var9_10);
                    }
                    var13_13 = null;
                    ** if (var2_2 == null) goto lbl-1000
                }
                catch (Throwable var12_22) {
                    block22: {
                        var13_15 = null;
                        if (var2_2 != null) {
                            try {
                                var14_20 = var2_2.getUserName();
                                WorkSpaceManagerFactory.getManager().removeWorkSpace(var14_20);
                            }
                            catch (WorkSpaceException var14_21) {
                                if (!SecurityAdmin.tc.isDebugEnabled()) break block22;
                                Tr.debug((TraceComponent)SecurityAdmin.tc, (String)"Exception removing WorkSpace.");
                            }
                        }
                    }
                    throw var12_22;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var14_16 = var2_2.getUserName();
                        WorkSpaceManagerFactory.getManager().removeWorkSpace(var14_16);
                    }
                    catch (WorkSpaceException var14_17) {
                        if (SecurityAdmin.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)SecurityAdmin.tc, (String)"Exception removing WorkSpace.");
                        }
                    }
                }
lbl-1000:
                // 4 sources

                {
                    break block21;
                    catch (Exception var3_4) {
                        if (SecurityAdmin.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)SecurityAdmin.tc, (String)"Exception refreshing J2C AuthData.");
                        }
                        var13_14 = null;
                        if (var2_2 != null) {
                            try {
                                var14_18 = var2_2.getUserName();
                                WorkSpaceManagerFactory.getManager().removeWorkSpace(var14_18);
                            }
                            catch (WorkSpaceException var14_19) {
                                if (SecurityAdmin.tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)SecurityAdmin.tc, (String)"Exception removing WorkSpace.");
                                }
                            }
                        }
                    }
                }
            }
        }
        if (SecurityAdmin.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)SecurityAdmin.tc, (String)"updateAuthDataCfg ");
        }
    }

    public void updateJAASCfg(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateJAASCfg ");
        }
        Configuration configuration = com.ibm.ws.security.auth.login.Configuration.getConfiguration();
        String string2 = configuration.getClass().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The Login Configuration class is: " + string2));
        }
        if (configuration instanceof com.ibm.ws.security.auth.login.Configuration) {
            try {
                com.ibm.ws.security.auth.login.Configuration configuration2 = (com.ibm.ws.security.auth.login.Configuration)configuration;
                configuration2.updateWCCMAppConfig(string);
                configuration2.refresh();
                if (tc.isDebugEnabled()) {
                    String string3 = configuration2.toString();
                    Tr.debug((TraceComponent)tc, (String)("The dynamic JAAS login configuration is:\n" + string3));
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.updateJAASCfg", (String)"97", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.init.wccmjaas.error", (Object)new Object[]{exception});
            }
        } else {
            Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.enabled");
            if (bl != null && bl.booleanValue()) {
                Tr.error((TraceComponent)tc, (String)"security.init.wccmjaas.wrongclasserror", (Object)new Object[]{string2, LOGIN_CONFIG_CLASS});
                throw new RuntimeException("JAAS Login provider class com.ibm.ws.security.auth.login.Configuration is not configured as login provider class");
            }
            Tr.warning((TraceComponent)tc, (String)"security.init.wccmjaas.wrongclasswarning", (Object)new Object[]{string2, LOGIN_CONFIG_CLASS});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateJAASCfg ");
        }
    }

    public String getJAASCfg() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getJAASCfg ");
        }
        String string = null;
        Configuration configuration = com.ibm.ws.security.auth.login.Configuration.getConfiguration();
        String string2 = configuration.getClass().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The Login Configuration class is: " + string2));
        }
        if (configuration instanceof com.ibm.ws.security.auth.login.Configuration) {
            try {
                com.ibm.ws.security.auth.login.Configuration configuration2 = (com.ibm.ws.security.auth.login.Configuration)configuration;
                string = configuration2.toString();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.getJAASCfg", (String)"147", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.init.wccmjaas.error", (Object)new Object[]{exception});
            }
        } else {
            Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.enabled");
            if (bl != null && bl.booleanValue()) {
                Tr.error((TraceComponent)tc, (String)"security.init.wccmjaas.wrongclasserror", (Object)new Object[]{string2, LOGIN_CONFIG_CLASS});
                throw new RuntimeException("JAAS Login provider class com.ibm.ws.security.auth.login.Configuration is not configured as login provider class");
            }
            Tr.warning((TraceComponent)tc, (String)"security.init.wccmjaas.wrongclasswarning", (Object)new Object[]{string2, LOGIN_CONFIG_CLASS});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getJAASCfg ");
        }
        return string;
    }

    public Result getUsers(String string, Integer n, Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUsers ", (Object)(string + " " + n));
        }
        int n2 = n;
        Result result = null;
        UserRegistry userRegistry = this.getRegistry(properties);
        if (userRegistry != null) {
            try {
                result = userRegistry.getUsers(string, n2);
            }
            catch (CustomRegistryException customRegistryException) {
                FFDCFilter.processException((Throwable)customRegistryException, (String)"com.ibm.ws.security.core.SecurityAdmin.getUsers", (String)"193", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.sambean.getusrerr", (Object)new Object[]{string, new Integer(n2), customRegistryException});
                throw customRegistryException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.getUsers", (String)"198", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.sambean.getusrerr", (Object)new Object[]{string, new Integer(n2), exception});
                throw exception;
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"security.sa.no.registry");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUsers ");
        }
        return result;
    }

    public Result getGroups(String string, Integer n, Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGroups ", (Object)(string + " " + n));
        }
        int n2 = n;
        Result result = null;
        UserRegistry userRegistry = this.getRegistry(properties);
        if (userRegistry != null) {
            try {
                result = userRegistry.getGroups(string, n2);
            }
            catch (CustomRegistryException customRegistryException) {
                FFDCFilter.processException((Throwable)customRegistryException, (String)"com.ibm.ws.security.core.SecurityAdmin.getGroups", (String)"225", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.sambean.getgrperr", (Object)new Object[]{string, new Integer(n2), customRegistryException});
                throw customRegistryException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.getGroups", (String)"230", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.sambean.getgrperr", (Object)new Object[]{string, new Integer(n2), exception});
                throw exception;
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"security.sa.no.registry");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGroups ");
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Boolean checkRunAsUser(List list, List list2, String string, Properties properties) throws Exception {
        Boolean bl;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkRunAsUser", (Object)string);
        }
        if (SecurityConfig.isJACCEnabled()) {
            if (!tc.isDebugEnabled()) return Boolean.TRUE;
            Tr.debug((TraceComponent)tc, (String)"No runAsRole to role checking when JACC is enabled");
            return Boolean.TRUE;
        }
        boolean bl2 = false;
        UserRegistry userRegistry = null;
        if (string == null || string.trim().length() <= 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"RunAs username is null");
            }
            bl2 = true;
        } else if (list.contains(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("user " + string + " is in the user list"));
            }
            bl2 = true;
        } else {
            userRegistry = this.getRegistry(properties);
            Result result = null;
            object = null;
            if (userRegistry != null) {
                result = userRegistry.getUsers(string, 1);
                if (result != null) {
                    object = (String)result.getList().get(0);
                }
                if (list != null && object != null && ((String)object).length() > 0 && list.contains(object)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("user " + string + " is in the list"));
                    }
                    bl2 = true;
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"security.sa.no.registry");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cannot determine if user " + string + " is in the list since registry is null. Returing false"));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"checkRunAsUser");
                }
            }
        }
        if (!bl2 && userRegistry != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("user " + string + " is not in the user list. Checking in the group list"));
            }
            boolean bl3 = false;
            object = (Boolean)SecurityConfig.getConfig().getValue("security.registry.IgnoreCase");
            if (object != null && ((Boolean)object).booleanValue()) {
                bl3 = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ignoreCase is set");
                }
            }
            List list3 = userRegistry.getGroupsForUser(string);
            if (list2 != null && list3 != null) {
                block0: for (int i = 0; i < list2.size() && !bl2; ++i) {
                    if (bl3) {
                    } else {
                        if (!list3.contains(list2.get(i))) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("user " + string + " is in the group list"));
                        }
                        bl2 = true;
                        continue;
                    }
                    for (int j = 0; j < list3.size(); ++j) {
                        String string2;
                        String string3 = (String)list3.get(j);
                        if (!string3.equalsIgnoreCase(string2 = (String)list2.get(i))) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("user " + string + " is in the group list"));
                        }
                        bl2 = true;
                        continue block0;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkRunAsUser", (Object)(bl2 ? Boolean.TRUE : Boolean.FALSE));
        }
        if (bl2) {
            bl = Boolean.TRUE;
            return bl;
        }
        bl = Boolean.FALSE;
        return bl;
    }

    public String getAccessIds(boolean bl, String string, Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAccessIds", (Object)string);
        }
        String string2 = null;
        UserRegistry userRegistry = this.getRegistry(properties);
        if (userRegistry != null) {
            string2 = bl ? userRegistry.getUniqueUserId(string) : userRegistry.getUniqueGroupId(string);
        } else {
            Tr.error((TraceComponent)tc, (String)"security.sa.no.registry");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"registry is null. Returing null accessId");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAccessIds");
        }
        return string2;
    }

    public String getRealm(Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRealm ");
        }
        UserRegistry userRegistry = this.getRegistry(properties);
        String string = null;
        if (userRegistry != null) {
            try {
                string = userRegistry.getRealm();
            }
            catch (CustomRegistryException customRegistryException) {
                FFDCFilter.processException((Throwable)customRegistryException, (String)"com.ibm.ws.security.core.SecurityAdmin.getRealm", (String)"273", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.sa.get.realm", (Object)new Object[]{customRegistryException});
                throw customRegistryException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.getRealm", (String)"278", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.sa.get.realm", (Object)new Object[]{exception});
                throw exception;
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"security.sa.no.registry");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRealm ", (Object)string);
        }
        return string;
    }

    public void generateKeys(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"generateKeys ");
        }
        LTPAServerObject lTPAServerObject = this.getLtpaServer();
        try {
            if (lTPAServerObject != null) {
                lTPAServerObject.generateKeys(string.getBytes("UTF8"));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.generateKeys", (String)"253", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.ErrorCreatingLTPAKeys", (Object)new Object[]{exception});
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"generateKeys ");
        }
    }

    public Properties genKeys(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"genKeys ");
        }
        LTPAServerObject lTPAServerObject = this.getLtpaServer();
        Properties properties = null;
        try {
            if (lTPAServerObject != null) {
                properties = lTPAServerObject.genKeys(string.getBytes("UTF8"));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.generateKeys", (String)"253", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.ErrorCreatingLTPAKeys", (Object)new Object[]{exception});
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"genKeys ");
        }
        return properties;
    }

    public void exportKeys(String string, Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("exportKeys filename:" + string));
        }
        LTPAServerObject lTPAServerObject = this.getLtpaServer(properties);
        Properties properties2 = null;
        try {
            if (lTPAServerObject != null) {
                properties2 = lTPAServerObject.exportSSOProperties();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.exportKeys", (String)"273", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.sambean.expltpakeys", (Object)new Object[]{exception});
            throw exception;
        }
        try {
            this.setProps(properties2, string);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.core.SecurityAdmin.exportKeys", (String)"283", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.sa.set.props", (Object)new Object[]{string, iOException});
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"exportKeys ");
        }
    }

    public void importKeys(String string, byte[] byArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("importKeys " + string));
        }
        Properties properties = new Properties();
        try {
            properties = this.getProps(string);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.core.SecurityAdmin.importKeys", (String)"302", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.sa.set.props", (Object)new Object[]{string, iOException});
            throw iOException;
        }
        try {
            LTPAServerObject lTPAServerObject = this.getLtpaServer(properties);
            lTPAServerObject.importSSOProperties(properties, byArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.importKeys", (String)"312", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.sambean.impltpakeys", (Object)new Object[]{properties, exception});
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"importKeys ");
        }
    }

    public void getApplicationRoles(String string) {
    }

    public void getEjbModuleRoles(String string, String string2) {
    }

    public void getWebModuleRoles(String string, String string2) {
    }

    public void importLTPAKeys(Properties properties, byte[] byArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"importLTPAKeys");
        }
        try {
            LTPAServerObject lTPAServerObject = this.getLtpaServer(properties);
            if (null != lTPAServerObject) {
                lTPAServerObject.importSSOProperties(properties, byArray);
            }
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.sambean.impltpakeys", (Object)new Object[]{properties, exception});
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.importLTPAKeys", (String)"348", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"importLTPAKeys", (Object)exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"importLTPAKeys");
        }
    }

    public void checkImportLTPAKeys(Properties properties, byte[] byArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkImportLTPAKeys");
        }
        try {
            LTPAServerObject lTPAServerObject = this.getLtpaServer(properties);
            if (null != lTPAServerObject) {
                lTPAServerObject.checkImportSSOProperties(properties, byArray);
            }
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.sambean.impltpakeys", (Object)new Object[]{properties, exception});
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.checkImportLTPAKeys", (String)"348", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"checkImportLTPAKeys", (Object)exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkImportLTPAKeys");
        }
    }

    public Properties exportLTPAKeys() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"exportLTPAKeys");
        }
        try {
            Properties properties = null;
            LTPAServerObject lTPAServerObject = this.getLtpaServer();
            if (lTPAServerObject != null) {
                properties = lTPAServerObject.exportSSOProperties();
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ltpaServer is null! not good.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("exportLTPAKeys: " + (properties != null ? properties.toString() : "null props")));
            }
            return properties;
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.sambean.expltpakeys", (Object)new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.exportLTPAKeys", (String)"368", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"exportLTPAKeys", (Object)exception);
            }
            throw exception;
        }
    }

    /*
     * Unable to fully structure code
     */
    public Boolean checkPassword(String var1_1, String var2_2, Properties var3_3) throws Exception {
        if (SecurityAdmin.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)SecurityAdmin.tc, (String)"checkPassword");
        }
        var4_4 = false;
        var5_5 = this.getRegistry(var3_3);
        if (var5_5 != null) {
            try {
                var6_6 = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism.OID");
                if (ContextManagerFactory.getInstance().isCellSecurityEnabled() && var6_6 != null && "oid:1.2.840.113554.1.2.2".endsWith(var6_6)) {
                    var7_10 = (String)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.krb.kerberos_realm");
                    if (var7_10 != null && !var7_10.equals("") && var1_1.indexOf(64) == -1) {
                        var1_1 = var1_1 + "@" + var7_10;
                    }
                    if ((var8_12 = ContextManagerFactory.getInstance().login(ContextManagerFactory.getInstance().getDefaultRealm(), var1_1, var2_2)) == null) ** GOTO lbl35
                    if (SecurityAdmin.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)SecurityAdmin.tc, (String)"password is ok");
                    }
                    var4_4 = true;
                }
                var7_11 = var5_5.checkPassword(var1_1, var2_2);
                var4_4 = true;
            }
            catch (PasswordCheckFailedException var6_7) {
                FFDCFilter.processException((Throwable)var6_7, (String)"com.ibm.ws.security.core.SecurityAdmin.checkPassword", (String)"392", (Object)this);
                Tr.error((TraceComponent)SecurityAdmin.tc, (String)"security.sa.chk.password", (Object)new Object[]{var1_1, var6_7});
                throw var6_7;
            }
            catch (CustomRegistryException var6_8) {
                FFDCFilter.processException((Throwable)var6_8, (String)"com.ibm.ws.security.core.SecurityAdmin.checkPassword", (String)"397", (Object)this);
                Tr.error((TraceComponent)SecurityAdmin.tc, (String)"security.sa.chk.password.custom", (Object)new Object[]{var1_1, var6_8});
                throw var6_8;
            }
            catch (Exception var6_9) {
                FFDCFilter.processException((Throwable)var6_9, (String)"com.ibm.ws.security.core.SecurityAdmin.checkPassword", (String)"402", (Object)this);
                Tr.error((TraceComponent)SecurityAdmin.tc, (String)"security.sa.chk.password.custom", (Object)new Object[]{var1_1, var6_9});
                throw var6_9;
            }
        } else {
            if (SecurityAdmin.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)SecurityAdmin.tc, (String)"registry is null: checkPassword failed");
            }
            Tr.error((TraceComponent)SecurityAdmin.tc, (String)"security.sa.no.registry");
        }
lbl35:
        // 4 sources

        if (SecurityAdmin.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)SecurityAdmin.tc, (String)"checkPassword", (Object)(var4_4 != false ? Boolean.TRUE : Boolean.FALSE));
        }
        return var4_4 != false ? Boolean.TRUE : Boolean.FALSE;
    }

    public Integer checkTokenLibFile(String string, String string2, String string3, String string4, String string5, String string6) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkTokenLibFile");
        }
        int n = SSLConfigValidation.checkTokenLibFile(string, string2, string3, string4, string5, string6);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkTokenLibFile", (Object)("status=" + n));
        }
        return new Integer(n);
    }

    public Integer checkKeyFile(String string, String string2, String string3, String string4, String string5) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkKeyFile");
        }
        int n = SSLConfigValidation.checkKeyFile(string, string2, string3, string4, string5);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkKeyFile", (Object)("status=" + n));
        }
        return new Integer(n);
    }

    public Integer checkTrustFile(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkTrustFile");
        }
        int n = SSLConfigValidation.checkTrustFile(string, string2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkTrustFile", (Object)("status=" + n));
        }
        return new Integer(n);
    }

    public TokenHolder getOpaqueToken(ByteArray byteArray) {
        TokenHolder tokenHolder;
        byte[] byArray;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getOpaqueToken");
            }
            byArray = null;
            tokenHolder = null;
            if (AdminHelper.getPlatformHelper().isZOS()) {
                block14: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Extract stoken of input ssoToken's originating servant.");
                    }
                    Token token = null;
                    try {
                        token = ContextManagerFactory.getInstance().getWSCredTokenMapper().validateLTPAToken(byteArray.getArray());
                        String[] stringArray = token.getAttributes("com.ibm.websphere.zOS.ServantIdentifier");
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("retrieved servantID" + stringArray[0]));
                        }
                        tokenHolder = SecurityAdminHelper.getOpaqueToken(byteArray, stringArray[0]);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)("getOpaqueToken returns token." + tokenHolder));
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.getOpaqueToken", (String)"795", (Object)this);
                        if (!tc.isEntryEnabled()) break block14;
                        Tr.exit((TraceComponent)tc, (String)"Exception occurred extracting stoken of input ssoToken's originating servant.", (Object)new Object[]{exception});
                    }
                }
                return tokenHolder;
            }
            try {
                DistributedMap distributedMap = DistributedMapFactory.getMap("WSSecureMap");
                if (distributedMap != null) {
                    byArray = (byte[])distributedMap.get((Object)byteArray);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.getOpaqueToken", (String)"798", (Object)this);
                if (!tc.isEntryEnabled()) break block15;
                Tr.exit((TraceComponent)tc, (String)"Exception occurred getting opaque token from distributed map.", (Object)new Object[]{exception});
            }
        }
        if (byArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getOpaqueToken returns null.");
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getOpaqueToken returns opaque token.");
            }
            tokenHolder = new TokenHolder(byArray, "WS_OPAQUE", 1);
        }
        return tokenHolder;
    }

    public TokenHolder getInitialContextToken(ByteArray byteArray, String string) {
        TokenHolder tokenHolder;
        byte[] byArray;
        block31: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("getInitialContextToken, targetServer: " + string));
            }
            byArray = null;
            GSSCredential gSSCredential = null;
            tokenHolder = null;
            GSSContext gSSContext = null;
            GSSManager gSSManager = GSSManager.getInstance();
            try {
                DistributedMap distributedMap = DistributedMapFactory.getMap("WSSecureMapNotShared");
                if (distributedMap != null) {
                    gSSCredential = (GSSCredential)distributedMap.get((Object)byteArray);
                } else {
                    Tr.error((TraceComponent)tc, (String)"dm is null");
                }
                if (gSSCredential != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"gssCred is not null ");
                    }
                    String string2 = "host@" + string;
                    Oid oid = null;
                    if (oid == null) {
                        try {
                            oid = new Oid("1.2.840.113554.1.2.2");
                        }
                        catch (GSSException gSSException) {
                            Object[] objectArray = new Object[]{Oid.class, "Oid(\"1.2.840.113554.1.2.2\")", gSSException};
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Exception getting OID: " + gSSException.getMessage()));
                            }
                            throw gSSException;
                        }
                    }
                    GSSName gSSName = null;
                    try {
                        gSSName = gSSManager.createName(string2, GSSName.NT_HOSTBASED_SERVICE, oid);
                    }
                    catch (GSSException gSSException) {
                        Object[] objectArray = new Object[]{gSSManager, "createName()", gSSException};
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Exception calling createName: " + gSSException.getMessage()));
                        }
                        throw gSSException;
                    }
                    Tr.debug((TraceComponent)tc, (String)("ServerName" + gSSName));
                    try {
                        gSSContext = gSSManager.createContext(gSSName, oid, gSSCredential, 0);
                    }
                    catch (GSSException gSSException) {
                        Object[] objectArray = new Object[]{gSSManager, "createContext()", gSSException};
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Exception calling createContext: " + gSSException.getMessage()));
                        }
                        throw gSSException;
                    }
                    try {
                        gSSContext.requestCredDeleg(true);
                    }
                    catch (GSSException gSSException) {
                        Object[] objectArray = new Object[]{gSSContext, "requestCredDeleg(true)", gSSException};
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Exception calling requestCredDeleg: " + gSSException.getMessage()));
                        }
                        throw gSSException;
                    }
                    byte[] byArray2 = null;
                    int n = 0;
                    try {
                        byArray = gSSContext.initSecContext(byArray2, 0, n);
                        Tr.debug((TraceComponent)tc, (String)("Token = " + byArray.length + byArray));
                    }
                    catch (GSSException gSSException) {
                        Object[] objectArray = new Object[]{gSSContext, "initSecContext()", gSSException};
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Exception calling initSecContext: " + gSSException.getMessage()));
                        }
                        throw gSSException;
                    }
                    if (gSSContext.isEstablished()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"initSecContext: clientContext established successfully.");
                        }
                    } else {
                        Object[] objectArray = new Object[]{gSSContext, string2};
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"initSecContext: clientContext not established.");
                        }
                    }
                    break block31;
                }
                Tr.error((TraceComponent)tc, (String)"gssCred was null");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.getOpaqueToken", (String)"1108", (Object)this);
                if (!tc.isEntryEnabled()) break block31;
                Tr.exit((TraceComponent)tc, (String)"Exception occurred getting opaque token from distributed map.", (Object)new Object[]{exception});
            }
        }
        if (byArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getInitialContextToken returns null.");
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getInitialContextToken returns opaque token.");
            }
            tokenHolder = new TokenHolder(byArray, "INIT_CONTEXT_TOKEN", 1);
        }
        return tokenHolder;
    }

    public TokenHolder[] getSingleSignonTokens() {
        Serializable serializable;
        TokenHolder tokenHolder;
        SingleSignonToken[] singleSignonTokenArray;
        block13: {
            Exception exception;
            SecurityManager securityManager;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getSingleSignonTokens");
            }
            if ((securityManager = System.getSecurityManager()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                    Tr.debug((TraceComponent)tc, (String)("Expecting: " + GET_SSO_TOKEN_PERM));
                }
                securityManager.checkPermission((Permission)GET_SSO_TOKEN_PERM);
            }
            singleSignonTokenArray = null;
            tokenHolder = null;
            try {
                serializable = ContextManagerFactory.getInstance().getCallerSubject();
                exception = SubjectHelper.getWSCredentialFromSubject((Subject)serializable);
                if (serializable != null && exception != null && !exception.isUnauthenticated() && !exception.isBasicAuth()) {
                    singleSignonTokenArray = (SingleSignonToken[])com.ibm.ws.security.util.AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((Subject)serializable){
                        private final /* synthetic */ Subject val$subject;
                        {
                            this.val$subject = subject;
                        }

                        public Object run() throws Exception {
                            HashSet hashSet = new HashSet();
                            Set set = this.val$subject.getPrivateCredentials(class$com$ibm$wsspi$security$token$SingleSignonToken == null ? (class$com$ibm$wsspi$security$token$SingleSignonToken = SecurityAdmin.class$("com.ibm.wsspi.security.token.SingleSignonToken")) : class$com$ibm$wsspi$security$token$SingleSignonToken);
                            Set set2 = this.val$subject.getPublicCredentials(class$com$ibm$wsspi$security$token$SingleSignonToken == null ? (class$com$ibm$wsspi$security$token$SingleSignonToken = SecurityAdmin.class$("com.ibm.wsspi.security.token.SingleSignonToken")) : class$com$ibm$wsspi$security$token$SingleSignonToken);
                            if (set != null) {
                                hashSet.addAll(set);
                            }
                            if (set2 != null) {
                                hashSet.addAll(set2);
                            }
                            return hashSet.toArray(new SingleSignonToken[0]);
                        }
                    });
                    tokenHolder = new TokenHolder(exception.getCredentialToken(), "LtpaToken", -1);
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                exception = privilegedActionException.getException();
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.getSingleSignonTokens", (String)"1541", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unexpected exception getting token list", (Object)exception);
                }
            }
            catch (Exception exception2) {
                FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.security.core.SecurityAdmin.getSingleSignonTokens", (String)"1546", (Object)this);
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception getting token list", (Object)exception2);
            }
        }
        serializable = new HashSet();
        for (int i = 0; singleSignonTokenArray != null && i < singleSignonTokenArray.length; ++i) {
            try {
                serializable.add(new TokenHolder(singleSignonTokenArray[i].getBytes(), singleSignonTokenArray[i].getName(), (int)singleSignonTokenArray[i].getVersion()));
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.getSingleSignonTokens", (String)"1562", (Object)this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception building TokenHolder list", (Object)exception);
            }
        }
        if ((SecurityConfig.getConfig().getValue("com.ibm.ws.security.ssoInteropModeEnabled").equals("true") || SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundPropagationEnabled").equals("false") || serializable.size() == 0) && tokenHolder != null) {
            serializable.add(tokenHolder);
        }
        TokenHolder[] tokenHolderArray = serializable.toArray(new TokenHolder[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSingleSignonTokens", (Object)tokenHolderArray);
        }
        return tokenHolderArray;
    }

    private UserRegistry getRegistry(Properties properties) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (tc.isEntryEnabled()) {
            object4 = SecurityConfig.maskPasswords(properties);
            Tr.entry((TraceComponent)tc, (String)("getRegistry " + object4));
        }
        object4 = this._registry;
        if (properties == null && object4 != null) {
            return object4;
        }
        if (properties == null && object4 == null) {
            object3 = (Properties)SecurityConfig.getConfig().getValue("security.activeUserRegistry.props");
            properties = SecurityConfig.expandProps((Properties)object3);
            object2 = (Properties)SecurityConfig.getConfig().getValue("security.registry.ldap.props");
            if (object2 != null) {
                Properties properties2;
                Enumeration<Object> enumeration = ((Properties)object2).keys();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    properties.put(object, ((Properties)object2).get(object));
                }
                object = (Boolean)SecurityConfig.getConfig().getValue("security.registry.ldap.SSLEnabled");
                properties.put("sslEnabled", object);
                if (((Boolean)object).booleanValue() && (properties2 = (Properties)SecurityConfig.getConfig().getValue("security.registry.ldap.SSLConfig")) != null) {
                    properties.put("sslConfig", properties2);
                }
                properties.put("CustUserRegImplClass", "com.ibm.ws.security.registry.ldap.LdapRegistryImpl");
            }
        }
        try {
            Properties properties3 = null;
            if (properties != null) {
                properties3 = new Properties();
                object3 = properties.keys();
                while (object3.hasMoreElements()) {
                    object2 = (String)object3.nextElement();
                    properties3.put(object2, properties.get(object2));
                }
            }
            if (properties3 != null && (object3 = (Boolean)properties3.get("sslEnabled")) != null && ((Boolean)object3).booleanValue()) {
                block17: {
                    object2 = null;
                    try {
                        object2 = (Properties)properties3.get("sslConfig");
                    }
                    catch (ClassCastException classCastException) {
                        object = (SecureSocketLayer)properties3.get("sslConfig");
                        if (object == null) break block17;
                        object2 = this.createPropertiesFromSecureSocketLayer((SecureSocketLayer)object);
                    }
                }
                SecurityConfig.expandProps((Properties)object2);
                properties3.put("sslConfig", object2);
            }
            object3 = new UserRegistryImpl();
            object2 = SecurityConfig.expandProps(properties3);
            ((UserRegistryImpl)((Object)object3)).initialize((Properties)object2);
            object4 = object3;
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.ws.security.core.SecurityAdmin.getRegistry", (String)"452", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.createerror", (Object)new Object[]{remoteException});
            throw remoteException;
        }
        catch (CustomRegistryException customRegistryException) {
            FFDCFilter.processException((Throwable)customRegistryException, (String)"com.ibm.ws.security.core.SecurityAdmin.getRegistry", (String)"457", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.createerror", (Object)new Object[]{customRegistryException});
            throw customRegistryException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityAdmin.getRegistry", (String)"462", (Object)this);
            Tr.error((TraceComponent)tc, (String)"security.registry.createerror", (Object)new Object[]{exception});
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRegistry ");
        }
        if (this._registry == null) {
            this._registry = object4;
        }
        return object4;
    }

    private Properties createPropertiesFromSecureSocketLayer(SecureSocketLayer secureSocketLayer) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Converting SSL config to properties.");
        }
        Properties properties = new Properties();
        properties.put("com.ibm.ssl.keyManager", JSSEProviderFactory.getKeyManagerFactoryAlgorithm());
        properties.put("com.ibm.ssl.trustManager", JSSEProviderFactory.getTrustManagerFactoryAlgorithm());
        properties.put("com.ibm.ssl.protocol", "SSL");
        if (secureSocketLayer.getKeyFileName() != null) {
            properties.put("com.ibm.ssl.keyStore", secureSocketLayer.getKeyFileName());
        }
        if (secureSocketLayer.getTrustFileName() != null) {
            properties.put("com.ibm.ssl.trustStore", secureSocketLayer.getTrustFileName());
        }
        if (secureSocketLayer.getTrustFilePassword() != null) {
            properties.put("com.ibm.ssl.trustStorePassword", secureSocketLayer.getTrustFilePassword());
        }
        if (secureSocketLayer.getKeyFilePassword() != null) {
            properties.put("com.ibm.ssl.keyStorePassword", secureSocketLayer.getKeyFilePassword());
        }
        if (secureSocketLayer.getKeyFileFormat() != null) {
            properties.put("com.ibm.ssl.keyStoreType", SASConfig.getKeyStoreType(secureSocketLayer.getKeyFileFormat()));
        }
        if (secureSocketLayer.getTrustFileFormat() != null) {
            properties.put("com.ibm.ssl.trustStoreType", SASConfig.getKeyStoreType(secureSocketLayer.getTrustFileFormat()));
        }
        properties.put("com.ibm.ssl.clientAuthentication", Boolean.toString(secureSocketLayer.isClientAuthentication()));
        properties.put("com.ibm.ssl.securityLevel", SASConfig.getSecurityLevel(secureSocketLayer.getSecurityLevel()));
        for (int i = 0; i < secureSocketLayer.getProperties().size(); ++i) {
            Property property = (Property)secureSocketLayer.getProperties().get(i);
            if (property == null) continue;
            properties.put(property.getName(), property.getValue());
        }
        if (secureSocketLayer.isEnableCryptoHardwareSupport()) {
            CryptoHardwareToken cryptoHardwareToken = secureSocketLayer.getCryptoHardware();
            properties.put("com.ibm.ssl.tokenType", cryptoHardwareToken.getTokenType());
            properties.put("com.ibm.ssl.tokenLibraryFile", cryptoHardwareToken.getLibraryFile());
            properties.put("com.ibm.ssl.tokenPassword", cryptoHardwareToken.getPassword());
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProps(String string) throws IOException {
        URL uRL;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getProps ");
            }
            String string2 = string;
            uRL = null;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.security.core.SecurityAdmin.getProps", (String)"495", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.sa.set.props", (Object)new Object[]{string2, malformedURLException});
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"Malformed url", (Object)string2);
            }
        }
        Properties properties = new Properties();
        InputStream inputStream = uRL.openStream();
        try {
            properties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getProps ");
        }
        return properties;
    }

    private void setProps(Properties properties, String string) throws IOException {
        URL uRL;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"setProps ");
            }
            String string2 = string;
            uRL = null;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.security.core.SecurityAdmin.setProps", (String)"526", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.sa.set.props", (Object)new Object[]{string2, malformedURLException});
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"Malformed url", (Object)string2);
            }
        }
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(uRL.getFile());
        properties.save(fileOutputStream, "SSOProperties");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setProps ");
        }
    }

    private LTPAServerObject getLtpaServer(Properties properties) throws Exception {
        return this.getLtpaServer();
    }

    private LTPAServerObject getLtpaServer() throws Exception {
        if (this._ltpaServer == null) {
            this._ltpaServer = new LTPAServerObject();
            if (this._ltpaServer == null) {
                Tr.error((TraceComponent)tc, (String)"security.sambean.noltpaserver");
                throw new Exception("Error creating LTPAServerObject.");
            }
        }
        return this._ltpaServer;
    }

    public void preInvoke(String string, Object[] objectArray, String[] stringArray, StateObject stateObject, int n) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"preInvoke()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"preInvoke");
        }
    }

    public void postInvoke(String string, Object[] objectArray, String[] stringArray, StateObject stateObject, int n, Throwable throwable, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"postInvoke");
        }
        if (string.equals("purgeUserFromAuthCache")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"purgeUserFromAuthCache()");
            }
            this.purgeUserFromAuthCache((String)objectArray[0], (String)objectArray[1]);
        } else if (string.equals("clearAuthCache")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"clearAuthCache()");
            }
            this.clearAuthCache();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"postInvoke()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void propagatePolicyToJACCProvider(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"propagatePolicyToJACCProvider");
        }
        WorkSpace workSpace = null;
        EARFile eARFile = null;
        Resource resource = null;
        try {
            String string2 = "" + System.currentTimeMillis();
            workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(string2);
            RepositoryContextType repositoryContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("deployments");
            Collection collection = workSpace.findContext(repositoryContextType);
            Iterator iterator = collection.iterator();
            URI uRI = URI.createURI((String)"deployment.xml");
            while (iterator.hasNext()) {
                block11: {
                    Object var21_20;
                    Object object;
                    RepositoryContext repositoryContext = (RepositoryContext)iterator.next();
                    String string3 = repositoryContext.getName();
                    boolean bl = false;
                    if (string != null) {
                        object = new StringTokenizer(string, ":");
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            if (!string3.equals(((StringTokenizer)object).nextToken())) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("appName to be propagated is: " + string3));
                            }
                            bl = true;
                        }
                    }
                    if (string != null && !bl) continue;
                    object = repositoryContext.getPath();
                    repositoryContext.extract(false);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("appName is: " + string3 + ", dirName is " + (String)object));
                    }
                    try {
                        CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
                        ArchiveOptions archiveOptions = new ArchiveOptions();
                        archiveOptions.setUseJavaReflection(false);
                        archiveOptions.setIsReadOnly(true);
                        resource = repositoryContext.getResourceSet().createResource(uRI);
                        HashMap hashMap = new HashMap();
                        resource.load(hashMap);
                        Deployment deployment = (Deployment)resource.getContents().get(0);
                        ApplicationDeployment applicationDeployment = (ApplicationDeployment)deployment.getDeployedObject();
                        String string4 = applicationDeployment.getAppContextIDForSecurity();
                        eARFile = commonarchiveFactory.openEARFile(archiveOptions, (String)object);
                        AppInstallNotify.getInstance().appInstall(eARFile, string3, string4, false);
                        var21_20 = null;
                        if (eARFile == null) break block11;
                    }
                    catch (Throwable throwable) {
                        var21_20 = null;
                        if (eARFile != null) {
                            eARFile.close();
                        }
                        if (resource == null) throw throwable;
                        resource.unload();
                        resource = null;
                        throw throwable;
                    }
                    eARFile.close();
                }
                if (resource == null) continue;
                resource.unload();
                resource = null;
                {
                }
            }
            Object var23_22 = null;
            if (workSpace == null) return;
        }
        catch (Throwable throwable) {
            Object var23_23 = null;
            if (workSpace == null) throw throwable;
            String string5 = workSpace.getUserName();
            WorkSpaceManagerFactory.getManager().removeWorkSpace(string5);
            throw throwable;
        }
        String string6 = workSpace.getUserName();
        WorkSpaceManagerFactory.getManager().removeWorkSpace(string6);
    }

    public static List getSecureSocketLayerCipherList(Boolean bl) {
        boolean bl2;
        ArrayList<String> arrayList;
        String[] stringArray;
        block12: {
            KeyManagerFactory keyManagerFactory = null;
            TrustManagerFactory trustManagerFactory = null;
            SSLContext sSLContext = null;
            KeyStore keyStore = null;
            KeyStore keyStore2 = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = "CipherList";
            SecurityConfiguration securityConfiguration = null;
            JSSEProvider jSSEProvider = null;
            stringArray = null;
            arrayList = new ArrayList<String>();
            bl2 = JSSEProviderFactory.isFipsEnabled();
            if (bl2 == bl) {
                SSLConfiguration sSLConfiguration;
                if (cachedDefaultCiphers != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("getSecureSocketLayerCipherList returning cached Ciphers: " + cachedDefaultCiphers));
                    }
                    return cachedDefaultCiphers;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getSecureSocketLayerCipherList cachedDefaultCiphers is null, proceed to determine the provider.");
                }
                if ((securityConfiguration = VaultImpl.getSecurityConfiguration()) != null && securityConfiguration.processIsServer() && (sSLConfiguration = securityConfiguration.getCSIInboundSSLConfig()) != null) {
                    string = sSLConfiguration.getSSLTrustStoreType();
                    string2 = sSLConfiguration.getSSLKeyStoreType();
                    string4 = sSLConfiguration.getSSLKeyFile();
                    string3 = sSLConfiguration.getSSLKeyPassword();
                    string5 = sSLConfiguration.getSSLProtocol();
                    jSSEProvider = JSSEProviderFactory.getInstance((String)sSLConfiguration.getSSLContextProvider());
                    try {
                        keyStore = jSSEProvider.getKeyStoreInstance(string);
                        trustManagerFactory = jSSEProvider.getTrustManagerFactoryInstance();
                        trustManagerFactory.init(keyStore);
                        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
                        keyStore2 = jSSEProvider.getKeyStoreInstance(string2);
                        InputStream inputStream = SecurityAdmin.openKeyStore(string4);
                        keyStore2.load(inputStream, string3.toCharArray());
                        keyManagerFactory = jSSEProvider.getKeyManagerFactoryInstance();
                        keyManagerFactory.init(keyStore2, string3.toCharArray());
                        KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
                        sSLContext = jSSEProvider.getSSLContextInstance(string5);
                        sSLContext.init(keyManagerArray, trustManagerArray, null);
                        if (sSLContext != null) {
                            stringArray = sSLContext.getServerSocketFactory().getDefaultCipherSuites();
                        }
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.debug((TraceComponent)tc, (String)("Exception getting SSL context: " + exception.getMessage()));
                    }
                }
            }
        }
        if (stringArray == null) {
            stringArray = bl != false ? FIPS_CIPHER_SUITES_LIST : CIPHER_SUITES_LIST;
        }
        arrayList = new ArrayList(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("SSL_RSA_WITH_NULL_MD5") || stringArray[i].equals("SSL_RSA_WITH_NULL_SHA") || stringArray[i].equals("SSL_DH_anon_WITH_AES_128_CBC_SHA") || stringArray[i].equals("SSL_DH_anon_WITH_RC4_128_MD5") || stringArray[i].equals("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA") || stringArray[i].equals("SSL_DH_anon_WITH_DES_CBC_SHA") || stringArray[i].equals("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5") || stringArray[i].equals("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA") || stringArray.equals("SSL_DH_anon_WITH_AES_256_CBC_SHA")) continue;
            arrayList.add(stringArray[i]);
        }
        if (arrayList != null && bl == bl2) {
            cachedDefaultCiphers = arrayList;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSecureSocketLayerCipherList = " + arrayList));
        }
        return arrayList;
    }

    protected static InputStream openKeyStore(String string) throws MalformedURLException, IOException {
        try {
            OpenKeyStoreAction openKeyStoreAction = new OpenKeyStoreAction(string);
            return (InputStream)AccessController.doPrivileged(openKeyStoreAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception opening keystore.", (Object)new Object[]{exception});
            }
            if (exception instanceof MalformedURLException) {
                throw (MalformedURLException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception.getMessage());
        }
    }

    static class OpenKeyStoreAction
    implements PrivilegedExceptionAction {
        private String file = null;

        public OpenKeyStoreAction(String string) {
            this.file = string;
        }

        public Object run() throws MalformedURLException, IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"OpenKeyStoreAction.run");
            }
            InputStream inputStream = null;
            URL uRL = null;
            File file = new File(this.file);
            if (file.exists() && file.length() == 0L) {
                throw new IOException("Keystore file exists, but is empty: " + this.file);
            }
            uRL = !file.exists() ? new URL(this.file) : new URL("file:" + file.getCanonicalPath());
            inputStream = uRL.openStream();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"OpenKeyStoreAction.run");
            }
            return inputStream;
        }
    }
}

