/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.orbssl.WSPKCSInKeyStore;
import com.ibm.ws.security.orbssl.WSPKCSInKeyStoreList;
import com.ibm.ws.security.orbssl.WSSSLClientSocketFactoryImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.Security;
import java.util.ArrayList;

public final class SSLConfigValidation {
    static WSPKCSInKeyStoreList pkStoreL = WSSSLClientSocketFactoryImpl.getPKCSkeyStoreList();
    static WSPKCSInKeyStore wspkStore = null;
    private static final TraceComponent tc = Tr.register((Class)SSLConfigValidation.class, null, (String)"com.ibm.ejs.resources.security");

    public static int checkTokenLibFile(String string, String string2, String string3, String string4, String string5, String string6) {
        int n;
        block12: {
            File file;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"checkTokenLibFile");
            }
            String string7 = PasswordUtil.passwordDecode((String)string4);
            String string8 = SSLConfigValidation.resolveInstallRoot(string2);
            n = 0;
            String string9 = string3;
            if (string9 == null || string9.equals("")) {
                string9 = "0";
            }
            if ((file = new File(string8)) == null || !file.isFile() || !file.canRead()) {
                n = 1;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"tokenLib file not found.");
                }
            }
            if (n == 0) {
                try {
                    wspkStore = pkStoreL.insert(string, string8 + ":" + string9, string7, true);
                }
                catch (Exception exception) {
                    n = 2;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SSLConfigValidation.checkTokenLibFile", (String)"98");
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug((TraceComponent)tc, (String)"invalid password.");
                }
            }
        }
        if (n == 0 && string5 != null && !string5.equals("") && !SSLConfigValidation.findTokenAlias(string5)) {
            n = 3;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"invalid serverAlias.");
            }
        }
        if (n == 0 && string6 != null && !string6.equals("") && !SSLConfigValidation.findTokenAlias(string6)) {
            n = 4;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"invalid clientAlias.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkTokenLibFile");
        }
        return n;
    }

    public static int checkKeyFile(String string, String string2, String string3, String string4, String string5) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkKeyFile");
        }
        String string6 = PasswordUtil.passwordDecode((String)string3);
        String string7 = SSLConfigValidation.resolveInstallRoot(string2);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"keyFilename: ", (Object)string7);
        }
        int n = 0;
        boolean bl = true;
        int n2 = 0;
        KeyStore keyStore = null;
        ArrayList<Object> arrayList = new ArrayList();
        while (bl) {
            try {
                keyStore = KeyStore.getInstance(string);
            }
            catch (Exception exception) {
                n = 2;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SSLConfigValidation.checkKeyFile", (String)"176");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"invalid fileType.");
                }
                bl = false;
            }
            if (n != 0) continue;
            try {
                keyStore.load(SSLConfigValidation.openKeyStore(string7), string6 == null ? null : string6.toCharArray());
                bl = false;
            }
            catch (Exception exception) {
                if (exception.getMessage().equalsIgnoreCase("Invalid keystore format") || exception.getMessage().indexOf("DerInputStream.getLength()") != -1) {
                    if (n2 == 0) {
                        Tr.warning((TraceComponent)tc, (String)"security.ssl.config.initialization.warning.invalidkeystoretype");
                        arrayList = new ArrayList<String>(Security.getAlgorithms("KeyStore"));
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Valid keyStore list: " + arrayList.toString()));
                        }
                    }
                    if (n2 >= arrayList.size()) {
                        n = 3;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SSLConfigValidation.checkKeyFile", (String)"206");
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"checkKeyFile", (Object)exception);
                        }
                        bl = false;
                    }
                    string = (String)arrayList.get(n2++);
                    continue;
                }
                n = 3;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SSLConfigValidation.checkKeyFile", (String)"219");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"checkKeyFile", (Object)exception);
                }
                bl = false;
            }
        }
        if (n == 0 && string4 != null && !string4.equals("")) {
            boolean bl2 = false;
            try {
                bl2 = keyStore.containsAlias(string4);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SSLConfigValidation.checkKeyFile", (String)"242");
            }
            if (!bl2) {
                n = 4;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"invalid serverAlias.");
                }
            }
        }
        if (n == 0 && string5 != null && !string5.equals("")) {
            boolean bl3 = false;
            try {
                bl3 = keyStore.containsAlias(string5);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SSLConfigValidation.checkKeyFile", (String)"266");
            }
            if (!bl3) {
                n = 5;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"invalid clientAlias.");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkKeyFile");
        }
        return n;
    }

    public static int checkTrustFile(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkTrustFile");
        }
        String string4 = PasswordUtil.passwordDecode((String)string3);
        String string5 = SSLConfigValidation.resolveInstallRoot(string2);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"trustFilename: ", (Object)string5);
        }
        int n = 0;
        boolean bl = true;
        int n2 = 0;
        KeyStore keyStore = null;
        ArrayList<Object> arrayList = new ArrayList();
        while (bl) {
            try {
                keyStore = KeyStore.getInstance(string);
            }
            catch (Exception exception) {
                n = 2;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SSLConfigValidation.checkTrustFile", (String)"320");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"invalid fileType.");
                }
                bl = false;
            }
            if (n != 0) continue;
            try {
                keyStore.load(SSLConfigValidation.openKeyStore(string5), string4 == null ? null : string4.toCharArray());
                bl = false;
            }
            catch (Exception exception) {
                if (exception.getMessage().equalsIgnoreCase("Invalid keystore format") || exception.getMessage().indexOf("DerInputStream.getLength()") != -1) {
                    if (n2 == 0) {
                        Tr.warning((TraceComponent)tc, (String)"security.ssl.config.initialization.warning.invalidkeystoretype");
                        arrayList = new ArrayList<String>(Security.getAlgorithms("KeyStore"));
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Valid keyStore list: " + arrayList.toString()));
                        }
                    }
                    if (n2 >= arrayList.size()) {
                        n = 3;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SSLConfigValidation.checkTrustFile", (String)"351");
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"checkTrustFile", (Object)exception);
                        }
                        bl = false;
                    }
                    string = (String)arrayList.get(n2++);
                    continue;
                }
                n = 3;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SSLConfigValidation.checkTrustFile", (String)"364");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"checkTrustFile", (Object)exception);
                }
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkTrustFile");
        }
        return n;
    }

    private static InputStream openKeyStore(String string) throws MalformedURLException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"openKeyStore", (Object)new Object[]{string});
        }
        InputStream inputStream = null;
        URL uRL = null;
        File file = new File(string);
        if (file.exists() && file.length() == 0L) {
            throw new IOException("Keystore file exists, but is empty: " + string);
        }
        uRL = !file.exists() ? new URL(string) : new URL("file:" + file.getCanonicalPath());
        inputStream = uRL.openStream();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"openKeyStore");
        }
        return inputStream;
    }

    private static String resolveInstallRoot(String string) {
        String string2 = string;
        String string3 = "${USER_INSTALL_ROOT}";
        int n = string3.length();
        int n2 = string.indexOf(string3);
        if (n2 != -1) {
            String string4 = (String)SecurityConfig.getConfig().getValue(string3);
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.replace(n2, n2 + n, string4);
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private static boolean findTokenAlias(String string) {
        KeyStore keyStore = wspkStore.getKS();
        boolean bl = false;
        try {
            bl = keyStore.containsAlias(string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SSLConfigValidation.findTokenAlias", (String)"446");
        }
        return bl;
    }
}

