/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.SAFRoleMapper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SAFRoleMapperImpl;
import com.ibm.ws.security.core.SecurityConfig;
import java.util.Properties;

public class SAFRoleMapperFactory {
    private static final TraceComponent tc = Tr.register((Class)SAFRoleMapperFactory.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    private static SAFRoleMapper _roleMapper = null;
    private static final SAFRoleMapperFactory _instance = new SAFRoleMapperFactory();

    private SAFRoleMapperFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        _roleMapper = SAFRoleMapperFactory.getSAFRoleMapper();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public static SAFRoleMapper getSAFRoleMapper() {
        if (_roleMapper != null) {
            return _roleMapper;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSAFRoleMapper");
        }
        ContextManager contextManager = ContextManagerFactory.getInstance();
        String string = contextManager.getProperty("com.ibm.websphere.security.SAF.RoleMapper", null);
        Properties properties = SAFRoleMapperFactory.getRoleMapperContext();
        if (string != null) {
            try {
                _roleMapper = (SAFRoleMapper)Class.forName(string).newInstance();
                _roleMapper.initialize(properties);
                Tr.audit((TraceComponent)tc, (String)"security.saf.role.mapper.loaded", (Object)new Object[]{string});
            }
            catch (Throwable throwable) {
                Tr.audit((TraceComponent)tc, (String)"security.saf.role.mapper.exception", (Object)new Object[]{string});
                _roleMapper = null;
            }
        }
        if (_roleMapper == null) {
            _roleMapper = new SAFRoleMapperImpl();
            _roleMapper.initialize(properties);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSAFRoleMapper", (Object)_roleMapper);
        }
        return _roleMapper;
    }

    private static Properties getRoleMapperContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRoleMapperContext");
        }
        Properties properties = new Properties();
        SecurityConfig securityConfig = SecurityConfig.getConfig();
        String string = null;
        string = (String)securityConfig.getValue("cellname");
        properties.setProperty("CELL_NAME", string == null ? "" : string);
        string = (String)securityConfig.getValue("cell.short.name");
        properties.setProperty("SHORT_CELL_NAME", string == null ? "" : string);
        string = (String)securityConfig.getValue("shortservername");
        properties.setProperty("SERVER_NAME", string == null ? "" : string);
        string = (String)securityConfig.getValue("server.short.name");
        properties.setProperty("SHORT_SERVER_NAME", string == null ? "" : string);
        string = (String)securityConfig.getValue("security.zOS.domainName");
        if (string != null) {
            properties.setProperty("DOMAIN_NAME", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRoleMapperContext", (Object)properties);
        }
        return properties;
    }
}

