/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.server.LTPAConfigException;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.x500.X500Principal;

public final class LTPALoginHelper {
    private static final TraceComponent tc = Tr.register((Class)LTPALoginHelper.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    private static final LTPALoginHelper _instance = new LTPALoginHelper();
    private ContextManager _contextManager;
    LTPAServerObject ltpaServer;

    public static LTPALoginHelper instance() {
        return _instance;
    }

    private LTPALoginHelper() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        this._contextManager = ContextManagerFactory.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    private LTPAServerObject getLTPAServer() {
        block3: {
            try {
                if (this.ltpaServer == null) {
                    this.ltpaServer = LTPAServerObject.getLTPAServer();
                }
            }
            catch (LTPAConfigException lTPAConfigException) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"LTPA configuration error", (Object)lTPAConfigException);
            }
        }
        return this.ltpaServer;
    }

    byte[] login(String string, String string2, String string3) {
        byte[] byArray;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"login", (Object)new Object[]{string, string2, string3 != null ? "****" : "null"});
            }
            byArray = null;
            try {
                WSCredential wSCredential = this._contextManager.authenticate(string, string2, string3);
                long l = wSCredential.getExpiration();
                byArray = wSCredential.getCredentialToken();
            }
            catch (AuthenticationFailedException authenticationFailedException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Authentication failed", (Object)((Object)authenticationFailedException));
                }
            }
            catch (CredentialDestroyedException credentialDestroyedException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Credential destroyed", (Object)((Object)credentialDestroyedException));
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception", (Object)throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login", byArray);
        }
        return byArray;
    }

    boolean isTokenValid(byte[] byArray) {
        boolean bl;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"isTokenValid", (Object)byArray);
            }
            bl = false;
            try {
                WSCredential wSCredential = this.getLTPAServer().validate(byArray);
                bl = true;
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"invalid credential", (Object)byArray);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isTokenValid", (Object)new Boolean(bl));
        }
        return bl;
    }

    public long getRemainingTime(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRemainingTime", (Object)byArray);
        }
        long l = 0L;
        long l2 = 0L;
        try {
            l = this.getLTPAServer().getExpiration(byArray);
            if (l > 0L) {
                l2 = l - System.currentTimeMillis();
            }
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)tc, (String)"Token invalid", (Object)new Object[]{byArray, exception});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRemainingTime", (Object)new Long(l2));
        }
        return l2;
    }

    public byte[] encodeDistinguishedName(final String string) {
        byte[] byArray;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"encodeDistinguishedName", (Object)string);
            }
            byArray = null;
            try {
                byArray = (byte[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        X500Principal x500Principal = new X500Principal(string);
                        return x500Principal.getEncoded();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!tc.isEventEnabled()) break block4;
                Tr.event((TraceComponent)tc, (String)"Unable to encode DN", (Object)new Object[]{string, privilegedActionException.getCause()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"encodeDistinguishedName", (Object)byArray);
        }
        return byArray;
    }

    public String decodeDistinguishedName(final byte[] byArray) {
        String string;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"decodeDistinguishedName", (Object)byArray);
            }
            string = null;
            try {
                string = (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        X500Principal x500Principal = new X500Principal(byArray);
                        return x500Principal.getName();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!tc.isEventEnabled()) break block4;
                Tr.event((TraceComponent)tc, (String)"Unable to decode DN", (Object)new Object[]{byArray, privilegedActionException.getCause()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"decodeDistinguishedName", (Object)string);
        }
        return string;
    }

    public byte[] getServerLTPAToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerLTPAToken");
        }
        byte[] byArray = null;
        try {
            Subject subject = this._contextManager.getServerSubject();
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
            try {
                byArray = wSCredential.getCredentialToken();
            }
            catch (CredentialDestroyedException credentialDestroyedException) {
                FFDCFilter.processException((Throwable)credentialDestroyedException, (String)"com.ibm.ws.security.core.LTPALoginHelper", (String)"325", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.cred.CredentialDestroyedException");
            }
            catch (CredentialExpiredException credentialExpiredException) {
                Tr.debug((TraceComponent)tc, (String)"Server credential has expired and probably shouldn't have", (Object)credentialExpiredException);
                Tr.error((TraceComponent)tc, (String)"security.cred.CredentialExpiredException");
            }
            if (byArray == null) {
                LTPAServerObject lTPAServerObject = LTPAServerObject.getLTPAServer();
                WSCredential wSCredential2 = lTPAServerObject.createLTPAToken(wSCredential);
                byArray = wSCredential2.getCredentialToken();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.LTPALoginHelper", (String)"345", (Object)this);
            byArray = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerLTPAToken", (Object)byArray);
        }
        return byArray;
    }

    public String getUserFromLTPAToken(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUserFromLTPAToken", (Object)byArray);
        }
        String string = "";
        try {
            LTPAServerObject lTPAServerObject = LTPAServerObject.getLTPAServer();
            string = lTPAServerObject.validateGetUser(byArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.LTPALoginHelper", (String)"374", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUserFromLTPAToken", (Object)string);
        }
        return string;
    }
}

