/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorize;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.authorize.MethodConstraint;
import java.util.ArrayList;
import java.util.HashMap;

public class URLMap {
    private static TraceComponent tc = Tr.register((Class)URLMap.class, null, (String)"com.ibm.ejs.resources.security");
    StringBuffer newURLPattern;
    HashMap mapMethod;
    ArrayList unchkDataConstraintList = new ArrayList();
    boolean unqualified = false;
    String[] allMethods = new String[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"};

    public URLMap(String string) {
        this.newURLPattern = new StringBuffer(string);
        this.mapMethod = new HashMap();
        for (int i = 0; i < this.allMethods.length; ++i) {
            this.mapMethod.put(this.allMethods[i], new MethodConstraint());
        }
    }

    public void appendURLPattern(String string) {
        this.newURLPattern.append(":" + string);
    }

    public String getURLPattern() {
        return this.newURLPattern.toString();
    }

    public void setExcludedSet(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            MethodConstraint methodConstraint = (MethodConstraint)this.mapMethod.get(((String)arrayList.get(i)).toUpperCase());
            methodConstraint.setExcluded();
        }
    }

    public void setUncheckedSet(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            MethodConstraint methodConstraint = (MethodConstraint)this.mapMethod.get(((String)arrayList.get(i)).toUpperCase());
            methodConstraint.setUnchecked();
        }
    }

    public void setRoleMap(String string, ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            MethodConstraint methodConstraint = (MethodConstraint)this.mapMethod.get(((String)arrayList.get(i)).toUpperCase());
            methodConstraint.setRole(string);
        }
    }

    public void setUserDataMap(String string, ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            MethodConstraint methodConstraint = (MethodConstraint)this.mapMethod.get(((String)arrayList.get(i)).toUpperCase());
            methodConstraint.setUserData(string);
        }
    }

    public String[] getExcludedArray() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.allMethods.length; ++i) {
            MethodConstraint methodConstraint = (MethodConstraint)this.mapMethod.get(this.allMethods[i]);
            if (!methodConstraint.isExcluded()) continue;
            arrayList.add(this.allMethods[i]);
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new String[0]);
        }
        return null;
    }

    public String[] getUncheckedArray() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.allMethods.length; ++i) {
            MethodConstraint methodConstraint = (MethodConstraint)this.mapMethod.get(this.allMethods[i]);
            if (methodConstraint.isExcluded() || !methodConstraint.isUnchecked() && !methodConstraint.isRoleSetEmpty()) continue;
            arrayList.add(this.allMethods[i]);
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new String[0]);
        }
        return null;
    }

    public HashMap getRoleMap() {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.allMethods.length; ++i) {
            MethodConstraint methodConstraint = (MethodConstraint)this.mapMethod.get(this.allMethods[i]);
            if (methodConstraint.isExcluded() || methodConstraint.isUnchecked() || methodConstraint.isRoleSetEmpty()) continue;
            ArrayList arrayList = methodConstraint.getRoleList();
            ArrayList<String> arrayList2 = null;
            for (int j = 0; j < arrayList.size(); ++j) {
                arrayList2 = (ArrayList<String>)hashMap.get((String)arrayList.get(j));
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<String>();
                }
                arrayList2.add(this.allMethods[i]);
                hashMap.put(arrayList.get(j), arrayList2);
            }
        }
        return hashMap;
    }

    public String[] getUserDataArray() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.allMethods.length; ++i) {
            MethodConstraint methodConstraint = (MethodConstraint)this.mapMethod.get(this.allMethods[i]);
            if (methodConstraint.isExcluded()) continue;
            String string = methodConstraint.getUserData();
            if (string != null && (string.equalsIgnoreCase("INTEGRAL") || string.equalsIgnoreCase("CONFIDENTIAL"))) {
                arrayList.add(this.allMethods[i]);
                continue;
            }
            this.unchkDataConstraintList.add(this.allMethods[i]);
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new String[0]);
        }
        return null;
    }

    public String[] getUnchkDataConstraintArray() {
        if (this.unchkDataConstraintList.size() > 0) {
            return this.unchkDataConstraintList.toArray(new String[0]);
        }
        return null;
    }

    public String[] getAllMethods() {
        return this.allMethods;
    }
}

