/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.security.auth.CacheEvictionListener;
import com.ibm.ws.security.auth.CacheException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class Cache
implements AlarmListener {
    private static final TraceComponent tc = Tr.register((Class)Cache.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    private static Long defaultTimeout = null;
    private Hashtable primaryTable;
    private Hashtable secondaryTable;
    private Hashtable tertiaryTable;
    private int minSize = 0;
    private int entryLimit = Integer.MAX_VALUE;
    private CacheEvictionListener evictionCallback;
    private Alarm alarm;

    public Cache(int n, long l) {
        this(n, l, 0, null);
    }

    public Cache(int n, long l, int n2, CacheEvictionListener cacheEvictionListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{new Integer(n), new Long(l), new Integer(n2), cacheEvictionListener});
        }
        this.primaryTable = new Hashtable(n);
        this.secondaryTable = new Hashtable(n);
        this.tertiaryTable = new Hashtable(n);
        this.minSize = n;
        this.entryLimit = n2;
        this.alarm = new Alarm(l);
        this.alarm.addAlarmListener(this);
        this.evictionCallback = cacheEvictionListener;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public void remove(Object object) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove", (Object)object);
        }
        Object object2 = this.evictionCallback != null ? this.get(object) : null;
        this.primaryTable.remove(object);
        this.secondaryTable.remove(object);
        this.tertiaryTable.remove(object);
        if (this.evictionCallback != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object2);
            this.evictionCallback.evicted(arrayList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"get", (Object)object);
        }
        Hashtable hashtable = this.primaryTable;
        Entry entry = (Entry)this.primaryTable.get(object);
        if (entry == null) {
            hashtable = this.secondaryTable;
            entry = (Entry)this.secondaryTable.get(object);
            if (entry == null) {
                hashtable = this.tertiaryTable;
                entry = (Entry)this.tertiaryTable.get(object);
            }
            if (entry == null) {
                hashtable = null;
            }
        }
        if (hashtable != null && hashtable != this.primaryTable) {
            this.primaryTable.put(object, entry);
            hashtable.remove(object);
        }
        if (hashtable == null) {
            Hashtable hashtable2 = this.primaryTable;
            synchronized (hashtable2) {
                entry = (Entry)this.primaryTable.get(object);
                if (entry == null) {
                    entry = new Entry();
                    this.primaryTable.put(object, entry);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"get", (Object)entry.value);
        }
        return entry.value;
    }

    public void insert(Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"insert", (Object)new Object[]{object, object2});
        }
        Entry entry = new Entry(object2);
        this.primaryTable.put(object, entry);
        if (this.isEvictionRequired()) {
            this.evictStaleEntries();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"insert");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isEvictionRequired() {
        boolean bl = false;
        if (this.entryLimit != Integer.MAX_VALUE) {
            Hashtable hashtable = this.primaryTable;
            synchronized (hashtable) {
                int n = this.primaryTable.size() + this.secondaryTable.size() + this.tertiaryTable.size();
                if (n > this.entryLimit && this.tertiaryTable.size() > this.entryLimit / 10) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    protected void evictStaleEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"evictStaleEntries");
        }
        Hashtable hashtable = this.tertiaryTable;
        this.tertiaryTable = this.secondaryTable;
        this.secondaryTable = this.primaryTable;
        this.primaryTable = new Hashtable(this.minSize > this.secondaryTable.size() ? this.minSize : this.secondaryTable.size());
        if (this.evictionCallback != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator iterator = hashtable.values().iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                arrayList.add(entry.value);
            }
            this.evictionCallback.evicted(arrayList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"evictStaleEntries");
        }
    }

    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
        }
        this.evictStaleEntries();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAllEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clearAllEntries");
        }
        Hashtable hashtable = this.primaryTable;
        synchronized (hashtable) {
            if (this.evictionCallback != null) {
                this.tertiaryTable.putAll(this.primaryTable);
                this.tertiaryTable.putAll(this.secondaryTable);
            }
            this.primaryTable.clear();
            this.secondaryTable.clear();
            this.evictStaleEntries();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clearAllEntries");
        }
    }

    public static long getDefaultTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultTimeout");
        }
        long l = 0L;
        if (defaultTimeout != null) {
            l = defaultTimeout;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDefaultTimeout", (Object)new Long(l));
        }
        return l;
    }

    public static void setDefaultTimeout(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDefaultTimeout", (Object)new Long(l));
        }
        if (defaultTimeout == null) {
            defaultTimeout = new Long(l);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setDefaultTimeout");
        }
    }

    private static class Alarm
    implements AlarmListener {
        private Vector alarms = new Vector();
        private long timeout;

        void addAlarmListener(AlarmListener alarmListener) {
            this.alarms.addElement(alarmListener);
        }

        Alarm(long l) {
            this.timeout = l / 2L;
            this.alarm(null);
        }

        public void alarm(Object object) {
            for (int i = 0; i < this.alarms.size(); ++i) {
                ((AlarmListener)this.alarms.elementAt(i)).alarm(object);
            }
            AlarmManager.createDeferrable((long)this.timeout, (AlarmListener)this);
        }

        public long getTimeout() {
            return this.timeout * 2L;
        }
    }

    public static class Entry {
        public Object value;
        public int timesAccessed;

        public Entry() {
        }

        public Entry(Object object) {
            this.value = object;
        }
    }
}

