/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.Cache;
import com.ibm.ws.security.auth.CacheException;
import com.ibm.ws.security.auth.CacheObject;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.auth.ServerCredSigner;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.token.WSCredentialTokenMapper;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.math.BigInteger;
import java.security.Permission;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;

public class AuthCache
extends Cache
implements SecurityCache {
    private static final TraceComponent tc = Tr.register((Class)AuthCache.class, (String)"Security", (String)"com.ibm.ejs.resources.security");
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static AuthCache authCache = null;
    private static long defaultTimeout = 0L;
    private final ContextManager contextManager;
    private final WSCredentialTokenMapperInterface credTokenMapper;
    private long cushion = -1L;
    protected static boolean authCacheEnabled = true;
    protected static boolean allowLookupByBasicAuth = true;
    public static final String AUTH_CACHE_ENABLED = "com.ibm.websphere.security.util.authCacheEnabled";
    public static final String AUTH_CACHE_SIZE = "com.ibm.websphere.security.util.authCacheSize";

    public static synchronized AuthCache getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInstance");
        }
        if (authCache == null) {
            Long l = (Long)SecurityConfig.getConfig().getValue("security.CacheTimeout");
            long l2 = l;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("security cache timeout is " + l2));
            }
            Cache.setDefaultTimeout(l2 * 1000L);
            String string = System.getProperty(AUTH_CACHE_SIZE);
            if (string == null || string.equals("") || new Integer(string) < 0) {
                string = "200";
            }
            authCache = new AuthCache(new Integer(string), l2 * 1000L);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInstance", (Object)authCache);
        }
        return authCache;
    }

    private AuthCache(int n, long l) {
        super(n, l);
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{new Integer(n), new Long(l)});
        }
        authCacheEnabled = (string = System.getProperty(AUTH_CACHE_ENABLED)) == null ? true : !string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("no");
        allowLookupByBasicAuth = string == null || !string.equalsIgnoreCase("BasicAuthDisabled");
        this.contextManager = ContextManagerFactory.getInstance();
        this.credTokenMapper = WSCredentialTokenMapper.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"AuthCache", (Object)this);
        }
    }

    public void removeEntry(String string, String string2) throws CacheException {
        String string3;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeEntry", (Object)new Object[]{string, string2});
        }
        if (string == null) {
            string = this.contextManager.getDefaultRealm();
        }
        if (string2 != null && (object = this.get(string3 = string + ":" + string2)) != null && object instanceof CacheObject) {
            this.removeEntry((CacheObject)object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeEntry");
        }
    }

    public void removeEntry(CacheObject cacheObject) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeEntry", (Object)cacheObject);
        }
        if (cacheObject != null) {
            try {
                Object[] objectArray = cacheObject.getKeyArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    this.remove(objectArray[i]);
                    if (!(objectArray[i] instanceof ByteArray)) continue;
                    this.credTokenMapper.invalidateDistributedObject((Object)((ByteArray)objectArray[i]));
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.util.AuthCache.removeEntry", (String)"198", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception removing credential from cache", (Object)exception);
                }
                throw new CacheException(exception.getMessage(), (Throwable)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeEntry");
        }
    }

    public void removeAllEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeAllEntries");
        }
        this.clearAllEntries();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeAllEntries");
        }
    }

    public Subject getSubject(byte[] byArray) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSubject", (Object)byArray);
        }
        Subject subject = null;
        if (authCacheEnabled) {
            ByteArray byteArray = new ByteArray(byArray);
            subject = this.getSubject(byteArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubject", subject);
        }
        return subject;
    }

    public Subject getSubject(Object object) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSubject", (Object)object);
        }
        Subject subject = null;
        if (authCacheEnabled) {
            Object object2 = null;
            try {
                object2 = this.get(object);
                if (object2 != null && object2 instanceof CacheObject) {
                    subject = ((CacheObject)object2).getSubject();
                    Map map = ((CacheObject)object2).getPropTokenMap();
                    if (map != null) {
                        this.setPropTokenMapOnThread(map);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.util.AuthCache.getSubject", (String)"276", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception trying to get object from cache", (Object)exception);
                }
                throw new CacheException(exception.getMessage(), (Throwable)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubject", subject);
        }
        return subject;
    }

    public Subject getSubject(String string, String string2, String string3) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSubject", (Object)new Object[]{string, string2, "xxxxx"});
        }
        if (string2 == null || string3 == null || !authCacheEnabled || !allowLookupByBasicAuth) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSubject", null);
            }
            return null;
        }
        Subject subject = null;
        try {
            byte[] byArray = null;
            try {
                byArray = ServerCredSigner.getInstance().getOneWayHash(string3);
                if (tc.isDebugEnabled() && byArray != null) {
                    Tr.debug((TraceComponent)tc, (String)("One-way password hash using SHA is: " + new BigInteger(byArray)));
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.util.AuthCache.getSubject", (String)"317", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.sas.encode.error", (Object)new Object[]{exception});
            }
            byArray = byArray != null ? byArray : string3.getBytes();
            String string4 = string + ":" + string2;
            Object object = this.get(string4);
            if (object != null && object instanceof CacheObject) {
                CacheObject cacheObject = (CacheObject)object;
                Object[] objectArray = cacheObject.getKeyArray();
                Object var10_12 = null;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!(objectArray[i] instanceof BasicAuthCacheData)) continue;
                    BasicAuthCacheData basicAuthCacheData = (BasicAuthCacheData)objectArray[i];
                    if (basicAuthCacheData != null && !Arrays.equals(basicAuthCacheData.password, byArray)) {
                        this.removeEntry(string, string2);
                        continue;
                    }
                    subject = cacheObject.getSubject();
                    Map map = cacheObject.getPropTokenMap();
                    if (map == null) continue;
                    this.setPropTokenMapOnThread(map);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.util.AuthCache.getSubject", (String)"360", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Authentication failed", (Object)exception);
            }
            throw new CacheException(exception.getMessage(), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubject", subject);
        }
        return subject;
    }

    public Subject getSubject(String string, String string2) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSubject", (Object)new Object[]{string, string2});
        }
        if (!authCacheEnabled || string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSubject", null);
            }
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + MAP_CREDENTIAL.toString()));
            }
            securityManager.checkPermission((Permission)MAP_CREDENTIAL);
        }
        Subject subject = null;
        try {
            String string3 = string + ":" + string2;
            Object object = this.get(string3);
            if (object != null && object instanceof CacheObject) {
                CacheObject cacheObject = (CacheObject)object;
                subject = cacheObject.getSubject();
                Map map = cacheObject.getPropTokenMap();
                if (map != null) {
                    this.setPropTokenMapOnThread(map);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.util.AuthCache.getSubject", (String)"417", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Authentication failed", (Object)exception);
            }
            throw new CacheException(exception.getMessage(), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubject", subject);
        }
        return subject;
    }

    public void updateEntry(Subject subject, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateEntry", (Object)new Object[]{subject, byArray});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateEntry");
        }
    }

    public void insert(Subject subject) {
        this.insert(subject, null, null);
    }

    public void insert(Subject subject, Object[] objectArray) {
        this.insert(subject, null, objectArray);
    }

    public void insert(Subject subject, String string) {
        this.insert(subject, string, null);
    }

    public void insert(Subject subject, String string, Object[] objectArray) {
        this.insert(subject, null, string, objectArray);
    }

    public void insert(Subject subject, String string, String string2, Object[] objectArray) {
        block29: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"insert", (Object)new Object[]{subject, string, string2 == null ? string2 : "xxxxx", objectArray});
            }
            if (subject == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"insert");
                }
                return;
            }
            WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)subject);
            CacheObject cacheObject = new CacheObject();
            cacheObject.setSubject(subject);
            try {
                Object object;
                Object object2;
                if (string2 != null) {
                    object2 = new BasicAuthCacheData();
                    ((BasicAuthCacheData)object2).realm = wSCredential.getRealmName();
                    ((BasicAuthCacheData)object2).userId = wSCredential.getSecurityName();
                    object = null;
                    try {
                        object = ServerCredSigner.getInstance().getOneWayHash(string2);
                        if (tc.isDebugEnabled() && object != null) {
                            Tr.debug((TraceComponent)tc, (String)("One-way password hash using SHA is: " + new BigInteger((byte[])object)));
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.util.AuthCache.insert", (String)"530", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"security.sas.encode.error", (Object)new Object[]{exception});
                    }
                    ((BasicAuthCacheData)object2).password = (byte[])(object != null ? object : (ByteArray)string2.getBytes());
                    cacheObject.setKey(object2);
                    this.insert(object2, cacheObject);
                    if (string != null && !string.equals(((BasicAuthCacheData)object2).userId)) {
                        ((BasicAuthCacheData)object2).userId = string;
                        cacheObject.setKey(object2);
                        this.insert(object2, cacheObject);
                    }
                }
                if (wSCredential != null) {
                    Map map;
                    Map map2;
                    String string3;
                    String string4;
                    String string5;
                    String string6;
                    ByteArray byteArray;
                    byte[] byArray;
                    Object object3;
                    SingleSignonToken singleSignonToken;
                    object2 = wSCredential.getCredentialToken();
                    object = new ByteArray((byte[])object2);
                    if (object != null) {
                        cacheObject.setKey(object);
                        this.insert(object, cacheObject);
                    }
                    if ((singleSignonToken = SubjectHelper.getDefaultSSOTokenFromSubject((Subject)subject)) != null) {
                        object3 = new ByteArray(singleSignonToken.getBytes());
                        cacheObject.setKey(object3);
                        this.insert(object3, cacheObject);
                    }
                    if ((object3 = this.credTokenMapper.getCacheKeyFromHashtable(subject)) != null) {
                        cacheObject.setKey(object3);
                        this.insert(object3, cacheObject);
                    }
                    if ((byArray = (byte[])this.contextManager.get("CacheKeyAttribute")) != null) {
                        byteArray = new ByteArray(byArray);
                        cacheObject.setKey(byteArray);
                        this.insert(byteArray, cacheObject);
                    }
                    if ((byteArray = (ByteArray)this.contextManager.get("ZOSCacheKey")) != null) {
                        cacheObject.setKey(byteArray);
                        this.insert(byteArray, cacheObject);
                    }
                    if ((string6 = wSCredential.getRealmName() + ":" + wSCredential.getSecurityName()) != null) {
                        cacheObject.setKey(string6);
                        this.insert(string6, cacheObject);
                    }
                    if (string != null && !string.equals(wSCredential.getSecurityName())) {
                        string6 = wSCredential.getRealmName() + ":" + string;
                        cacheObject.setKey(string6);
                        this.insert(string6, cacheObject);
                    }
                    if ((string5 = this.credTokenMapper.createSubjectUniqueID(subject)) != null) {
                        cacheObject.setKey(string5);
                        this.insert(string5, cacheObject);
                    }
                    if ((string4 = (String)wSCredential.get("security.login_uid")) != null) {
                        string4 = wSCredential.getRealmName() + ":" + string4;
                        cacheObject.setKey(string4);
                        this.insert(string4, cacheObject);
                    }
                    if ((string3 = wSCredential.getRealmName() + ":" + wSCredential.getUniqueSecurityName()) != null) {
                        cacheObject.setKey(string3);
                        this.insert(string3, cacheObject);
                    }
                    if (objectArray != null && objectArray.length > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Additional lookup keys size: " + objectArray.length));
                        }
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Additional lookup value: " + objectArray[i]));
                            }
                            if (objectArray[i] == null) continue;
                            if (objectArray[i] instanceof byte[]) {
                                map2 = new ByteArray((byte[])objectArray[i]);
                                cacheObject.setKey(map2);
                                this.insert(map2, cacheObject);
                                continue;
                            }
                            cacheObject.setKey(objectArray[i]);
                            this.insert(objectArray[i], cacheObject);
                        }
                    }
                    if ((map = this.contextManager.getPropagationTokens()) != null) {
                        map2 = null;
                        map2 = this.clonePropTokenMap(map);
                        if (map2 != null) {
                            cacheObject.setPropTokenMap(map2);
                        }
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.server.util.AuthCache.insert", (String)"672", (Object)this);
                if (!tc.isDebugEnabled()) break block29;
                Tr.debug((TraceComponent)tc, (String)"Exception inserting Subject into cache: ", (Object)new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"insert");
        }
    }

    public long getCushion() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCushion");
        }
        if (this.cushion == -1L) {
            long l;
            long l2 = Cache.getDefaultTimeout();
            long l3 = 0L;
            long l4 = (Integer)SecurityConfig.getConfig().getValue("security.CacheCushionMin") * 60 * 1000 - 5000;
            long l5 = (Integer)SecurityConfig.getConfig().getValue("security.CacheCushionMax") * 60 * 1000;
            if (l5 <= 0L) {
                l5 = 600000L;
            }
            if (((Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred")).booleanValue()) {
                String string = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
                l3 = string.equals("ICSF") ? (Long)SecurityConfig.getConfig().getValue("was.security.ISCF.timeout") * 60L * 1000L : (Long)SecurityConfig.getConfig().getValue("security.ltpa.expirydate") * 60L * 1000L;
            }
            this.cushion = l3 > 0L ? ((l = l3 / 5L) < l4 ? l4 : (l > l5 ? l5 : l)) : 0L;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCushion", (Object)new Long(this.cushion));
        }
        return this.cushion;
    }

    private void setPropTokenMapOnThread(Map map) {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"setPropTokenMapOnThread", (Object)map);
            }
            if (map != null && map.size() > 0) {
                try {
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        PropagationToken propagationToken = (PropagationToken)map.get(string);
                        if (propagationToken == null) continue;
                        if (string.equals("com.ibm.ws.security.token.PropagationTokenImpl:1")) {
                            Enumeration enumeration = propagationToken.getAttributeNames();
                            while (enumeration.hasMoreElements()) {
                                String[] stringArray;
                                String[] stringArray2;
                                String string2 = (String)enumeration.nextElement();
                                if (string2 == null || string2.equals("com.ibm.wsspi.security.propagation.callers") || string2.equals("com.ibm.wsspi.security.propagation.hosts") || (stringArray2 = WSSecurityHelper.getPropagationAttributes((String)string2)) != null || (stringArray = propagationToken.getAttributes(string2)) == null || stringArray.length <= 0) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Adding attributes for " + string2 + " to existing prop token"));
                                }
                                for (int i = 0; i < stringArray.length; ++i) {
                                    WSSecurityHelper.addPropagationAttribute((String)string2, (String)stringArray[i]);
                                }
                            }
                            continue;
                        }
                        this.contextManager.setPropagationToken(string, (PropagationToken)propagationToken.clone());
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.AuthCache.setPropTokenMapOnThread", (String)"797", (Object)this);
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug((TraceComponent)tc, (String)"Exception setting propagation tokens on thread", (Object)exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setPropTokenMapOnThread");
        }
    }

    private Map clonePropTokenMap(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clonePropTokenMap", (Object)map);
        }
        HashMap<String, Object> hashMap = null;
        if (map != null && map.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cloning propagation tokens.");
            }
            hashMap = new HashMap<String, Object>();
            try {
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    PropagationToken propagationToken = (PropagationToken)map.get(string);
                    if (propagationToken == null) continue;
                    hashMap.put(string, propagationToken.clone());
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.AuthCache.clonePropTokenMap", (String)"836", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception cloning propagation tokens.", (Object)new Object[]{exception});
                }
                hashMap = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clonePropTokenMap", hashMap);
        }
        return hashMap;
    }

    class BasicAuthCacheData {
        public String realm;
        public String userId;
        public byte[] password;

        BasicAuthCacheData() {
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof BasicAuthCacheData)) {
                return false;
            }
            return this.realm.equals(((BasicAuthCacheData)object).realm) && this.userId.equals(((BasicAuthCacheData)object).userId) && Arrays.equals(this.password, ((BasicAuthCacheData)object).password);
        }

        public int hashCode() {
            return (this.realm + ":" + this.userId).hashCode();
        }

        public String toString() {
            return this.realm + ":" + this.userId;
        }
    }
}

