/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit;

import com.ibm.ejs.ras.AuditLogger;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereSecurityPermission;
import com.ibm.websphere.security.audit.AuditEventFactory;
import com.ibm.websphere.security.audit.AuditHandler;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.security.audit.AuditEventSettings;
import com.ibm.ws.security.audit.AuditHandlerImpl;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.audit.AuditServiceProvider;
import java.security.Permission;
import java.security.ProviderException;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public final class AuditServiceImpl
implements AuditService {
    private static final TraceComponent tc = Tr.register((Class)AuditServiceImpl.class, null, (String)"com.ibm.ejs.resources.security");
    private static AuditServiceImpl _auditService = null;
    private boolean _active = false;
    private HashMap _factory = new HashMap(1);
    private HashMap _context = new HashMap(3);
    private String _providerName = null;
    private AuditServiceProvider _providerObj = null;
    private boolean _queueEnabled = false;
    private int _queueSize = 0;
    private int _recoveryPolicy = 1;
    private String _domain = null;
    private String _componentName = null;
    private String _cellName = null;
    private String _nodeName = null;
    private String _serverName = null;
    private String _realm = null;
    private String _spec = null;
    private static final WebSphereSecurityPermission AUDIT_PERM = WebSphereSecurityPermission.INTERNAL_PERMISSION;
    private static AuditEventSettings[] _aes = new AuditEventSettings[12];
    private WsHandler _traceLogger;
    private static AuditLogger _aLog;

    public static AuditService getAuditService() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                Tr.debug((TraceComponent)tc, (String)("Expecting : " + AUDIT_PERM.toString()));
            }
            securityManager.checkPermission((Permission)AUDIT_PERM);
        }
        if (_auditService == null) {
            Tr.audit((TraceComponent)tc, (String)"security.audit.service.disabled.audit");
        }
        return _auditService;
    }

    public static void initAuditService(Map map) throws Exception {
        if (_auditService != null) {
            throw new IllegalStateException("AuditService has already been initialized");
        }
        _auditService = new AuditServiceImpl(map);
    }

    private AuditServiceImpl(Map map) throws Exception {
        try {
            this._cellName = (String)SecurityConfig.getConfig().getValue("cellname");
            this._nodeName = (String)SecurityConfig.getConfig().getValue("nodename");
            this._serverName = (String)SecurityConfig.getConfig().getValue("shortservername");
            if (this._componentName == null || this._componentName.length() == 0) {
                this._componentName = "WebSphere Application Server";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Cell = " + this._cellName + ", Node = " + this._nodeName + ", Server = " + this._serverName));
            }
            for (int i = 0; i <= 11; ++i) {
                AuditServiceImpl._aes[i] = new AuditEventSettings(i);
            }
            this._context.put("cell", this._cellName);
            this._context.put("node", this._nodeName);
            this._context.put("server", this._serverName);
            this._context.put("component", this._componentName);
            this._context.put("com.ibm.wsspi.security.audit.AuditService", this);
            _aLog = new AuditLogger();
            this._traceLogger = _aLog.createAuditLogger();
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.audit.service.exception.error", (Object)new Object[]{exception});
        }
        this.refresh(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Map map) throws Exception {
        block47: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Performing Java 2 Security Permission Check ...");
                    Tr.debug((TraceComponent)tc, (String)("Expecting : " + AUDIT_PERM.toString()));
                }
                securityManager.checkPermission((Permission)AUDIT_PERM);
            }
            try {
                String string = (String)map.get("com.ibm.audit.auditServiceEnabled");
                if (string != null) {
                    this._active = "true".equalsIgnoreCase(string);
                }
                String string2 = (String)map.get("com.ibm.audit.auditPolicy");
                boolean bl = "REQUIRED".equalsIgnoreCase(string2);
                if (this._active) {
                    Tr.audit((TraceComponent)tc, (String)"security.audit.service.enabled.audit");
                    if (bl) {
                        Tr.audit((TraceComponent)tc, (String)"security.audit.service.required.audit");
                        this._recoveryPolicy = 2;
                    } else {
                        Tr.audit((TraceComponent)tc, (String)"security.audit.service.optional.audit");
                        this._recoveryPolicy = 1;
                    }
                    HashMap hashMap = this._factory;
                    synchronized (hashMap) {
                        Object object;
                        Object object2;
                        Object object3;
                        Object object4;
                        Object object5;
                        String string3 = (String)map.get("com.ibm.websphere.security.audit.auditEventFactory");
                        if (string3 != null) {
                            object5 = new StringTokenizer(string3, ";,=");
                            while (((StringTokenizer)object5).hasMoreTokens()) {
                                object4 = ((StringTokenizer)object5).nextToken().trim();
                                if (((String)object4).length() > 0) {
                                    if (((StringTokenizer)object5).hasMoreTokens()) {
                                        object3 = ((StringTokenizer)object5).nextToken().trim();
                                        if (((String)object3).length() > 0) {
                                            block45: {
                                                try {
                                                    object2 = Class.forName((String)object3);
                                                    object = (AuditEventFactory)((Class)object2).newInstance();
                                                    object.init((String)object4, map, (Map)this._context);
                                                    this._factory.put(object4, object);
                                                }
                                                catch (Throwable throwable) {
                                                    Tr.error((TraceComponent)tc, (String)"security.audit.service.loading.error", (Object)new Object[]{"AuditEventFactory", object4, object3});
                                                    if (this._recoveryPolicy != 2) break block45;
                                                    this._active = false;
                                                    throw new MissingResourceException("Cannot load AuditEventFactory name: " + (String)object4 + " Class name: " + (String)object3, (String)object3, (String)object4);
                                                }
                                            }
                                            Tr.info((TraceComponent)tc, (String)"security.audit.service.provider.info", (Object)new Object[]{"AuditEventFactory", object4, object3});
                                            continue;
                                        }
                                        Tr.error((TraceComponent)tc, (String)"security.audit.service.invalid.error", (Object)new Object[]{"com.ibm.websphere.security.audit.auditEventFactory", string3, object3});
                                        continue;
                                    }
                                    Tr.error((TraceComponent)tc, (String)"security.audit.service.undefined.error", (Object)new Object[]{"com.ibm.websphere.security.audit.auditEventFactory", string3});
                                    continue;
                                }
                                Tr.error((TraceComponent)tc, (String)"security.audit.service.invalid.error", (Object)new Object[]{"com.ibm.websphere.security.audit.auditEventFactory", string3, null});
                            }
                        } else {
                            Tr.warning((TraceComponent)tc, (String)"security.audit.service.missing.warning", (Object)new Object[]{"com.ibm.websphere.security.audit.auditEventFactory"});
                        }
                        if (this._recoveryPolicy == 2 && this._factory.size() == 0) {
                            Tr.error((TraceComponent)tc, (String)"security.audit.service.config.error", (Object)new Object[]{"AuditEventFactory"});
                            this._active = false;
                            throw new ProviderException("Security auditing is REQUIRED but no AuditEventFactory was defined.");
                        }
                        object5 = (String)map.get("com.ibm.audit.auditSpecification");
                        if (object5 != null) {
                            object4 = new StringTokenizer((String)object5, "=,:");
                            while (((StringTokenizer)object4).hasMoreTokens()) {
                                object3 = ((StringTokenizer)object4).nextToken().trim();
                                if (((String)object3).length() > 0) {
                                    if (((StringTokenizer)object4).hasMoreTokens()) {
                                        object2 = ((StringTokenizer)object4).nextToken().trim();
                                        if (((String)object2).length() > 0) {
                                            if (((StringTokenizer)object4).hasMoreTokens()) {
                                                object = ((StringTokenizer)object4).nextToken().trim();
                                                if (((String)object).length() > 0) {
                                                    if (((StringTokenizer)object4).hasMoreTokens()) {
                                                        String string4 = ((StringTokenizer)object4).nextToken().trim();
                                                        if (string4.length() > 0) {
                                                            if (string4.equals("enabled")) {
                                                                this.setActive((String)object3, (String)object2, (String)object);
                                                                continue;
                                                            }
                                                            if (string4.equals("disabled")) {
                                                                this.resetActive((String)object3, (String)object2, (String)object);
                                                                continue;
                                                            }
                                                            Tr.error((TraceComponent)tc, (String)"security.audit.service.invalid.error", (Object)new Object[]{"com.ibm.audit.auditSpecification", object5, string4});
                                                            continue;
                                                        }
                                                        Tr.error((TraceComponent)tc, (String)"security.audit.service.invalid.error", (Object)new Object[]{"com.ibm.audit.auditSpecification", object5, string4});
                                                        continue;
                                                    }
                                                    Tr.error((TraceComponent)tc, (String)"security.audit.service.undefined.error", (Object)new Object[]{"com.ibm.audit.auditSpecification", object5});
                                                    continue;
                                                }
                                                Tr.error((TraceComponent)tc, (String)"security.audit.service.invalid.error", (Object)new Object[]{"com.ibm.audit.auditSpecification", object5, object});
                                                continue;
                                            }
                                            Tr.error((TraceComponent)tc, (String)"security.audit.service.undefined.error", (Object)new Object[]{"com.ibm.audit.auditSpecification", object5});
                                            continue;
                                        }
                                        Tr.error((TraceComponent)tc, (String)"security.audit.service.invalid.error", (Object)new Object[]{"com.ibm.audit.auditSpecification", object5, object2});
                                        continue;
                                    }
                                    Tr.error((TraceComponent)tc, (String)"security.audit.service.undefined.error", (Object)new Object[]{"com.ibm.audit.auditSpecification", object5});
                                    continue;
                                }
                                Tr.error((TraceComponent)tc, (String)"security.audit.service.invalid.error", (Object)new Object[]{"com.ibm.audit.auditSpecification", object5, null});
                            }
                        } else {
                            Tr.warning((TraceComponent)tc, (String)"security.audit.service.missing.warning", (Object)new Object[]{"com.ibm.audit.auditSpecification"});
                        }
                        if ((object4 = (String)map.get("com.ibm.wsspi.security.audit.auditServiceProvider")) != null) {
                            object3 = new StringTokenizer((String)object4, ";,=");
                            if (((StringTokenizer)object3).hasMoreTokens()) {
                                this._providerName = ((StringTokenizer)object3).nextToken().trim();
                                if (this._providerName.length() > 0) {
                                    if (((StringTokenizer)object3).hasMoreTokens()) {
                                        object2 = ((StringTokenizer)object3).nextToken().trim();
                                        if (((String)object2).length() > 0) {
                                            block46: {
                                                try {
                                                    object = Class.forName((String)object2);
                                                    this._providerObj = (AuditServiceProvider)((Class)object).newInstance();
                                                    this._providerObj.refresh(map);
                                                }
                                                catch (Throwable throwable) {
                                                    Tr.error((TraceComponent)tc, (String)"security.audit.service.loading.error", (Object)new Object[]{"AuditServiceProvider", this._providerName, object2});
                                                    if (this._recoveryPolicy != 2) break block46;
                                                    this._active = false;
                                                    throw new MissingResourceException("Cannot load AuditServiceProvider name: " + this._providerName + " Class name: " + (String)object2, (String)object2, this._providerName);
                                                }
                                            }
                                            Tr.info((TraceComponent)tc, (String)"security.audit.service.provider.info", (Object)new Object[]{"AuditServiceProvider", this._providerName, object2});
                                        } else {
                                            Tr.error((TraceComponent)tc, (String)"security.audit.service.invalid.error", (Object)new Object[]{"com.ibm.wsspi.security.audit.auditServiceProvider", this._providerName, object2});
                                        }
                                    } else {
                                        Tr.error((TraceComponent)tc, (String)"security.audit.service.undefined.error", (Object)new Object[]{"com.ibm.wsspi.security.audit.auditServiceProvider", object4});
                                    }
                                } else {
                                    Tr.error((TraceComponent)tc, (String)"security.audit.service.invalid.error", (Object)new Object[]{"com.ibm.wsspi.security.audit.auditServiceProvider", this._providerName, null});
                                }
                            }
                            while (((StringTokenizer)object3).hasMoreTokens()) {
                                Tr.warning((TraceComponent)tc, (String)"security.audit.service.extra.warning", (Object)new Object[]{((StringTokenizer)object3).nextToken()});
                            }
                        } else {
                            Tr.warning((TraceComponent)tc, (String)"security.audit.service.missing.warning", (Object)new Object[]{"com.ibm.wsspi.security.audit.auditServiceProvider"});
                        }
                        if (this._recoveryPolicy == 2 && this._providerObj == null) {
                            Tr.error((TraceComponent)tc, (String)"security.audit.service.config.error", (Object)new Object[]{"AuditServiceProvider"});
                            this._active = false;
                            throw new ProviderException("Security auditing is REQUIRED but no AuditServiceProvider was defined.");
                        }
                        break block47;
                    }
                }
                Tr.audit((TraceComponent)tc, (String)"security.audit.service.disabled.audit");
            }
            catch (Exception exception) {
                Tr.error((TraceComponent)tc, (String)"security.audit.service.exception.error", (Object)new Object[]{exception});
                this._active = false;
                throw exception;
            }
        }
    }

    public Object getEvent(String string) {
        if (this._providerObj != null) {
            try {
                return this._providerObj.getEvent(string);
            }
            catch (Exception exception) {
                if (this._recoveryPolicy == 2) {
                    Tr.error((TraceComponent)tc, (String)"security.audit.service.provider.error", (Object)new Object[]{exception});
                }
                return null;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"AuditServiceProvider not initialized");
        }
        return null;
    }

    public static AuditEventSettings[] getAuditEventSettings() {
        return _aes;
    }

    public static AuditLogger getAuditLogger() {
        return _aLog;
    }

    public String sendEvent(Object object, String string) {
        if (this._providerObj != null) {
            try {
                return this._providerObj.sendEvent(object, string);
            }
            catch (Exception exception) {
                if (this._recoveryPolicy == 2) {
                    Tr.error((TraceComponent)tc, (String)"security.audit.service.provider.error", (Object)new Object[]{exception});
                }
                return null;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"AuditServiceProvider not initialized");
        }
        return null;
    }

    public String sendEvent(Object object, int n, int n2, String string) {
        if (this._providerObj != null) {
            try {
                return this._providerObj.sendEvent(object, n, n2, string);
            }
            catch (Exception exception) {
                if (this._recoveryPolicy == 2) {
                    Tr.error((TraceComponent)tc, (String)"security.audit.service.provider.error", (Object)new Object[]{exception});
                }
                return null;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"AuditServiceProvider not initialized");
        }
        return null;
    }

    public boolean isAuthentic(AuditHandler auditHandler) {
        if (auditHandler == null) {
            return false;
        }
        return "com.ibm.ws.security.audit.AuditHandlerImpl".equals(auditHandler.getClass().getName());
    }

    public String getProviderName() {
        return this._providerName;
    }

    public boolean isActive() {
        return this._active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(String string, String string2, String string3) {
        if (this._factory == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"AuditEventFactory not initialized");
            }
            return false;
        }
        HashMap hashMap = this._factory;
        synchronized (hashMap) {
            AuditEventFactory auditEventFactory = (AuditEventFactory)this._factory.get(string);
            if (auditEventFactory == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("AuditEventFactory " + string + " not initialized"));
                }
                return false;
            }
            return auditEventFactory.isActive(string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(String string, int n, int n2) {
        if (this._factory == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"AuditEventFactory not initialized");
            }
            return false;
        }
        HashMap hashMap = this._factory;
        synchronized (hashMap) {
            AuditEventFactory auditEventFactory = (AuditEventFactory)this._factory.get(string);
            if (auditEventFactory == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("AuditEventFactory " + string + " not initialized"));
                }
                return false;
            }
            return auditEventFactory.isActive(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(String string, String string2, String string3) {
        if (this._factory == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"AuditEventFactory not initialized");
            }
            return;
        }
        HashMap hashMap = this._factory;
        synchronized (hashMap) {
            AuditEventFactory auditEventFactory = (AuditEventFactory)this._factory.get(string);
            if (auditEventFactory != null) {
                auditEventFactory.setActive(string2, string3);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("AuditEventFactory " + string + " not initialized"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(String string, int n, int n2) {
        if (this._factory == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"AuditEventFactory not initialized");
            }
            return;
        }
        HashMap hashMap = this._factory;
        synchronized (hashMap) {
            AuditEventFactory auditEventFactory = (AuditEventFactory)this._factory.get(string);
            if (auditEventFactory != null) {
                auditEventFactory.setActive(n, n2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("AuditEventFactory " + string + " not initialized"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetActive(String string, String string2, String string3) {
        if (this._factory == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"AuditEventFactory not initialized");
            }
            return;
        }
        HashMap hashMap = this._factory;
        synchronized (hashMap) {
            AuditEventFactory auditEventFactory = (AuditEventFactory)this._factory.get(string);
            if (auditEventFactory != null) {
                auditEventFactory.resetActive(string2, string3);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("AuditEventFactory " + string + " not initialized"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetActive(String string, int n, int n2) {
        if (this._factory == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"AuditEventFactory not initialized");
            }
            return;
        }
        HashMap hashMap = this._factory;
        synchronized (hashMap) {
            AuditEventFactory auditEventFactory = (AuditEventFactory)this._factory.get(string);
            if (auditEventFactory != null) {
                auditEventFactory.resetActive(n, n2);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("AuditEventFactory " + string + " not initialized"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getActive() {
        if (this._factory == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"AuditEventFactory not initialized");
            }
            return null;
        }
        HashMap hashMap = this._factory;
        synchronized (hashMap) {
            AuditEventFactory[] auditEventFactoryArray = (AuditEventFactory[])this._factory.values().toArray();
            if (auditEventFactoryArray == null || auditEventFactoryArray.length == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"AuditEventFactory list empty");
                }
                return null;
            }
            String[] stringArray = (String[])this._factory.keySet().toArray();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < auditEventFactoryArray.length; ++i) {
                try {
                    String string = auditEventFactoryArray[i].getActive();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "=;,");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken().trim();
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        String string3 = stringTokenizer.nextToken().trim();
                        stringBuffer.append(stringArray[i] + "=" + string2 + "=" + string3 + ";");
                    }
                    continue;
                }
                catch (Exception exception) {
                    Tr.error((TraceComponent)tc, (String)"security.audit.service.factory.error", (Object)new Object[]{new Integer(i), exception});
                }
            }
            return stringBuffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuditHandler newAuditHandler(String string, String string2) {
        if (this._factory == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"AuditEventFactory not initialized");
            }
            return null;
        }
        HashMap hashMap = this._factory;
        synchronized (hashMap) {
            return new AuditHandlerImpl(this, this._componentName, string2, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAuditEventFactoryName() {
        if (this._factory == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"AuditEventFactory not initialized");
            }
            return null;
        }
        HashMap hashMap = this._factory;
        synchronized (hashMap) {
            return this._factory.keySet().toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuditEventFactory getAuditEventFactory(String string) {
        if (this._factory == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"AuditEventFactory not initialized");
            }
            return null;
        }
        HashMap hashMap = this._factory;
        synchronized (hashMap) {
            return (AuditEventFactory)this._factory.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAuthentic(Object object, String string) {
        if (this._factory == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"AuditEventFactory not initialized");
            }
            return false;
        }
        HashMap hashMap = this._factory;
        synchronized (hashMap) {
            if (string == null || string.equals("")) {
                return this.isAuthentic(object);
            }
            AuditEventFactory auditEventFactory = (AuditEventFactory)this._factory.get(string);
            if (auditEventFactory == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("AuditEventFactory " + string + " not initialized"));
                }
                throw new NoSuchElementException("AuditEventFactory: " + string + " not initialized");
            }
            return auditEventFactory.isAuthentic(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAuthentic(Object object) {
        if (this._factory == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"AuditEventFactory not initialized");
            }
            return false;
        }
        HashMap hashMap = this._factory;
        synchronized (hashMap) {
            AuditEventFactory[] auditEventFactoryArray = this._factory.values().toArray(new AuditEventFactory[0]);
            for (int i = 0; i < this._factory.size(); ++i) {
                if (!auditEventFactoryArray[i].isAuthentic(object)) continue;
                return true;
            }
            return false;
        }
    }
}

