/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.gsk.ikeyman.basic.IkeymanLoggerInterface;
import com.ibm.log.CorporateLevelLogger;
import com.ibm.log.EnhancedFormatter;
import com.ibm.log.FileHandler;
import com.ibm.log.Level;
import com.ibm.log.LogEventFormatter;
import com.ibm.log.LogEventListener;

public class IkeymanLoggerImpl
implements IkeymanLoggerInterface {
    private static IkeymanLoggerImpl theLogger = null;
    private CorporateLevelLogger levelLogger;
    private EnhancedFormatter eFormatter;
    private FileHandler fileLog = new FileHandler("FileHandler");

    public static IkeymanLoggerInterface getLogger(String string, String string2, String string3) {
        if (theLogger == null) {
            theLogger = new IkeymanLoggerImpl(string, string2, string3);
        }
        return theLogger;
    }

    private IkeymanLoggerImpl(String string, String string2, String string3) {
        this.eFormatter = new EnhancedFormatter();
        this.levelLogger = new CorporateLevelLogger("IkeymanLogger");
        if (string != null && string.equalsIgnoreCase("true")) {
            this.levelLogger.setLogging(true);
        } else {
            this.levelLogger.setLogging(false);
        }
        if (string3 != null) {
            this.fileLog.setFileName(string3);
        } else {
            this.fileLog.setFileName("ikmlog.log");
        }
        this.fileLog.setAppending(false);
        this.fileLog.setFormatter((LogEventFormatter)this.eFormatter);
        this.levelLogger.addLogEventListener((LogEventListener)this.fileLog);
        if (string2 != null) {
            this.levelLogger.setLevel(this.getLoggingFilter(string2));
        } else {
            this.levelLogger.setLevel(Level.ALL);
        }
    }

    public void entry(String string, String string2) {
        if (this.levelLogger.isLogging()) {
            this.levelLogger.entry(Level.DEBUG_MID, (Object)string, string2);
        }
    }

    public void exit(String string, String string2) {
        if (this.levelLogger.isLogging()) {
            this.levelLogger.exit(Level.DEBUG_MID, (Object)string, string2);
        }
    }

    public void info(String string, String string2, String string3) {
        if (this.levelLogger.isLogging()) {
            this.levelLogger.text(Level.INFO, (Object)string, string2, string3);
        }
    }

    public void warning(String string, String string2, String string3) {
        if (this.levelLogger.isLogging()) {
            this.levelLogger.text(Level.WARN, (Object)string, string2, string3);
        }
    }

    public void error(String string, String string2, String string3) {
        if (this.levelLogger.isLogging()) {
            this.levelLogger.text(Level.ERROR, (Object)string, string2, string3);
        }
    }

    public void exception(String string, String string2, Throwable throwable, String string3) {
        if (this.levelLogger.isLogging()) {
            this.levelLogger.exception(Level.ERROR, (Object)string, string2, throwable, string3);
        }
    }

    private Level getLoggingFilter(String string) {
        if (string.equalsIgnoreCase("ALL")) {
            return Level.ALL;
        }
        if (string.equalsIgnoreCase("INFO")) {
            return Level.INFO;
        }
        if (string.equalsIgnoreCase("WARN")) {
            return Level.WARN;
        }
        if (string.equalsIgnoreCase("ERROR")) {
            return Level.ERROR;
        }
        return null;
    }

    public void closeLogFile() {
        if (this.fileLog != null) {
            this.fileLog.close();
        }
        this.fileLog = null;
    }
}

