/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMButton;
import com.ibm.gsk.ikeyman.basic.BERObject;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AVA;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CRLDistributionPointsExtension;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.IssuerAlternativeNameExtension;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.NameConstraintsExtension;
import com.ibm.security.x509.PolicyConstraintsExtension;
import com.ibm.security.x509.PolicyMappingsExtension;
import com.ibm.security.x509.PrivateKeyUsageExtension;
import com.ibm.security.x509.RDN;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.security.Principal;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class KeyInfoDetailsDialog
extends JDialog
implements ActionListener,
TreeSelectionListener {
    private KeyInfoDetailsTree keyInfoDetailsTree;
    private KeyInfoDetailsTextAreaJTextArea keyInfoDetailsTextArea;
    private KMButton okButton;
    private String title;
    private static final int HEX_DUMP_WIDTH = 16;

    public KeyInfoDetailsDialog(JFrame jFrame, String string, KeyItem keyItem) {
        super(jFrame, string, true);
        this.title = string;
        this.createKeyInfoDetailsTree(keyItem);
        this.initializeLayout(keyItem);
        this.setDefaultCloseOperation(2);
    }

    private void createKeyInfoDetailsTree(KeyItem keyItem) {
        Object object;
        KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject = new KeyInfoDetailsTreeNodeUserObject(this.title, null);
        KeyInfoDetailsTreeNode keyInfoDetailsTreeNode = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject);
        if (keyItem.hasCertificate()) {
            object = keyItem.getCertificateChain();
            if (object != null && ((Vector)object).size() > 0) {
                CertificateItem certificateItem = (CertificateItem)((Vector)object).elementAt(0);
                try {
                    X509CertImpl x509CertImpl = new X509CertImpl(certificateItem.getEncoded());
                    KeyInfoDetailsTreeNode keyInfoDetailsTreeNode2 = this.createCertificateNode(x509CertImpl);
                    if (keyInfoDetailsTreeNode2 != null) {
                        keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode2);
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            object = keyItem.getCertificateRequestItem();
            byte[] byArray = ((BERObject)object).getEncoded();
            try {
                CertificationRequest certificationRequest = new CertificationRequest(byArray);
                KeyInfoDetailsTreeNode keyInfoDetailsTreeNode3 = this.createCertificationRequestNode(certificationRequest);
                if (keyInfoDetailsTreeNode3 != null) {
                    keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.keyInfoDetailsTree = new KeyInfoDetailsTree(keyInfoDetailsTreeNode);
        int n = ((Component)this.keyInfoDetailsTree).getFontMetrics(this.keyInfoDetailsTree.getFont()).getHeight();
        this.keyInfoDetailsTree.setRowHeight(n);
        this.keyInfoDetailsTree.addTreeSelectionListener(this);
    }

    private KeyInfoDetailsTreeNode createCertificateNode(X509CertImpl x509CertImpl) {
        KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_CERT"), null);
        KeyInfoDetailsTreeNode keyInfoDetailsTreeNode = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject);
        try {
            KeyInfoDetailsTreeNode keyInfoDetailsTreeNode2 = this.createTBSCertificateNode(x509CertImpl);
            if (keyInfoDetailsTreeNode2 != null) {
                keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode2);
            }
            AlgorithmId algorithmId = AlgorithmId.get((String)x509CertImpl.getSigAlgName());
            byte[] byArray = x509CertImpl.getSignature();
            this.createSignatureAlgorithmAndSignatureNodes(keyInfoDetailsTreeNode, algorithmId, byArray);
            if (keyInfoDetailsTreeNode.getChildCount() == 0) {
                keyInfoDetailsTreeNode = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return keyInfoDetailsTreeNode;
    }

    private KeyInfoDetailsTreeNode createTBSCertificateNode(X509CertImpl x509CertImpl) {
        KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_TBS_CERT"), null);
        KeyInfoDetailsTreeNode keyInfoDetailsTreeNode = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject);
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string;
            Object object5;
            Object object6;
            KeyInfoDetailsTreeNode keyInfoDetailsTreeNode2;
            KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject2;
            Object object7;
            Object object8;
            String string2;
            String string3 = new String("v" + x509CertImpl.getVersion());
            KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject3 = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_VERSION"), string3);
            KeyInfoDetailsTreeNode keyInfoDetailsTreeNode3 = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject3);
            keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode3);
            byte[] byArray = x509CertImpl.getSerialNumber().toByteArray();
            if (byArray != null && byArray.length > 0 && (string2 = this.getHexDump(byArray)) != null && string2.length() > 0) {
                object8 = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_SERIALNO"), string2);
                object7 = new KeyInfoDetailsTreeNode((KeyInfoDetailsTreeNodeUserObject)object8);
                keyInfoDetailsTreeNode.add((MutableTreeNode)object7);
            }
            if ((string2 = this.getHexDump(x509CertImpl.getSignature())) != null && string2.length() > 0) {
                object8 = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_SIG"), string2);
                object7 = new KeyInfoDetailsTreeNode((KeyInfoDetailsTreeNodeUserObject)object8);
                keyInfoDetailsTreeNode.add((MutableTreeNode)object7);
            }
            if ((object7 = new X500Name((object8 = x509CertImpl.getIssuerDN()).getName())) != null) {
                keyInfoDetailsTreeNodeUserObject2 = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_ISSUER"), null);
                keyInfoDetailsTreeNode2 = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject2);
                this.createNameNodes(keyInfoDetailsTreeNode2, (X500Name)object7);
                if (keyInfoDetailsTreeNode2.getChildCount() > 0) {
                    keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode2);
                }
            }
            keyInfoDetailsTreeNodeUserObject2 = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_VALIDITY"), null);
            keyInfoDetailsTreeNode2 = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject2);
            Date date = x509CertImpl.getNotBefore();
            String string4 = DateFormat.getDateTimeInstance(0, 0, KMSystem.getLocale()).format(date);
            KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject4 = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_NOT_BEFORE"), string4);
            KeyInfoDetailsTreeNode keyInfoDetailsTreeNode4 = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject4);
            keyInfoDetailsTreeNode2.add(keyInfoDetailsTreeNode4);
            Date date2 = x509CertImpl.getNotAfter();
            String string5 = DateFormat.getDateTimeInstance(0, 0, KMSystem.getLocale()).format(date2);
            KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject5 = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_NOT_AFTER"), string5);
            KeyInfoDetailsTreeNode keyInfoDetailsTreeNode5 = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject5);
            keyInfoDetailsTreeNode2.add(keyInfoDetailsTreeNode5);
            keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode2);
            Principal principal = x509CertImpl.getSubjectDN();
            X500Name x500Name = new X500Name(principal.getName());
            if (x500Name != null) {
                object6 = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_SUBJECT"), null);
                object5 = new KeyInfoDetailsTreeNode((KeyInfoDetailsTreeNodeUserObject)object6);
                this.createNameNodes((KeyInfoDetailsTreeNode)object5, x500Name);
                if (((DefaultMutableTreeNode)object5).getChildCount() > 0) {
                    keyInfoDetailsTreeNode.add((MutableTreeNode)object5);
                }
            }
            object6 = null;
            object6 = x509CertImpl.getPublicKey();
            object5 = new DerValue(object6.getEncoded());
            AlgorithmId algorithmId = AlgorithmId.parse((DerValue)object5.getData().getDerValue());
            byte[] byArray2 = null;
            byArray2 = object6.getEncoded();
            KeyInfoDetailsTreeNode keyInfoDetailsTreeNode6 = this.createSubjectPublicKeyInfoNode(algorithmId, byArray2);
            if (keyInfoDetailsTreeNode6 != null) {
                keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode6);
            }
            BitArray bitArray = null;
            try {
                bitArray = new BitArray(x509CertImpl.getIssuerUniqueID());
            }
            catch (Exception exception) {
                bitArray = null;
            }
            byte[] byArray3 = null;
            if (bitArray != null) {
                byArray3 = bitArray.toByteArray();
            }
            if (byArray3 != null) {
                string = this.getHexDump(byArray3);
                object4 = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_ISSUER_UNIQUE_ID"), string);
                object3 = new KeyInfoDetailsTreeNode((KeyInfoDetailsTreeNodeUserObject)object4);
                keyInfoDetailsTreeNode.add((MutableTreeNode)object3);
            }
            string = null;
            try {
                string = new BitArray(x509CertImpl.getSubjectUniqueID());
            }
            catch (Exception exception) {
                string = null;
            }
            object4 = null;
            if (string != null) {
                object4 = string.toByteArray();
            }
            if (object4 != null) {
                object3 = this.getHexDump((byte[])object4);
                object2 = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_SUBJECT_UNIQUE_ID"), (String)object3);
                object = new KeyInfoDetailsTreeNode((KeyInfoDetailsTreeNodeUserObject)object2);
                keyInfoDetailsTreeNode.add((MutableTreeNode)object);
            }
            try {
                KeyInfoDetailsTreeNode keyInfoDetailsTreeNode7;
                object3 = new DerValue(x509CertImpl.getEncoded());
                object2 = object3.getData().getDerValue();
                object = new X509CertInfo(object2);
                CertificateExtensions certificateExtensions = (CertificateExtensions)object.get("extensions");
                if (certificateExtensions != null && (keyInfoDetailsTreeNode7 = this.createExtensionsNode(certificateExtensions)) != null) {
                    keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode7);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (keyInfoDetailsTreeNode.getChildCount() == 0) {
                keyInfoDetailsTreeNode = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return keyInfoDetailsTreeNode;
    }

    private void createNameNodes(KeyInfoDetailsTreeNode keyInfoDetailsTreeNode, X500Name x500Name) {
        int n = x500Name.size();
        int n2 = 0;
        while (n2 < n) {
            RDN[] rDNArray = new RDN[n];
            rDNArray[n2] = x500Name.getRDN(n2);
            int n3 = rDNArray[n2].size();
            int n4 = 0;
            while (n4 < n3) {
                AVA[] aVAArray = new AVA[n3];
                aVAArray[n4] = rDNArray[n2].getAVA(n4);
                KeyInfoDetailsTreeNode keyInfoDetailsTreeNode2 = this.createAttributeTypeAndValueNode(aVAArray[n4]);
                if (keyInfoDetailsTreeNode2 != null) {
                    keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode2);
                }
                ++n4;
            }
            ++n2;
        }
        keyInfoDetailsTreeNode.sortChildren();
    }

    private KeyInfoDetailsTreeNode createAttributeTypeAndValueNode(AVA aVA) {
        KeyInfoDetailsTreeNode keyInfoDetailsTreeNode;
        KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject;
        String string;
        String string2 = null;
        KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject2 = null;
        KeyInfoDetailsTreeNode keyInfoDetailsTreeNode2 = null;
        ObjectIdentifier objectIdentifier = aVA.getOID();
        if (objectIdentifier != null) {
            string2 = this.getAttributeName(objectIdentifier);
            keyInfoDetailsTreeNodeUserObject2 = new KeyInfoDetailsTreeNodeUserObject(string2, null);
            keyInfoDetailsTreeNode2 = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject2);
            string = objectIdentifier.toString();
            if (string != null && string.length() > 0) {
                keyInfoDetailsTreeNodeUserObject = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_TYPE"), string);
                keyInfoDetailsTreeNode = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject);
                keyInfoDetailsTreeNode2.add(keyInfoDetailsTreeNode);
            }
        } else {
            string2 = aVA.toString();
            keyInfoDetailsTreeNodeUserObject2 = new KeyInfoDetailsTreeNodeUserObject(string2, null);
            keyInfoDetailsTreeNode2 = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject2);
        }
        if ((string = aVA.getValue()) != null && string.length() > 0) {
            keyInfoDetailsTreeNodeUserObject = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_VALUE"), string);
            keyInfoDetailsTreeNode = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject);
            keyInfoDetailsTreeNode2.add(keyInfoDetailsTreeNode);
        }
        if (keyInfoDetailsTreeNode2.getChildCount() == 0) {
            keyInfoDetailsTreeNode2 = null;
        }
        return keyInfoDetailsTreeNode2;
    }

    private String getAttributeName(ObjectIdentifier objectIdentifier) {
        String string = null;
        if (objectIdentifier != null) {
            string = objectIdentifier.equals(X500Name.commonName_oid) ? Ikeyman.getNLSResString("GUI_LABEL_COMMON_NAME") : (objectIdentifier.equals(X500Name.serialNumber_oid) ? Ikeyman.getNLSResString("GUI_LABEL_SERIALNO") : (objectIdentifier.equals(X500Name.countryName_oid) ? Ikeyman.getNLSResString("GUI_LABEL_COUNTRY") : (objectIdentifier.equals(X500Name.localityName_oid) ? Ikeyman.getNLSResString("GUI_LABEL_LOCALITY") : (objectIdentifier.equals(X500Name.stateName_oid) ? Ikeyman.getNLSResString("GUI_LABEL_STATE") : (objectIdentifier.equals(X500Name.streetAddress_oid) ? Ikeyman.getNLSResString("GUI_LABEL_STREET") : (objectIdentifier.equals(X500Name.orgName_oid) ? Ikeyman.getNLSResString("GUI_LABEL_ORG") : (objectIdentifier.equals(X500Name.orgUnitName_oid) ? Ikeyman.getNLSResString("GUI_LABEL_ORG_UNIT") : (objectIdentifier.equals(X500Name.title_oid) ? Ikeyman.getNLSResString("GUI_LABEL_TITLE2") : (objectIdentifier.equals(X500Name.postalCode_oid) ? Ikeyman.getNLSResString("GUI_LABEL_ZIPCODE") : (objectIdentifier.equals(X500Name.emailAddress_oid) ? Ikeyman.getNLSResString("GUI_LABEL_EMAIL_ADDRESS1") : objectIdentifier.toString()))))))))));
        }
        return string;
    }

    private KeyInfoDetailsTreeNode createSubjectPublicKeyInfoNode(AlgorithmId algorithmId, byte[] byArray) {
        String string;
        KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_SUBJECT_PUBLIC_KEYINFO"), null);
        KeyInfoDetailsTreeNode keyInfoDetailsTreeNode = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject);
        KeyInfoDetailsTreeNode keyInfoDetailsTreeNode2 = this.createAlgorithmNode(algorithmId, Ikeyman.getNLSResString("GUI_LABEL_ALGORITHM"));
        if (keyInfoDetailsTreeNode2 != null) {
            keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode2);
        }
        if (byArray != null && byArray.length > 0 && (string = this.getHexDump(byArray)) != null && string.length() > 0) {
            KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject2 = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_SUBJECT_PUBLIC_KEY"), string);
            KeyInfoDetailsTreeNode keyInfoDetailsTreeNode3 = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject2);
            keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode3);
        }
        if (keyInfoDetailsTreeNode.getChildCount() == 0) {
            keyInfoDetailsTreeNode = null;
        }
        return keyInfoDetailsTreeNode;
    }

    private KeyInfoDetailsTreeNode createAlgorithmNode(AlgorithmId algorithmId, String string) {
        KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject = new KeyInfoDetailsTreeNodeUserObject(string, null);
        KeyInfoDetailsTreeNode keyInfoDetailsTreeNode = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject);
        if (algorithmId != null) {
            Object object;
            Object object2;
            Object object3;
            ObjectIdentifier objectIdentifier = algorithmId.getOID();
            if (objectIdentifier != null && (object3 = objectIdentifier.toString()) != null && ((String)object3).length() > 0) {
                object2 = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_ALGORITHM"), (String)object3);
                object = new KeyInfoDetailsTreeNode((KeyInfoDetailsTreeNodeUserObject)object2);
                keyInfoDetailsTreeNode.add((MutableTreeNode)object);
            }
            object3 = null;
            object2 = null;
            if (null == algorithmId.getAlgParameters()) {
                object3 = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_PARAMETERS"), Ikeyman.getNLSResString("GUI_LABEL_NULL"));
                object2 = new KeyInfoDetailsTreeNode((KeyInfoDetailsTreeNodeUserObject)object3);
                keyInfoDetailsTreeNode.add((MutableTreeNode)object2);
            } else {
                try {
                    object = this.getHexDumpWithASCII(algorithmId.getParameters());
                    if (object != null && ((String)object).length() > 0) {
                        object3 = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_PARAMETERS"), (String)object);
                        object2 = new KeyInfoDetailsTreeNode((KeyInfoDetailsTreeNodeUserObject)object3);
                        keyInfoDetailsTreeNode.add((MutableTreeNode)object2);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (keyInfoDetailsTreeNode.getChildCount() == 0) {
            keyInfoDetailsTreeNode = null;
        }
        return keyInfoDetailsTreeNode;
    }

    private KeyInfoDetailsTreeNode createExtensionsNode(CertificateExtensions certificateExtensions) {
        KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_EXTENSIONS"), null);
        KeyInfoDetailsTreeNode keyInfoDetailsTreeNode = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject);
        Collection collection = certificateExtensions.getAllExtensions();
        Iterator iterator = collection.iterator();
        Extension[] extensionArray = new Extension[collection.size()];
        int n = 0;
        while (iterator.hasNext()) {
            extensionArray[n] = (Extension)iterator.next();
            ++n;
        }
        int n2 = 0;
        while (n2 < collection.size()) {
            KeyInfoDetailsTreeNode keyInfoDetailsTreeNode2 = this.createExtensionNode(extensionArray[n2]);
            if (keyInfoDetailsTreeNode2 != null) {
                keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode2);
            }
            ++n2;
        }
        if (keyInfoDetailsTreeNode.getChildCount() == 0) {
            keyInfoDetailsTreeNode = null;
        } else {
            keyInfoDetailsTreeNode.sortChildren();
        }
        return keyInfoDetailsTreeNode;
    }

    private KeyInfoDetailsTreeNode createExtensionNode(Extension extension) {
        Object object;
        Object object2;
        KeyInfoDetailsTreeNode keyInfoDetailsTreeNode;
        String string;
        Object object3;
        block54: {
            block53: {
                String string2 = " ";
                String string3 = " ";
                ObjectIdentifier objectIdentifier = null;
                String string4 = " ";
                object3 = " ";
                int n = 0;
                boolean bl = false;
                String string5 = Ikeyman.getNLSResString("GUI_LABEL_EXTNID");
                String string6 = Ikeyman.getNLSResString("GUI_LABEL_CRITICAL");
                string = Ikeyman.getNLSResString("GUI_LABEL_EXTNVALUE");
                objectIdentifier = extension.getExtensionId();
                string2 = objectIdentifier.toString();
                string3 = string2;
                if (string3.equals("2.5.29.9")) {
                    string3 = Ikeyman.getNLSResString("GUI_LABEL_SUBJECT_DIRECTORY_ATTRIBUTES");
                    n = 9;
                } else if (string3.equals("2.5.29.14")) {
                    string3 = Ikeyman.getNLSResString("GUI_LABEL_SUBJECT_KEY_IDENTIFIER");
                    n = 14;
                } else if (string3.equals("2.5.29.15")) {
                    string3 = Ikeyman.getNLSResString("GUI_LABEL_KEY_USAGE");
                    n = 15;
                } else if (string3.equals("2.5.29.16")) {
                    string3 = Ikeyman.getNLSResString("GUI_LABEL_PRIVATE_KEY_USAGE_PERIOD");
                    n = 16;
                } else if (string3.equals("2.5.29.17")) {
                    string3 = Ikeyman.getNLSResString("GUI_LABEL_SUBJECT_ALTERNATIVE_NAME");
                    n = 17;
                } else if (string3.equals("2.5.29.18")) {
                    string3 = Ikeyman.getNLSResString("GUI_LABEL_ISSUER_ALTERNATIVE_NAMES");
                    n = 18;
                } else if (string3.equals("2.5.29.19")) {
                    string3 = Ikeyman.getNLSResString("GUI_LABEL_BASIC_CONSTRAINTS");
                    n = 19;
                } else if (string3.equals("2.5.29.30")) {
                    string3 = Ikeyman.getNLSResString("GUI_LABEL_NAME_CONSTRAINTS");
                    n = 30;
                } else if (string3.equals("2.5.29.31")) {
                    string3 = Ikeyman.getNLSResString("GUI_LABEL_CRL_DISTRIBUTION_POINTS");
                    n = 31;
                } else if (string3.equals("2.5.29.32")) {
                    string3 = Ikeyman.getNLSResString("GUI_LABEL_CERTIFICATE_POLICIES");
                    n = 32;
                } else if (string3.equals("2.5.29.33")) {
                    string3 = Ikeyman.getNLSResString("GUI_LABEL_POLICY_MAPPINGS");
                    n = 33;
                } else if (string3.equals("2.5.29.35")) {
                    string3 = Ikeyman.getNLSResString("GUI_LABEL_AUTH_KEY_ID");
                    n = 35;
                } else if (string3.equals("2.5.29.36")) {
                    string3 = Ikeyman.getNLSResString("GUI_LABEL_POLICY_CONSTRAINTS");
                    n = 36;
                } else if (string3.equals("2.5.29.37")) {
                    string3 = Ikeyman.getNLSResString("GUI_LABEL_EXT_KEY_USAGE_FIELD");
                    n = 37;
                }
                KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject = new KeyInfoDetailsTreeNodeUserObject(string3, null);
                keyInfoDetailsTreeNode = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject);
                KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject2 = new KeyInfoDetailsTreeNodeUserObject(string5, string2);
                KeyInfoDetailsTreeNode keyInfoDetailsTreeNode2 = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject2);
                keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode2);
                string4 = extension.isCritical() ? Ikeyman.getNLSResString("GUI_LABEL_TRUE") : Ikeyman.getNLSResString("GUI_LABEL_FALSE");
                KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject3 = new KeyInfoDetailsTreeNodeUserObject(string6, string4);
                KeyInfoDetailsTreeNode keyInfoDetailsTreeNode3 = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject3);
                keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode3);
                if (bl) break block53;
                object2 = null;
                switch (n) {
                    case 9: {
                        break;
                    }
                    case 14: {
                        try {
                            object = ((SubjectKeyIdentifierExtension)extension).get("key_id");
                            object3 = object.toString();
                        }
                        catch (Exception exception) {}
                        break block54;
                    }
                    case 15: {
                        object3 = ((KeyUsageExtension)extension).toString();
                        break;
                    }
                    case 16: {
                        object3 = ((PrivateKeyUsageExtension)extension).toString();
                        break;
                    }
                    case 17: {
                        try {
                            object2 = (GeneralNames)((SubjectAlternativeNameExtension)extension).get("subject_name");
                            object = ((Vector)object2).toString();
                            GeneralName generalName = object2.getGeneralName(7);
                            GeneralNameInterface generalNameInterface = generalName.getName();
                            IPAddressName iPAddressName = (IPAddressName)generalNameInterface;
                            StringTokenizer stringTokenizer = new StringTokenizer(((Vector)object2).toString(), ",");
                            StringBuffer stringBuffer = new StringBuffer();
                            while (stringTokenizer.hasMoreTokens()) {
                                String string7 = stringTokenizer.nextToken();
                                if (string7.indexOf("IPAddress") != -1) {
                                    stringBuffer.append("IPAddress: " + iPAddressName.getName() + ", ");
                                    continue;
                                }
                                stringBuffer.append(string7 + ", ");
                            }
                            if (stringBuffer.toString().endsWith(", ")) {
                                stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length() - 1);
                            }
                            if (stringBuffer.toString().indexOf("]") == 1) {
                                stringBuffer.append("]");
                            }
                            object3 = object;
                        }
                        catch (Exception exception) {}
                        break block54;
                    }
                    case 18: {
                        try {
                            object2 = (GeneralNames)((IssuerAlternativeNameExtension)extension).get("issuer_name");
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        object3 = ((Vector)object2).toString();
                        break;
                    }
                    case 19: {
                        object3 = ((BasicConstraintsExtension)extension).toString();
                        break;
                    }
                    case 30: {
                        object3 = ((NameConstraintsExtension)extension).toString();
                        break;
                    }
                    case 31: {
                        object3 = ((CRLDistributionPointsExtension)extension).toString();
                        break;
                    }
                    case 32: {
                        break;
                    }
                    case 33: {
                        object3 = ((PolicyMappingsExtension)extension).toString();
                        break;
                    }
                    case 35: {
                        object3 = ((AuthorityKeyIdentifierExtension)extension).toString();
                        break;
                    }
                    case 36: {
                        object3 = ((PolicyConstraintsExtension)extension).toString();
                        break;
                    }
                    case 37: {
                        break;
                    }
                }
                break block54;
            }
            object3 = Ikeyman.getNLSResString("GUI_LABEL_INFO_NOT_VALID_ERROR");
        }
        object2 = new KeyInfoDetailsTreeNodeUserObject(string, (String)object3);
        object = new KeyInfoDetailsTreeNode((KeyInfoDetailsTreeNodeUserObject)object2);
        keyInfoDetailsTreeNode.add((MutableTreeNode)object);
        return keyInfoDetailsTreeNode;
    }

    private void createSignatureAlgorithmAndSignatureNodes(KeyInfoDetailsTreeNode keyInfoDetailsTreeNode, AlgorithmId algorithmId, byte[] byArray) {
        String string;
        KeyInfoDetailsTreeNode keyInfoDetailsTreeNode2 = this.createAlgorithmNode(algorithmId, Ikeyman.getNLSResString("GUI_LABEL_SIG_ALG"));
        if (keyInfoDetailsTreeNode2 != null) {
            keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode2);
        }
        if (byArray != null && byArray.length > 0 && (string = this.getHexDump(byArray)) != null && string.length() > 0) {
            KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_SIG_VALUE"), string);
            KeyInfoDetailsTreeNode keyInfoDetailsTreeNode3 = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject);
            keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode3);
        }
    }

    private KeyInfoDetailsTreeNode createCertificationRequestNode(CertificationRequest certificationRequest) {
        KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_CERTREQ"), null);
        KeyInfoDetailsTreeNode keyInfoDetailsTreeNode = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject);
        CertificationRequestInfo certificationRequestInfo = certificationRequest.getCertRequestInfo();
        KeyInfoDetailsTreeNode keyInfoDetailsTreeNode2 = this.createCertificationRequestInfoNode(certificationRequestInfo);
        if (keyInfoDetailsTreeNode2 != null) {
            keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode2);
        }
        AlgorithmId algorithmId = certificationRequest.getSignatureAlgorithm();
        byte[] byArray = certificationRequest.getSignature();
        this.createSignatureAlgorithmAndSignatureNodes(keyInfoDetailsTreeNode, algorithmId, byArray);
        if (keyInfoDetailsTreeNode.getChildCount() == 0) {
            keyInfoDetailsTreeNode = null;
        }
        return keyInfoDetailsTreeNode;
    }

    private KeyInfoDetailsTreeNode createCertificationRequestInfoNode(CertificationRequestInfo certificationRequestInfo) {
        KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_CERTREQ_INFO"), null);
        KeyInfoDetailsTreeNode keyInfoDetailsTreeNode = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject);
        try {
            KeyInfoDetailsTreeNode keyInfoDetailsTreeNode2;
            Object object;
            Object object2;
            byte[] byArray = certificationRequestInfo.getVersion().toByteArray();
            String string = this.getHexDump(byArray);
            KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject2 = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_VERSION"), string);
            KeyInfoDetailsTreeNode keyInfoDetailsTreeNode3 = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject2);
            keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode3);
            X500Name x500Name = certificationRequestInfo.getSubjectName();
            if (x500Name != null) {
                object2 = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_SUBJECT"), null);
                object = new KeyInfoDetailsTreeNode((KeyInfoDetailsTreeNodeUserObject)object2);
                this.createNameNodes((KeyInfoDetailsTreeNode)object, x500Name);
                if (((DefaultMutableTreeNode)object).getChildCount() > 0) {
                    keyInfoDetailsTreeNode.add((MutableTreeNode)object);
                }
            }
            object2 = null;
            object2 = certificationRequestInfo.getSubjectPublicKeyInfo();
            if (object2 != null) {
                object = new DerValue(object2.getEncoded());
                keyInfoDetailsTreeNode2 = AlgorithmId.parse((DerValue)object.getData().getDerValue());
                byte[] byArray2 = null;
                byArray2 = object2.getEncoded();
                KeyInfoDetailsTreeNode keyInfoDetailsTreeNode4 = this.createSubjectPublicKeyInfoNode((AlgorithmId)keyInfoDetailsTreeNode2, byArray2);
                if (keyInfoDetailsTreeNode4 != null) {
                    keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode4);
                }
            }
            if ((object = certificationRequestInfo.getAttributes()) != null && (keyInfoDetailsTreeNode2 = this.createAttributesNode((PKCSAttributes)object)) != null) {
                keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode2);
            }
            if (keyInfoDetailsTreeNode.getChildCount() == 0) {
                keyInfoDetailsTreeNode = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return keyInfoDetailsTreeNode;
    }

    private KeyInfoDetailsTreeNode createAttributesNode(PKCSAttributes pKCSAttributes) {
        KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_ATTRIBUTES"), null);
        KeyInfoDetailsTreeNode keyInfoDetailsTreeNode = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject);
        PKCSAttribute[] pKCSAttributeArray = pKCSAttributes.getAttributes();
        if (pKCSAttributeArray != null) {
            int n = 0;
            while (n < pKCSAttributeArray.length) {
                KeyInfoDetailsTreeNode keyInfoDetailsTreeNode2 = this.createAttributeNode(pKCSAttributeArray[n]);
                if (keyInfoDetailsTreeNode2 != null) {
                    keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode2);
                }
                ++n;
            }
        }
        if (keyInfoDetailsTreeNode.getChildCount() == 0) {
            keyInfoDetailsTreeNode = null;
        } else {
            keyInfoDetailsTreeNode.sortChildren();
        }
        return keyInfoDetailsTreeNode;
    }

    private KeyInfoDetailsTreeNode createAttributeNode(PKCSAttribute pKCSAttribute) {
        Object object;
        Object object2;
        String string;
        String string2 = null;
        KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject = null;
        KeyInfoDetailsTreeNode keyInfoDetailsTreeNode = null;
        ObjectIdentifier objectIdentifier = pKCSAttribute.getAttributeId();
        if (objectIdentifier != null) {
            string2 = this.getAttributeName(objectIdentifier);
            keyInfoDetailsTreeNodeUserObject = new KeyInfoDetailsTreeNodeUserObject(string2, null);
            keyInfoDetailsTreeNode = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject);
            string = objectIdentifier.toString();
            if (string != null && string.length() > 0) {
                object2 = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_TYPE"), string);
                object = new KeyInfoDetailsTreeNode((KeyInfoDetailsTreeNodeUserObject)object2);
                keyInfoDetailsTreeNode.add((MutableTreeNode)object);
            }
        } else {
            string2 = Ikeyman.getNLSResString("GUI_LABEL_ATTRIBUTE");
            keyInfoDetailsTreeNodeUserObject = new KeyInfoDetailsTreeNodeUserObject(string2, null);
            keyInfoDetailsTreeNode = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject);
        }
        try {
            string = pKCSAttribute.toString();
            object2 = string.getBytes();
            if (object2 != null && ((byte[])object2).length > 0) {
                object = string;
                KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject2 = new KeyInfoDetailsTreeNodeUserObject(Ikeyman.getNLSResString("GUI_LABEL_VALUE"), (String)object);
                KeyInfoDetailsTreeNode keyInfoDetailsTreeNode2 = new KeyInfoDetailsTreeNode(keyInfoDetailsTreeNodeUserObject2);
                keyInfoDetailsTreeNode.add(keyInfoDetailsTreeNode2);
            }
            if (keyInfoDetailsTreeNode.getChildCount() == 0) {
                keyInfoDetailsTreeNode = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return keyInfoDetailsTreeNode;
    }

    private String getHexDump(byte[] byArray) {
        String string = new String("");
        if (byArray != null && byArray.length > 0) {
            int n = 0;
            while (n < byArray.length) {
                int n2;
                if (n % 16 == 0) {
                    if (n > 0 && n < byArray.length) {
                        string = string + "\n";
                    }
                } else {
                    string = string + " ";
                }
                if ((n2 = byArray[n] & 0xFF) < 16) {
                    string = string + "0";
                }
                string = string + Integer.toHexString(n2).toUpperCase();
                ++n;
            }
        }
        return string;
    }

    private String getHexDumpWithASCII(byte[] byArray) {
        String string = new String("");
        if (byArray != null && byArray.length > 0) {
            String string2 = new String("");
            String string3 = new String("");
            int n = 0;
            int n2 = 0;
            while (n < byArray.length) {
                int n3 = 0;
                n3 = n + 16 <= byArray.length ? 16 : byArray.length % 16;
                byte[] byArray2 = new byte[n3];
                string3 = "";
                n2 = 0;
                while (n2 < byArray2.length) {
                    byArray2[n2] = byArray[n + n2];
                    string3 = byArray2[n2] < 0 || Character.getType((char)byArray2[n2]) == 15 ? string3 + "." : string3 + (char)byArray2[n2];
                    ++n2;
                }
                string2 = this.getHexDump(byArray2);
                string = string + string2;
                if (byArray2.length % 16 != 0) {
                    n2 = 0;
                    while (n2 < 16 - byArray2.length % 16) {
                        string = string + "   ";
                        ++n2;
                    }
                }
                string = string + "    " + string3;
                if (n + n3 < byArray.length) {
                    string = string + "\n";
                }
                n += n3;
            }
        }
        return string;
    }

    public void initializeLayout(KeyItem keyItem) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Container container = this.getContentPane();
        container.setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new SoftBevelBorder(1));
        jPanel.setBorder(compoundBorder);
        JLabel jLabel = new JLabel(this.title);
        Font font = new Font(Ikeyman.defaultFont.getName(), 0, Ikeyman.defaultFont.getSize() + 2);
        jLabel.setFont(font);
        jLabel.setHorizontalAlignment(0);
        jPanel.add((Component)jLabel, "Center");
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        container.add(jPanel);
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        container.add(jSeparator);
        JLabel jLabel2 = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_FIELD"));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        container.add(jLabel2);
        JScrollPane jScrollPane = new JScrollPane(this.keyInfoDetailsTree);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        container.add(jScrollPane);
        JSeparator jSeparator2 = new JSeparator();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jSeparator2, gridBagConstraints);
        container.add(jSeparator2);
        JLabel jLabel3 = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_VALUE"));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        container.add(jLabel3);
        this.keyInfoDetailsTextArea = new KeyInfoDetailsTextAreaJTextArea(8, 70);
        Font font2 = new Font(Ikeyman.defaultMonospacedFont.getName(), 0, Ikeyman.defaultMonospacedFont.getSize());
        this.keyInfoDetailsTextArea.setEditable(false);
        JScrollPane jScrollPane2 = new JScrollPane(this.keyInfoDetailsTextArea);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jScrollPane2, gridBagConstraints);
        container.add(jScrollPane2);
        JSeparator jSeparator3 = new JSeparator();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        gridBagLayout.setConstraints(jSeparator3, gridBagConstraints);
        container.add(jSeparator3);
        JPanel jPanel2 = new JPanel();
        this.okButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_OK"));
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        this.okButton.requestFocus();
        jPanel2.add(this.okButton);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        container.add(jPanel2);
        Dimension dimension = jScrollPane2.getPreferredSize();
        jScrollPane.setMinimumSize(dimension);
        jScrollPane2.setMinimumSize(dimension);
        Dimension dimension2 = container.getMinimumSize();
        dimension2.height += ((Component)this.keyInfoDetailsTextArea).getFontMetrics(font2).getHeight() * 2;
        container.setSize(dimension2);
        ((Component)this).setSize(dimension2);
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((dimension3.width - dimension2.width) / 2, (dimension3.height - dimension2.height) / 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        KeyInfoDetailsTreeNode keyInfoDetailsTreeNode;
        if (treeSelectionEvent.getSource() == this.keyInfoDetailsTree && (keyInfoDetailsTreeNode = (KeyInfoDetailsTreeNode)this.keyInfoDetailsTree.getLastSelectedPathComponent()) != null) {
            KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject = (KeyInfoDetailsTreeNodeUserObject)keyInfoDetailsTreeNode.getUserObject();
            this.keyInfoDetailsTextArea.setText(keyInfoDetailsTreeNodeUserObject.getValue());
            this.keyInfoDetailsTextArea.setCaretPosition(0);
        }
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.okButton.requestFocus();
    }

    class KeyInfoDetailsTreeNode
    extends DefaultMutableTreeNode {
        public KeyInfoDetailsTreeNode(KeyInfoDetailsTreeNodeUserObject keyInfoDetailsTreeNodeUserObject) {
            super(keyInfoDetailsTreeNodeUserObject);
        }

        public boolean isLessThan(KeyInfoDetailsTreeNode keyInfoDetailsTreeNode) {
            String string = ((KeyInfoDetailsTreeNodeUserObject)this.getUserObject()).getName().toUpperCase();
            String string2 = ((KeyInfoDetailsTreeNodeUserObject)keyInfoDetailsTreeNode.getUserObject()).getName().toUpperCase();
            if (string == null || string.length() == 0) {
                return string2 != null && string2.length() != 0;
            }
            if (string2 == null || string2.length() == 0) {
                return false;
            }
            char c = string.charAt(0);
            char c2 = string2.charAt(0);
            if (c >= '0' && c <= '9') {
                if (c2 >= '0' && c2 <= '9') {
                    return string.compareTo(string2) < 0;
                }
                return false;
            }
            if (c2 >= '0' && c2 <= '9') {
                return true;
            }
            return string.compareTo(string2) < 0;
        }

        public void sortChildren() {
            KeyInfoDetailsTreeNode[] keyInfoDetailsTreeNodeArray;
            int n = this.getChildCount();
            if (n > 1 && (keyInfoDetailsTreeNodeArray = new KeyInfoDetailsTreeNode[n]) != null) {
                int n2 = 0;
                while (n2 < n) {
                    keyInfoDetailsTreeNodeArray[n2] = (KeyInfoDetailsTreeNode)this.getChildAt(n2);
                    ++n2;
                }
                this.removeAllChildren();
                n2 = 0;
                while (n2 < n) {
                    int n3 = 0;
                    while (n3 < n2) {
                        if (keyInfoDetailsTreeNodeArray[n2].isLessThan((KeyInfoDetailsTreeNode)this.getChildAt(n3))) break;
                        ++n3;
                    }
                    this.insert(keyInfoDetailsTreeNodeArray[n2], n3);
                    ++n2;
                }
            }
        }
    }

    class KeyInfoDetailsTreeNodeUserObject {
        private String name;
        private String value;

        public KeyInfoDetailsTreeNodeUserObject(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }
    }

    class KeyInfoDetailsTree
    extends JTree {
        private KeyInfoDetailsTreeNode rootNode;

        public boolean isFocusTraversable() {
            return true;
        }

        public KeyInfoDetailsTree(KeyInfoDetailsTreeNode keyInfoDetailsTreeNode) {
            super(keyInfoDetailsTreeNode);
            this.rootNode = keyInfoDetailsTreeNode;
            this.expandAll(keyInfoDetailsTreeNode);
        }

        public void expandAll() {
            this.expandAll(this.rootNode);
        }

        private void expandAll(KeyInfoDetailsTreeNode keyInfoDetailsTreeNode) {
            if (keyInfoDetailsTreeNode != null) {
                TreePath treePath = new TreePath(keyInfoDetailsTreeNode.getPath());
                this.expandPath(treePath);
                int n = 0;
                while (n < keyInfoDetailsTreeNode.getChildCount()) {
                    this.expandAll((KeyInfoDetailsTreeNode)keyInfoDetailsTreeNode.getChildAt(n));
                    ++n;
                }
            }
        }
    }

    class KeyInfoDetailsTextAreaJTextArea
    extends JTextArea {
        KeyInfoDetailsTextAreaJTextArea(int n, int n2) {
            super(n, n2);
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }
}

