/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.Transaction;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.EnvironmentType;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.ImplFactory;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class TransactionManagerFactory {
    private static final TraceComponent tc = Tr.register((Class)TransactionManagerFactory.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static WebSphereTransactionManager _tranManager;
    private static LocalTransactionCurrent _localTranCurrent;
    private static UOWCurrent _uowCurrent;
    private static String _tmSetKey;
    private static String _ltcKey;
    private static String _class;

    private TransactionManagerFactory() {
    }

    public static WebSphereTransactionManager getTransactionManager() {
        if (_tranManager == null) {
            TransactionManagerFactory.loadImplementations();
            if (_tranManager == null) {
                throw new NoClassDefFoundError(_class);
            }
        }
        return _tranManager;
    }

    public static LocalTransactionCurrent getLocalTransactionCurrent() {
        if (_localTranCurrent == null) {
            TransactionManagerFactory.loadImplementations();
            if (_localTranCurrent == null) {
                throw new NoClassDefFoundError(_class);
            }
        }
        return _localTranCurrent;
    }

    public static UOWCurrent getUOWCurrent() {
        if (_uowCurrent == null) {
            TransactionManagerFactory.loadImplementations();
            if (_uowCurrent == null) {
                throw new NoClassDefFoundError(_class);
            }
        }
        return _uowCurrent;
    }

    private static void loadImplementations() {
        block5: {
            int n = EnvironmentType.getEnvironmentType();
            if (n == 0) {
                _tmSetKey = "com.ibm.ws.transaction.WSTxManager";
                _ltcKey = "com.ibm.ws.transaction.LocalTranCurrent";
            } else if (n == 1) {
                _tmSetKey = "com.ibm.ws.transaction.NonRecovWSTxManager";
                _ltcKey = null;
            }
            try {
                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        block7: {
                            Class clazz = null;
                            try {
                                Method method;
                                if (_tmSetKey != null) {
                                    clazz = ImplFactory.loadClassFromKey((String)_tmSetKey);
                                    method = clazz.getMethod("instance", null);
                                    _tranManager = (WebSphereTransactionManager)method.invoke(null, null);
                                    if (tc.isEventEnabled()) {
                                        Tr.event((TraceComponent)tc, (String)"Transaction manager initialized");
                                    }
                                    _uowCurrent = (UOWCurrent)((Object)_tranManager);
                                    if (tc.isEventEnabled()) {
                                        Tr.event((TraceComponent)tc, (String)"UOW Current initialized");
                                    }
                                }
                                if (_ltcKey != null) {
                                    clazz = ImplFactory.loadClassFromKey((String)_ltcKey);
                                    method = clazz.getMethod("instance", null);
                                    _localTranCurrent = (LocalTransactionCurrent)method.invoke(null, null);
                                }
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.Transaction.TransactionManagerFactry.loadImplementations", (String)"158");
                                if (tc.isEventEnabled()) {
                                    Tr.event((TraceComponent)tc, (String)"Error encountered loading implementations", (Object)throwable);
                                }
                                if (!(throwable instanceof NoClassDefFoundError)) break block7;
                                _class = throwable.getMessage();
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.Transaction.TransactionManagerFactory.loadImplementations", (String)"169");
                if (!tc.isEventEnabled()) break block5;
                Tr.event((TraceComponent)tc, (String)"PrivilegedActionException loading and initializing impls", (Object)privilegedActionException);
            }
        }
    }

    static {
        _tmSetKey = null;
        _ltcKey = null;
        _class = null;
    }
}

