/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.workarea;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.workarea.NoSuchPartitionException;
import com.ibm.websphere.workarea.PartitionAlreadyExistsException;
import com.ibm.websphere.workarea.UserWorkArea;
import com.ibm.websphere.workarea.WorkAreaInternalException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.PropertyGroupUnknownException;
import com.ibm.ws.javax.activity.ServiceAlreadyRegisteredException;
import com.ibm.ws.javax.activity.SystemException;
import com.ibm.ws.javax.activity.UserActivity;
import com.ibm.ws.javax.activity.coordination.ServiceManager;
import com.ibm.ws.naming.util.CacheableReference;
import com.ibm.ws.workarea.ContextBridge;
import com.ibm.ws.workarea.ServiceManagerImpl;
import com.ibm.ws.workarea.ServiceWithContextImpl;
import com.ibm.ws.workarea.UserWorkAreaClientImpl;
import com.ibm.ws.workarea.UserWorkAreaServerImpl;
import com.ibm.ws.workarea.WorkAreaMessages;
import com.ibm.ws.workarea.WorkAreaPartitionManager;
import com.ibm.ws.workarea.WorkAreaService;
import com.ibm.ws.workarea.WorkAreaServiceServer;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class WorkAreaPartitionManagerImpl
implements WorkAreaPartitionManager,
Referenceable {
    private static final TraceComponent _tc = Tr.register((Class)WorkAreaPartitionManagerImpl.class, null, (String)"com.ibm.ws.workarea.resources.acwa");
    private static Hashtable _partitions = null;
    private static Hashtable _partitionIDs = null;
    private static int _nextID = 0;
    private static boolean _isInitializationComplete = false;
    private static boolean isRegisteredWithAB = false;
    private static String _container = null;
    private static WorkAreaPartitionManagerImpl _workareaPartitionManagerImpl = null;
    private UserActivity currentAS = null;
    private ContextBridge currentCB = null;
    private static boolean isClientProcess = false;
    private String activityServiceUrlPackage = null;
    private static ServiceWithContextImpl _swic = null;
    private static WorkAreaServiceServer wass = null;

    private WorkAreaPartitionManagerImpl() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"WorkAreaPartitionManagerImpl");
        }
        _partitions = new Hashtable();
        _partitionIDs = new Hashtable();
        if (WorkAreaService.isClientProcess()) {
            isClientProcess = true;
            this.activityServiceUrlPackage = "services:websphere/UserActivity";
        } else {
            this.activityServiceUrlPackage = "services:websphere/ActivityManager";
            _swic = ServiceWithContextImpl.getInstance();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"WorkAreaPartitionManagerImpl");
        }
    }

    public Reference getReference() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getReference");
        }
        CacheableReference cacheableReference = new CacheableReference("com.ibm.websphere.workarea.WorkAreaPartitionManager", "com.ibm.ws.workarea.WorkAreaPartitionManagerFactory", null);
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getReference", (Object)cacheableReference);
        }
        return cacheableReference;
    }

    public static WorkAreaPartitionManagerImpl getInstance() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getInstance");
        }
        if (_workareaPartitionManagerImpl == null) {
            _workareaPartitionManagerImpl = new WorkAreaPartitionManagerImpl();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getInstance", (Object)_workareaPartitionManagerImpl);
        }
        return _workareaPartitionManagerImpl;
    }

    public UserWorkArea createWorkAreaPartition(String string, Properties properties) throws PartitionAlreadyExistsException, IllegalAccessException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)new Object[]{string, properties});
        }
        boolean bl = true;
        boolean bl2 = false;
        if (_isInitializationComplete) {
            IllegalAccessException illegalAccessException = new IllegalAccessException(WorkAreaMessages.getMsg("INF_INITIALIZATION_COMPLETE", new Object[]{WorkAreaService.getServerName(), string}));
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)illegalAccessException);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)("A user tried to create a partition after the server had been started: " + illegalAccessException));
            }
            Tr.error((TraceComponent)_tc, (String)WorkAreaMessages.getMsg("INF_INITIALIZATION_COMPLETE", new Object[]{WorkAreaService.getServerName(), string}));
            throw illegalAccessException;
        }
        if (string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(WorkAreaMessages.getMsg("ERR_INVALID_PARTITION_NAME", new Object[]{string}));
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)illegalArgumentException);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)("Null partition name was entered! " + illegalArgumentException));
            }
            Tr.error((TraceComponent)_tc, (String)"ERR_INVALID_PARTITION_NAME", (Object)string);
            throw illegalArgumentException;
        }
        if (properties == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)illegalArgumentException);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)("Null properties object was entered! " + illegalArgumentException));
            }
            throw illegalArgumentException;
        }
        boolean bl3 = _partitions.containsKey(string);
        if (bl3) {
            PartitionAlreadyExistsException partitionAlreadyExistsException = new PartitionAlreadyExistsException(WorkAreaMessages.getMsg("ERR_PARTITION_ALREADY_EXISTS", new Object[]{string}));
            Tr.error((TraceComponent)_tc, (String)"ERR_PARTITION_ALREADY_EXISTS", (Object)string);
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)partitionAlreadyExistsException);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)("Partition \"" + string + "\" already exists: " + partitionAlreadyExistsException));
            }
            throw partitionAlreadyExistsException;
        }
        Referenceable referenceable = null;
        if (!bl3) {
            block51: {
                block50: {
                    InitialContext initialContext = null;
                    try {
                        initialContext = new InitialContext();
                        this.currentAS = (UserActivity)initialContext.lookup(this.activityServiceUrlPackage);
                    }
                    catch (NamingException namingException) {
                        FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.workarea.WorkAreaPartitionManagerImpl.createWorkAreaPartition", (String)"245", (Object)this);
                        if (_tc.isEventEnabled()) {
                            Tr.event((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)namingException);
                        }
                        if (!_tc.isDebugEnabled()) break block50;
                        Tr.debug((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)"Cannot construct new InitialContext instance for services: namespace; server bringup will terminate!");
                    }
                }
                if (this.currentAS == null) {
                    WorkAreaInternalException workAreaInternalException = new WorkAreaInternalException(WorkAreaMessages.getMsg("ERR_NO_AG", new Object[]{string, WorkAreaService.getServerName()}));
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)((Object)workAreaInternalException));
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)"ActivityService reference is null.  ActivtyService could not be obtained from naming!");
                    }
                    throw workAreaInternalException;
                }
                this.remapProperties(properties);
                this.getAndSetMaxSize(string, properties, "maxSendSize");
                this.getAndSetMaxSize(string, properties, "maxReceiveSize");
                properties.setProperty("cacheable", "false");
                String string2 = (String)properties.get("Bidirectional");
                if (string2 != null) {
                    if (string2.equals("true")) {
                        properties.setProperty("marshalResponseUpdate", "true");
                        properties.setProperty("unmarshalResponseUpdate", "true");
                        bl2 = true;
                    } else {
                        properties.setProperty("marshalResponseUpdate", "false");
                        properties.setProperty("unmarshalResponseUpdate", "false");
                        bl2 = false;
                    }
                } else {
                    properties.setProperty("marshalResponseUpdate", "false");
                    properties.setProperty("unmarshalResponseUpdate", "false");
                    bl2 = false;
                }
                try {
                    ServiceManagerImpl serviceManagerImpl = new ServiceManagerImpl(string, properties, this.currentAS);
                    this.currentAS.registerService((ServiceManager)serviceManagerImpl);
                }
                catch (PropertyGroupUnknownException propertyGroupUnknownException) {
                    FFDCFilter.processException((Throwable)propertyGroupUnknownException, (String)"com.ibm.ws.workarea.WorkAreaPartitionManagerImpl.createWorkAreaPartition", (String)"289", (Object)this);
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)((Object)propertyGroupUnknownException));
                    }
                    bl = false;
                }
                catch (SystemException systemException) {
                    FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ws.workarea.WorkAreaPartitionManagerImpl.createWorkAreaPartition", (String)"296", (Object)this);
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)((Object)systemException));
                    }
                    bl = false;
                }
                catch (ServiceAlreadyRegisteredException serviceAlreadyRegisteredException) {
                    FFDCFilter.processException((Throwable)serviceAlreadyRegisteredException, (String)"com.ibm.ws.workarea.WorkAreaPartitionManagerImpl.createWorkAreaPartition", (String)"301", (Object)this);
                    if (_tc.isEventEnabled()) {
                        Tr.event((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)((Object)serviceAlreadyRegisteredException));
                    }
                    bl = false;
                }
                try {
                    this.currentAS.begin(0);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.workarea.WorkAreaPartitionManagerImpl.createWorkAreaPartition", (String)"313", (Object)this);
                    Tr.error((TraceComponent)_tc, (String)"ERR_INTRNL_EXC", (Object)new Object[]{string, WorkAreaService.getServerName()});
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)("Can't begin AS: " + exception));
                    }
                    bl = false;
                }
                if (bl) {
                    try {
                        this.currentCB = (ContextBridge)this.currentAS.getPropertyGroup(string);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.workarea.WorkAreaPartitionManagerImpl.createWorkAreaPartition", (String)"326", (Object)this);
                        Tr.error((TraceComponent)_tc, (String)"ERR_INTRNL_EXC", (Object)new Object[]{string, WorkAreaService.getServerName()});
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)("Can't get property group: " + exception));
                        }
                        bl = false;
                        try {
                            this.currentAS.complete();
                        }
                        catch (Exception exception2) {
                            FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.workarea.WorkAreaPartitionManagerImpl.createWorkAreaPartition", (String)"337", (Object)this);
                            bl = false;
                            Tr.error((TraceComponent)_tc, (String)"ERR_INTRNL_EXC", (Object)new Object[]{string, WorkAreaService.getServerName()});
                            if (!_tc.isDebugEnabled()) break block51;
                            Tr.debug((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)("Can't complete AS" + exception2));
                        }
                    }
                }
            }
            if (bl) {
                try {
                    this.currentAS.complete();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.workarea.WorkAreaPartitionManagerImpl.createWorkAreaPartition", (String)"353", (Object)this);
                    Tr.error((TraceComponent)_tc, (String)"ERR_INTRNL_EXC", (Object)new Object[]{string, WorkAreaService.getServerName()});
                    if (_tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)_tc, (String)"createWorkAreaPartition", (Object)("Can't complete AS" + exception));
                    }
                    bl = false;
                }
            }
            if (bl && !isClientProcess) {
                referenceable = new UserWorkAreaServerImpl(this.currentAS, this.currentCB, string, bl2, _nextID);
                _partitions.put(string, referenceable);
                _partitionIDs.put(string, new Integer(_nextID));
                _swic.addPartition((UserWorkAreaServerImpl)referenceable, _nextID);
                ++_nextID;
                if (!isRegisteredWithAB) {
                    isRegisteredWithAB = true;
                    wass.doAsynchBeansRegistration();
                }
            } else if (bl && isClientProcess) {
                referenceable = new UserWorkAreaClientImpl(this.currentAS, this.currentCB, string, bl2);
                _partitions.put(string, referenceable);
            }
            if (bl && string.equals(WorkAreaService.getServiceName())) {
                _partitions.put("UserWorkArea", referenceable);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)_tc, (String)"createWorkAreaPartition", referenceable);
            }
        }
        return referenceable;
    }

    public UserWorkArea getWorkAreaPartition(String string) throws NoSuchPartitionException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getWorkAreaPartition", (Object)string);
        }
        UserWorkArea userWorkArea = null;
        if (string != null) {
            userWorkArea = (UserWorkArea)_partitions.get(string);
        }
        if (userWorkArea == null) {
            NoSuchPartitionException noSuchPartitionException = new NoSuchPartitionException(WorkAreaMessages.getMsg("INF_PARTITION_DOESNT_EXISTS", new Object[]{string}));
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"getWorkAreaPartition", (Object)noSuchPartitionException);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"getWorkAreaPartition", (Object)("Partition \"" + string + "\" doesn't exists: " + noSuchPartitionException));
            }
            throw noSuchPartitionException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getWorkAreaPartition", (Object)userWorkArea);
        }
        return userWorkArea;
    }

    public int getPartitionID(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getPartitionID", (Object)string);
        }
        if (string == null) {
            NullPointerException nullPointerException = new NullPointerException();
            if (_tc.isEventEnabled()) {
                Tr.event((TraceComponent)_tc, (String)"getPartitionID", (Object)nullPointerException);
            }
            throw nullPointerException;
        }
        Integer n = (Integer)_partitionIDs.get(string);
        int n2 = n;
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getPartitionID", (Object)n.toString());
        }
        return n2;
    }

    public static void initializationComplete() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"initializationComplete");
        }
        _isInitializationComplete = true;
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"initializationComplete");
        }
    }

    private void getAndSetMaxSize(String string, Properties properties, String string2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getAndSetMaxSize", (Object)new Object[]{string, properties, string2});
        }
        if (string == null || string2 == null || properties == null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)_tc, (String)"getAndSetMaxSize");
            }
            return;
        }
        String string3 = properties.getProperty(string2);
        boolean bl = false;
        if (string3 == null) {
            string3 = WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE_STRING;
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"getAndSetMaxSize", (Object)("Setting " + string2 + " to use the default size of " + string3));
            }
        } else {
            try {
                int n = Integer.valueOf(string3);
                if (n == -1) {
                    string3 = WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE_STRING;
                } else if (n == 0) {
                    string3 = "-2";
                } else if (n < -1) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (_tc.isEventEnabled()) {
                    Tr.event((TraceComponent)_tc, (String)"getAndSetMaxSize", (Object)numberFormatException);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)"getAndSetMaxSize", (Object)("Cannot parse value " + string3 + "; will use default size of " + WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE_STRING));
                }
                if (string2.equals("maxSendSize")) {
                    Tr.error((TraceComponent)_tc, (String)WorkAreaMessages.getMsg("INF_INVALID_MAXSENDSIZE_FORMAT", new Object[]{string, string3, WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE_STRING}));
                } else if (string2.equals("maxReceiveSize")) {
                    Tr.error((TraceComponent)_tc, (String)WorkAreaMessages.getMsg("INF_INVALID_MAXRECEIVESIZE_FORMAT", new Object[]{string, string3, WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE_STRING}));
                }
                bl = true;
            }
            if (bl) {
                if (string2.equals("maxSendSize")) {
                    Tr.audit((TraceComponent)_tc, (String)"INF_INVALID_MAXSENDSIZE_FORMAT", (Object)new Object[]{string, string3, WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE_STRING});
                } else if (string2.equals("maxReceiveSize")) {
                    Tr.audit((TraceComponent)_tc, (String)"INF_INVALID_MAXRECEIVESIZE_FORMAT", (Object)new Object[]{string, string3, WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE_STRING});
                }
                string3 = WorkAreaService.DEFAULT_SEND_RECEIVE_SIZE_STRING;
            }
        }
        properties.setProperty(string2, string3);
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getAndSetMaxSize");
        }
    }

    private void remapProperties(Properties properties) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"remapProperties", (Object)properties);
        }
        if (properties.containsKey("isContextBidirectional")) {
            properties.put("Bidirectional", properties.get("isContextBidirectional"));
        }
        if (properties.containsKey("lazySerialization")) {
            properties.put("DeferredAttributeSerialization", properties.get("lazySerialization"));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"remapProperties");
        }
    }

    public void setServiceImlpRef(WorkAreaServiceServer workAreaServiceServer) {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"setServiceImlpRef", (Object)workAreaServiceServer);
        }
        wass = workAreaServiceServer;
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"setServiceImlpRef");
        }
    }
}

