/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChainGroupData;
import com.ibm.websphere.channel.framework.ChainStartMode;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.channel.framework.ChannelFactoryData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.InboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.GenericChannelData;
import com.ibm.websphere.models.config.channelservice.channels.GenericChannelFactory;
import com.ibm.websphere.models.config.channelservice.channels.GenericInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.GenericOutboundChannel;
import com.ibm.websphere.models.config.process.ProcessFactory;
import com.ibm.websphere.models.descriptor.channel.ChannelKind;
import com.ibm.ws.channel.framework.ChannelTypeManager;
import com.ibm.ws.channel.framework.impl.CFEndPointImpl;
import com.ibm.ws.channel.framework.impl.ChainDataImpl;
import com.ibm.ws.channel.framework.impl.ChainStartAlarmListener;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.ws.channel.framework.impl.OutboundVirtualConnectionFactoryImpl;
import com.ibm.ws.channel.framework.impl.WSChainData;
import com.ibm.ws.channel.framework.impl.WSVirtualConnectionFactoryImpl;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.Alias;
import com.ibm.ws.http.VirtualHost;
import com.ibm.ws.runtime.component.ChannelFrameworkServiceImpl;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.runtime.service.VirtualHostMgr;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.ws.timeutils.QuickApproxTimeA;
import com.ibm.ws.timeutils.QuickApproxTimeZ;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.ThreadPool;
import com.ibm.wsspi.channel.ChannelFactory;
import com.ibm.wsspi.channel.WSChannelFactory;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.DetailedCFEndPointCriteria;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.WSVirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChainGroupException;
import com.ibm.wsspi.channel.framework.exception.ChainNotInboundException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import com.ibm.wsspi.channel.framework.exception.IncoherentChainException;
import com.ibm.wsspi.channel.framework.exception.InvalidChannelFactoryException;
import com.ibm.wsspi.channel.framework.exception.NoCFEndPointException;
import com.ibm.wsspi.channel.framework.exception.NullCFEndPointException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class WSChannelFrameworkImpl
extends ChannelFrameworkImpl
implements ChannelFrameworkService {
    private static TraceComponent tc = Tr.register(WSChannelFrameworkImpl.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    public static final String CLASS_NAME = "com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl";
    protected int _chainNameCounter = 0;
    protected int _channelNameCounter = 0;
    protected VirtualHostMgr _virtualHostMgr;
    protected ClassLoader _loader;
    protected ChannelFrameworkServiceImpl _cfService;
    protected ChannelTypeManager _typeManager;

    public WSChannelFrameworkImpl(TransportChannelService transportChannelService, ClassLoader classLoader, ChannelFrameworkServiceImpl channelFrameworkServiceImpl, ChannelTypeManager channelTypeManager) {
        this._loader = classLoader;
        this._cfService = channelFrameworkServiceImpl;
        this._typeManager = channelTypeManager;
        if (this.currentlyOnZ()) {
            QuickApproxTimeZ quickApproxTimeZ = new QuickApproxTimeZ();
            QuickApproxTime.setRef(quickApproxTimeZ);
        } else {
            QuickApproxTimeA quickApproxTimeA = new QuickApproxTimeA();
            QuickApproxTime.setRef(quickApproxTimeA);
        }
    }

    public synchronized void clear() throws ChannelException, ChainException, ChainGroupException {
        super.clear();
        this._chainNameCounter = 0;
        this._channelNameCounter = 0;
    }

    public synchronized ChainData addChain(Chain chain) throws ChannelException, ChainException, ChainGroupException {
        Object object;
        String string = chain.getName();
        boolean bl = this.isInbound(chain);
        TransportChannel transportChannel = this.getFirstChannel(chain);
        TransportChannel transportChannel2 = this.getLastChannel(chain);
        String[] stringArray = this.getChannelNames(chain);
        boolean bl2 = true;
        boolean bl3 = true;
        String string2 = null;
        bl2 = false == chain.isSetEnable() ? true : chain.isEnable();
        if (stringArray.length == 0) {
            Tr.error(tc, "chain.channels.empty", string);
            bl3 = false;
        } else {
            if (!this.validateChainFlow(bl ? FlowType.INBOUND : FlowType.OUTBOUND, chain)) {
                Tr.error(tc, "chain.flow.mismatch", string);
                bl3 = false;
            }
            if (bl) {
                if (!this.validateChannelKind(ChannelKind.CONNECTOR_LITERAL, transportChannel)) {
                    Tr.error(tc, "chain.inbound.first.mismatch", string);
                    bl3 = false;
                }
                if (!this.validateChannelKind(ChannelKind.ACCEPTOR_LITERAL, transportChannel2)) {
                    Tr.error(tc, "chain.inbound.last.mismatch", string);
                    bl3 = false;
                }
                try {
                    object = this._typeManager.getChannelType(transportChannel2);
                    Class<?> clazz = this._loader.loadClass(((ChannelTypeManager.ChannelMetaData)object).getRuntimeClass());
                    WSChannelFactory wSChannelFactory = (WSChannelFactory)this.getChannelFactoryInternal(clazz, false);
                    string2 = wSChannelFactory.determineAcceptorID((InboundTransportChannel)transportChannel2);
                }
                catch (Exception exception) {
                    FFDCFilter.processException(exception, "com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl.addInboundChain", "229", this, new Object[]{chain});
                    Tr.error(tc, "chain.acceptor.determination.failure", string);
                    bl3 = false;
                }
            } else if (!this.validateChannelKind(ChannelKind.CONNECTOR_LITERAL, transportChannel2)) {
                Tr.error(tc, "chain.outbound.last.mismatch", string);
                bl3 = false;
            }
        }
        if (!bl3) {
            return null;
        }
        object = bl ? this.addChainInternal(string, FlowType.INBOUND, stringArray, string2, bl2) : this.addChain(string, FlowType.OUTBOUND, stringArray);
        ((WSChainData)object).setEnabled(bl2);
        return object;
    }

    public synchronized ChainData addChain(String string, FlowType flowType, String[] stringArray, String string2) throws ChannelException, ChainException, ChainGroupException {
        return this.addChainInternal(string, flowType, stringArray, string2, string2 != null);
    }

    public synchronized ChannelData addChannel(TransportChannel transportChannel) throws ChannelException, ConfigurationError {
        Map map;
        Object object;
        Class<?> clazz;
        ChannelTypeManager.ChannelMetaData channelMetaData;
        String string;
        if (transportChannel instanceof GenericInboundChannel || transportChannel instanceof GenericOutboundChannel) {
            GenericChannelData genericChannelData = (GenericChannelData)((Object)transportChannel);
            string = this._typeManager.createFullyQualifiedGenericID(genericChannelData);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "generic channel detected: " + string);
            }
            if (genericChannelData.getJarFile() == null || genericChannelData.getTypeID() == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("generic channel ");
                stringBuffer.append(transportChannel.getName());
                stringBuffer.append(" is missing jarFile and/or typeID information");
                throw new ChannelException(stringBuffer.toString());
            }
            channelMetaData = this._typeManager.getChannelType(string);
        } else {
            channelMetaData = this._typeManager.getChannelType(transportChannel);
        }
        boolean bl = transportChannel instanceof InboundTransportChannel;
        string = transportChannel.getName();
        if (channelMetaData == null) {
            Tr.error(tc, "channel.descriptor.notfound", transportChannel.getClass().getName());
            return null;
        }
        try {
            clazz = this.getLoader().loadClass(channelMetaData.getRuntimeClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("could not find factory type ");
            stringBuffer.append(channelMetaData.getRuntimeClass());
            throw new InvalidChannelFactoryException(stringBuffer.toString());
        }
        try {
            object = (WSChannelFactory)this.getChannelFactoryInternal(clazz, true);
            map = object.createChannelConfigurationMap(transportChannel, this);
        }
        catch (ClassCastException classCastException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(clazz);
            stringBuffer.append(" does not implement ");
            stringBuffer.append(WSChannelFactory.class);
            throw new InvalidChannelFactoryException(stringBuffer.toString(), classCastException);
        }
        if (bl) {
            object = (InboundTransportChannel)transportChannel;
            int n = object.isSetDiscriminationWeight() ? object.getDiscriminationWeight() : (channelMetaData.isSetDefaultWeight() ? channelMetaData.getDefaultWeight() : 0);
            return this.addChannel(string, clazz, map, n);
        }
        return this.addChannel(string, clazz, map);
    }

    public synchronized void intializeChannelFactory(TransportChannelFactory transportChannelFactory) throws ChannelFactoryException, ConfigurationError {
        ChannelTypeManager.ChannelFactoryMetaData channelFactoryMetaData;
        Object object;
        Object object2;
        if (transportChannelFactory instanceof GenericChannelFactory) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "generic channel factory detected: " + transportChannelFactory);
            }
            object2 = (GenericChannelData)((Object)transportChannelFactory);
            object = this._typeManager.createFullyQualifiedGenericID((GenericChannelData)object2);
            if (object2.getJarFile() == null || object2.getTypeID() == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("generic channel factory ");
                stringBuffer.append(transportChannelFactory.eResource().getURIFragment(transportChannelFactory));
                stringBuffer.append(" is missing jarFile and/or typeID information");
                throw new ChannelFactoryException(stringBuffer.toString());
            }
            channelFactoryMetaData = this._typeManager.getChannelFactoryType(object);
        } else {
            channelFactoryMetaData = this._typeManager.getChannelFactoryType(transportChannelFactory);
        }
        if (channelFactoryMetaData == null) {
            Tr.error(tc, "factory.descriptor.notfound", transportChannelFactory.getClass().getName());
            return;
        }
        try {
            object2 = this.getLoader().loadClass(channelFactoryMetaData.getRuntimeClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("could not find factory type ");
            stringBuffer.append(channelFactoryMetaData.getRuntimeClass());
            throw new InvalidChannelFactoryException(stringBuffer.toString());
        }
        try {
            object = (WSChannelFactory)this.getChannelFactoryInternal((Class)object2, false);
            Map map = object.createFactoryConfigurationMap(transportChannelFactory, this);
            this.initChannelFactory((Class)object2, (ChannelFactory)object, map);
        }
        catch (ClassCastException classCastException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(object2);
            stringBuffer.append(" does not implement ");
            stringBuffer.append(WSChannelFactory.class);
            throw new InvalidChannelFactoryException(stringBuffer.toString(), classCastException);
        }
    }

    public synchronized void startChainsByAcceptorID(String string) throws ChannelException, ChainException, ChainGroupException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "starting group " + string + ":", this.getChainGroup(string));
        }
        this.startChainGroup(string);
    }

    protected void retryChainStart(ChainData chainData, Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retryChainStart");
        }
        if (this.chainStartRetryAttempts != 0) {
            ((ChainDataImpl)chainData).chainStartFailed(1, this.chainStartRetryAttempts);
            Tr.error(tc, "chain.retrystart.warning", new Object[]{chainData.getName(), new Integer(this.chainStartRetryInterval), new Integer(this.chainStartRetryAttempts)});
            ChainStartAlarmListener chainStartAlarmListener = new ChainStartAlarmListener(this, chainData, this.chainStartRetryAttempts, this.chainStartRetryInterval);
            AlarmManager.createNonDeferrable(this.chainStartRetryInterval, chainStartAlarmListener);
        } else {
            ((ChainDataImpl)chainData).chainStartFailed(1, 0);
            FFDCFilter.processException(exception, "com.ibm.ws.channel.framework.impl.WSChannelFrameworkImpl.retryChainStart", "521", this, new Object[]{chainData});
            Tr.error(tc, "chain.retrystart.error", new Object[]{chainData.getName(), new Integer(1)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retryChainStart");
        }
    }

    public synchronized void startChainsByAcceptorID(String string, ChainStartMode chainStartMode) throws ChannelException, ChainException, ChainGroupException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "starting group " + string + ":", this.getChainGroup(string) + " mode:" + chainStartMode.getOrdinal());
        }
        this.startChainGroup(string, chainStartMode);
    }

    public synchronized void stopChainsByAcceptorID(String string, long l) throws ChannelException, ChainException, ChainGroupException {
        this.stopChainGroup(string, l);
    }

    public synchronized void stopChainInternal(com.ibm.ws.channel.framework.chains.Chain chain, long l) throws ChannelException, ChainException {
        super.stopChainInternal(chain, l);
        Tr.audit(tc, "chain.stopped", new Object[]{chain.getName()});
    }

    synchronized void startChainInternal(ChainData chainData) throws ChannelException, ChainException {
        super.startChainInternal(chainData);
    }

    public synchronized void startChainInternal(ChainData chainData, ChainStartMode chainStartMode) throws ChannelException, ChainException {
        super.startChainInternal(chainData, chainStartMode);
        Tr.audit(tc, "chain.started", new Object[]{chainData.getName()});
    }

    public synchronized ChainData updateChain(String string, String[] stringArray) throws ChannelException, ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateChain");
        }
        boolean bl = false;
        String string2 = null;
        WSChainData wSChainData = (WSChainData)super.getChain(string);
        if (null != wSChainData) {
            bl = wSChainData.isEnabled();
            string2 = wSChainData.getAcceptorID();
        }
        wSChainData = (WSChainData)super.updateChain(string, stringArray);
        wSChainData.setEnabled(bl);
        wSChainData.setAcceptorID(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateChain");
        }
        return wSChainData;
    }

    public synchronized CFEndPoint getEndPoint(String string) throws ChainNotInboundException, NoCFEndPointException, NullCFEndPointException {
        WSChainData wSChainData = (WSChainData)this.getChain(string);
        return wSChainData == null ? null : wSChainData.getEndPoint();
    }

    public CFEndPoint[] getEndPointsByAcceptorID(String string) {
        ChainGroupData chainGroupData = this.getChainGroup(string);
        if (chainGroupData == null) {
            return null;
        }
        ArrayList<CFEndPoint> arrayList = new ArrayList<CFEndPoint>();
        ChainData[] chainDataArray = chainGroupData.getChains();
        for (int i = 0; i < chainDataArray.length; ++i) {
            try {
                CFEndPoint cFEndPoint = this.getEndPoint(chainDataArray[i].getName());
                if (cFEndPoint == null) continue;
                arrayList.add(cFEndPoint);
                continue;
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Unavailable CFEndPoint for chain " + chainDataArray[i].getName());
            }
        }
        return arrayList.toArray(new CFEndPoint[arrayList.size()]);
    }

    public CFEndPoint[] getEndPoints(CFEndPoint[] cFEndPointArray, CFEndPointCriteria cFEndPointCriteria) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndPoints");
        }
        CFEndPoint[] cFEndPointArray2 = this.commonGetEndPoints(cFEndPointArray, cFEndPointCriteria, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndPoints");
        }
        return cFEndPointArray2;
    }

    public synchronized CFEndPoint determineBestEndPoint(CFEndPoint[] cFEndPointArray, CFEndPointCriteria cFEndPointCriteria) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "determineBestEndPoint");
        }
        CFEndPoint cFEndPoint = null;
        CFEndPoint[] cFEndPointArray2 = this.commonGetEndPoints(cFEndPointArray, cFEndPointCriteria, true);
        if (cFEndPointArray2 != null) {
            cFEndPoint = cFEndPointArray2[cFEndPointArray2.length - 1];
        }
        if (cFEndPoint != null) {
            ((CFEndPointImpl)cFEndPoint).setFramework(this);
        }
        if (tc.isDebugEnabled()) {
            if (cFEndPoint == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("CFEndPoint not found for criteria:\r\n");
                stringBuffer.append(this.getCriteriaString(cFEndPointCriteria));
                stringBuffer.append("\r\nCFEndPointArray:");
                for (int i = 0; i < cFEndPointArray.length; ++i) {
                    stringBuffer.append("\r\n");
                    stringBuffer.append(cFEndPointArray[i]);
                }
                Tr.debug(tc, stringBuffer.toString());
            } else {
                Tr.debug(tc, "Chosen CFEndPoint: " + cFEndPoint);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "determineBestEndPoint");
        }
        return cFEndPoint;
    }

    /*
     * Enabled aggressive block sorting
     */
    private synchronized CFEndPoint[] commonGetEndPoints(CFEndPoint[] cFEndPointArray, CFEndPointCriteria cFEndPointCriteria, boolean bl) {
        CFEndPoint[] cFEndPointArray2;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commonGetEndPoints", new Object[]{cFEndPointArray, cFEndPointCriteria, bl ? Boolean.TRUE : Boolean.FALSE});
        }
        if (cFEndPointArray == null || cFEndPointArray.length == 0 || cFEndPointCriteria == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commonGetEndPoints", "returns null");
            }
            return null;
        }
        CFEndPoint cFEndPoint = null;
        String string = cFEndPointCriteria.getChainName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Chain name specified in criteria: " + string);
        }
        ArrayList<CFEndPoint> arrayList = new ArrayList<CFEndPoint>();
        if (string != null) {
            for (n = 0; n < cFEndPointArray.length; ++n) {
                if (cFEndPointArray[n] == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Skipping over null end point in position " + n);
                    continue;
                }
                if (!cFEndPointArray[n].getName().equals(string)) continue;
                arrayList.add(cFEndPointArray[n]);
                if (!bl) {
                    continue;
                }
                break;
            }
        } else {
            n = cFEndPointCriteria.isSSLRequired();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Criteria specification if SSL is required: " + (n != 0));
            }
            cFEndPointArray2 = this.extractVhostFromCriteria(cFEndPointCriteria);
            for (int i = 0; i < cFEndPointArray.length; ++i) {
                cFEndPoint = cFEndPointArray[i];
                if (cFEndPoint == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Skipping over null end point in position " + i);
                    continue;
                }
                if (cFEndPoint.getChannelAccessor() == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Skipping over end point with null channel accessor, " + cFEndPoint.getName());
                    continue;
                }
                if (cFEndPointArray2 != null && !cFEndPointArray2.equals(cFEndPoint.getVhost())) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Skipping over end point with unmatching vhost, " + cFEndPoint.getVhost());
                    continue;
                }
                if (!cFEndPoint.getChannelAccessor().equals(cFEndPointCriteria.getChannelAccessor())) continue;
                if (n != 0) {
                    if (!cFEndPoint.isSSLEnabled()) continue;
                    if (arrayList.size() == 0) {
                        arrayList.add(cFEndPoint);
                        if (!cFEndPoint.isLocal() || !bl) continue;
                        break;
                    }
                    if (bl) {
                        if (!cFEndPoint.isLocal()) continue;
                        arrayList.add(cFEndPoint);
                        break;
                    } else {
                        arrayList.add(cFEndPoint);
                        continue;
                    }
                }
                if (cFEndPoint.isSSLEnabled()) continue;
                arrayList.add(cFEndPoint);
                if (!cFEndPoint.isLocal() || !bl) {
                    continue;
                }
                break;
            }
        }
        n = arrayList.size();
        cFEndPointArray2 = null;
        if (n > 0) {
            cFEndPointArray2 = new CFEndPoint[n];
            arrayList.toArray(cFEndPointArray2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commonGetEndPoints", Integer.toString(n));
        }
        return cFEndPointArray2;
    }

    private String extractVhostFromCriteria(CFEndPointCriteria cFEndPointCriteria) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractVhostFromCriteria");
        }
        String string = null;
        if (DetailedCFEndPointCriteria.class.isAssignableFrom(cFEndPointCriteria.getClass())) {
            Map map;
            DetailedCFEndPointCriteria detailedCFEndPointCriteria = (DetailedCFEndPointCriteria)cFEndPointCriteria;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found a DetailedCFEndPointCriteria, " + detailedCFEndPointCriteria);
            }
            if ((map = detailedCFEndPointCriteria.getChainProperties()) != null) {
                string = (String)map.get("vhost");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Vhost provided in criteria, " + string);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractVhostFromCriteria");
        }
        return string;
    }

    public String getVhost(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVhost");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "inputHost=" + string + ", inputPort=" + string2);
        }
        if (string == null || string2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No virtual host found for inputHost=" + string + ", inputPort=" + string2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getVhost");
            }
            return null;
        }
        String string3 = null;
        if (this._virtualHostMgr == null) {
            this._virtualHostMgr = (VirtualHostMgr)super.lookupService(VirtualHostMgr.class);
            if (null == this._virtualHostMgr) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to find VirtualHostMgr service in ChannelFramework");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getVhost");
                }
                return null;
            }
        }
        VirtualHost[] virtualHostArray = this._virtualHostMgr.getVirtualHosts();
        Alias[] aliasArray = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        block0: for (int i = 0; i < virtualHostArray.length && !bl; ++i) {
            aliasArray = virtualHostArray[i].getAliases();
            for (int j = 0; j < aliasArray.length && !bl; ++j) {
                string4 = aliasArray[j].getHostname();
                string5 = aliasArray[j].getPort();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Comparing to host=" + string4 + ", port=" + string5);
                }
                if (!string4.equals("*") && !string.equals("*") && !string4.equals(string) || !string5.equals("*") && !string2.equals("*") && !string5.equals(string2)) continue;
                bl = true;
                string3 = virtualHostArray[i].getName();
                if (!tc.isDebugEnabled()) continue block0;
                Tr.debug(tc, "Found a match, " + string3);
                continue block0;
            }
        }
        if (null == string3 && tc.isDebugEnabled()) {
            Tr.debug(tc, "Never found a match");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVhost");
        }
        return string3;
    }

    private String getCriteriaString(CFEndPointCriteria cFEndPointCriteria) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Name= ");
        stringBuffer.append(cFEndPointCriteria.getChainName());
        stringBuffer.append(" SSL=");
        stringBuffer.append(cFEndPointCriteria.isSSLRequired());
        stringBuffer.append(" Accessor=");
        stringBuffer.append(cFEndPointCriteria.getChannelAccessor());
        Class[] classArray = cFEndPointCriteria.getOptionalChannelFactories();
        if (classArray != null && classArray.length > 0) {
            stringBuffer.append(" Factories=");
            for (int i = 0; i < classArray.length; ++i) {
                stringBuffer.append(classArray[i]);
                stringBuffer.append(",");
            }
        }
        return stringBuffer.toString();
    }

    public synchronized void prepareEndPoint(CFEndPoint cFEndPoint) throws ChannelException, ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareEndPoint");
        }
        if (null == cFEndPoint) {
            throw new ChainException("Parameter is null");
        }
        WSVirtualConnectionFactory wSVirtualConnectionFactory = null;
        if (null != ((CFEndPointImpl)cFEndPoint).getOutboundChainData()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found existing outboundChainData for CFEndPoint");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Need to build outboundChainData and vcf for CFEndPoint");
            }
            OutboundChannelDefinition[] outboundChannelDefinitionArray = cFEndPoint.getOutboundChannelDefs();
            wSVirtualConnectionFactory = this.getOutboundVCFactory(outboundChannelDefinitionArray);
            cFEndPoint.setOutboundVCFactory(wSVirtualConnectionFactory);
            ((CFEndPointImpl)cFEndPoint).setOutboundChainData((WSChainData)this.getChain(wSVirtualConnectionFactory.getName()));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resulting outbound chain, " + wSVirtualConnectionFactory.getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareEndPoint");
        }
    }

    public Object lookupService(Class clazz) {
        Object object = super.lookupService(clazz);
        if (object == null && this._cfService != null) {
            object = this._cfService.getService(clazz);
        }
        return object;
    }

    public ThreadPool getDefaultThreadPool() {
        ThreadPool threadPool = null;
        ThreadPoolMgr threadPoolMgr = null;
        if (this._cfService != null) {
            threadPoolMgr = (ThreadPoolMgr)this._cfService.getService(ThreadPoolMgr.class);
            if (threadPoolMgr == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ThreadPoolMgr could not be found; using ChannelFramework default ThreadPool instead");
                }
                return super.getDefaultThreadPool();
            }
            threadPool = threadPoolMgr.getThreadPool("Default");
            if (threadPool == null) {
                Object object;
                if (tc.isDebugEnabled()) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append("could not obtain ");
                    ((StringBuffer)object).append("Default");
                    ((StringBuffer)object).append(" from the ThreadPoolManager; constructing dummy ThreadPool");
                    Tr.debug(tc, ((StringBuffer)object).toString());
                }
                object = ProcessFactory.eINSTANCE.createThreadPool();
                object.setName("Default");
                object.setMinimumSize(10);
                object.setMaximumSize(50);
                object.setIsGrowable(true);
                threadPool = threadPoolMgr.getThreadPool("Default", (com.ibm.websphere.models.config.process.ThreadPool)object);
                object = null;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Service could not be found; using ChannelFramework default ThreadPool instead");
            }
            return super.getDefaultThreadPool();
        }
        this._cfService.releaseService(threadPoolMgr);
        return threadPool;
    }

    public ThreadPool getThreadPool(String string) {
        ThreadPool threadPool;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getThreadPool");
        }
        if ((threadPool = super.getThreadPool(string)) == null) {
            if (this._cfService != null) {
                ThreadPoolMgr threadPoolMgr = (ThreadPoolMgr)this._cfService.getService(ThreadPoolMgr.class);
                if (threadPoolMgr != null) {
                    threadPool = threadPoolMgr.getThreadPool(string);
                    this._cfService.releaseService(threadPoolMgr);
                    if (tc.isDebugEnabled()) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("obtaining thread pool ");
                        stringBuffer.append(string);
                        stringBuffer.append(" from the ThreadPoolManager");
                        Tr.debug(tc, stringBuffer.toString());
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found CFService, but no pool manager.  Returning null.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CFService not found so null will be returned.");
            }
        } else if (tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("obtaining thread pool ");
            stringBuffer.append(string);
            stringBuffer.append(" from the Channel Framework ThreadPool repository");
            Tr.debug(tc, stringBuffer.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getThreadPool");
        }
        return threadPool;
    }

    protected void addChainToGroupInternal(String string, String string2) throws ChannelException, ChainException, ChainGroupException {
        ChainGroupData chainGroupData = this.getChainGroup(string);
        if (chainGroupData != null) {
            this.addChainToGroup(string, string2);
        } else {
            this.addChainGroup(string, new String[]{string2});
        }
    }

    protected void removeChainFromGroupInternal(String string, String string2) throws ChannelException, ChainException, ChainGroupException {
        this.removeChainFromGroup(string, string2);
        ChainGroupData chainGroupData = this.getChainGroup(string);
        if (chainGroupData != null && chainGroupData.getChains().length == 0) {
            this.removeChainGroup(string);
        }
    }

    protected ChainData createChainData(String string, FlowType flowType, ChannelData[] channelDataArray, ChannelFrameworkImpl channelFrameworkImpl, Map map) throws IncoherentChainException {
        return new WSChainData(string, flowType, channelDataArray, channelFrameworkImpl, map);
    }

    protected OutboundVirtualConnectionFactoryImpl createVirtualConnectionFactory(ChainData chainData, ChannelFrameworkImpl channelFrameworkImpl) throws ChannelException, ChainException {
        return new WSVirtualConnectionFactoryImpl(chainData, this);
    }

    private ClassLoader getLoader() {
        return this._loader;
    }

    private synchronized WSVirtualConnectionFactory getOutboundVCFactory(OutboundChannelDefinition[] outboundChannelDefinitionArray) throws ChainException, ChannelException {
        Object object;
        Object[] objectArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutboundVCFactory");
        }
        WSVirtualConnectionFactoryImpl wSVirtualConnectionFactoryImpl = null;
        ChainDataImpl chainDataImpl = null;
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        for (int i = 0; i < outboundChannelDefinitionArray.length; ++i) {
            n2 += outboundChannelDefinitionArray[i].getOutboundFactory().hashCode();
        }
        Iterator iterator = this.outboundVCFactories.values().iterator();
        while (iterator.hasNext()) {
            wSVirtualConnectionFactoryImpl = (WSVirtualConnectionFactoryImpl)iterator.next();
            chainDataImpl = (ChainDataImpl)wSVirtualConnectionFactoryImpl.getChain().getChainData();
            n = chainDataImpl.getChannelFactoryHash();
            if (n2 != n) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found matching hash keys");
            }
            if ((objectArray = chainDataImpl.getChannelList()).length != outboundChannelDefinitionArray.length) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found matching number of channels");
            }
            bl = true;
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                ChannelFactoryData channelFactoryData = super.getChannelFactory(object.getFactoryType());
                OutboundChannelDefinition outboundChannelDefinition = outboundChannelDefinitionArray[i];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Comparing existing def ...\n " + object.getFactoryType() + "\n" + "to new def ...\n" + outboundChannelDefinition.getOutboundFactory());
                }
                if (object.getFactoryType() == outboundChannelDefinition.getOutboundFactory() && this.propertiesIncluded(outboundChannelDefinition.getOutboundChannelProperties(), object.getPropertyBag()) && this.propertiesIncluded(outboundChannelDefinition.getOutboundFactoryProperties(), channelFactoryData.getProperties())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Keys matched, but factories didn't");
                }
                bl = false;
                break;
            }
            if (!bl) continue;
        }
        if (!bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No existing VCF, create one.");
            }
            objectArray = new String[outboundChannelDefinitionArray.length];
            object = null;
            for (int i = 0; i < outboundChannelDefinitionArray.length; ++i) {
                objectArray[i] = object = "channel_" + this._channelNameCounter++;
                this.addChannel((String)object, outboundChannelDefinitionArray[i].getOutboundFactory(), outboundChannelDefinitionArray[i].getOutboundChannelProperties());
            }
            String string = new String("chain_" + this._chainNameCounter++);
            this.addChain(string, FlowType.OUTBOUND, (String[])objectArray);
            wSVirtualConnectionFactoryImpl = (WSVirtualConnectionFactoryImpl)this.getOutboundVCFactory(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundVCFactory");
        }
        return wSVirtualConnectionFactoryImpl;
    }

    private boolean propertiesIncluded(Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propertiesIncluded");
        }
        boolean bl = true;
        if (map == null) {
            return true;
        }
        if (map2 == null) {
            return false;
        }
        Iterator iterator = map.keySet().iterator();
        Object var5_5 = null;
        Object var6_6 = null;
        Object object = null;
        while (iterator.hasNext()) {
            var5_5 = iterator.next();
            var6_6 = map.get(var5_5);
            object = map2.get(var5_5);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Comparing input=" + var6_6 + " to existing=" + object);
            }
            if (object != null && object.equals(var6_6)) continue;
            bl = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propertiesIncluded");
        }
        return bl;
    }

    private TransportChannel getFirstChannel(Chain chain) {
        if (chain == null || chain.getTransportChannels() == null || chain.getTransportChannels().isEmpty()) {
            return null;
        }
        return (TransportChannel)chain.getTransportChannels().get(0);
    }

    private TransportChannel getLastChannel(Chain chain) {
        if (chain == null || chain.getTransportChannels() == null || chain.getTransportChannels().isEmpty()) {
            return null;
        }
        EList eList = chain.getTransportChannels();
        return (TransportChannel)eList.get(eList.size() - 1);
    }

    private boolean isInbound(Chain chain) {
        TransportChannel transportChannel = this.getFirstChannel(chain);
        return transportChannel != null && transportChannel instanceof InboundTransportChannel;
    }

    private String[] getChannelNames(Chain chain) {
        if (chain == null || chain.getTransportChannels() == null) {
            return null;
        }
        String[] stringArray = new String[chain.getTransportChannels().size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((TransportChannel)chain.getTransportChannels().get(i)).getName();
        }
        return stringArray;
    }

    private FlowType getFlowType(TransportChannel transportChannel) {
        if (transportChannel == null) {
            return null;
        }
        return transportChannel instanceof InboundTransportChannel ? FlowType.INBOUND : FlowType.OUTBOUND;
    }

    private boolean validateChainFlow(FlowType flowType, Chain chain) {
        boolean bl = true;
        Iterator iterator = chain.getTransportChannels().iterator();
        while (bl && iterator.hasNext()) {
            bl = flowType == this.getFlowType((TransportChannel)iterator.next());
        }
        return bl;
    }

    private boolean validateChannelKind(ChannelKind channelKind, TransportChannel transportChannel) {
        if (transportChannel == null) {
            return false;
        }
        ChannelTypeManager.ChannelMetaData channelMetaData = this._typeManager.getChannelType(transportChannel);
        if (channelMetaData == null) {
            return false;
        }
        return channelKind == channelMetaData.getKind();
    }

    private synchronized ChainData addChainInternal(String string, FlowType flowType, String[] stringArray, String string2, boolean bl) throws ChannelException, ChainException, ChainGroupException {
        WSChainData wSChainData = (WSChainData)this.addChain(string, flowType, stringArray);
        wSChainData.setAcceptorID(string2);
        if (bl) {
            this.addChainToGroupInternal(string2, string);
            wSChainData.setEnabled(bl);
        } else {
            Tr.audit(tc, "chain.disabled", new String[]{string});
        }
        return wSChainData;
    }

    protected boolean currentlyOnZ() {
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        if (platformHelper != null) {
            return platformHelper.isZOS();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PlatformHelperFactory.getPlatformHelper() returned NULL!");
        }
        return false;
    }

    protected int currentZRegion() {
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        if (platformHelper != null) {
            if (PlatformHelperFactory.getPlatformHelper().isBaseServantJvm()) {
                return 8;
            }
            if (PlatformHelperFactory.getPlatformHelper().isControlJvm()) {
                return 2;
            }
            if (PlatformHelperFactory.getPlatformHelper().isCRAJvm()) {
                return 4;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not on SR, CR, CRA Z region");
            }
            return 16;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PlatformHelperFactory.getPlatformHelper() returned NULL!");
        }
        RuntimeException runtimeException = new RuntimeException("Can not determine Z region");
        throw runtimeException;
    }

    protected ChainDataImpl createOutboundChain(CFEndPointImpl cFEndPointImpl) throws ChannelException, ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createOutboundChain");
        }
        OutboundChannelDefinition[] outboundChannelDefinitionArray = cFEndPointImpl.getOutboundChannelDefs();
        ChainDataImpl chainDataImpl = null;
        String[] stringArray = new String[outboundChannelDefinitionArray.length];
        String string = null;
        for (int i = 0; i < outboundChannelDefinitionArray.length; ++i) {
            stringArray[i] = string = "channel_" + this._channelNameCounter++;
            this.addChannel(string, outboundChannelDefinitionArray[i].getOutboundFactory(), outboundChannelDefinitionArray[i].getOutboundChannelProperties());
        }
        String string2 = new String("chain_" + this._chainNameCounter++);
        chainDataImpl = (ChainDataImpl)this.addChain(string2, FlowType.OUTBOUND, stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createOutboundChain");
        }
        return chainDataImpl;
    }

    public void setChainEnabled(String string, boolean bl) {
        WSChainData wSChainData = (WSChainData)this.getChain(string);
        if (null != wSChainData) {
            wSChainData.setEnabled(bl);
        }
    }
}

