/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.channel.framework.chains.Chain;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.ws.channel.framework.impl.OutboundVirtualConnectionImpl;
import com.ibm.ws.channel.framework.impl.RuntimeState;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.OutboundConnectionLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.InvalidChainNameException;

public class OutboundVirtualConnectionFactoryImpl
implements VirtualConnectionFactory {
    private static final TraceComponent tc = Tr.register(OutboundVirtualConnectionFactoryImpl.class, "ChannelFramework", "com.ibm.ws.channel.resources.channelframeworkservice");
    protected ChannelFrameworkImpl cf = null;
    protected int refCount = 0;
    protected String name = null;
    protected Chain outboundChain = null;
    protected Channel[] chans = null;

    public OutboundVirtualConnectionFactoryImpl(ChainData chainData, ChannelFrameworkImpl channelFrameworkImpl) throws ChannelException, ChainException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor");
        }
        this.name = chainData.getName();
        this.refCount = 1;
        this.cf = channelFrameworkImpl;
        this.cf.initChainInternal(chainData);
        this.outboundChain = this.cf.getRunningChain(this.name);
        if (this.outboundChain == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "constructor");
            }
            throw new InvalidChainNameException("Invalid chain when trying to access via the channel framework");
        }
        this.chans = this.outboundChain.getChannels();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    public VirtualConnection createConnection() throws ChannelException, ChainException {
        OutboundVirtualConnectionImpl outboundVirtualConnectionImpl = this.createNewConnection();
        if (this.outboundChain.getState() != RuntimeState.STARTED) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Starting outbound chain, " + this.name);
            }
            this.cf.startChainInternal(this.outboundChain.getChainData());
            this.outboundChain = this.cf.getRunningChain(this.name);
            if (this.refCount == 0) {
                this.refCount = 1;
            }
        }
        ConnectionLink[] connectionLinkArray = new ConnectionLink[this.chans.length];
        connectionLinkArray[0] = this.chans[0].getConnectionLink(outboundVirtualConnectionImpl);
        for (int i = 1; i < this.chans.length; ++i) {
            try {
                connectionLinkArray[i] = this.chans[i].getConnectionLink(outboundVirtualConnectionImpl);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.channel.framework.impl.OutboundVirtualConnectionImpl.createConnection", "125", new Object[]{this, this.chans[i]});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error getting con link from " + this.chans[i].getName() + ", " + exception.getMessage());
                }
                throw new ChannelException(exception.getMessage());
            }
            connectionLinkArray[i - 1].setDeviceLink(connectionLinkArray[i]);
            connectionLinkArray[i].setApplicationCallback(connectionLinkArray[i - 1]);
        }
        outboundVirtualConnectionImpl.setConnectionLink((OutboundConnectionLink)connectionLinkArray[0]);
        return outboundVirtualConnectionImpl;
    }

    private OutboundVirtualConnectionImpl createNewConnection() {
        return new OutboundVirtualConnectionImpl();
    }

    public synchronized void incrementRefCount() {
        ++this.refCount;
    }

    public synchronized void decrementRefCount() {
        --this.refCount;
    }

    public synchronized void destroy() throws ChainException, ChannelException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        if (this.refCount == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Virtual connection factory already destroyed");
            }
            throw new ChainException("Virtual connection factory already destroyed");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "outbound VCF");
        }
        this.decrementRefCount();
        if (0 == this.refCount) {
            if (this.outboundChain.getState() == RuntimeState.STARTED) {
                this.cf.stopChainInternal(this.outboundChain, 0L);
            }
            this.cf.destroyChainInternal(this.outboundChain);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public synchronized void destroyInternal() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroyInternal");
        }
        try {
            this.cf.stopChainInternal(this.outboundChain, 0L);
            this.cf.destroyChainInternal(this.outboundChain);
        }
        catch (ChannelException channelException) {
        }
        catch (ChainException chainException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroyInternal");
        }
    }

    public FlowType getType() {
        return FlowType.OUTBOUND;
    }

    public String getName() {
        return this.name;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public Chain getChain() {
        return this.outboundChain;
    }

    public String toString() {
        return "Outbound VCF: chain = " + this.name + ", refCount = " + this.refCount;
    }
}

