/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.ctm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.j2ee.commonarchivecore.exception.OpenFailureException;
import com.ibm.etools.j2ee.commonarchivecore.exception.ResourceLoadException;
import com.ibm.websphere.models.config.channelservice.channels.GenericChannelData;
import com.ibm.websphere.models.config.channelservice.channels.GenericChannelFactory;
import com.ibm.websphere.models.config.channelservice.channels.GenericInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.GenericOutboundChannel;
import com.ibm.websphere.models.descriptor.channel.ChannelFactoryType;
import com.ibm.websphere.models.descriptor.channel.ChannelType;
import com.ibm.websphere.models.descriptor.channel.impl.ChannelPackageImpl;
import com.ibm.ws.channel.framework.ChannelTypeManager;
import com.ibm.wsspi.channel.framework.exception.ChannelJARAlreadyLoadedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;

public abstract class BaseChannelTypeManager
implements ChannelTypeManager {
    private static TraceComponent tc = Tr.register(BaseChannelTypeManager.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    protected Set _jarSet;
    protected Map _typeMap = new HashMap();

    public BaseChannelTypeManager() {
        this._jarSet = new HashSet();
        ChannelPackageImpl.init();
        ArchiveInit.init();
    }

    public ChannelTypeManager.ChannelMetaData getChannelType(Object object) {
        try {
            return (ChannelTypeManager.ChannelMetaData)this.getTypeMetaData(object);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public ChannelTypeManager.ChannelFactoryMetaData getChannelFactoryType(Object object) {
        try {
            return (ChannelTypeManager.ChannelFactoryMetaData)this.getTypeMetaData(object);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public String createFullyQualifiedGenericID(GenericChannelData genericChannelData) {
        return BaseChannelTypeManager.createFullyQualifiedGenericID(genericChannelData.getJarFile(), genericChannelData.getTypeID());
    }

    protected Object getTypeMetaData(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return this._typeMap.get(object);
        }
        if (object instanceof Class) {
            Object object2 = this._typeMap.get(object);
            if (object2 == null) {
                Class clazz = (Class)object;
                object2 = this.getTypeMetaData(clazz.getName());
                if (object2 == null) {
                    Class<?>[] classArray = clazz.getInterfaces();
                    for (int i = 0; i < classArray.length && object2 == null; ++i) {
                        object2 = this.getTypeMetaData(classArray[i]);
                    }
                }
                if (object2 == null) {
                    object2 = this.getTypeMetaData(clazz.getSuperclass());
                }
                this._typeMap.put(object, object2);
            }
            return object2;
        }
        Object object3 = object instanceof GenericChannelData ? this.getTypeMetaData(this.createFullyQualifiedGenericID((GenericChannelData)object)) : this.getTypeMetaData(object.getClass());
        if (object3 == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "could not find channel or channel factory metadata for " + object);
        }
        return object3;
    }

    protected boolean loadChannelJARs(File[] fileArray) {
        boolean bl = true;
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                bl &= this.loadChannelJAR(fileArray[i]);
                continue;
            }
            catch (ChannelJARAlreadyLoadedException channelJARAlreadyLoadedException) {
                Tr.error(tc, "channel.jar.already.loaded", channelJARAlreadyLoadedException.getOffendingFile().getAbsolutePath());
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadChannelJAR(File file) throws ChannelJARAlreadyLoadedException {
        boolean bl = false;
        if (file == null) {
            return bl;
        }
        if (this._jarSet.contains(file)) {
            throw new ChannelJARAlreadyLoadedException(file);
        }
        Archive archive = null;
        try {
            archive = CommonarchiveFactoryImpl.getActiveFactory().openArchive(file.getAbsolutePath());
            Resource resource = archive.getMofResource("META-INF/ws-channel.xmi");
            Iterator iterator = resource.getContents().iterator();
            while (iterator.hasNext()) {
                ChannelTypeManager.ChannelFactoryMetaData channelFactoryMetaData;
                Object e = iterator.next();
                if (e instanceof ChannelType) {
                    ChannelTypeManager.ChannelMetaData channelMetaData = new ChannelTypeManager.ChannelMetaData(file, (ChannelType)e);
                    if (!this.validate(file, channelMetaData)) continue;
                    this.addChannelMetaData(channelMetaData);
                    continue;
                }
                if (!(e instanceof ChannelFactoryType) || !this.validate(file, channelFactoryMetaData = new ChannelTypeManager.ChannelFactoryMetaData(file, (ChannelFactoryType)e))) continue;
                this.addChannelFactoryMetaData(channelFactoryMetaData);
            }
            this._jarSet.add(file);
            bl = true;
        }
        catch (OpenFailureException openFailureException) {
            Tr.error(tc, "channel.jar.open.failure", new Object[]{file, openFailureException});
        }
        catch (FileNotFoundException fileNotFoundException) {
            Tr.debug(tc, "Channel implementation {0} does not have a channel descriptor.", file);
            bl = true;
        }
        catch (ResourceLoadException resourceLoadException) {
            Tr.error(tc, "channel.descriptor.parse.failure", new Object[]{file, resourceLoadException});
        }
        finally {
            if (archive != null) {
                archive.close();
            }
        }
        return bl;
    }

    protected void addChannelMetaData(ChannelTypeManager.ChannelMetaData channelMetaData) {
        String string = channelMetaData.getConfigurationClass();
        if (this.checkGeneric(string)) {
            string = BaseChannelTypeManager.createFullyQualifiedGenericID(channelMetaData.getJARFile(), channelMetaData.getTypeID());
        }
        if (tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("associating ");
            stringBuffer.append(string);
            stringBuffer.append('/');
            stringBuffer.append(channelMetaData);
            Tr.debug(tc, stringBuffer.toString());
        }
        this._typeMap.put(string, channelMetaData);
    }

    protected void addChannelFactoryMetaData(ChannelTypeManager.ChannelFactoryMetaData channelFactoryMetaData) {
        String string = channelFactoryMetaData.getConfigurationClass();
        if (this.checkGeneric(string)) {
            string = BaseChannelTypeManager.createFullyQualifiedGenericID(channelFactoryMetaData.getJARFile(), channelFactoryMetaData.getTypeID());
        }
        if (tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("associating ");
            stringBuffer.append(string);
            stringBuffer.append('/');
            stringBuffer.append(channelFactoryMetaData);
            Tr.debug(tc, stringBuffer.toString());
        }
        this._typeMap.put(string, channelFactoryMetaData);
    }

    protected boolean checkGeneric(String string) {
        return string.equals(GenericInboundChannel.class.getName()) || string.equals(GenericOutboundChannel.class.getName()) || string.equals(GenericChannelFactory.class.getName());
    }

    protected boolean validate(File file, ChannelTypeManager.ChannelMetaData channelMetaData) {
        boolean bl = true;
        if (channelMetaData.getRuntimeClass() == null) {
            Tr.error(tc, "channel.descriptor.factory.missing", file);
            bl = false;
        }
        if (channelMetaData.getConfigurationClass() == null) {
            Tr.error(tc, "channel.descriptor.channel.missing", file);
            bl = false;
        }
        if (channelMetaData.getApplicationInterface() == null && channelMetaData.getDeviceInterface().isEmpty()) {
            Tr.error(tc, "channel.descriptor.interfaces.missing", file);
            bl = false;
        }
        if (channelMetaData.isSetDefaultWeight() && channelMetaData.getDefaultWeight() < 0) {
            Tr.error(tc, "channel.descriptor.weight.invalid", new Object[]{file, new Integer(channelMetaData.getDefaultWeight())});
            bl = false;
        }
        return bl;
    }

    protected boolean validate(File file, ChannelTypeManager.ChannelFactoryMetaData channelFactoryMetaData) {
        boolean bl = true;
        if (channelFactoryMetaData.getRuntimeClass() == null) {
            Tr.error(tc, "channel.descriptor.factory.missing", file);
            bl = false;
        }
        if (channelFactoryMetaData.getConfigurationClass() == null) {
            Tr.error(tc, "channel.descriptor.channel.config.missing", file);
            bl = false;
        }
        return bl;
    }

    protected static String createFullyQualifiedGenericID(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append('#');
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }
}

