/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.ws.channel.commands.CFCommand;
import com.ibm.ws.channel.commands.CFCommandUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;

public class ListChainTemplatesCommand
extends CFCommand {
    private static TraceComponent tc = CFCommandUtils.register(ListChainTemplatesCommand.class);

    public ListChainTemplatesCommand(CommandMetadata commandMetadata) {
        super(commandMetadata);
    }

    public ListChainTemplatesCommand(CommandData commandData) throws CommandNotFoundException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        super.validate();
        String string = (String)this.getParameter("acceptorFilter");
        if (string != null) {
            try {
                this.getConfigService().getAttributesMetaInfo(string);
            }
            catch (Exception exception) {
                throw new InvalidParameterValueException(this.getName(), "acceptorFilter", string);
            }
        }
    }

    public void execute() {
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        try {
            this.validate();
            List list = this.getAllChainTemplates();
            String string = (String)this.getParameter("acceptorFilter");
            if (string != null) {
                list = this.filterChains(list, string, null);
            }
            commandResultImpl.setResult(list);
        }
        catch (Exception exception) {
            commandResultImpl.setException(exception);
        }
        this.setCommandResult(commandResultImpl);
    }

    protected List getAllChainTemplates() throws Exception {
        ConfigService configService = this.getConfigService();
        Session session = this.getConfigSession();
        return this.hackFilter(Arrays.asList(configService.queryTemplates(session, "Chain")));
    }

    protected List hackFilter(List list) throws Exception {
        ArrayList arrayList = new ArrayList(list);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ObjectName objectName = (ObjectName)iterator.next();
            String string = objectName.toString();
            if ((string = string.replace('\\', '/')).indexOf("templates/chains") >= 0) continue;
            if (tc.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("removing ");
                stringBuffer.append(objectName);
                stringBuffer.append(" because it is not parented by the proper context");
                Tr.debug(tc, stringBuffer.toString());
            }
            iterator.remove();
        }
        return arrayList;
    }
}

