/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.commands;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.channel.commands.CFCommandUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public abstract class CFCommand
extends AbstractAdminCommand {
    private static TraceComponent tc = CFCommandUtils.register(CFCommand.class);

    public CFCommand(CommandMetadata commandMetadata) {
        super(commandMetadata);
    }

    public CFCommand(CommandData commandData) throws CommandNotFoundException {
        super(commandData);
    }

    protected ConfigService getConfigService() {
        return CommandMgr.getCommandMgr().getCommandProviderHelper().getConfigService();
    }

    protected String determineType(ObjectName objectName) throws ConfigServiceException, ConnectorException, AttributeNotFoundException {
        Object object;
        String string = ConfigServiceHelper.getConfigDataType(objectName);
        if (string == null) {
            Session session;
            ObjectName[] objectNameArray;
            if (tc.isDebugEnabled()) {
                object = new StringBuffer();
                ((StringBuffer)object).append("could not get type information for ");
                ((StringBuffer)object).append(CFCommand.convertON(objectName));
                ((StringBuffer)object).append(", attempting to resolve against ConfigService");
                Tr.debug(tc, ((StringBuffer)object).toString());
            }
            if ((objectNameArray = (object = this.getConfigService()).queryConfigObjects(session = this.getConfigSession(), null, objectName, null)) != null && objectNameArray.length == 1) {
                string = ConfigServiceHelper.getConfigDataType(objectNameArray[0]);
            }
            if (string == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting type information from attributes");
                }
                AttributeList attributeList = object.getAttributes(session, objectName, null, false);
                string = (String)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Type");
            }
        }
        if (tc.isDebugEnabled()) {
            object = new StringBuffer();
            ((StringBuffer)object).append("type information for ");
            ((StringBuffer)object).append(CFCommand.convertON(objectName));
            if (string == null) {
                ((StringBuffer)object).append(" could not be determined");
            } else {
                ((StringBuffer)object).append(" determined to be ");
                ((StringBuffer)object).append(string);
            }
            Tr.debug(tc, ((StringBuffer)object).toString());
        }
        return string;
    }

    protected boolean checkType(ObjectName objectName, String string, boolean bl) throws ConfigServiceException, AttributeNotFoundException, ConnectorException {
        return this.checkType(objectName, new String[]{string}, bl);
    }

    protected boolean checkType(ObjectName objectName, String[] stringArray, boolean bl) throws ConfigServiceException, AttributeNotFoundException, ConnectorException {
        String string = this.determineType(objectName);
        if (string == null) {
            return bl;
        }
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    protected List filterChains(List list, String string, String string2) throws Exception {
        ConfigService configService = this.getConfigService();
        Session session = this.getConfigSession();
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string3;
            CharSequence charSequence;
            ObjectName objectName = (ObjectName)iterator.next();
            List list2 = (List)configService.getAttribute(session, objectName, "transportChannels", false);
            if (list2 == null || list2.isEmpty()) {
                if (!tc.isDebugEnabled()) continue;
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("removing ");
                ((StringBuffer)charSequence).append(CFCommand.convertON(objectName));
                ((StringBuffer)charSequence).append(" because it has no channels");
                Tr.debug(tc, ((StringBuffer)charSequence).toString());
                continue;
            }
            if (string != null && !string.equals(string3 = this.determineType((ObjectName)list2.get(list2.size() - 1)))) {
                if (!tc.isDebugEnabled()) continue;
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("removing ");
                ((StringBuffer)charSequence).append(CFCommand.convertON(objectName));
                ((StringBuffer)charSequence).append(" because its last channel is of type <");
                ((StringBuffer)charSequence).append(string3);
                ((StringBuffer)charSequence).append("> instead of the required <");
                ((StringBuffer)charSequence).append(string);
                ((StringBuffer)charSequence).append(">");
                Tr.debug(tc, ((StringBuffer)charSequence).toString());
                continue;
            }
            if (string2 != null) {
                string3 = this.determineType((ObjectName)list2.get(0));
                if (string3 == null || !string3.equals("TCPInboundChannel")) {
                    if (!tc.isDebugEnabled()) continue;
                    charSequence = new StringBuffer();
                    ((StringBuffer)charSequence).append("removing ");
                    ((StringBuffer)charSequence).append(CFCommand.convertON(objectName));
                    ((StringBuffer)charSequence).append(" because its first channel is of type <");
                    ((StringBuffer)charSequence).append(string3);
                    ((StringBuffer)charSequence).append("> instead of the required <TCPInboundChannel>");
                    Tr.debug(tc, ((StringBuffer)charSequence).toString());
                    continue;
                }
                charSequence = (String)configService.getAttribute(session, (ObjectName)list2.get(0), "endPointName");
                if (charSequence == null || !((String)charSequence).equals(string2)) {
                    if (!tc.isDebugEnabled()) continue;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("removing ");
                    stringBuffer.append(CFCommand.convertON(objectName));
                    stringBuffer.append(" because its TCPInboundChannel's endPointName <");
                    stringBuffer.append((String)charSequence);
                    stringBuffer.append("> does not match the required <");
                    stringBuffer.append(string2);
                    stringBuffer.append('>');
                    Tr.debug(tc, stringBuffer.toString());
                    continue;
                }
            }
            arrayList.add(objectName);
        }
        return arrayList;
    }

    protected static String convertON(ObjectName objectName) {
        if (objectName == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = objectName.getKeyProperty("_Websphere_Config_Data_Display_Name");
        String string2 = objectName.getKeyProperty("_Websphere_Config_Data_Id");
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append('(');
        stringBuffer.append(string2);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

