/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.html.HtmlSelectManyListbox;
import javax.faces.component.html.HtmlSelectManyMenu;
import javax.faces.component.html.HtmlSelectOneListbox;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;

public class MenuRenderer
extends HtmlBasicInputRenderer {
    private static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.renderkit.html_basic.MenuRenderer";

    public void decode(FacesContext facesContext, UIComponent uIComponent) {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "decode", "Begin decoding component " + uIComponent.getId());
        }
        boolean bl = false;
        if (uIComponent instanceof HtmlSelectOneMenu) {
            bl = ((HtmlSelectOneMenu)uIComponent).isDisabled();
            if (!bl) {
                bl = ((HtmlSelectOneMenu)uIComponent).isReadonly();
            }
        } else if (uIComponent instanceof HtmlSelectOneListbox) {
            bl = ((HtmlSelectOneListbox)uIComponent).isDisabled();
            if (!bl) {
                bl = ((HtmlSelectOneListbox)uIComponent).isReadonly();
            }
        } else if (uIComponent instanceof HtmlSelectManyMenu) {
            bl = ((HtmlSelectManyMenu)uIComponent).isDisabled();
            if (!bl) {
                bl = ((HtmlSelectManyMenu)uIComponent).isReadonly();
            }
        } else if (uIComponent instanceof HtmlSelectManyListbox) {
            bl = ((HtmlSelectManyListbox)uIComponent).isDisabled();
            if (!bl) {
                bl = ((HtmlSelectManyListbox)uIComponent).isReadonly();
            }
        } else {
            bl = Util.componentIsDisabledOnReadonly(uIComponent);
        }
        if (bl) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "decode", "No decoding necessary since the component " + uIComponent.getId() + " is disabled");
            }
            return;
        }
        String string = uIComponent.getClientId(facesContext);
        Util.doAssert(string != null);
        if (uIComponent instanceof UISelectMany) {
            Map map = facesContext.getExternalContext().getRequestParameterValuesMap();
            if (map.containsKey(string)) {
                String[] stringArray = (String[])map.get(string);
                this.setSubmittedValue(uIComponent, stringArray);
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "decode", "submitted values for UISelectMany component " + uIComponent.getId() + " after decoding " + stringArray);
                }
            } else {
                this.setSubmittedValue(uIComponent, new String[0]);
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "decode", "Set empty array for UISelectMany component " + uIComponent.getId() + " after decoding ");
                }
            }
        } else {
            Map map = facesContext.getExternalContext().getRequestParameterMap();
            if (map.containsKey(string)) {
                String string2;
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "decode", "found clientId in request parameter map");
                }
                if ((string2 = (String)map.get(string)) != null) {
                    this.setSubmittedValue(uIComponent, string2);
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "decode", "submitted value for UISelectOne component " + uIComponent.getId() + " after decoding " + string2);
                    }
                } else if (((UIInput)uIComponent).isRequired()) {
                    this.setSubmittedValue(uIComponent, "");
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "decode", "submitted required value for UISelectOne component " + uIComponent.getId() + " after decoding to empty string");
                    }
                }
            } else if (((UIInput)uIComponent).isRequired()) {
                this.setSubmittedValue(uIComponent, "");
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "decode", "submitted required value for UISelectOne component " + uIComponent.getId() + " after decoding to empty string");
                }
            }
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uIComponent, Object object) throws ConverterException {
        if (uIComponent instanceof UISelectMany) {
            return this.convertSelectManyValue(facesContext, (UISelectMany)uIComponent, (String[])object);
        }
        return this.convertSelectOneValue(facesContext, (UISelectOne)uIComponent, (String)object);
    }

    public Object convertSelectOneValue(FacesContext facesContext, UISelectOne uISelectOne, String string) throws ConverterException {
        Object object = null;
        if (string == null) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "convertSelectOneValue", "No conversion necessary for SelectOne Component  " + uISelectOne.getId() + " since the new value is null ");
            }
            return null;
        }
        object = super.getConvertedValue(facesContext, (UIComponent)uISelectOne, string);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "convertSelectOneValue", "SelectOne Component  " + uISelectOne.getId() + " convertedValue " + object);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object convertSelectManyValue(FacesContext facesContext, UISelectMany uISelectMany, String[] stringArray) throws ConverterException {
        void var5_9;
        ValueBinding valueBinding = uISelectMany.getValueBinding("value");
        String[] stringArray2 = stringArray;
        Class clazz = null;
        if (null != valueBinding) {
            clazz = valueBinding.getType(facesContext);
            if (null == clazz) throw new ConverterException(Util.getExceptionMessageString("com.sun.faces.TYPECONVERSION_ERROR"));
            if (clazz.isArray()) {
                Object object = this.handleArrayCase(facesContext, uISelectMany, clazz, stringArray);
            } else {
                if (!List.class.isAssignableFrom(clazz)) throw new ConverterException(Util.getExceptionMessageString("com.sun.faces.TYPECONVERSION_ERROR"));
                Object object = this.handleListCase(facesContext, stringArray);
            }
        } else {
            Object[] objectArray = new Object[1];
            Object object = this.handleArrayCase(facesContext, uISelectMany, objectArray.getClass(), stringArray);
        }
        if (!log.isLoggable(Level.FINE)) return var5_9;
        log.logp(Level.FINE, CLASS_NAME, "convertSelectManyValue", "SelectMany Component  " + uISelectMany.getId() + " convertedValues " + var5_9);
        return var5_9;
    }

    protected Object handleArrayCase(FacesContext facesContext, UISelectMany uISelectMany, Class clazz, String[] stringArray) throws ConverterException {
        Object object = null;
        Class<?> clazz2 = null;
        Converter converter = null;
        int n = 0;
        int n2 = null != stringArray ? stringArray.length : 0;
        clazz2 = clazz.getComponentType();
        if (clazz2.equals(String.class)) {
            return stringArray;
        }
        try {
            object = Array.newInstance(clazz2, n2);
        }
        catch (Exception exception) {
            throw new ConverterException((Throwable)exception);
        }
        if (null == stringArray) {
            return object;
        }
        converter = uISelectMany.getConverter();
        if (null == converter && null == (converter = Util.getConverterForClass(clazz2))) {
            if (clazz2.equals(Object.class)) {
                return stringArray;
            }
            throw new ConverterException("null Converter");
        }
        Util.doAssert(null != object);
        if (clazz2.isPrimitive()) {
            for (n = 0; n < n2; ++n) {
                if (clazz2.equals(Boolean.TYPE)) {
                    Array.setBoolean(object, n, (Boolean)converter.getAsObject(facesContext, (UIComponent)uISelectMany, stringArray[n]));
                    continue;
                }
                if (clazz2.equals(Byte.TYPE)) {
                    Array.setByte(object, n, (Byte)converter.getAsObject(facesContext, (UIComponent)uISelectMany, stringArray[n]));
                    continue;
                }
                if (clazz2.equals(Double.TYPE)) {
                    Array.setDouble(object, n, (Double)converter.getAsObject(facesContext, (UIComponent)uISelectMany, stringArray[n]));
                    continue;
                }
                if (clazz2.equals(Float.TYPE)) {
                    Array.setFloat(object, n, ((Float)converter.getAsObject(facesContext, (UIComponent)uISelectMany, stringArray[n])).floatValue());
                    continue;
                }
                if (clazz2.equals(Integer.TYPE)) {
                    Array.setInt(object, n, (Integer)converter.getAsObject(facesContext, (UIComponent)uISelectMany, stringArray[n]));
                    continue;
                }
                if (clazz2.equals(Character.TYPE)) {
                    Array.setChar(object, n, ((Character)converter.getAsObject(facesContext, (UIComponent)uISelectMany, stringArray[n])).charValue());
                    continue;
                }
                if (clazz2.equals(Short.TYPE)) {
                    Array.setShort(object, n, (Short)converter.getAsObject(facesContext, (UIComponent)uISelectMany, stringArray[n]));
                    continue;
                }
                if (!clazz2.equals(Long.TYPE)) continue;
                Array.setLong(object, n, (Long)converter.getAsObject(facesContext, (UIComponent)uISelectMany, stringArray[n]));
            }
        } else {
            for (n = 0; n < n2; ++n) {
                if (log.isLoggable(Level.FINE)) {
                    Object object2 = converter.getAsObject(facesContext, (UIComponent)uISelectMany, stringArray[n]);
                    log.logp(Level.FINE, CLASS_NAME, "handleArrayCase", "String value: " + stringArray[n] + " converts to : " + object2.toString());
                }
                Array.set(object, n, converter.getAsObject(facesContext, (UIComponent)uISelectMany, stringArray[n]));
            }
        }
        return object;
    }

    protected Object handleListCase(FacesContext facesContext, String[] stringArray) {
        int n = 0;
        int n2 = stringArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (n = 0; n < n2; ++n) {
            arrayList.add(stringArray[n]);
        }
        return arrayList;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "encodeEnd", "Begin encoding component " + uIComponent.getId());
        }
        if (!uIComponent.isRendered()) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "encodeEnd", "End encoding component " + uIComponent.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Util.doAssert(responseWriter != null);
        this.renderSelect(facesContext, uIComponent);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "encodeEnd", "End encoding component " + uIComponent.getId());
        }
    }

    void renderSelect(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        Object v;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Util.doAssert(responseWriter != null);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "renderSelect", "Rendering 'select'");
        }
        responseWriter.startElement("select", uIComponent);
        this.writeIdAttributeIfNecessary(facesContext, responseWriter, uIComponent);
        responseWriter.writeAttribute("name", (Object)uIComponent.getClientId(facesContext), "clientId");
        if (!this.getMultipleText(uIComponent).equals("")) {
            responseWriter.writeAttribute("multiple", (Object)Boolean.TRUE, null);
        }
        String string = null;
        string = uIComponent instanceof HtmlSelectOneMenu ? ((HtmlSelectOneMenu)uIComponent).getStyleClass() : (uIComponent instanceof HtmlSelectOneListbox ? ((HtmlSelectOneListbox)uIComponent).getStyleClass() : (uIComponent instanceof HtmlSelectManyMenu ? ((HtmlSelectManyMenu)uIComponent).getStyleClass() : (uIComponent instanceof HtmlSelectManyListbox ? ((HtmlSelectManyListbox)uIComponent).getStyleClass() : (String)uIComponent.getAttributes().get("styleClass"))));
        if (null != string) {
            responseWriter.writeAttribute("class", (Object)string, "styleClass");
        }
        int n = this.getOptionNumber(facesContext, uIComponent);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "renderSelect", "Rendering " + n + " options");
        }
        if (null == (v = uIComponent.getAttributes().get("size")) || v instanceof Integer && (Integer)v == Integer.MIN_VALUE) {
            this.writeDefaultSize(responseWriter, n);
        }
        if (uIComponent instanceof HtmlSelectOneMenu) {
            this.renderPassthrusForSelectOneMenu(facesContext, uIComponent);
        } else if (uIComponent instanceof HtmlSelectOneListbox) {
            this.renderPassthrusForSelectOneListBox(facesContext, uIComponent);
        } else if (uIComponent instanceof HtmlSelectManyMenu) {
            this.renderPassthrusForSelectManyMenu(facesContext, uIComponent);
        } else if (uIComponent instanceof HtmlSelectManyListbox) {
            this.renderPassthrusForSelectManyListBox(facesContext, uIComponent);
        } else {
            Util.renderPassThruAttributes(responseWriter, uIComponent);
            Util.renderBooleanPassThruAttributes(responseWriter, uIComponent);
        }
        this.renderOptions(facesContext, uIComponent);
        responseWriter.endElement("select");
    }

    int getOptionNumber(FacesContext facesContext, UIComponent uIComponent) {
        Iterator iterator = Util.getSelectItems(facesContext, uIComponent);
        int n = 0;
        while (iterator.hasNext()) {
            ++n;
            SelectItem selectItem = (SelectItem)iterator.next();
            if (!(selectItem instanceof SelectItemGroup)) continue;
            int n2 = ((SelectItemGroup)selectItem).getSelectItems().length;
            n += n2;
        }
        return n;
    }

    void renderOptions(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Util.doAssert(responseWriter != null);
        Iterator iterator = Util.getSelectItems(facesContext, uIComponent);
        SelectItem selectItem = null;
        while (iterator.hasNext()) {
            selectItem = (SelectItem)iterator.next();
            if (selectItem instanceof SelectItemGroup) {
                responseWriter.startElement("optgroup", uIComponent);
                responseWriter.writeAttribute("label", (Object)selectItem.getLabel(), "label");
                SelectItem[] selectItemArray = ((SelectItemGroup)selectItem).getSelectItems();
                for (int i = 0; i < selectItemArray.length; ++i) {
                    this.renderOption(facesContext, uIComponent, selectItemArray[i]);
                }
                responseWriter.endElement("optgroup");
                continue;
            }
            this.renderOption(facesContext, uIComponent, selectItem);
        }
    }

    protected void renderOption(FacesContext facesContext, UIComponent uIComponent, SelectItem selectItem) throws IOException {
        boolean bl;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Util.doAssert(responseWriter != null);
        responseWriter.writeText((Object)"\t", null);
        responseWriter.startElement("option", uIComponent);
        String string = this.getFormattedValue(facesContext, uIComponent, selectItem.getValue());
        responseWriter.writeAttribute("value", (Object)string, "value");
        Object[] objectArray = this.getSubmittedSelectedValues(facesContext, uIComponent);
        if (objectArray != null) {
            bl = this.isSelected((Object)string, objectArray);
        } else {
            Object object = this.getCurrentSelectedValues(facesContext, uIComponent);
            bl = this.isSelected(selectItem.getValue(), object);
        }
        if (bl) {
            responseWriter.writeAttribute(this.getSelectedTextString(), (Object)Boolean.TRUE, null);
        }
        if (selectItem.isDisabled()) {
            responseWriter.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        responseWriter.writeText((Object)selectItem.getLabel(), "label");
        responseWriter.endElement("option");
        responseWriter.writeText((Object)"\n", null);
    }

    boolean isSelected(Object object, Object object2) {
        if (null != object2) {
            int n = Array.getLength(object2);
            for (int i = 0; i < n; ++i) {
                Object object3 = Array.get(object2, i);
                if (!(object3 == null ? object == null : object3.equals(object))) continue;
                return true;
            }
        }
        return false;
    }

    boolean isSelected(Object object, Object[] objectArray) {
        if (null != objectArray) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                if (!objectArray[i].equals(object)) continue;
                return true;
            }
        }
        return false;
    }

    protected void writeDefaultSize(ResponseWriter responseWriter, int n) throws IOException {
        responseWriter.writeAttribute("size", (Object)"1", "size");
    }

    String getSelectedTextString() {
        return " selected";
    }

    String getMultipleText(UIComponent uIComponent) {
        if (uIComponent instanceof UISelectMany) {
            return " multiple ";
        }
        return "";
    }

    Object[] getSubmittedSelectedValues(FacesContext facesContext, UIComponent uIComponent) {
        if (uIComponent instanceof UISelectMany) {
            UISelectMany uISelectMany = (UISelectMany)uIComponent;
            return (Object[])uISelectMany.getSubmittedValue();
        }
        UISelectOne uISelectOne = (UISelectOne)uIComponent;
        Object object = uISelectOne.getSubmittedValue();
        if (null != object) {
            return new Object[]{object};
        }
        return null;
    }

    Object getCurrentSelectedValues(FacesContext facesContext, UIComponent uIComponent) {
        if (uIComponent instanceof UISelectMany) {
            UISelectMany uISelectMany = (UISelectMany)uIComponent;
            Object object = uISelectMany.getValue();
            if (object instanceof List) {
                return ((List)object).toArray();
            }
            return object;
        }
        UISelectOne uISelectOne = (UISelectOne)uIComponent;
        Object object = uISelectOne.getValue();
        if (null != object) {
            return new Object[]{object};
        }
        return null;
    }

    void renderPassthrusForSelectOneMenu(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Util.doAssert(responseWriter != null);
        if (((HtmlSelectOneMenu)uIComponent).getAccesskey() != null) {
            responseWriter.writeAttribute("accesskey", (Object)((HtmlSelectOneMenu)uIComponent).getAccesskey(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getDir() != null) {
            responseWriter.writeAttribute("dir", (Object)((HtmlSelectOneMenu)uIComponent).getDir(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).isDisabled()) {
            responseWriter.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getLang() != null) {
            responseWriter.writeAttribute("lang", (Object)((HtmlSelectOneMenu)uIComponent).getLang(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnblur() != null) {
            responseWriter.writeAttribute("onblur", (Object)((HtmlSelectOneMenu)uIComponent).getOnblur(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnchange() != null) {
            responseWriter.writeAttribute("onchange", (Object)((HtmlSelectOneMenu)uIComponent).getOnchange(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnclick() != null) {
            responseWriter.writeAttribute("onclick", (Object)((HtmlSelectOneMenu)uIComponent).getOnclick(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOndblclick() != null) {
            responseWriter.writeAttribute("ondblclick", (Object)((HtmlSelectOneMenu)uIComponent).getOndblclick(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnfocus() != null) {
            responseWriter.writeAttribute("onfocus", (Object)((HtmlSelectOneMenu)uIComponent).getOnfocus(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnkeydown() != null) {
            responseWriter.writeAttribute("onkeydown", (Object)((HtmlSelectOneMenu)uIComponent).getOnkeydown(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnkeypress() != null) {
            responseWriter.writeAttribute("onkeypress", (Object)((HtmlSelectOneMenu)uIComponent).getOnkeypress(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnkeyup() != null) {
            responseWriter.writeAttribute("onkeyup", (Object)((HtmlSelectOneMenu)uIComponent).getOnkeyup(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnmousedown() != null) {
            responseWriter.writeAttribute("onmousedown", (Object)((HtmlSelectOneMenu)uIComponent).getOnmousedown(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnmousemove() != null) {
            responseWriter.writeAttribute("onmousemove", (Object)((HtmlSelectOneMenu)uIComponent).getOnmousemove(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnmouseout() != null) {
            responseWriter.writeAttribute("onmouseout", (Object)((HtmlSelectOneMenu)uIComponent).getOnmouseout(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnmouseover() != null) {
            responseWriter.writeAttribute("onmouseover", (Object)((HtmlSelectOneMenu)uIComponent).getOnmouseover(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnmouseup() != null) {
            responseWriter.writeAttribute("onmouseup", (Object)((HtmlSelectOneMenu)uIComponent).getOnmouseup(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getOnselect() != null) {
            responseWriter.writeAttribute("onselect", (Object)((HtmlSelectOneMenu)uIComponent).getOnselect(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).isReadonly()) {
            responseWriter.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getStyle() != null) {
            responseWriter.writeAttribute("style", (Object)((HtmlSelectOneMenu)uIComponent).getStyle(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getTabindex() != null) {
            responseWriter.writeAttribute("tabindex", (Object)((HtmlSelectOneMenu)uIComponent).getTabindex(), null);
        }
        if (((HtmlSelectOneMenu)uIComponent).getTitle() != null) {
            responseWriter.writeAttribute("title", (Object)((HtmlSelectOneMenu)uIComponent).getTitle(), null);
        }
    }

    void renderPassthrusForSelectOneListBox(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Util.doAssert(responseWriter != null);
        if (((HtmlSelectOneListbox)uIComponent).getAccesskey() != null) {
            responseWriter.writeAttribute("accesskey", (Object)((HtmlSelectOneListbox)uIComponent).getAccesskey(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getDir() != null) {
            responseWriter.writeAttribute("dir", (Object)((HtmlSelectOneListbox)uIComponent).getDir(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).isDisabled()) {
            responseWriter.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getLang() != null) {
            responseWriter.writeAttribute("lang", (Object)((HtmlSelectOneListbox)uIComponent).getLang(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnblur() != null) {
            responseWriter.writeAttribute("onblur", (Object)((HtmlSelectOneListbox)uIComponent).getOnblur(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnchange() != null) {
            responseWriter.writeAttribute("onchange", (Object)((HtmlSelectOneListbox)uIComponent).getOnchange(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnclick() != null) {
            responseWriter.writeAttribute("onclick", (Object)((HtmlSelectOneListbox)uIComponent).getOnclick(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOndblclick() != null) {
            responseWriter.writeAttribute("ondblclick", (Object)((HtmlSelectOneListbox)uIComponent).getOndblclick(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnfocus() != null) {
            responseWriter.writeAttribute("onfocus", (Object)((HtmlSelectOneListbox)uIComponent).getOnfocus(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnkeydown() != null) {
            responseWriter.writeAttribute("onkeydown", (Object)((HtmlSelectOneListbox)uIComponent).getOnkeydown(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnkeypress() != null) {
            responseWriter.writeAttribute("onkeypress", (Object)((HtmlSelectOneListbox)uIComponent).getOnkeypress(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnkeyup() != null) {
            responseWriter.writeAttribute("onkeyup", (Object)((HtmlSelectOneListbox)uIComponent).getOnkeyup(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnmousedown() != null) {
            responseWriter.writeAttribute("onmousedown", (Object)((HtmlSelectOneListbox)uIComponent).getOnmousedown(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnmousemove() != null) {
            responseWriter.writeAttribute("onmousemove", (Object)((HtmlSelectOneListbox)uIComponent).getOnmousemove(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnmouseout() != null) {
            responseWriter.writeAttribute("onmouseout", (Object)((HtmlSelectOneListbox)uIComponent).getOnmouseout(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnmouseover() != null) {
            responseWriter.writeAttribute("onmouseover", (Object)((HtmlSelectOneListbox)uIComponent).getOnmouseover(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnmouseup() != null) {
            responseWriter.writeAttribute("onmouseup", (Object)((HtmlSelectOneListbox)uIComponent).getOnmouseup(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getOnselect() != null) {
            responseWriter.writeAttribute("onselect", (Object)((HtmlSelectOneListbox)uIComponent).getOnselect(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).isReadonly()) {
            responseWriter.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getSize() > 0) {
            responseWriter.writeAttribute("size", (Object)new Integer(((HtmlSelectOneListbox)uIComponent).getSize()), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getStyle() != null) {
            responseWriter.writeAttribute("style", (Object)((HtmlSelectOneListbox)uIComponent).getStyle(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getTabindex() != null) {
            responseWriter.writeAttribute("tabindex", (Object)((HtmlSelectOneListbox)uIComponent).getTabindex(), null);
        }
        if (((HtmlSelectOneListbox)uIComponent).getTitle() != null) {
            responseWriter.writeAttribute("title", (Object)((HtmlSelectOneListbox)uIComponent).getTitle(), null);
        }
    }

    void renderPassthrusForSelectManyListBox(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Util.doAssert(responseWriter != null);
        if (((HtmlSelectManyListbox)uIComponent).getAccesskey() != null) {
            responseWriter.writeAttribute("accesskey", (Object)((HtmlSelectManyListbox)uIComponent).getAccesskey(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getDir() != null) {
            responseWriter.writeAttribute("dir", (Object)((HtmlSelectManyListbox)uIComponent).getDir(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).isDisabled()) {
            responseWriter.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getLang() != null) {
            responseWriter.writeAttribute("lang", (Object)((HtmlSelectManyListbox)uIComponent).getLang(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnblur() != null) {
            responseWriter.writeAttribute("onblur", (Object)((HtmlSelectManyListbox)uIComponent).getOnblur(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnchange() != null) {
            responseWriter.writeAttribute("onchange", (Object)((HtmlSelectManyListbox)uIComponent).getOnchange(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnclick() != null) {
            responseWriter.writeAttribute("onclick", (Object)((HtmlSelectManyListbox)uIComponent).getOnclick(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOndblclick() != null) {
            responseWriter.writeAttribute("ondblclick", (Object)((HtmlSelectManyListbox)uIComponent).getOndblclick(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnfocus() != null) {
            responseWriter.writeAttribute("onfocus", (Object)((HtmlSelectManyListbox)uIComponent).getOnfocus(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnkeydown() != null) {
            responseWriter.writeAttribute("onkeydown", (Object)((HtmlSelectManyListbox)uIComponent).getOnkeydown(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnkeypress() != null) {
            responseWriter.writeAttribute("onkeypress", (Object)((HtmlSelectManyListbox)uIComponent).getOnkeypress(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnkeyup() != null) {
            responseWriter.writeAttribute("onkeyup", (Object)((HtmlSelectManyListbox)uIComponent).getOnkeyup(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnmousedown() != null) {
            responseWriter.writeAttribute("onmousedown", (Object)((HtmlSelectManyListbox)uIComponent).getOnmousedown(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnmousemove() != null) {
            responseWriter.writeAttribute("onmousemove", (Object)((HtmlSelectManyListbox)uIComponent).getOnmousemove(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnmouseout() != null) {
            responseWriter.writeAttribute("onmouseout", (Object)((HtmlSelectManyListbox)uIComponent).getOnmouseout(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnmouseover() != null) {
            responseWriter.writeAttribute("onmouseover", (Object)((HtmlSelectManyListbox)uIComponent).getOnmouseover(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnmouseup() != null) {
            responseWriter.writeAttribute("onmouseup", (Object)((HtmlSelectManyListbox)uIComponent).getOnmouseup(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getOnselect() != null) {
            responseWriter.writeAttribute("onselect", (Object)((HtmlSelectManyListbox)uIComponent).getOnselect(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).isReadonly()) {
            responseWriter.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getSize() > 0) {
            responseWriter.writeAttribute("size", (Object)new Integer(((HtmlSelectManyListbox)uIComponent).getSize()), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getStyle() != null) {
            responseWriter.writeAttribute("style", (Object)((HtmlSelectManyListbox)uIComponent).getStyle(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getTabindex() != null) {
            responseWriter.writeAttribute("tabindex", (Object)((HtmlSelectManyListbox)uIComponent).getTabindex(), null);
        }
        if (((HtmlSelectManyListbox)uIComponent).getTitle() != null) {
            responseWriter.writeAttribute("title", (Object)((HtmlSelectManyListbox)uIComponent).getTitle(), null);
        }
    }

    void renderPassthrusForSelectManyMenu(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        Util.doAssert(responseWriter != null);
        if (((HtmlSelectManyMenu)uIComponent).getAccesskey() != null) {
            responseWriter.writeAttribute("accesskey", (Object)((HtmlSelectManyMenu)uIComponent).getAccesskey(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getDir() != null) {
            responseWriter.writeAttribute("dir", (Object)((HtmlSelectManyMenu)uIComponent).getDir(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).isDisabled()) {
            responseWriter.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getLang() != null) {
            responseWriter.writeAttribute("lang", (Object)((HtmlSelectManyMenu)uIComponent).getLang(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnblur() != null) {
            responseWriter.writeAttribute("onblur", (Object)((HtmlSelectManyMenu)uIComponent).getOnblur(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnchange() != null) {
            responseWriter.writeAttribute("onchange", (Object)((HtmlSelectManyMenu)uIComponent).getOnchange(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnclick() != null) {
            responseWriter.writeAttribute("onclick", (Object)((HtmlSelectManyMenu)uIComponent).getOnclick(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOndblclick() != null) {
            responseWriter.writeAttribute("ondblclick", (Object)((HtmlSelectManyMenu)uIComponent).getOndblclick(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnfocus() != null) {
            responseWriter.writeAttribute("onfocus", (Object)((HtmlSelectManyMenu)uIComponent).getOnfocus(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnkeydown() != null) {
            responseWriter.writeAttribute("onkeydown", (Object)((HtmlSelectManyMenu)uIComponent).getOnkeydown(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnkeypress() != null) {
            responseWriter.writeAttribute("onkeypress", (Object)((HtmlSelectManyMenu)uIComponent).getOnkeypress(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnkeyup() != null) {
            responseWriter.writeAttribute("onkeyup", (Object)((HtmlSelectManyMenu)uIComponent).getOnkeyup(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnmousedown() != null) {
            responseWriter.writeAttribute("onmousedown", (Object)((HtmlSelectManyMenu)uIComponent).getOnmousedown(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnmousemove() != null) {
            responseWriter.writeAttribute("onmousemove", (Object)((HtmlSelectManyMenu)uIComponent).getOnmousemove(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnmouseout() != null) {
            responseWriter.writeAttribute("onmouseout", (Object)((HtmlSelectManyMenu)uIComponent).getOnmouseout(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnmouseover() != null) {
            responseWriter.writeAttribute("onmouseover", (Object)((HtmlSelectManyMenu)uIComponent).getOnmouseover(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnmouseup() != null) {
            responseWriter.writeAttribute("onmouseup", (Object)((HtmlSelectManyMenu)uIComponent).getOnmouseup(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getOnselect() != null) {
            responseWriter.writeAttribute("onselect", (Object)((HtmlSelectManyMenu)uIComponent).getOnselect(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).isReadonly()) {
            responseWriter.writeAttribute("readonly", (Object)"readonly", null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getStyle() != null) {
            responseWriter.writeAttribute("style", (Object)((HtmlSelectManyMenu)uIComponent).getStyle(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getTabindex() != null) {
            responseWriter.writeAttribute("tabindex", (Object)((HtmlSelectManyMenu)uIComponent).getTabindex(), null);
        }
        if (((HtmlSelectManyMenu)uIComponent).getTitle() != null) {
            responseWriter.writeAttribute("title", (Object)((HtmlSelectManyMenu)uIComponent).getTitle(), null);
        }
    }
}

