/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.util.MessageFactory;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;

public abstract class HtmlBasicRenderer
extends Renderer {
    private static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.renderkit.html_basic.HtmlBasicRenderer";

    public void addGenericErrorMessage(FacesContext facesContext, UIComponent uIComponent, String string, String string2) {
        Object[] objectArray = new Object[3];
        objectArray[0] = string2;
        facesContext.addMessage(uIComponent.getClientId(facesContext), MessageFactory.getMessage(facesContext, string, objectArray));
    }

    public void decode(FacesContext facesContext, UIComponent uIComponent) {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "decode", "Begin decoding component " + uIComponent.getId());
        }
        UIInput uIInput = null;
        if (!(uIComponent instanceof UIInput)) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "decode", "No decoding necessary since the component " + uIComponent.getId() + " is not an instance or a sub class of UIInput");
            }
            return;
        }
        uIInput = (UIInput)uIComponent;
        if (Util.componentIsDisabledOnReadonly(uIComponent)) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "decode", "No decoding necessary since the component " + uIComponent.getId() + " is disabled");
            }
            return;
        }
        String string = uIComponent.getClientId(facesContext);
        Util.doAssert(string != null);
        Map map = facesContext.getExternalContext().getRequestParameterMap();
        if (map.containsKey(string)) {
            String string2 = (String)map.get(string);
            this.setSubmittedValue(uIComponent, string2);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "decode", "new value after decoding" + string2);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "decode", "End decoding component " + uIComponent.getId());
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        String string = null;
        ResponseWriter responseWriter = null;
        Object var5_5 = null;
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "encodeEnd", "Begin encoding component " + uIComponent.getId());
        }
        if (!uIComponent.isRendered()) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "encodeEnd", "End encoding component " + uIComponent.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        responseWriter = facesContext.getResponseWriter();
        Util.doAssert(responseWriter != null);
        string = this.getCurrentValue(facesContext, uIComponent);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "encodeEnd", "Value to be rendered " + string);
        }
        this.getEndTextToRender(facesContext, uIComponent, string);
    }

    protected String getCurrentValue(FacesContext facesContext, UIComponent uIComponent) {
        Object object = null;
        if (uIComponent instanceof UIInput) {
            object = ((UIInput)uIComponent).getSubmittedValue();
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "getCurrentValue", "submitted value for component " + object);
            }
            if (null == object) {
                if (((UIInput)uIComponent).isLocalValueSet()) {
                    object = ((UIInput)uIComponent).getLocalValue();
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "getCurrentValue", "local value for component " + object);
                    }
                } else {
                    object = this.getValue(uIComponent);
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "getCurrentValue", "value for component " + object);
                    }
                }
            }
        } else {
            object = this.getValue(uIComponent);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "getCurrentValue", "value for component " + object);
            }
        }
        String string = null;
        if (object != null) {
            string = this.getFormattedValue(facesContext, uIComponent, object);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "getCurrentValue", "formatted value " + string);
            }
        }
        return string;
    }

    protected Object getValue(UIComponent uIComponent) {
        throw new UnsupportedOperationException();
    }

    protected void getEndTextToRender(FacesContext facesContext, UIComponent uIComponent, String string) throws IOException {
    }

    protected void setSubmittedValue(UIComponent uIComponent, Object object) {
    }

    protected String getFormattedValue(FacesContext facesContext, UIComponent uIComponent, Object object) throws ConverterException {
        Object[] objectArray;
        String string = null;
        if (!(uIComponent instanceof ValueHolder)) {
            if (object != null) {
                string = object.toString();
            }
            return string;
        }
        Converter converter = null;
        if (uIComponent instanceof ValueHolder) {
            converter = ((ValueHolder)uIComponent).getConverter();
        }
        if (converter == null && object == null) {
            return "";
        }
        if (converter == null) {
            if (object instanceof String) {
                return (String)object;
            }
            objectArray = object.getClass();
            converter = Util.getConverterForClass(objectArray);
            if (converter == null && object != null) {
                string = object.toString();
                return string;
            }
        }
        if (converter != null) {
            string = converter.getAsString(facesContext, uIComponent, object);
            return string;
        }
        objectArray = new Object[]{object, "null Converter"};
        throw new ConverterException(MessageFactory.getMessage(facesContext, uIComponent, "com.sun.faces.TYPECONVERSION_ERROR", objectArray));
    }

    public String convertClientId(FacesContext facesContext, String string) {
        return string;
    }

    protected Iterator getMessageIter(FacesContext facesContext, String string, UIComponent uIComponent) {
        UIComponent uIComponent2;
        Iterator iterator = null;
        iterator = null != string ? (string.length() == 0 ? facesContext.getMessages(null) : ((uIComponent2 = this.getForComponent(facesContext, string, uIComponent)) == null ? Collections.EMPTY_LIST.iterator() : facesContext.getMessages(uIComponent2.getClientId(facesContext)))) : facesContext.getMessages();
        return iterator;
    }

    protected UIComponent getForComponent(FacesContext facesContext, String string, UIComponent uIComponent) {
        if (null == string || string.length() == 0) {
            return null;
        }
        UIComponent uIComponent2 = null;
        try {
            for (UIComponent uIComponent3 = uIComponent; uIComponent3 != null && (uIComponent2 = uIComponent3.findComponent(string)) == null; uIComponent3 = uIComponent3.getParent()) {
            }
            if (uIComponent2 == null) {
                uIComponent2 = this.findUIComponentBelow((UIComponent)facesContext.getViewRoot(), string);
            }
        }
        catch (Throwable throwable) {
            Object[] objectArray = new Object[]{string};
            throw new RuntimeException(Util.getExceptionMessageString("com.sun.faces.COMPONENT_NOT_FOUND_ERROR", objectArray));
        }
        if (uIComponent2 == null && log.isLoggable(Level.WARNING)) {
            log.logp(Level.WARNING, CLASS_NAME, "getForComponent", Util.getExceptionMessageString("com.sun.faces.COMPONENT_NOT_FOUND_IN_VIEW_WARNING", new Object[]{string}));
        }
        return uIComponent2;
    }

    private UIComponent findUIComponentBelow(UIComponent uIComponent, String string) {
        UIComponent uIComponent2 = null;
        List list = uIComponent.getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            UIComponent uIComponent3 = (UIComponent)list.get(i);
            if (uIComponent3 instanceof NamingContainer) {
                uIComponent2 = uIComponent3.findComponent(string);
            }
            if (uIComponent2 == null && uIComponent3.getChildCount() > 0) {
                uIComponent2 = this.findUIComponentBelow(uIComponent3, string);
            }
            if (uIComponent2 != null) break;
        }
        return uIComponent2;
    }

    protected void encodeRecursive(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        if (!uIComponent.isRendered()) {
            return;
        }
        uIComponent.encodeBegin(facesContext);
        if (uIComponent.getRendersChildren()) {
            uIComponent.encodeChildren(facesContext);
        } else {
            Iterator iterator = this.getChildren(uIComponent);
            while (iterator.hasNext()) {
                UIComponent uIComponent2 = (UIComponent)iterator.next();
                this.encodeRecursive(facesContext, uIComponent2);
            }
        }
        uIComponent.encodeEnd(facesContext);
    }

    protected Iterator getChildren(UIComponent uIComponent) {
        ArrayList<UIComponent> arrayList = new ArrayList<UIComponent>();
        Iterator iterator = uIComponent.getChildren().iterator();
        while (iterator.hasNext()) {
            UIComponent uIComponent2 = (UIComponent)iterator.next();
            if (!uIComponent2.isRendered()) continue;
            arrayList.add(uIComponent2);
        }
        return arrayList.iterator();
    }

    protected UIComponent getFacet(UIComponent uIComponent, String string) {
        UIComponent uIComponent2 = uIComponent.getFacet(string);
        if (uIComponent2 != null && !uIComponent2.isRendered()) {
            uIComponent2 = null;
        }
        return uIComponent2;
    }

    protected boolean shouldWriteIdAttribute(UIComponent uIComponent) {
        String string = uIComponent.getId();
        return null != string && !string.startsWith("_id");
    }

    protected void writeIdAttributeIfNecessary(FacesContext facesContext, ResponseWriter responseWriter, UIComponent uIComponent) {
        block3: {
            if (this.shouldWriteIdAttribute(uIComponent)) {
                try {
                    responseWriter.writeAttribute("id", (Object)uIComponent.getClientId(facesContext), "id");
                }
                catch (IOException iOException) {
                    if (!log.isLoggable(Level.FINE)) break block3;
                    log.logp(Level.FINE, CLASS_NAME, "writeIdAttributeIfNecessary", "Can't write ID attribute" + iOException.getMessage());
                }
            }
        }
    }

    protected Param[] getParamList(FacesContext facesContext, UIComponent uIComponent) {
        ArrayList<Param> arrayList = new ArrayList<Param>();
        Iterator iterator = uIComponent.getChildren().iterator();
        while (iterator.hasNext()) {
            UIComponent uIComponent2 = (UIComponent)iterator.next();
            if (!(uIComponent2 instanceof UIParameter)) continue;
            UIParameter uIParameter = (UIParameter)uIComponent2;
            Object object = uIParameter.getValue();
            Param param = new Param(uIParameter.getName(), object == null ? null : object.toString());
            arrayList.add(param);
        }
        return arrayList.toArray(new Param[arrayList.size()]);
    }

    protected class Param {
        private String name;
        private String value;

        public Param(String string, String string2) {
            this.set(string, string2);
        }

        public void set(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

