/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.application.StateManager;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;

public class ResponseStateManagerImpl
extends ResponseStateManager {
    protected static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.renderkit.ResponseStateManagerImpl";
    private static final String FACES_VIEW_STATE = "com.sun.faces.FACES_VIEW_STATE";
    private static final String COMPRESS_STATE_PARAM = "com.sun.faces.COMPRESS_STATE";
    private Boolean compressStateSet = null;

    public Object getComponentStateToRestore(FacesContext facesContext) {
        Map map = facesContext.getExternalContext().getRequestMap();
        Object v = map.get(FACES_VIEW_STATE);
        map.put(FACES_VIEW_STATE, null);
        return v;
    }

    public Object getTreeStructureToRestore(FacesContext facesContext, String string) {
        Object object = null;
        Object object2 = null;
        ByteArrayInputStream byteArrayInputStream = null;
        GZIPInputStream gZIPInputStream = null;
        ObjectInputStream objectInputStream = null;
        boolean bl = this.isCompressStateSet(facesContext);
        Map map = facesContext.getExternalContext().getRequestParameterMap();
        String string2 = (String)map.get("com.sun.faces.VIEW");
        if (string2 == null) {
            return null;
        }
        byte[] byArray = Base64.decode(string2.getBytes());
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            if (bl) {
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "getTreeStructureToRestore", "Deflating state before restoring..");
                }
                gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
                objectInputStream = new ObjectInputStream(gZIPInputStream);
            } else {
                objectInputStream = new ObjectInputStream(byteArrayInputStream);
            }
            object = objectInputStream.readObject();
            object2 = objectInputStream.readObject();
            Map map2 = facesContext.getExternalContext().getRequestMap();
            map2.put(FACES_VIEW_STATE, object2);
            objectInputStream.close();
            byteArrayInputStream.close();
            if (bl) {
                gZIPInputStream.close();
            }
        }
        catch (OptionalDataException optionalDataException) {
            log.logp(Level.SEVERE, CLASS_NAME, "getTreeStructureToRestore", optionalDataException.getMessage(), optionalDataException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.logp(Level.SEVERE, CLASS_NAME, "getTreeStructureToRestore", classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (IOException iOException) {
            log.logp(Level.SEVERE, CLASS_NAME, "getTreeStructureToRestore", iOException.getMessage(), iOException);
        }
        return object;
    }

    public void writeState(FacesContext facesContext, StateManager.SerializedView serializedView) throws IOException {
        String string = null;
        GZIPOutputStream gZIPOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        boolean bl = this.isCompressStateSet(facesContext);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bl) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "getTreeStructureToRestore", "Compressing state before saving..");
            }
            gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
        } else {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        }
        objectOutputStream.writeObject(serializedView.getStructure());
        objectOutputStream.writeObject(serializedView.getState());
        objectOutputStream.close();
        if (bl) {
            gZIPOutputStream.close();
        }
        byteArrayOutputStream.close();
        string = " <input type=\"hidden\" name=\"com.sun.faces.VIEW\" value=\"" + new String(Base64.encode(byteArrayOutputStream.toByteArray()), "ISO-8859-1") + "\" />\n ";
        facesContext.getResponseWriter().write(string);
    }

    protected String replaceMarkers(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        while (n != -1) {
            String string4 = string.substring(0, n);
            int n2 = n + string2.length();
            String string5 = string.substring(n2, string.length());
            string4 = string4.concat(string3);
            string = string4 = string4.concat(string5);
            n = string.indexOf(string2);
        }
        return string;
    }

    public boolean isCompressStateSet(FacesContext facesContext) {
        if (null != this.compressStateSet) {
            return this.compressStateSet;
        }
        this.compressStateSet = Boolean.TRUE;
        String string = facesContext.getExternalContext().getInitParameter(COMPRESS_STATE_PARAM);
        if (string != null) {
            this.compressStateSet = Boolean.valueOf(string);
        }
        return this.compressStateSet;
    }
}

