/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.lifecycle.ApplyRequestValuesPhase;
import com.sun.faces.lifecycle.InvokeApplicationPhase;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.lifecycle.ProcessValidationsPhase;
import com.sun.faces.lifecycle.RenderResponsePhase;
import com.sun.faces.lifecycle.RestoreViewPhase;
import com.sun.faces.lifecycle.UpdateModelValuesPhase;
import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.http.HttpServletRequest;

public class LifecycleImpl
extends Lifecycle {
    private static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.lifecycle.LifecycleImpl";
    private ArrayList listeners = new ArrayList();
    private Phase[] phases = new Phase[]{null, new RestoreViewPhase(), new ApplyRequestValuesPhase(), new ProcessValidationsPhase(), new UpdateModelValuesPhase(), new InvokeApplicationPhase()};
    private Phase response = new RenderResponsePhase();

    public void execute(FacesContext facesContext) throws FacesException {
        if (facesContext == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "execute", "execute(" + facesContext + ")");
        }
        for (int i = 1; i < this.phases.length && !facesContext.getRenderResponse() && !facesContext.getResponseComplete(); ++i) {
            this.phase((PhaseId)PhaseId.VALUES.get(i), this.phases[i], facesContext);
            if (!this.reload((PhaseId)PhaseId.VALUES.get(i), facesContext)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "execute", "Skipping rest of execute() because of a reload");
            }
            facesContext.renderResponse();
        }
    }

    public void render(FacesContext facesContext) throws FacesException {
        if (facesContext == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "render", "render(" + facesContext + ")");
        }
        if (!facesContext.getResponseComplete()) {
            this.phase(PhaseId.RENDER_RESPONSE, this.response, facesContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhaseListener(PhaseListener phaseListener) {
        if (phaseListener == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "addPhaseListener", "addPhaseListener(" + phaseListener.getPhaseId().toString() + "," + phaseListener);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            ArrayList arrayList2 = (ArrayList)this.listeners.clone();
            arrayList2.add(phaseListener);
            this.listeners = arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhaseListener[] getPhaseListeners() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            return this.listeners.toArray(new PhaseListener[this.listeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePhaseListener(PhaseListener phaseListener) {
        if (phaseListener == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "removePhaseListener", "removePhaseListener(" + phaseListener.getPhaseId().toString() + "," + phaseListener);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            ArrayList arrayList2 = (ArrayList)this.listeners.clone();
            arrayList2.remove(phaseListener);
            this.listeners = arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void phase(PhaseId phaseId, Phase phase, FacesContext facesContext) throws FacesException {
        block9: {
            block8: {
                int n;
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "phase", "phase(" + phaseId.toString() + "," + facesContext + ")");
                }
                ArrayList arrayList = this.listeners;
                int n2 = arrayList.size();
                ArrayList<PhaseListener> arrayList2 = new ArrayList<PhaseListener>(n2);
                if (n2 <= 0) break block8;
                PhaseEvent phaseEvent = new PhaseEvent(facesContext, phaseId, (Lifecycle)this);
                PhaseListener phaseListener = null;
                PhaseId phaseId2 = null;
                for (n = 0; n < n2; ++n) {
                    phaseListener = (PhaseListener)arrayList.get(n);
                    phaseId2 = phaseListener.getPhaseId();
                    if (!phaseId.equals(phaseId2) && !PhaseId.ANY_PHASE.equals(phaseId2)) continue;
                    phaseListener.beforePhase(phaseEvent);
                    arrayList2.add(phaseListener);
                }
                try {
                    if (!this.skipping(phaseId, facesContext)) {
                        phase.execute(facesContext);
                    }
                    Object var12_11 = null;
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    for (n = arrayList2.size() - 1; n >= 0; --n) {
                        phaseListener = (PhaseListener)arrayList2.get(n);
                        phaseListener.afterPhase(phaseEvent);
                    }
                    throw throwable;
                }
                for (n = arrayList2.size() - 1; n >= 0; --n) {
                    phaseListener = (PhaseListener)arrayList2.get(n);
                    phaseListener.afterPhase(phaseEvent);
                }
                break block9;
            }
            if (!this.skipping(phaseId, facesContext)) {
                phase.execute(facesContext);
            }
        }
    }

    private boolean reload(PhaseId phaseId, FacesContext facesContext) {
        Iterator iterator;
        if (!phaseId.equals(PhaseId.RESTORE_VIEW)) {
            return false;
        }
        if (!(facesContext.getExternalContext().getRequest() instanceof HttpServletRequest)) {
            return false;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        String string = httpServletRequest.getMethod();
        if ("GET".equals(string) && (iterator = facesContext.getExternalContext().getRequestParameterNames()).hasNext()) {
            return false;
        }
        return !"POST".equals(string) && !"PUT".equals(string);
    }

    private boolean skipping(PhaseId phaseId, FacesContext facesContext) {
        if (facesContext.getResponseComplete()) {
            return true;
        }
        return facesContext.getRenderResponse() && !phaseId.equals(PhaseId.RENDER_RESPONSE);
    }
}

