/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.Expression;
import com.sun.faces.el.impl.ExpressionInfo;
import com.sun.faces.el.impl.UnaryOperator;
import java.util.List;

public class UnaryOperatorExpression
extends Expression {
    UnaryOperator mOperator;
    List mOperators;
    Expression mExpression;

    public UnaryOperator getOperator() {
        return this.mOperator;
    }

    public void setOperator(UnaryOperator unaryOperator) {
        this.mOperator = unaryOperator;
    }

    public List getOperators() {
        return this.mOperators;
    }

    public void setOperators(List list) {
        this.mOperators = list;
    }

    public Expression getExpression() {
        return this.mExpression;
    }

    public void setExpression(Expression expression) {
        this.mExpression = expression;
    }

    public UnaryOperatorExpression(UnaryOperator unaryOperator, List list, Expression expression) {
        this.mOperator = unaryOperator;
        this.mOperators = list;
        this.mExpression = expression;
    }

    public String getExpressionString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        if (this.mOperator != null) {
            stringBuffer.append(this.mOperator.getOperatorSymbol());
            stringBuffer.append(" ");
        } else {
            int n = this.mOperators.size();
            for (int i = 0; i < n; ++i) {
                UnaryOperator unaryOperator = (UnaryOperator)this.mOperators.get(i);
                stringBuffer.append(unaryOperator.getOperatorSymbol());
                stringBuffer.append(" ");
            }
        }
        stringBuffer.append(this.mExpression.getExpressionString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public Object evaluate(ExpressionInfo expressionInfo) throws ElException {
        Object object = this.mExpression.evaluate(expressionInfo);
        if (this.mOperator != null) {
            object = this.mOperator.apply(object);
        } else {
            for (int i = this.mOperators.size() - 1; i >= 0; --i) {
                UnaryOperator unaryOperator = (UnaryOperator)this.mOperators.get(i);
                object = unaryOperator.apply(object);
            }
        }
        return object;
    }
}

