/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.BinaryOperator;
import com.sun.faces.el.impl.Coercions;
import com.sun.faces.el.impl.Constants;
import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.MessageUtil;
import com.sun.faces.el.impl.PrimitiveObjects;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModulusOperator
extends BinaryOperator {
    private static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.el.impl.ModulusOperator";
    public static final ModulusOperator SINGLETON = new ModulusOperator();

    public String getOperatorSymbol() {
        return "%";
    }

    public Object apply(Object object, Object object2) throws ElException {
        if (object == null && object2 == null) {
            if (log.isLoggable(Level.WARNING)) {
                log.logp(Level.WARNING, CLASS_NAME, "apply", MessageUtil.getMessageWithArgs(Constants.ARITH_OP_NULL, this.getOperatorSymbol()));
            }
            return PrimitiveObjects.getInteger(0);
        }
        if (object != null && (Coercions.isFloatingPointType(object) || Coercions.isFloatingPointString(object)) || Coercions.isBigDecimal(object) || object2 != null && (Coercions.isFloatingPointType(object2) || Coercions.isFloatingPointString(object2) || Coercions.isBigDecimal(object2))) {
            double d = Coercions.coerceToPrimitiveNumber(object, Double.class).doubleValue();
            double d2 = Coercions.coerceToPrimitiveNumber(object2, Double.class).doubleValue();
            try {
                return PrimitiveObjects.getDouble(d % d2);
            }
            catch (Exception exception) {
                if (log.isLoggable(Level.SEVERE)) {
                    String string = MessageUtil.getMessageWithArgs(Constants.ARITH_ERROR, this.getOperatorSymbol(), "" + d, "" + d2);
                    log.logp(Level.SEVERE, CLASS_NAME, "apply", string);
                    throw new ElException(string);
                }
                return PrimitiveObjects.getInteger(0);
            }
        }
        if (Coercions.isBigInteger(object) || Coercions.isBigInteger(object2)) {
            BigInteger bigInteger = (BigInteger)Coercions.coerceToPrimitiveNumber(object, BigInteger.class);
            BigInteger bigInteger2 = (BigInteger)Coercions.coerceToPrimitiveNumber(object2, BigInteger.class);
            try {
                return bigInteger.remainder(bigInteger2);
            }
            catch (Exception exception) {
                if (log.isLoggable(Level.SEVERE)) {
                    String string = MessageUtil.getMessageWithArgs(Constants.ARITH_ERROR, this.getOperatorSymbol(), "" + bigInteger, "" + bigInteger2);
                    log.logp(Level.SEVERE, CLASS_NAME, "apply", string);
                    throw new ElException(string);
                }
                return PrimitiveObjects.getInteger(0);
            }
        }
        long l = Coercions.coerceToPrimitiveNumber(object, Long.class).longValue();
        long l2 = Coercions.coerceToPrimitiveNumber(object2, Long.class).longValue();
        try {
            return PrimitiveObjects.getLong(l % l2);
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.SEVERE)) {
                String string = MessageUtil.getMessageWithArgs(Constants.ARITH_ERROR, this.getOperatorSymbol(), "" + l, "" + l2);
                log.logp(Level.SEVERE, CLASS_NAME, "apply", string);
                throw new ElException(string);
            }
            return PrimitiveObjects.getInteger(0);
        }
    }
}

